/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.icetech.basics.config.GrayProperties;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.PropertyInfoRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.SpringUtils;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.domain.dto.LedConfigDTO;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.DeviceUpgradeHandle;
import com.icetech.park.service.park.ParkRecoveryService;
import com.icetech.park.service.report.CallService;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.utils.JsonUtils;
import com.icetech.third.utils.RedisUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service(value="p2cPropertyInfoServiceImpl")
@RefreshScope
public class PropertyInfoServiceImpl
extends AbstractService
implements CallService<PropertyInfoRequest, Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(PropertyInfoServiceImpl.class);
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private DeviceUpgradeHandle deviceUpgradeHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private AsyncNotifyClient asyncNotifyClient;
    @Value(value="${model.config}")
    private String modelConfig;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Resource
    private RedisHandle redisHandle;
    @Autowired
    private GrayProperties grayProperties;
    @Autowired
    private ParkRecoveryService parkRecoveryService;

    @Override
    public P2cBaseResponse<Map<String, Object>> execute(TokenDeviceVo deviceInfo, P2cBaseRequest<PropertyInfoRequest> baseRequest) {
        PropertyInfoRequest propertyInfoRequest = (PropertyInfoRequest)baseRequest.getBizContent();
        this.verifyParams(propertyInfoRequest);
        String reportVersion = propertyInfoRequest.getVersion().trim();
        if (P2cVersionEnum.getIndex((String)reportVersion) == 0) {
            return P2cBaseResponse.instance(baseRequest, (int)CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode(), (String)"\u7248\u672c\u53f7\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("enexType", deviceInfo.getInandoutType());
        dataMap.put("parkCode", deviceInfo.getParkCode());
        dataMap.put("protocolType", deviceInfo.getSource());
        ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(deviceInfo.getParkId());
        ObjectResponse.notError((Response)parkConfigObjectResponse);
        ParkConfig parkConfig = (ParkConfig)parkConfigObjectResponse.getData();
        dataMap.put("retentionAlarm", 1);
        dataMap.put("retentionTimeThreshold", NumberUtils.toPrimitive((Integer)parkConfig.getCarenexTimelong()) * 60 < 30 ? 60 : parkConfig.getCarenexTimelong() * 60);
        dataMap.put("retentionAlarmMethod", NumberUtils.toPrimitive((Integer)parkConfig.getRetentionAlarmMethod(), (int)1));
        dataMap.put("retentionIntervalTime", NumberUtils.toPrimitive((Integer)parkConfig.getRetentionIntervalTime(), (int)600));
        if (P2cVersionEnum.getIndex((String)deviceInfo.getVersion()) >= P2cVersionEnum.\u7248\u672c18.getIndex()) {
            List<ParkRecoveryVo> recoverys = this.parkRecoveryService.getOpenParkRecoveryByParkIds(Collections.singletonList(deviceInfo.getParkId()));
            if (CollectionUtils.isNotEmpty(recoverys)) {
                dataMap.put("enableShamPlate", parkConfig.getEnableShamPlate());
                dataMap.put("shamPlateMethod", parkConfig.getShamPlateMethod());
            } else if (propertyInfoRequest.getEnableShamPlate() != null) {
                dataMap.put("enableShamPlate", propertyInfoRequest.getEnableShamPlate());
                dataMap.put("shamPlateMethod", propertyInfoRequest.getShamPlateMethod());
            }
        }
        this.propertyModify(deviceInfo, propertyInfoRequest, baseRequest.getMessageId());
        return P2cBaseResponse.success(baseRequest, dataMap);
    }

    private void propertyModify(TokenDeviceVo deviceInfo, PropertyInfoRequest propertyInfoRequest, String messageId) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            Optional<LedConfigDTO> ledConfigOptional;
            List ledConfigDTOS;
            String param;
            String serialNumber = deviceInfo.getDeviceNo();
            Integer protocolType = deviceInfo.getSource();
            if (!propertyInfoRequest.getVersion().equals(deviceInfo.getVersion()) || propertyInfoRequest.getNewBluetooth() != null && !propertyInfoRequest.getNewBluetooth().equals(deviceInfo.getNewBluetooth())) {
                deviceInfo.setVersion(propertyInfoRequest.getVersion());
                deviceInfo.setNewBluetooth(propertyInfoRequest.getNewBluetooth());
                this.cacheHandle.updateDeviceInfo(deviceInfo.getDeviceNo(), deviceInfo);
            }
            if ((param = (String)this.redisUtils.get("p2c:property:get:flag:" + deviceInfo.getDeviceNo(), String.class)) != null) {
                String[] params = param.split("/");
                this.redisUtils.set("p2c:property:get:info:" + deviceInfo.getDeviceNo(), (Object)propertyInfoRequest);
                this.asyncNotifyClient.callBack(params[0], params[1], SpringUtils.getActiveProfile(), propertyInfoRequest);
            }
            ObjectResponse deviceBySerialNumber = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
            ParkDevice parkDevice = (ParkDevice)deviceBySerialNumber.getData();
            String protocolVer = propertyInfoRequest.getVersion();
            String productModel = propertyInfoRequest.getProductModel();
            String firmwareVersion = propertyInfoRequest.getFirmwareVersion();
            Integer connectionMode = propertyInfoRequest.getConnectionMode();
            Integer wirelessCarrier = propertyInfoRequest.getWirelessCarrier();
            String network = propertyInfoRequest.getNetwork();
            Integer newBluetooth = propertyInfoRequest.getNewBluetooth();
            if (firmwareVersion != null) {
                this.deviceUpgradeHandle.versionModify(serialNumber, firmwareVersion);
            }
            if (!protocolVer.equals(parkDevice.getProtocolVer()) || !protocolType.equals(parkDevice.getProtocolType()) || productModel != null && !productModel.equals(parkDevice.getProductModel()) || firmwareVersion != null && !firmwareVersion.equals(parkDevice.getFirmwareVersion()) || connectionMode != null && !connectionMode.equals(parkDevice.getCallMethods()) || wirelessCarrier != null && !wirelessCarrier.equals(parkDevice.getWirelessCarrier()) || network != null && !network.equals(parkDevice.getNetwork()) || newBluetooth != null && !newBluetooth.equals(parkDevice.getNewBluetooth())) {
                parkDevice.setProtocolVer(protocolVer);
                parkDevice.setProtocolType(protocolType);
                parkDevice.setProductModel(productModel);
                parkDevice.setFirmwareVersion(firmwareVersion);
                parkDevice.setCallMethods(connectionMode);
                parkDevice.setWirelessCarrier(wirelessCarrier);
                parkDevice.setNetwork(network);
                parkDevice.setNewBluetooth(newBluetooth);
                this.parkDeviceService.updateDevice(parkDevice);
                log.info("[\u8bbe\u5907\u5c5e\u6027\u4e0a\u62a5\u63a5\u53e3] \u66f4\u65b0\u7248\u672c\u53f7\u548c\u534f\u8bae\u7c7b\u578b\u5b8c\u6210, sn[{}], protocolType[{}], protocolVer[{}], productModel[{}], firmwareVersion[{}]", new Object[]{serialNumber, protocolType, protocolVer, productModel, firmwareVersion});
            }
            if (StringUtils.isNotBlank((CharSequence)this.modelConfig) && CollectionUtils.isNotEmpty((Collection)(ledConfigDTOS = (List)JsonUtils.fromJson((String)this.modelConfig, (TypeReference)new TypeReference<List<LedConfigDTO>>(){}))) && (ledConfigOptional = ledConfigDTOS.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getModel()) && a.getModel().equals(productModel)).findFirst()).isPresent()) {
                ParkInoutdevice parkInoutdevice;
                LedConfigDTO ledConfigDTO = ledConfigOptional.get();
                ObjectResponse channelDevice = this.parkService.getInoutDeviceById(Long.valueOf(parkDevice.getChannelId().intValue()));
                if (!(!ObjectResponse.isSuccess((Response)channelDevice) || (parkInoutdevice = (ParkInoutdevice)channelDevice.getData()).getLedcardType().equals(ledConfigDTO.getValue()) && parkInoutdevice.getTtsType().equals(ledConfigDTO.getTtsType()))) {
                    log.info("[\u8bbe\u5907\u5c5e\u6027\u4e0a\u62a5\u63a5\u53e3]\u63a7\u5236\u5361\u7c7b\u578b\u548ctts\u6709\u5176\u4e2d\u4e00\u4e0d\u4e00\u81f4");
                    ParkInoutdevice update = new ParkInoutdevice();
                    update.setId(parkInoutdevice.getId());
                    update.setLedcardType(ledConfigDTO.getValue());
                    update.setTtsType(ledConfigDTO.getTtsType());
                    this.parkInoutdeviceDao.updateById((Object)update);
                    String deleteKey = "park:channel:id:" + parkDevice.getChannelId();
                    String deleteCode = "park:channel:code:" + parkInoutdevice.getInandoutCode();
                    if (this.grayProperties.isCacheEnable()) {
                        deleteKey = "gray:" + deleteKey;
                        deleteCode = "gray:" + deleteCode;
                    }
                    this.redisHandle.delete(deleteKey);
                    this.redisHandle.delete(deleteCode);
                }
            }
        }));
    }
}

