/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.response.p2c.HeartbeatResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.park.domain.request.HeartbeatRequest;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import com.icetech.third.utils.RedisUtils;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cHeartbeatServiceImpl")
public class HeartbeatServiceImpl
extends AbstractService
implements CallService<HeartbeatRequest, HeartbeatResponse> {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatServiceImpl.class);
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    @Override
    public P2cBaseResponse<HeartbeatResponse> execute(TokenDeviceVo deviceToken, P2cBaseRequest<HeartbeatRequest> baseRequest) {
        String serialNumber = deviceToken.getDeviceNo();
        String version = deviceToken.getVersion();
        HeartbeatRequest heartbeatRequest = (HeartbeatRequest)baseRequest.getBizContent();
        if (P2cVersionEnum.\u7248\u672c1.getVersion().equals(version)) {
            Long deviceTime = heartbeatRequest.getDeviceTime();
            heartbeatRequest.setDeviceTime(Long.valueOf(DateTools.getUnixTime((long)deviceTime)));
        }
        this.verifyParams(heartbeatRequest);
        String reportVersion = heartbeatRequest.getVersion();
        if (reportVersion != null && P2cVersionEnum.getIndex((String)reportVersion) == 0) {
            return P2cBaseResponse.instance(baseRequest, (int)CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode(), (String)"\u7248\u672c\u53f7\u4e0d\u5b58\u5728");
        }
        this.redisUtils.hPut("p2c:heartbeat:time", serialNumber, (Object)DateTools.unixTimestamp());
        this.asyncHandle(deviceToken, serialNumber, heartbeatRequest.getVersion());
        HeartbeatResponse heartbeatResponse = new HeartbeatResponse();
        heartbeatResponse.setCloudTime(Long.valueOf(DateTools.unixTimestamp()));
        return P2cBaseResponse.success(baseRequest, (Object)heartbeatResponse);
    }

    private void asyncHandle(TokenDeviceVo deviceToken, String serialNumber, String reportVersion) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            String parkCode = deviceToken.getParkCode();
            String channelCode = deviceToken.getInandoutCode();
            String version = deviceToken.getVersion();
            boolean isUpdate = false;
            if (reportVersion != null && !reportVersion.equals(version)) {
                isUpdate = true;
                deviceToken.setVersion(reportVersion);
                ObjectResponse deviceBySerialNumber = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
                if (ObjectResponse.isSuccess((Response)deviceBySerialNumber) && Integer.valueOf(1).equals(((ParkDevice)deviceBySerialNumber.getData()).getType())) {
                    ParkDevice parkDevice = (ParkDevice)deviceBySerialNumber.getData();
                    parkDevice.setProtocolVer(reportVersion);
                    this.parkDeviceService.updateDevice(parkDevice);
                }
            }
            if (isUpdate) {
                this.cacheHandle.cacheDeviceInfo(serialNumber, deviceToken);
            } else {
                this.cacheHandle.expireDeviceInfo(serialNumber);
            }
            if (!this.redisUtils.exists("P2C_SERIAL_NUMBER_" + parkCode + "_" + channelCode)) {
                this.cacheHandle.setChannelSn(parkCode, channelCode, serialNumber, true);
            } else {
                this.cacheHandle.expireChannelSn(parkCode, channelCode);
            }
        }));
    }
}

