/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.domain.request.p2c.P2cDeviceStatusRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cDeviceStatusServiceImpl")
public class DeviceStatusServiceImpl
extends AbstractService
implements CallService<P2cDeviceStatusRequest, Void> {
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkDeviceDao parkDeviceDao;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<P2cDeviceStatusRequest> baseRequest) {
        P2cDeviceStatusRequest deviceStatusRequest = (P2cDeviceStatusRequest)baseRequest.getBizContent();
        this.verifyParams(deviceStatusRequest);
        Integer workStatus = deviceStatusRequest.getWorkStatus();
        if (workStatus == 2) {
            workStatus = 3;
        }
        ParkDevice parkDevice = new ParkDevice();
        parkDevice.setParkId(deviceToken.getParkId());
        parkDevice.setSerialNumber(deviceToken.getDeviceNo());
        parkDevice.setType(Integer.valueOf(1));
        ParkDevice parkDevice1 = this.parkDeviceDao.selectByParam(parkDevice);
        ObjectResponse objectResponse = this.parkDeviceService.modifyStatus(deviceToken.getParkId(), parkDevice1.getDeviceNo(), workStatus, deviceStatusRequest.getExceptionCause(), null);
        ObjectResponse.notError((Response)objectResponse);
        return P2cBaseResponse.success(baseRequest);
    }
}

