/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.CompleteOrderRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cCompleteOrderServiceImpl")
public class CompleteOrderServiceImpl
extends AbstractService
implements CallService<List<CompleteOrderRequest>, Object> {
    private static final Logger log = LoggerFactory.getLogger(CompleteOrderServiceImpl.class);
    @Autowired
    private CarOrderExitService carOrderExitService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private CarOrderEnterService carOrderEnterService;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private CacheHandle cacheHandle;

    @Override
    public P2cBaseResponse<Object> execute(TokenDeviceVo deviceToken, P2cBaseRequest<List<CompleteOrderRequest>> baseRequest) {
        List list = (List)baseRequest.getBizContent();
        if (list == null || list.isEmpty()) {
            return P2cBaseResponse.instance(baseRequest, (int)CodeEnum.\u7f3a\u5931\u53c2\u6570.getCode());
        }
        for (int i = 0; i < list.size(); ++i) {
            CompleteOrderRequest completeOrderRequest = (CompleteOrderRequest)list.get(i);
            P2cBaseResponse<?> p2cBaseResponse = this.execute(deviceToken, baseRequest, completeOrderRequest);
            if (p2cBaseResponse.getCode().equals(CodeEnum.\u6210\u529f.getCode())) continue;
            log.info("\u7b2c[{}]\u4e2a\u5143\u7d20\u7684\u53c2\u6570\u5904\u7406\u5931\u8d25\uff0c\u53c2\u6570[{}}, \u5904\u7406\u7ed3\u679c[{}]", new Object[]{i, completeOrderRequest, p2cBaseResponse});
        }
        return P2cBaseResponse.success(baseRequest);
    }

    public P2cBaseResponse<?> execute(TokenDeviceVo deviceToken, P2cBaseRequest<List<CompleteOrderRequest>> baseRequest, CompleteOrderRequest completeOrderRequest) {
        Long parkId = deviceToken.getParkId();
        String parkCode = deviceToken.getParkCode();
        String inandoutCode = deviceToken.getInandoutCode();
        String inandoutName = deviceToken.getInandoutName();
        this.verifyParams(completeOrderRequest);
        completeOrderRequest.setParkId(parkId);
        completeOrderRequest.setParkCode(parkCode);
        completeOrderRequest.setInandoutCode(inandoutCode);
        completeOrderRequest.setInandoutName(inandoutName);
        completeOrderRequest.setOrderNum(null);
        String plateNum = completeOrderRequest.getPlateNum();
        Long enterTime = completeOrderRequest.getEnterTime();
        if (enterTime == null) {
            completeOrderRequest.setEnterTime(completeOrderRequest.getExitTime());
            return this.saveEnex(baseRequest, parkCode, inandoutName, inandoutCode, completeOrderRequest);
        }
        if (!DataCommonConstants.isNoPlate((String)plateNum)) {
            OrderInfo orderInfo1 = new OrderInfo();
            orderInfo1.setPlateNum(plateNum);
            orderInfo1.setParkId(parkId);
            ObjectResponse inPark = this.orderService.findByOrderInfo(orderInfo1);
            OrderInfo orderInfo = (OrderInfo)inPark.getData();
            if (orderInfo != null && 1 == orderInfo.getServiceStatus()) {
                completeOrderRequest.setOrderNum(orderInfo.getOrderNum());
                completeOrderRequest.setType(orderInfo.getType());
            } else {
                if (orderInfo != null && (2 == orderInfo.getServiceStatus() || 4 == orderInfo.getServiceStatus()) && orderInfo.getEnterTime().compareTo(enterTime) >= 0) {
                    log.info("[\u7aef\u4e91-\u8131\u673a\u5b8c\u6574\u8ba2\u5355\u8865\u62a5] \u8f66\u8f86\u5df2\u7ecf\u79bb\u573a[{}], orderNum[{}]", (Object)plateNum, (Object)orderInfo.getOrderNum());
                    return P2cBaseResponse.success(baseRequest);
                }
                inPark = this.orderService.fuzzyPlate(parkId, inandoutCode, plateNum);
                if (inPark != null && inPark.getCode().equals("200")) {
                    orderInfo = (OrderInfo)inPark.getData();
                    log.info("[\u7aef\u4e91-\u8131\u673a\u5b8c\u6574\u8ba2\u5355\u8865\u62a5] \u79bb\u573a\u8f66\u724c[{}], \u6a21\u7cca\u5339\u914d\u5230\u8f66\u724c[{}]", (Object)plateNum, (Object)orderInfo.getPlateNum());
                    completeOrderRequest.setOrderNum(orderInfo.getOrderNum());
                    plateNum = orderInfo.getPlateNum();
                    completeOrderRequest.setPlateNum(plateNum);
                    completeOrderRequest.setType(orderInfo.getType());
                }
            }
            if (orderInfo == null || !orderInfo.getEnterTime().equals(enterTime)) {
                return this.saveEnex(baseRequest, parkCode, inandoutName, inandoutCode, completeOrderRequest);
            }
            this.dealPayRecord(inandoutName, inandoutCode, completeOrderRequest, orderInfo.getOrderNum(), orderInfo);
            completeOrderRequest.setOrderNum(orderInfo.getOrderNum());
            ObjectResponse objectResponse = this.normalExit(completeOrderRequest, parkCode);
            if (ObjectResponse.isSuccess((Response)objectResponse)) {
                return P2cBaseResponse.success(baseRequest);
            }
            return P2cBaseResponse.instance(baseRequest, (int)Integer.parseInt(objectResponse.getCode()));
        }
        return this.saveEnex(baseRequest, parkCode, inandoutName, inandoutCode, completeOrderRequest);
    }

    private void dealPayRecord(String inandoutName, String inandoutCode, CompleteOrderRequest completeOrderRequest, String orderNum, OrderInfo orderInfo) {
        Integer paidAmountFen = completeOrderRequest.getPaidAmountFen();
        Integer discountAmountFen = completeOrderRequest.getDiscountAmountFen();
        ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(orderInfo.getParkId());
        orderInfo.setExitTime(completeOrderRequest.getExitTime());
        ObjectResponse objectResponse = this.orderService.p2cQueryFee(orderInfo, (ParkConfig)parkConfigObjectResponse.getData());
        double platform_unpayPrice = 0.0;
        double platform_discountPrice = 0.0;
        QueryOrderFeeResponse orderFeeResponse = null;
        if (ObjectResponse.isSuccess((Response)objectResponse)) {
            orderFeeResponse = (QueryOrderFeeResponse)objectResponse.getData();
            platform_unpayPrice = Double.parseDouble(orderFeeResponse.getUnpayPrice());
            platform_discountPrice = Double.parseDouble(orderFeeResponse.getDiscountPrice());
        }
        if (paidAmountFen != null && discountAmountFen != null && paidAmountFen + discountAmountFen > 0) {
            PageQuery pageQuery = new PageQuery();
            OrderPay orderPayPara = new OrderPay();
            orderPayPara.setParkId(completeOrderRequest.getParkId());
            orderPayPara.setOrderNum(orderNum);
            orderPayPara.setPayStatus(Integer.valueOf(2));
            pageQuery.setParam((Object)orderPayPara);
            ObjectResponse orderPayListObjectResponse = this.orderPayService.findList(pageQuery);
            if (ObjectResponse.isSuccess((Response)orderPayListObjectResponse)) {
                List orderPayList = (List)orderPayListObjectResponse.getData();
                for (OrderPay orderPay : orderPayList) {
                    if (orderPay.getPayTerminal() == null) continue;
                    log.info("[\u7aef\u4e91-\u8131\u673a\u5b8c\u6574\u8ba2\u5355\u8865\u62a5] \u5df2\u7ecf\u6709\u652f\u4ed8\u8bb0\u5f55\uff0c\u65e0\u9700\u5904\u7406\u76f8\u673a\u4e0a\u62a5\u4ea4\u6613\uff0c\u8ba2\u5355\u53f7[{}]", (Object)orderNum);
                    return;
                }
            }
            OrderPay orderPay = new OrderPay();
            orderPay.setPayStatus(Integer.valueOf(2));
            orderPay.setOrderNum(orderNum);
            orderPay.setChannelId(inandoutCode);
            orderPay.setPayWay(Integer.valueOf(1));
            orderPay.setTradeNo(CodeTools.GenerateTradeNo());
            orderPay.setPayTime(completeOrderRequest.getExitTime());
            orderPay.setOrderTime(completeOrderRequest.getExitTime());
            orderPay.setTotalPrice(String.valueOf((double)(paidAmountFen + discountAmountFen) / 100.0));
            orderPay.setPaidPrice(String.valueOf((double)paidAmountFen.intValue() / 100.0));
            orderPay.setDiscountPrice(String.valueOf((double)discountAmountFen.intValue() / 100.0));
            orderPay.setPayTerminal(inandoutName);
            orderPay.setPayChannel(Integer.valueOf(10));
            orderPay.setIsSync(Integer.valueOf(0));
            ObjectResponse orderPayResponse = this.orderPayService.addOrderPay(orderPay);
            if (ObjectResponse.isSuccess((Response)orderPayResponse)) {
                log.info("[\u7aef\u4e91-\u8131\u673a\u5b8c\u6574\u8ba2\u5355\u8865\u62a5]\u4fdd\u5b58\u4ea4\u6613\u8bb0\u5f55\u6210\u529f,\u53c2\u6570[{}],\u54cd\u5e94[{}]", (Object)orderPay, (Object)JsonUtils.toString((Object)orderPayResponse));
            } else {
                log.info("[\u7aef\u4e91-\u8131\u673a\u5b8c\u6574\u8ba2\u5355\u8865\u62a5]\u4fdd\u5b58\u4ea4\u6613\u8bb0\u5f55\u5931\u8d25,\u53c2\u6570[{}],\u54cd\u5e94[{}]", (Object)orderPay, (Object)JsonUtils.toString((Object)orderPayResponse));
            }
        } else if (paidAmountFen != null && discountAmountFen != null && platform_unpayPrice + platform_discountPrice > 0.0) {
            if (platform_unpayPrice == 0.0) {
                OrderPay orderPay = new OrderPay();
                orderPay.setPayStatus(Integer.valueOf(2));
                orderPay.setOrderNum(orderNum);
                orderPay.setChannelId(inandoutCode);
                orderPay.setPayWay(Integer.valueOf(1));
                orderPay.setTradeNo(CodeTools.GenerateTradeNo());
                orderPay.setPayTime(completeOrderRequest.getExitTime());
                orderPay.setOrderTime(completeOrderRequest.getExitTime());
                orderPay.setTotalPrice(String.valueOf(platform_unpayPrice + platform_discountPrice));
                orderPay.setPaidPrice("0.00");
                orderPay.setDiscountPrice(String.valueOf(platform_discountPrice));
                orderPay.setPayTerminal(inandoutName);
                orderPay.setPayChannel(Integer.valueOf(10));
                orderPay.setIsSync(Integer.valueOf(0));
                ObjectResponse orderPayResponse = this.orderPayService.addOrderPay(orderPay);
                if (ObjectResponse.isSuccess((Response)orderPayResponse)) {
                    log.info("[\u7aef\u4e91-\u8131\u673a\u5b8c\u6574\u8ba2\u5355\u8865\u62a5]\u4fdd\u5b58\u4ea4\u6613\u8bb0\u5f55\u6210\u529f,\u53c2\u6570[{}],\u54cd\u5e94[{}]", (Object)orderPay, (Object)JsonUtils.toString((Object)orderPayResponse));
                } else {
                    log.info("[\u7aef\u4e91-\u8131\u673a\u5b8c\u6574\u8ba2\u5355\u8865\u62a5]\u4fdd\u5b58\u4ea4\u6613\u8bb0\u5f55\u5931\u8d25,\u53c2\u6570[{}],\u54cd\u5e94[{}]", (Object)orderPay, (Object)JsonUtils.toString((Object)orderPayResponse));
                }
            } else {
                completeOrderRequest.setException(true);
                completeOrderRequest.setTotalAmount(orderFeeResponse.getTotalAmount());
                completeOrderRequest.setPaidAmount(orderFeeResponse.getPaidAmount());
                completeOrderRequest.setDiscountAmount(orderFeeResponse.getDiscountAmount());
            }
        }
    }

    private P2cBaseResponse saveEnex(P2cBaseRequest p2CBaseRequest, String parkCode, String inandoutName, String inandoutCode, CompleteOrderRequest completeOrderRequest) {
        completeOrderRequest.setOrderNum(null);
        String orderNum = this.normalEnter(completeOrderRequest);
        if (orderNum == null) {
            return P2cBaseResponse.instance((P2cBaseRequest)p2CBaseRequest, (int)CodeEnum.\u670d\u52a1\u5668\u5f02\u5e38.getCode());
        }
        completeOrderRequest.setOrderNum(orderNum);
        ObjectResponse orderInfoObjectResponse = this.orderService.findByOrderNum(orderNum);
        ObjectResponse.notError((Response)orderInfoObjectResponse);
        this.dealPayRecord(inandoutName, inandoutCode, completeOrderRequest, orderNum, (OrderInfo)orderInfoObjectResponse.getData());
        ObjectResponse objectResponse = this.normalExit(completeOrderRequest, parkCode);
        if (ObjectResponse.isSuccess((Response)objectResponse)) {
            return P2cBaseResponse.success((P2cBaseRequest)p2CBaseRequest);
        }
        return P2cBaseResponse.instance((P2cBaseRequest)p2CBaseRequest, (int)Integer.parseInt(objectResponse.getCode()));
    }

    private String normalEnter(CompleteOrderRequest completeOrderRequest) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        BeanUtils.copyProperties((Object)completeOrderRequest, (Object)carEnterRequest);
        carEnterRequest.setEnterWay(Integer.valueOf(1));
        ObjectResponse enterObjectResponse = this.carOrderEnterService.enter(carEnterRequest);
        if (ObjectResponse.isSuccess((Response)enterObjectResponse)) {
            return ((CarEnterResult)enterObjectResponse.getData()).getOrderNum();
        }
        log.info("[\u7aef\u4e91-\u8131\u673a\u5b8c\u6574\u8ba2\u5355\u8865\u62a5] \u5165\u573a\u5931\u8d25, \u8f66\u724c\u53f7[{}], \u539f\u56e0[{}]", (Object)completeOrderRequest.getPlateNum(), (Object)enterObjectResponse.getMsg());
        return null;
    }

    public ObjectResponse normalExit(CompleteOrderRequest completeOrderRequest, String parkCode) {
        CarExitRequest carExitRequest = new CarExitRequest();
        BeanUtils.copyProperties((Object)completeOrderRequest, (Object)carExitRequest);
        carExitRequest.setMaxImage(completeOrderRequest.getExitMaxImage());
        carExitRequest.setSmallImage(completeOrderRequest.getExitSmallImage());
        log.info("[\u7aef\u4e91-\u8131\u673a\u5b8c\u6574\u8ba2\u5355\u8865\u62a5] \u51c6\u5907\u8bf7\u6c42cloudcenter\u79bb\u573a\u670d\u52a1, \u53c2\u6570[{}]", (Object)carExitRequest);
        ObjectResponse objectResponse = completeOrderRequest.isException() ? this.carOrderExitService.exceptionExit(carExitRequest, Integer.valueOf(4)) : this.carOrderExitService.exit(carExitRequest);
        if (ObjectResponse.isSuccess((Response)objectResponse)) {
            this.cacheHandle.removeExit(parkCode, completeOrderRequest.getInandoutCode());
            this.cacheHandle.removeChannelFee(parkCode, completeOrderRequest.getInandoutCode());
        }
        return objectResponse;
    }
}

