/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.impl.DualCameraV2ServiceImpl;
import com.icetech.park.service.report.CallService;
import com.icetech.park.service.report.p2c.impl.exit.CarExitHandler;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.RedisUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cCarExitServiceImpl")
public class CarExitServiceImpl
extends AbstractService
implements CallService<CarExitRequest, CarEnexResponse> {
    private static final Logger log = LoggerFactory.getLogger(CarExitServiceImpl.class);
    private static final String REDIS_KEY_LOCK_EXIT_PREFIX = "camera:report:exit:";
    private static final long REDIS_KEY_LOCK_TIMEOUT = 10000L;
    @Autowired
    private CarExitHandler carExitHandler;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private DualCameraV2ServiceImpl dualCameraService;
    @Autowired
    private MqPushService mqPushService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public P2cBaseResponse<CarEnexResponse> execute(TokenDeviceVo deviceToken, P2cBaseRequest<CarExitRequest> baseRequest) {
        CarExitRequest exitRequest = (CarExitRequest)baseRequest.getBizContent();
        String lockKey = REDIS_KEY_LOCK_EXIT_PREFIX + deviceToken.getInandoutCode() + ":" + exitRequest.getPlateNum() + ":" + exitRequest.getExitTime();
        boolean lock = this.redisUtils.tryLock(lockKey, baseRequest.getMessageId(), 10000L);
        if (!lock) {
            String oldMsgId = this.redisUtils.getLockValue(lockKey);
            this.redisUtils.updateLockValue(lockKey, baseRequest.getMessageId());
            P2cBaseResponse p2cBaseResponse = new P2cBaseResponse();
            p2cBaseResponse.setMessageId(oldMsgId);
            p2cBaseResponse.setCmd(baseRequest.getCmd() + "_resp");
            p2cBaseResponse.setCode(CodeEnum.\u8bf7\u6c42\u91cd\u590d.getCode());
            p2cBaseResponse.setMsg("\u6b63\u5728\u5904\u7406\u4e2d");
            return p2cBaseResponse;
        }
        try {
            if (P2cVersionEnum.\u7248\u672c1.getVersion().equals(deviceToken.getVersion())) {
                Long exitTime = exitRequest.getExitTime();
                exitRequest.setExitTime(Long.valueOf(DateTools.getUnixTime((long)exitTime)));
            }
            this.verifyParams(exitRequest);
            exitRequest.setParkId(deviceToken.getParkId());
            exitRequest.setParkCode(deviceToken.getParkCode());
            exitRequest.setInandoutCode(deviceToken.getInandoutCode());
            exitRequest.setInandoutName(deviceToken.getInandoutName());
            exitRequest.setOriginalExitTime(exitRequest.getExitTime());
            this.carExitHandler.addExitRecord(exitRequest);
            exitRequest.setOrderNum(null);
            P2cBaseResponse<CarEnexResponse> response = this.carExitHandler.execute(deviceToken, baseRequest);
            String messageId = this.redisUtils.getLockValue(lockKey);
            if (messageId != null) {
                response.setMessageId(messageId);
            }
            this.dualCameraHandle(deviceToken, exitRequest, (CarEnexResponse)response.getData());
            this.pushDigitalTwin(deviceToken, exitRequest, (CarEnexResponse)response.getData());
            P2cBaseResponse<CarEnexResponse> p2cBaseResponse = response;
            return p2cBaseResponse;
        }
        finally {
            this.redisUtils.releaseLock(lockKey);
        }
    }

    private void dualCameraHandle(TokenDeviceVo deviceToken, CarExitRequest exitRequest, CarEnexResponse carEnexResponse) {
        if (TriggerTypeEnum.\u8f6f\u89e6\u53d1.getVal().equals(exitRequest.getTriggerType()) || Integer.valueOf(2).equals(exitRequest.getProperty())) {
            return;
        }
        this.dualCameraService.afterHandle(carEnexResponse, deviceToken.getParkId(), deviceToken.getParkCode(), deviceToken.getInandoutCode(), deviceToken.getInandoutType(), exitRequest.getPlateNum(), exitRequest.getOpenFlag(), deviceToken.getDeviceNo());
    }

    private void pushDigitalTwin(TokenDeviceVo deviceToken, CarExitRequest request, CarEnexResponse response) {
        try {
            if (response == null || StringUtils.isBlank((CharSequence)response.getShow())) {
                return;
            }
            this.mqPushService.pushOrderEnexShow(deviceToken.getParkId(), deviceToken.getInandoutCode(), deviceToken.getDeviceNo(), response.getShow());
        }
        catch (Exception e) {
            log.warn("\u63a8\u9001\u6570\u636e\u5b6a\u751f\u51fa\u9519", (Throwable)e);
        }
    }
}

