/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.impl.DualCameraV2ServiceImpl;
import com.icetech.park.service.report.CallService;
import com.icetech.park.service.report.p2c.impl.enter.CarEnterHandler;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.RedisUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cCarEnterServiceImpl")
public class CarEnterServiceImpl
extends AbstractService
implements CallService<CarEnterRequest, CarEnexResponse> {
    private static final Logger log = LoggerFactory.getLogger(CarEnterServiceImpl.class);
    @Autowired
    private CarEnterHandler carEnterHandler;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private DualCameraV2ServiceImpl dualCameraService;
    private static final String REDIS_KEY_LOCK_ENTER_PREFIX = "camera:report:enter:";
    private static final long REDIS_KEY_LOCK_TIMEOUT = 10000L;
    @Autowired
    private MqPushService mqPushService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public P2cBaseResponse<CarEnexResponse> execute(TokenDeviceVo deviceToken, P2cBaseRequest<CarEnterRequest> baseRequest) {
        CarEnterRequest enterRequest = (CarEnterRequest)baseRequest.getBizContent();
        String lockKey = REDIS_KEY_LOCK_ENTER_PREFIX + deviceToken.getInandoutCode() + ":" + enterRequest.getPlateNum() + ":" + enterRequest.getEnterTime();
        boolean lock = this.redisUtils.tryLock(lockKey, baseRequest.getMessageId(), 10000L);
        if (!lock) {
            String oldMsgId = this.redisUtils.getLockValue(lockKey);
            this.redisUtils.updateLockValue(lockKey, baseRequest.getMessageId());
            P2cBaseResponse p2cBaseResponse = new P2cBaseResponse();
            p2cBaseResponse.setMessageId(oldMsgId);
            p2cBaseResponse.setCmd(baseRequest.getCmd() + "_resp");
            p2cBaseResponse.setCode(CodeEnum.\u8bf7\u6c42\u91cd\u590d.getCode());
            p2cBaseResponse.setMsg("\u6b63\u5728\u5904\u7406\u4e2d");
            return p2cBaseResponse;
        }
        try {
            String version = deviceToken.getVersion();
            String serialNumber = deviceToken.getDeviceNo();
            if (P2cVersionEnum.\u7248\u672c1.getVersion().equals(version)) {
                Long enterTime = enterRequest.getEnterTime();
                enterRequest.setEnterTime(Long.valueOf(DateTools.getUnixTime((long)enterTime)));
            }
            this.verifyParams(enterRequest);
            enterRequest.setParkId(deviceToken.getParkId());
            enterRequest.setParkCode(deviceToken.getParkCode());
            enterRequest.setInandoutCode(deviceToken.getInandoutCode());
            enterRequest.setInandoutName(deviceToken.getInandoutName());
            enterRequest.setOrderNum(CodeTools.GenerateOrderNum());
            this.carEnterHandler.addEnterRecord(enterRequest);
            CarEnexResponse carEnexResponse = this.carEnterHandler.execute(enterRequest, serialNumber, version);
            this.dualCameraHandle(deviceToken, enterRequest, carEnexResponse);
            this.pushDigitalTwin(deviceToken, enterRequest, carEnexResponse);
            P2cBaseResponse p2cBaseResponse = P2cBaseResponse.success(baseRequest, (Object)carEnexResponse);
            return p2cBaseResponse;
        }
        finally {
            this.redisUtils.releaseLock(lockKey);
        }
    }

    private void dualCameraHandle(TokenDeviceVo deviceToken, CarEnterRequest enterRequest, CarEnexResponse carEnexResponse) {
        if (TriggerTypeEnum.\u8f6f\u89e6\u53d1.getVal().equals(enterRequest.getTriggerType()) || Integer.valueOf(2).equals(enterRequest.getProperty())) {
            return;
        }
        this.dualCameraService.afterHandle(carEnexResponse, deviceToken.getParkId(), deviceToken.getParkCode(), deviceToken.getInandoutCode(), deviceToken.getInandoutType(), enterRequest.getPlateNum(), enterRequest.getOpenFlag(), deviceToken.getDeviceNo());
    }

    private void pushDigitalTwin(TokenDeviceVo deviceToken, CarEnterRequest request, CarEnexResponse response) {
        try {
            if (response == null || StringUtils.isBlank((CharSequence)response.getShow())) {
                return;
            }
            this.mqPushService.pushOrderEnexShow(deviceToken.getParkId(), deviceToken.getInandoutCode(), deviceToken.getDeviceNo(), response.getShow());
        }
        catch (Exception e) {
            log.warn("\u63a8\u9001\u6570\u636e\u5b6a\u751f\u51fa\u9519", (Throwable)e);
        }
    }
}

