/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.p2c.ApplyConfigRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.impl.ChannelRulesServiceImpl;
import com.icetech.park.service.down.p2c.impl.ChargeRuleServiceImpl;
import com.icetech.park.service.down.p2c.impl.KeyValueServiceImpl;
import com.icetech.park.service.down.p2c.impl.LcdConfigServiceImpl;
import com.icetech.park.service.down.p2c.impl.LedsoundConfigServiceImpl;
import com.icetech.park.service.down.p2c.impl.OssConfigServiceImpl;
import com.icetech.park.service.down.p2c.impl.P2cParkRegionServiceImpl;
import com.icetech.park.service.down.p2c.impl.VipTypeServiceImpl;
import com.icetech.park.service.report.CallService;
import java.util.Arrays;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cApplyConfigServiceImpl")
public class ApplyConfigServiceImpl
extends AbstractService
implements CallService<ApplyConfigRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(ApplyConfigServiceImpl.class);
    @Autowired
    private OssConfigServiceImpl ossConfigService;
    @Autowired
    private ChannelRulesServiceImpl channelRulesService;
    @Autowired
    private KeyValueServiceImpl keyValueService;
    @Autowired
    private ChargeRuleServiceImpl chargeRuleService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private LedsoundConfigServiceImpl ledsoundConfigService;
    @Autowired
    private LcdConfigServiceImpl lcdConfigService;
    @Autowired
    private VipTypeServiceImpl vipTypeService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private P2cParkRegionServiceImpl parkRegionService;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<ApplyConfigRequest> baseRequest) {
        ApplyConfigRequest applyConfigRequest = (ApplyConfigRequest)baseRequest.getBizContent();
        this.verifyParams(applyConfigRequest);
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.asyncHandle(deviceToken.getParkCode(), deviceToken.getParkId(), deviceToken.getDeviceNo(), deviceToken.getVersion(), applyConfigRequest)));
        return P2cBaseResponse.success(baseRequest);
    }

    private void asyncHandle(String parkCode, Long parkId, String serialNumber, String version, ApplyConfigRequest applyConfigRequest) {
        try {
            String configTypes = applyConfigRequest.getConfigTypes();
            String[] types = configTypes.split(",");
            Arrays.stream(types).forEach(type -> {
                if (Integer.parseInt(type) == 1) {
                    this.channelRulesService.send(parkCode, serialNumber);
                } else if (Integer.parseInt(type) == 2) {
                    ObjectResponse deviceResp = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
                    ObjectResponse.notError((Response)deviceResp);
                    ParkDevice device = (ParkDevice)deviceResp.getData();
                    ObjectResponse channelResp = this.parkService.getInoutDeviceById(Long.valueOf(device.getChannelId().longValue()));
                    ObjectResponse.notError((Response)channelResp);
                    ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
                    Integer ledLcdSource = channel.getLedLcdSource();
                    if (NumberUtils.toPrimitive((Integer)ledLcdSource) == 2) {
                        this.lcdConfigService.send(parkCode, channel, serialNumber);
                    } else {
                        this.ledsoundConfigService.send(parkCode, channel, serialNumber, version);
                    }
                } else if (Integer.parseInt(type) == 3) {
                    this.ossConfigService.send(parkCode, serialNumber);
                } else if (Integer.parseInt(type) == 4) {
                    this.keyValueService.send(parkCode, serialNumber);
                } else if (Integer.parseInt(type) == 5) {
                    this.chargeRuleService.send(parkCode, serialNumber, version);
                } else if (Integer.parseInt(type) == 6) {
                    this.vipTypeService.send(parkId, parkCode, serialNumber, version, applyConfigRequest.getFilter());
                } else if (Integer.parseInt(type) == 7) {
                    this.parkRegionService.send(parkId, parkCode, serialNumber);
                }
            });
        }
        catch (ResponseBodyException e) {
            log.warn("[\u914d\u7f6e\u4e0b\u53d1]\u88ab\u52a8\u4e0b\u53d1\u914d\u7f6e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }
}

