/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.mor.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.mor.BarrierGateStatusRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.order.domain.entity.BarrierGateException;
import com.icetech.order.service.BarrierGateExceptionService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class MorBarrierGateStatusServiceImpl
extends AbstractService
implements CallService<BarrierGateStatusRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(MorBarrierGateStatusServiceImpl.class);
    @Resource
    private BarrierGateExceptionService barrierGateExceptionService;
    @Resource
    private ParkService parkService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Value(value="${barrier-gate.alarm.push-message:defaultValue}")
    private String parkId;
    @Value(value="${barrier-gate.alarm.all.push-message.turn:false}")
    private boolean barrierGateTurn;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceInfo, P2cBaseRequest<BarrierGateStatusRequest> baseRequest) {
        BarrierGateException barrierGateException;
        BarrierGateStatusRequest barrierGateStatusRequest = (BarrierGateStatusRequest)baseRequest.getBizContent();
        this.verifyParams(barrierGateStatusRequest);
        BarrierGateException one = (BarrierGateException)this.barrierGateExceptionService.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BarrierGateException.class).eq(BarrierGateException::getChannelId, (Object)deviceInfo.getId())).orderByDesc(BarrierGateException::getId));
        if (one != null && barrierGateStatusRequest.getStatus().equals(one.getStatus())) {
            return P2cBaseResponse.success(baseRequest, null);
        }
        if (one == null && barrierGateStatusRequest.getStatus() == 1) {
            return P2cBaseResponse.success(baseRequest, null);
        }
        if (barrierGateStatusRequest.getStatus() == 2) {
            barrierGateException = new BarrierGateException();
            barrierGateException.setChannelId(deviceInfo.getId());
            barrierGateException.setReportSn(deviceInfo.getDeviceNo());
            barrierGateException.setChannelName(deviceInfo.getInandoutName());
            barrierGateException.setParkId(deviceInfo.getParkId());
            barrierGateException.setStatus(Integer.valueOf(2));
            barrierGateException.setAlarmTime(new Date(barrierGateStatusRequest.getEventTime() * 1000L));
            barrierGateException.setExceptionImage(barrierGateStatusRequest.getImage());
            this.barrierGateExceptionService.addBarrierGateException(barrierGateException);
            this.pushBarrierGateAlarmMessage(deviceInfo);
        }
        if (one != null && barrierGateStatusRequest.getStatus() == 1) {
            barrierGateException = new BarrierGateException();
            barrierGateException.setId(one.getId());
            barrierGateException.setStatus(Integer.valueOf(1));
            barrierGateException.setRecoverTime(new Date(barrierGateStatusRequest.getEventTime() * 1000L));
            barrierGateException.setRecoverImage(barrierGateStatusRequest.getImage());
            this.barrierGateExceptionService.updateById((Object)barrierGateException);
        }
        return P2cBaseResponse.success(baseRequest, null);
    }

    private void pushBarrierGateAlarmMessage(TokenDeviceVo deviceInfo) {
        if (this.parkId.contains(String.valueOf(deviceInfo.getParkId())) || this.barrierGateTurn) {
            log.info("\u6536\u5230\u9053\u95f8\u5f02\u5e38\u901a\u9053\u4fe1\u606f:{}", (Object)deviceInfo);
            ObjectResponse findByParkId = this.parkService.findByParkId(deviceInfo.getParkId());
            if (!ObjectResponse.isSuccess((Response)findByParkId)) {
                return;
            }
            Park park = (Park)findByParkId.getData();
            WebsocketPushData pushData = new WebsocketPushData();
            pushData.setRecordType(Integer.valueOf(4));
            pushData.setParkName(park.getParkName());
            pushData.setParkCode(park.getParkCode());
            pushData.setParkId(park.getId());
            pushData.setChannelCode(deviceInfo.getInandoutCode());
            pushData.setChannelType(deviceInfo.getInandoutType());
            pushData.setChannelName(deviceInfo.getInandoutName());
            String data = JsonUtils.toString((Object)pushData);
            log.info("\u53d1\u9001\u9053\u95f8\u5f02\u5e38\u6d88\u606f:{}", (Object)data);
            this.redisTemplate.convertAndSend("parkToWebscoket", (Object)data);
        }
    }
}

