/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.mor.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.mor.BackEventRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.ApplyCarVideoVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.dao.OrderModifyRecordDao;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderModifyRecord;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.order.service.impl.OrderBackServiceImpl;
import com.icetech.order.service.impl.OrderCarInfoServiceImpl;
import com.icetech.order.service.impl.OrderTagsServiceImpl;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.order.impl.OrderServiceImpl;
import com.icetech.park.service.report.CallService;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@RefreshScope
public class MorBackEventServiceImpl
extends AbstractService
implements CallService<BackEventRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(MorBackEventServiceImpl.class);
    @Resource
    private OrderServiceImpl orderService;
    @Resource
    private OrderCarInfoServiceImpl orderCarInfoService;
    @Resource
    private OrderBackServiceImpl orderBackService;
    @Resource
    private OrderTagsServiceImpl orderTagsService;
    @Resource
    private RabbitSender rabbitSender;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private CacheHandle cacheHandle;
    @Resource
    private OrderModifyRecordDao orderModifyRecordDao;
    @Resource
    private SendinfoDao sendinfoDao;
    @Resource
    private ParkService parkService;
    @Resource
    private OrderNotpayService orderNotpayService;
    @Value(value="${aisle.applyCarVideo.time:30}")
    private Integer aisleApplyCarVideoTime;
    @Value(value="${aisle.exceptionExit.time:600}")
    private Integer aisleExceptionExitTime;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceInfo, P2cBaseRequest<BackEventRequest> baseRequest) {
        BackEventRequest backEventRequest = (BackEventRequest)baseRequest.getBizContent();
        this.verifyParams(backEventRequest);
        OrderInfo orderInfo = this.getOrderInfo(backEventRequest, deviceInfo);
        if (orderInfo == null) {
            log.warn("[\u6298\u8fd4\u4e8b\u4ef6\u4e0a\u62a5] \u672a\u5339\u914d\u5230\u8ba2\u5355, [{}]", (Object)backEventRequest);
            return P2cBaseResponse.success(baseRequest, null);
        }
        if (deviceInfo.getInandoutType() == 1) {
            OrderBack orderBack = this.insertOrderBack(orderInfo, backEventRequest, deviceInfo);
            this.orderTags(orderInfo);
            this.getApplyCarVideo(deviceInfo, orderInfo, backEventRequest, orderBack);
            this.redisUtils.set("mor:back:" + orderInfo.getOrderNum(), (Object)orderBack, (long)(this.aisleExceptionExitTime + 5));
            this.updateEnterChannelCache(deviceInfo, orderInfo, orderBack);
        } else {
            boolean isPnc;
            if (2 == orderInfo.getServiceStatus() && NumberUtils.toPrimitive((Long)backEventRequest.getRecTime(), (long)DateTools.unixTimestamp()) - orderInfo.getExitTime() > 1200L) {
                log.warn("[\u6298\u8fd4\u4e8b\u4ef6\u4e0a\u62a5] \u4e0a\u6b21\u8ba2\u5355\u79bb\u573a\u8d85\u8fc7\u4e8620\u5206\u949f, \u672a\u5339\u914d\u5230\u8ba2\u5355, [{}]", (Object)backEventRequest);
                return P2cBaseResponse.success(baseRequest, null);
            }
            ObjectResponse parkConfigResp = this.parkService.getParkConfig(orderInfo.getParkId());
            boolean bl = isPnc = parkConfigResp.getData() != null && ((ParkConfig)parkConfigResp.getData()).getDataCollection() == 2;
            if (isPnc || 1 != orderInfo.getServiceStatus()) {
                this.updateOrderInfo(orderInfo);
                this.insertOrderModifyRecord(orderInfo, isPnc);
            }
            OrderBack orderBack = this.insertOrderBack(orderInfo, backEventRequest, deviceInfo);
            this.orderTags(orderInfo);
            this.getApplyCarVideo(deviceInfo, orderInfo, backEventRequest, orderBack);
            this.redisUtils.set("mor:back:" + orderInfo.getOrderNum(), (Object)orderBack, (long)(this.aisleExceptionExitTime + 5));
            this.updateExitChannelCache(deviceInfo, orderInfo, orderBack);
        }
        return P2cBaseResponse.success(baseRequest, null);
    }

    private OrderInfo getOrderInfo(BackEventRequest backEventRequest, TokenDeviceVo deviceVo) {
        if (StringUtils.isBlank((CharSequence)backEventRequest.getPlateNum()) || DataCommonConstants.isNoPlate((String)backEventRequest.getPlateNum())) {
            ObjectResponse<List<OrderInfo>> response = this.orderService.selectListByParam(deviceVo.getParkId(), backEventRequest.getBackStartTime(), backEventRequest.getBackEndTime(), null);
            if (!ObjectResponse.isSuccess(response)) {
                log.warn("[\u6298\u8fd4\u4e8b\u4ef6\u4e0a\u62a5] \u8bf7\u6c42\u5931\u8d25\uff01, [{}]", (Object)backEventRequest);
                return null;
            }
            List infoList = (List)response.getData();
            Map<String, List<OrderInfo>> listMap = infoList.stream().collect(Collectors.groupingBy(OrderInfo::getOrderNum));
            ObjectResponse carInfoObjectResponse = this.orderCarInfoService.getCarInfoList(listMap.keySet(), deviceVo.getParkId());
            OrderInfo orderInfo = null;
            if (ObjectResponse.isSuccess((Response)carInfoObjectResponse)) {
                for (OrderCarInfo datum : (List)carInfoObjectResponse.getData()) {
                    if (!deviceVo.getInandoutCode().equals(datum.getEnterChannelId()) && !deviceVo.getInandoutCode().equals(datum.getExitChannelId())) continue;
                    orderInfo = listMap.get(datum.getOrderNum()).get(0);
                }
            }
            return orderInfo;
        }
        return (OrderInfo)this.orderService.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getParkId, (Object)deviceVo.getParkId())).eq(OrderInfo::getPlateNum, (Object)backEventRequest.getPlateNum())).orderByDesc(OrderInfo::getEnterTime));
    }

    private void insertOrderModifyRecord(OrderInfo orderInfo, Boolean isPnc) {
        OrderModifyRecord orderModifyRecord = new OrderModifyRecord();
        orderModifyRecord.setAction(Integer.valueOf(1));
        orderModifyRecord.setCorrectType(Integer.valueOf(4));
        orderModifyRecord.setOrderNum(orderInfo.getOrderNum());
        orderModifyRecord.setParkId(orderInfo.getParkId());
        orderModifyRecord.setBeforeModify(String.valueOf(orderInfo.getServiceStatus()));
        orderModifyRecord.setAfterModify(String.valueOf(1));
        orderModifyRecord.setModifyTime(DateTools.getFormat((Date)new Date()));
        orderModifyRecord.setOperAccount("system.mor");
        this.orderModifyRecordDao.insert((Object)orderModifyRecord);
        if (isPnc.booleanValue()) {
            this.sendinfoDao.insert((Object)new SendInfo(orderInfo.getParkId(), orderModifyRecord.getId(), DownServiceEnum.\u8ba2\u5355\u4fee\u6539.getServiceType()));
        }
    }

    private OrderBack insertOrderBack(OrderInfo orderInfo, BackEventRequest backEvent, TokenDeviceVo deviceVo) {
        OrderBack orderBack = new OrderBack();
        BeanUtils.copyProperties((Object)orderInfo, (Object)orderBack);
        if (orderInfo.getExitTime() == null) {
            if (backEvent.getRecTime() != null) {
                orderBack.setExitTime(backEvent.getRecTime());
            } else {
                orderBack.setExitTime(Long.valueOf(backEvent.getBackStartTime() - 2L));
            }
        }
        if (NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 1) {
            orderBack.setEnterTime(null);
        }
        orderBack.setId(null);
        orderBack.setCreateTime(null);
        orderBack.setBackStartTime(backEvent.getBackStartTime());
        orderBack.setBackEndTime(backEvent.getBackEndTime());
        orderBack.setVideoId(backEvent.getVideoId());
        orderBack.setChannelName(deviceVo.getInandoutName());
        orderBack.setChannelId(deviceVo.getId());
        orderBack.setInandoutType(deviceVo.getInandoutType());
        this.orderBackService.addOrderBack(orderBack);
        return orderBack;
    }

    private void orderTags(OrderInfo orderInfo) {
        Optional<OrderTags> notPayOrder;
        List listByOrderNum = this.orderTagsService.getListByOrderNum(orderInfo.getOrderNum(), null);
        Optional<OrderTags> first = listByOrderNum.stream().filter(orderTags -> OrderTags.TagIdEnum.BACK_IN_PARK.getType() == orderTags.getTagId().intValue()).findFirst();
        if (!first.isPresent()) {
            OrderTags orderTags2 = new OrderTags();
            orderTags2.setOrderNum(orderInfo.getOrderNum());
            orderTags2.setParkId(orderInfo.getParkId());
            orderTags2.setRegionId(orderInfo.getRegionId());
            orderTags2.setTagId(Integer.valueOf(OrderTags.TagIdEnum.BACK_IN_PARK.getType()));
            this.orderTagsService.addOrderTags(orderTags2);
        }
        if ((notPayOrder = listByOrderNum.stream().filter(orderTags -> OrderTags.TagIdEnum.NOT_PAY_CAR.getType() == orderTags.getTagId().intValue()).findFirst()).isPresent()) {
            this.orderNotpayService.deleteByOrderNum(orderInfo.getOrderNum());
        }
    }

    private void updateOrderInfo(OrderInfo orderInfo) {
        this.orderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(OrderInfo.class).set(OrderInfo::getExitTime, null)).set(OrderInfo::getOddStatus, null)).set(OrderInfo::getServiceStatus, (Object)1)).eq(OrderInfo::getId, (Object)orderInfo.getId()));
    }

    private void getApplyCarVideo(TokenDeviceVo deviceVo, OrderInfo orderInfo, BackEventRequest backEvent, OrderBack orderBack) {
        ApplyCarVideoVo vo = new ApplyCarVideoVo();
        vo.setVideoType(Integer.valueOf(2));
        vo.setSn(deviceVo.getDeviceNo());
        vo.setChannelId(deviceVo.getId());
        vo.setOrderNum(orderInfo.getOrderNum());
        vo.setParkId(orderInfo.getParkId());
        vo.setPlateNum(orderInfo.getPlateNum());
        vo.setVideoId(backEvent.getVideoId());
        vo.setRecTime(orderBack.getExitTime());
        this.rabbitSender.sendMessage("aisle.delayed.exchange", "apply.car.video.routing", (Object)vo, Long.valueOf((long)this.aisleApplyCarVideoTime.intValue() * 1000L));
        log.info("[\u6298\u8fd4\u4e8b\u4ef6\u4e0a\u62a5] \u8bf7\u6c42\u89c6\u9891\u5ef6\u8fdf\u6d88\u606f\u53d1\u9001, [{}]", (Object)vo);
    }

    private void updateEnterChannelCache(TokenDeviceVo deviceVo, OrderInfo orderInfo, OrderBack orderBack) {
        CarEnterRequest enter = this.cacheHandle.getEntrance(deviceVo.getParkCode(), deviceVo.getInandoutCode());
        if (enter != null && enter.getPlateNum().equals(orderInfo.getPlateNum()) && Math.abs(enter.getEnterTime() - orderBack.getEnterTime()) < 5L) {
            log.info("[\u5165\u573a\u6298\u8fd4\u4e8b\u4ef6\u4e0a\u62a5] \u5220\u9664\u901a\u9053\u7f13\u5b58, \u8f66\u724c\u53f7[{}]", (Object)orderInfo.getPlateNum());
            this.cacheHandle.removeEntrace(deviceVo.getParkCode(), deviceVo.getInandoutCode());
            this.cacheHandle.removeChannelFee(deviceVo.getParkCode(), deviceVo.getInandoutCode());
        }
    }

    private void updateExitChannelCache(TokenDeviceVo deviceVo, OrderInfo orderInfo, OrderBack orderBack) {
        CarExitRequest exit = this.cacheHandle.getExit(deviceVo.getParkCode(), deviceVo.getInandoutCode());
        if (exit != null && exit.getPlateNum().equals(orderInfo.getPlateNum()) && Math.abs(exit.getOriginalExitTime() - orderBack.getExitTime()) < 5L) {
            log.info("[\u51fa\u573a\u6298\u8fd4\u4e8b\u4ef6\u4e0a\u62a5] \u5220\u9664\u901a\u9053\u7f13\u5b58, \u8f66\u724c\u53f7[{}]", (Object)orderInfo.getPlateNum());
            this.cacheHandle.removeExit(deviceVo.getParkCode(), deviceVo.getInandoutCode());
            this.cacheHandle.removeChannelFee(deviceVo.getParkCode(), deviceVo.getInandoutCode());
        }
    }
}

