/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.itc.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.domain.request.itc.RetentionCarRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.AisleInfoVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="itcRetentionCarServiceImpl")
public class RetentionCarServiceImpl
extends AbstractService
implements CallService<RetentionCarRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(RetentionCarServiceImpl.class);
    @Autowired
    private AlarmService alarmService;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<RetentionCarRequest> baseRequest) {
        RetentionCarRequest retentionCarRequest = (RetentionCarRequest)baseRequest.getBizContent();
        this.verifyParams(retentionCarRequest);
        AisleInfoVo aisleInfoVo = new AisleInfoVo();
        aisleInfoVo.setParkCode(deviceToken.getParkCode());
        aisleInfoVo.setParkId(deviceToken.getParkId());
        aisleInfoVo.setAisleType(deviceToken.getInandoutType());
        aisleInfoVo.setAisleCode(deviceToken.getInandoutCode());
        this.alarmService.aisleDurationAlarm(aisleInfoVo);
        return P2cBaseResponse.success(baseRequest);
    }
}

