/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.itc.impl;

import com.icetech.cloudcenter.domain.request.itc.RetentionCarLeaveRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="itcRetentionCarLeaveServiceImpl")
public class RetentionCarLeaveServiceImpl
extends AbstractService
implements CallService<RetentionCarLeaveRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(RetentionCarLeaveServiceImpl.class);
    @Resource
    private ChannelAlarmDao channelAlarmDao;
    @Resource
    private CacheHandle cacheHandle;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<RetentionCarLeaveRequest> baseRequest) {
        RetentionCarLeaveRequest retentionCarLeaveRequest = (RetentionCarLeaveRequest)baseRequest.getBizContent();
        this.verifyParams(retentionCarLeaveRequest);
        ChannelAlarm channelAlarm = new ChannelAlarm();
        channelAlarm.setParkId(deviceToken.getParkId());
        channelAlarm.setChannelCode(deviceToken.getInandoutCode());
        channelAlarm.setStatus(Integer.valueOf(ChannelAlarm.Status.\u5df2\u5904\u7406.getStatus()));
        this.channelAlarmDao.update(channelAlarm);
        this.cacheHandle.removeExit(deviceToken.getParkCode(), deviceToken.getInandoutCode());
        this.cacheHandle.removeChannelFee(deviceToken.getParkCode(), deviceToken.getInandoutCode());
        return P2cBaseResponse.success(baseRequest);
    }
}

