/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.itc.impl;

import cn.hutool.core.thread.ThreadUtil;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.ItcVersionEnum;
import com.icetech.cloudcenter.domain.request.itc.PropertyInfoRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.DeviceUpgradeHandle;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.report.CallService;
import com.icetech.third.utils.RedisUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="itcPropertyInfoServiceImpl")
public class PropertyInfoServiceImpl
extends AbstractService
implements CallService<PropertyInfoRequest, Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(PropertyInfoServiceImpl.class);
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private DeviceUpgradeHandle deviceUpgradeHandle;
    @Autowired
    private ItcCacheHandle cacheHandle;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public P2cBaseResponse<Map<String, Object>> execute(TokenDeviceVo deviceInfo, P2cBaseRequest<PropertyInfoRequest> baseRequest) {
        PropertyInfoRequest propertyInfoRequest = (PropertyInfoRequest)baseRequest.getBizContent();
        this.verifyParams(propertyInfoRequest);
        String reportVersion = propertyInfoRequest.getVersion().trim();
        if (ItcVersionEnum.getIndex((String)reportVersion) == 0) {
            return P2cBaseResponse.instance(baseRequest, (int)CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode(), (String)"\u7248\u672c\u53f7\u4e0d\u5b58\u5728");
        }
        CompletableFuture.runAsync(() -> this.setCache(deviceInfo, propertyInfoRequest, reportVersion));
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("enexType", deviceInfo.getInandoutType());
        this.propertyModify(propertyInfoRequest, deviceInfo.getDeviceNo(), deviceInfo.getSource());
        return P2cBaseResponse.success(baseRequest, dataMap);
    }

    private void setCache(TokenDeviceVo deviceInfo, PropertyInfoRequest propertyInfoRequest, String reportVersion) {
        if (!reportVersion.equals(deviceInfo.getVersion())) {
            deviceInfo.setVersion(reportVersion);
            this.cacheHandle.updateDeviceInfo(deviceInfo.getDeviceNo(), deviceInfo);
        }
        if (this.redisUtils.exists("p2c:property:get:flag:" + deviceInfo.getDeviceNo())) {
            this.redisUtils.set("p2c:property:get:info:" + deviceInfo.getDeviceNo(), (Object)propertyInfoRequest, 8L);
        }
    }

    private void propertyModify(PropertyInfoRequest propertyInfoRequest, String serialNumber, Integer protocolType) {
        ThreadUtil.execute(() -> {
            ObjectResponse deviceBySerialNumber = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
            ParkDevice parkDevice = (ParkDevice)deviceBySerialNumber.getData();
            String protocolVer = propertyInfoRequest.getVersion();
            String productModel = propertyInfoRequest.getProductModel();
            String firmwareVersion = propertyInfoRequest.getFirmwareVersion();
            Integer connectionMode = propertyInfoRequest.getConnectionMode();
            Integer wirelessCarrier = propertyInfoRequest.getWirelessCarrier();
            String network = propertyInfoRequest.getNetwork();
            if (firmwareVersion != null) {
                this.deviceUpgradeHandle.versionModify(serialNumber, firmwareVersion);
            }
            if (!protocolVer.equals(parkDevice.getProtocolVer()) || !protocolType.equals(parkDevice.getProtocolType()) || productModel != null && !productModel.equals(parkDevice.getProductModel()) || firmwareVersion != null && !firmwareVersion.equals(parkDevice.getFirmwareVersion()) || connectionMode != null && !connectionMode.equals(parkDevice.getCallMethods()) || wirelessCarrier != null && !wirelessCarrier.equals(parkDevice.getWirelessCarrier()) || network != null && !network.equals(parkDevice.getNetwork())) {
                parkDevice.setProtocolVer(protocolVer);
                parkDevice.setProtocolType(protocolType);
                parkDevice.setProductModel(productModel);
                parkDevice.setFirmwareVersion(firmwareVersion);
                parkDevice.setCallMethods(connectionMode);
                parkDevice.setWirelessCarrier(wirelessCarrier);
                parkDevice.setNetwork(network);
                this.parkDeviceService.updateDevice(parkDevice);
                log.info("[\u8bbe\u5907\u5c5e\u6027\u4e0a\u62a5\u63a5\u53e3] \u66f4\u65b0\u7248\u672c\u53f7\u548c\u534f\u8bae\u7c7b\u578b\u5b8c\u6210, sn[{}], protocolType[{}], protocolVer[{}], productModel[{}], firmwareVersion[{}]", new Object[]{serialNumber, protocolType, protocolVer, productModel, firmwareVersion});
            }
        });
    }
}

