/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.itc.impl;

import com.icetech.cloudcenter.api.paycode.PayCodePrePayService;
import com.icetech.cloudcenter.api.third.ThirdParkService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.itc.PayCodeRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.validator.Validator;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import com.icetech.third.service.SendOpenMsgService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="itcPayCodeServiceImpl")
public class PayCodeServiceImpl
extends AbstractService
implements CallService<PayCodeRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(PayCodeServiceImpl.class);
    @Autowired
    private PayCodePrePayService payCodePrePayService;
    @Resource
    private ThirdParkService thirdParkService;
    @Autowired
    private SendOpenMsgService sendOpenMsgService;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<PayCodeRequest> baseRequest) {
        PayCodeRequest payCodeRequest = (PayCodeRequest)baseRequest.getBizContent();
        Validator.validate((Object)payCodeRequest);
        ObjectResponse response = this.payCodePrePayService.prePay(deviceToken.getParkCode(), deviceToken.getDeviceNo(), deviceToken.getInandoutCode(), payCodeRequest.getPayCode());
        if (!ObjectResponse.isSuccess((Response)response)) {
            return P2cBaseResponse.instance(baseRequest, (int)CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode(), (String)response.getMsg());
        }
        return P2cBaseResponse.success(baseRequest);
    }
}

