/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.itc.impl;

import cn.hutool.core.thread.ThreadUtil;
import com.icetech.cloudcenter.domain.request.p2c.ApplyConfigRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.itc.impl.ItcOssConfigServiceImpl;
import com.icetech.park.service.report.CallService;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="itcApplyConfigServiceImpl")
public class ApplyConfigServiceImpl
extends AbstractService
implements CallService<ApplyConfigRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(ApplyConfigServiceImpl.class);
    @Autowired
    private ItcOssConfigServiceImpl ossConfigService;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<ApplyConfigRequest> baseRequest) {
        ApplyConfigRequest applyConfigRequest = (ApplyConfigRequest)baseRequest.getBizContent();
        this.verifyParams(applyConfigRequest);
        ThreadUtil.execute(() -> this.asyncHandle(deviceToken.getParkCode(), deviceToken.getDeviceNo(), applyConfigRequest));
        return P2cBaseResponse.success(baseRequest);
    }

    private void asyncHandle(String parkCode, String serialNumber, ApplyConfigRequest applyConfigRequest) {
        try {
            String configTypes = applyConfigRequest.getConfigTypes();
            String[] types = configTypes.split(",");
            Arrays.stream(types).forEach(type -> {
                if (Integer.parseInt(type) == 1) {
                    this.ossConfigService.send(parkCode, serialNumber);
                }
            });
        }
        catch (ResponseBodyException e) {
            log.warn("[\u914d\u7f6e\u4e0b\u53d1]\u88ab\u52a8\u4e0b\u53d1\u914d\u7f6e\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

