/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.full.impl;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.Base64Tools;
import com.icetech.park.domain.vo.full.UpSnapshotVO;
import com.icetech.park.service.down.full.impl.FullCloudSnapShotServiceImpl;
import com.icetech.park.service.report.full.FullUpSnapshotService;
import com.icetech.park.service.report.full.impl.ExtractContentAfterDomain;
import com.icetech.third.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FullUpSnapshotServiceImpl
implements FullUpSnapshotService {
    private static final Logger log = LoggerFactory.getLogger(FullUpSnapshotServiceImpl.class);
    private final RedisUtils redisUtils;
    private final FullCloudSnapShotServiceImpl fullCloudSnapShotService;
    private static final String KEY_PREFIX_SNAPSHOT_SN = "snapshot:sn:";

    @Override
    public ObjectResponse<?> executeSnapshot(UpSnapshotVO upSnapshotVO, String sn) {
        String redisKey = KEY_PREFIX_SNAPSHOT_SN + sn;
        String imgPath = ExtractContentAfterDomain.extractContentAfterDomain(Base64Tools.decodeBase64String((String)upSnapshotVO.getImgPath()), "aliyuncs.com/");
        String messageId = this.redisUtils.get(redisKey);
        log.info("\u83b7\u53d6\u79d2\u56fe\u6293\u62cd\u7684Key\uff1a{},MessageId:{},\u79d2\u56fe\u5730\u5740\uff1a{}", new Object[]{redisKey, messageId, imgPath});
        this.fullCloudSnapShotService.notify(messageId, imgPath, sn);
        return ObjectResponse.success();
    }

    public FullUpSnapshotServiceImpl(RedisUtils redisUtils, FullCloudSnapShotServiceImpl fullCloudSnapShotService) {
        this.redisUtils = redisUtils;
        this.fullCloudSnapShotService = fullCloudSnapShotService;
    }
}

