/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.full.impl;

import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.response.p2c.HeartbeatResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.request.HeartbeatRequest;
import com.icetech.park.domain.vo.full.KeepAliveVo;
import com.icetech.park.service.handle.P2cOperHandle;
import com.icetech.park.service.report.full.FullHeartbeatService;
import com.icetech.park.service.report.p2c.impl.HeartbeatServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FullHeartbeatServiceImpl
implements FullHeartbeatService {
    private static final Logger log = LoggerFactory.getLogger(FullHeartbeatServiceImpl.class);
    private final HeartbeatServiceImpl heartbeatService;
    private final P2cOperHandle p2cOperHandle;

    @Override
    public ObjectResponse<?> heartbeat(KeepAliveVo keepAliveVo, String sn) {
        TokenDeviceVo deviceToken = this.p2cOperHandle.getAndCacheDevice(sn, TokenDeviceVo.ProtocolTypeEnum.MQTT);
        HeartbeatRequest heartbeatRequest = new HeartbeatRequest();
        heartbeatRequest.setVersion(P2cVersionEnum.\u7248\u672c20.getVersion());
        heartbeatRequest.setDeviceTime(keepAliveVo.getTimestamp());
        P2cBaseRequest request = new P2cBaseRequest();
        request.setBizContent((Object)heartbeatRequest);
        P2cBaseResponse<HeartbeatResponse> response = this.heartbeatService.execute(deviceToken, (P2cBaseRequest<HeartbeatRequest>)request);
        if (response.getCode().equals(CodeEnum.\u6210\u529f.getCode())) {
            return ObjectResponse.success();
        }
        return ObjectResponse.failed();
    }

    public FullHeartbeatServiceImpl(HeartbeatServiceImpl heartbeatService, P2cOperHandle p2cOperHandle) {
        this.heartbeatService = heartbeatService;
        this.p2cOperHandle = p2cOperHandle;
    }
}

