/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.full.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.Base64Tools;
import com.icetech.park.domain.dto.full.IvsResultDTO;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.full.impl.FullCloudGpIoOutServiceImpl;
import com.icetech.park.service.down.full.impl.FullCloudSerialDataServiceImpl;
import com.icetech.park.service.factory.SendServiceFactory;
import com.icetech.park.service.report.CallService;
import com.icetech.park.service.report.full.FullEventCarService;
import com.icetech.park.service.report.full.impl.ExtractContentAfterDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FullEventCarServiceImpl
implements FullEventCarService {
    private static final Logger log = LoggerFactory.getLogger(FullEventCarServiceImpl.class);
    private final CacheHandle cacheHandle;
    private final ObjectMapper objectMapper;
    private final FullCloudGpIoOutServiceImpl fullDownGpIoOutService;
    private final FullCloudSerialDataServiceImpl fullCloudSerialDataService;

    @Override
    public P2cBaseResponse<?> eventCar(IvsResultDTO resultDTO, String messageId, String sn) {
        String channelCode = String.valueOf(resultDTO.getAlarmInfoPlate().getChannel());
        TokenDeviceVo deviceToken = this.cacheHandle.getDeviceInfo(sn);
        if (deviceToken == null) {
            log.info("\u83b7\u53d6\u8bbe\u5907\u901a\u9053\u4fe1\u606f\u5931\u8d25\uff01,channelCode:{},deviceToken:{}", (Object)channelCode, (Object)deviceToken);
            P2cBaseResponse p2cBaseResponse = new P2cBaseResponse();
            p2cBaseResponse.setCode(CodeEnum.\u672a\u5173\u8054\u901a\u9053\u4fe1\u606f.getCode());
            p2cBaseResponse.setMsg("\u83b7\u53d6\u8bbe\u5907\u901a\u9053\u4fe1\u606f\u5931\u8d25!");
            return p2cBaseResponse;
        }
        P2cBaseRequest<Object> content = this.assembleContent(resultDTO, messageId, deviceToken);
        String cmd = content.getCmd();
        CallService callService = SendServiceFactory.getP2cBean(cmd, CallService.class);
        P2cBaseResponse response = callService.execute(deviceToken, content);
        log.info("\u51fa\u5165\u573a\u8fd4\u56de\u53c2\u6570\uff1a{}", response);
        if (response.getCode() != 200) {
            P2cBaseResponse resp = new P2cBaseResponse();
            resp.setCode(CodeEnum.\u670d\u52a1\u5668\u5f02\u5e38.getCode());
            return resp;
        }
        CompletableFuture.runAsync(ThreadUtils.wrapTrace(() -> {
            try {
                this.brakeIo((P2cBaseResponse<Object>)response, deviceToken);
                this.brakeIoExecute((P2cBaseResponse<Object>)response, deviceToken);
            }
            catch (Exception e) {
                log.error("\u5f00\u95f8\u6216\u5c4f\u663e\u8bed\u97f3\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
        }));
        return response;
    }

    private void brakeIo(P2cBaseResponse<Object> response, TokenDeviceVo deviceToken) {
        CarEnexResponse carEnexResponse = (CarEnexResponse)response.getData();
        if (carEnexResponse.getOpenFlag() != 1) {
            log.info("\u4e0d\u4e0b\u53d1\u5f00\u95f8\u4fe1\u606f\uff01");
            return;
        }
        log.info("\u4e0b\u53d1\u5f00\u95f8\u4fe1\u606f");
        OpenBrakeRequest open = new OpenBrakeRequest();
        open.setParkCode(deviceToken.getParkCode());
        open.setAisleCode(deviceToken.getDeviceNo());
        this.fullDownGpIoOutService.requestOpenBrake(open, deviceToken.getParkId());
    }

    private void brakeIoExecute(P2cBaseResponse<Object> response, TokenDeviceVo deviceToken) {
        CarEnexResponse carEnexResponse = (CarEnexResponse)response.getData();
        log.info("\u4e0b\u53d1\u8bed\u97f3\uff1a{}\uff0c\u5c4f\u663e\uff1a{}", (Object)carEnexResponse.getSay(), (Object)carEnexResponse.getShow());
        HintRequest hintRequest = new HintRequest();
        hintRequest.setShow(carEnexResponse.getShow());
        hintRequest.setShowType(carEnexResponse.getShowType());
        hintRequest.setSay(carEnexResponse.getSay());
        hintRequest.setExtendShow(carEnexResponse.getExtendShow());
        this.fullCloudSerialDataService.execute(deviceToken.getParkId(), deviceToken.getParkCode(), deviceToken.getDeviceNo(), hintRequest);
    }

    public P2cBaseRequest<Object> assembleContent(IvsResultDTO ivsResultDTO, String messageId, TokenDeviceVo channel) {
        P2cBaseRequest request = new P2cBaseRequest();
        if (channel.getInandoutType() == 1) {
            request.setCmd("car_enter");
            request.setBizContent(this.objectMapper.convertValue(FullEventCarServiceImpl.assembleBizContent(ivsResultDTO, channel), (TypeReference)new TypeReference<CarEnterRequest>(){}));
        } else {
            request.setCmd("car_exit");
            request.setBizContent(this.objectMapper.convertValue(FullEventCarServiceImpl.assembleBizContent(ivsResultDTO, channel), (TypeReference)new TypeReference<CarExitRequest>(){}));
        }
        request.setMessageId(messageId);
        return request;
    }

    public static Map<String, Object> assembleBizContent(IvsResultDTO payload, TokenDeviceVo deviceToken) {
        HashMap<String, Object> bizContent = new HashMap<String, Object>(16);
        bizContent.put("reportTime", System.currentTimeMillis());
        bizContent.put("openFlag", 0);
        bizContent.put("type", 1);
        bizContent.put("property", 1);
        bizContent.put("plateNum", FullEventCarServiceImpl.getPlateNum(Base64Tools.decodeBase64String((String)payload.getAlarmInfoPlate().getResult().getPlateResult().getLicense())));
        bizContent.put("triggerType", 2);
        bizContent.put("plateColor", FullEventCarServiceImpl.getPlateColor(payload.getAlarmInfoPlate().getResult().getPlateResult().getColorType()));
        bizContent.put("shamFlag", payload.getAlarmInfoPlate().getResult().getPlateResult().getIsFakePlate() == 0 ? 1 : 0);
        bizContent.put("carType", 1);
        bizContent.put("reliability", 28);
        bizContent.put("carColor", FullEventCarServiceImpl.getCarColor(payload.getAlarmInfoPlate().getResult().getPlateResult().getCarColor()));
        bizContent.put("maxImage", ExtractContentAfterDomain.extractContentAfterDomain(Base64Tools.decodeBase64String((String)payload.getAlarmInfoPlate().getResult().getPlateResult().getImagePath()), "aliyuncs.com/"));
        bizContent.put("smallImage", ExtractContentAfterDomain.extractContentAfterDomain(Base64Tools.decodeBase64String((String)payload.getAlarmInfoPlate().getResult().getPlateResult().getImagePath()), "aliyuncs.com/"));
        if (deviceToken.getInandoutType() == 1) {
            bizContent.put("enterTime", payload.getAlarmInfoPlate().getResult().getPlateResult().getTimeStamp().getTimeval().getSec());
        } else {
            bizContent.put("exitTime", payload.getAlarmInfoPlate().getResult().getPlateResult().getTimeStamp().getTimeval().getSec());
        }
        return bizContent;
    }

    private static String getPlateColor(int colorValue) {
        switch (colorValue) {
            case 2: {
                return "\u9ec4\u8272";
            }
            case 3: {
                return "\u767d\u8272";
            }
            case 4: {
                return "\u9ed1\u8272";
            }
            case 5: {
                return "\u7eff\u8272";
            }
            case 6: {
                return "\u9ec4\u7eff";
            }
        }
        return "\u84dd\u8272";
    }

    private static String getCarColor(int carColor) {
        switch (carColor) {
            case 0: {
                return "\u767d\u8272";
            }
            case 1: {
                return "\u94f6\u8272";
            }
            case 2: {
                return "\u9ec4\u8272";
            }
            case 3: {
                return "\u7c89\u8272";
            }
            case 4: {
                return "\u7ea2\u8272";
            }
            case 5: {
                return "\u7eff\u8272";
            }
            case 6: {
                return "\u84dd\u7eff";
            }
            case 7: {
                return "\u68d5\u7eff";
            }
            case 8: {
                return "\u9ed1\u7eff";
            }
            case 9: {
                return "\u7070\u7eff";
            }
        }
        return "\u672a\u77e5";
    }

    private static String getPlateNum(String plateNum) {
        if ("_\u65e0_".equals(plateNum)) {
            return "\u672a\u8bc6\u522b";
        }
        return plateNum;
    }

    public FullEventCarServiceImpl(CacheHandle cacheHandle, ObjectMapper objectMapper, FullCloudGpIoOutServiceImpl fullDownGpIoOutService, FullCloudSerialDataServiceImpl fullCloudSerialDataService) {
        this.cacheHandle = cacheHandle;
        this.objectMapper = objectMapper;
        this.fullDownGpIoOutService = fullDownGpIoOutService;
        this.fullCloudSerialDataService = fullCloudSerialDataService;
    }
}

