/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report;

import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.utils.SpringUtils;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.month.MonthCarService;
import com.icetech.cloudcenter.api.month.MonthProductService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.api.user.VehicleService;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.response.MonthAbDto;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.cloudcenter.domain.response.NotPayDetail;
import com.icetech.cloudcenter.domain.response.QueryNotPayResponse;
import com.icetech.cloudcenter.domain.response.VipDetailDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.dao.monthcar.MonthRegionDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRegion;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.order.service.OrderTagsService;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.service.monthcar.MonthCarServiceBase;
import com.icetech.park.service.park.ParkRecoveryService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportParamHolder {
    private static final Logger log = LoggerFactory.getLogger(ReportParamHolder.class);
    private ParkService parkService;
    private ParkDeviceService parkDeviceService;
    private LcdService lcdService;
    private LedService ledService;
    private BlacklistService blacklistService;
    private OrderService orderService;
    private MonthCarService monthCarService;
    private MonthProductService monthProductService;
    private VipCarService vipCarService;
    private ParkVisitService parkVisitService;
    private VehicleService vehicleService;
    private StoreCardService storeCardService;
    private OrderTagsService orderTagsService;
    private MonthRegionDao monthRegionDao;
    private VipRegionService vipRegionService;
    protected Long parkId;
    protected String parkCode;
    protected String serialNumber;
    protected String channelCode;
    protected String version;
    protected Integer versionIndex;
    protected String plateNum;
    protected String orderNum;
    protected Integer enexType;
    protected Integer regionType;
    protected Integer chargeLiveCount;
    protected Integer oilLiveCount;
    protected Map<String, Object> displayParamMap;
    protected ParkDevice parkDevice;
    protected ParkRegion parkRegion;
    protected ParkInoutdevice parkChannel;
    protected Park parkInfo;
    protected ParkConfig parkConfig;
    protected ParkFreespace parkFreeSpace;
    protected OrderNotpayService orderNotpayService;
    protected ObjectResponse<LedConfig> ledConfigResp;
    protected ObjectResponse<LcdConfig> lcdConfigResp;
    protected ObjectResponse<OrderInfo> fuzzyInOrder;
    protected ObjectResponse<OrderInfo> fuzzyOutOrder;
    protected ObjectResponse<Blacklist> blacklistResp;
    protected MonthDetailDto monthDetail;
    protected MonthDetailDto otherRegionMonthDetail;
    protected ObjectResponse<VipType> vipTypeResp;
    protected VipDetailDto otherRegionVipDetailDto;
    protected ObjectResponse<ParkVisit> parkVisitResp;
    protected ObjectResponse<VehiclePlate> vehiclePlateResp;
    protected ObjectResponse<StoreCard> storeCardResp;
    protected QueryNotPayResponse queryNotPayResponse;
    protected OrderInfo replenishOrder;
    protected List<OrderSonInfo> orderSonInfos;
    protected ParkRecoveryService parkRecoveryService;

    public ReportParamHolder(Long parkId, String parkCode, String channelCode, String serialNumber, String version, String plateNum, Integer enexType, String orderNum) {
        this.parkId = parkId;
        this.parkCode = parkCode;
        this.channelCode = channelCode;
        this.serialNumber = serialNumber;
        this.version = version;
        this.versionIndex = P2cVersionEnum.getIndex((String)version);
        this.plateNum = plateNum;
        this.enexType = enexType;
        this.orderNum = orderNum;
        this.displayParamMap = new HashMap<String, Object>();
        this.parkService = (ParkService)SpringUtils.getBean(ParkService.class);
        this.parkDeviceService = (ParkDeviceService)SpringUtils.getBean(ParkDeviceService.class);
        this.lcdService = (LcdService)SpringUtils.getBean(LcdService.class);
        this.ledService = (LedService)SpringUtils.getBean(LedService.class);
        this.blacklistService = (BlacklistService)SpringUtils.getBean(BlacklistService.class);
        this.orderService = (OrderService)SpringUtils.getBean(OrderService.class);
        this.monthCarService = (MonthCarService)SpringUtils.getBean(MonthCarService.class);
        this.monthProductService = (MonthProductService)SpringUtils.getBean(MonthProductService.class);
        this.vipCarService = (VipCarService)SpringUtils.getBean(VipCarService.class);
        this.parkVisitService = (ParkVisitService)SpringUtils.getBean(ParkVisitService.class);
        this.vehicleService = (VehicleService)SpringUtils.getBean(VehicleService.class);
        this.storeCardService = (StoreCardService)SpringUtils.getBean(StoreCardService.class);
        this.orderTagsService = (OrderTagsService)SpringUtils.getBean(OrderTagsService.class);
        this.monthRegionDao = (MonthRegionDao)SpringUtils.getBean(MonthRegionDao.class);
        this.vipRegionService = (VipRegionService)SpringUtils.getBean(VipRegionService.class);
        this.orderNotpayService = (OrderNotpayService)SpringUtils.getBean(OrderNotpayService.class);
        this.parkRecoveryService = (ParkRecoveryService)SpringUtils.getBean(ParkRecoveryService.class);
    }

    public Integer getChargeLiveCount() {
        if (this.chargeLiveCount == null) {
            this.chargeLiveCount = this.orderService.getChargeLiveCount(this.getParkId());
        }
        return this.chargeLiveCount;
    }

    public Integer getOilLiveCount() {
        if (this.oilLiveCount == null) {
            this.oilLiveCount = this.orderService.getOilLiveCount(this.getParkId());
        }
        return this.oilLiveCount;
    }

    public ParkDevice getParkDevice() {
        if (this.parkDevice == null) {
            ObjectResponse deviceResp = this.parkDeviceService.getDeviceBySerialNumber(this.getSerialNumber());
            ObjectResponse.notError((Response)deviceResp);
            this.parkDevice = (ParkDevice)deviceResp.getData();
        }
        return this.parkDevice;
    }

    public ParkInoutdevice getParkChannel() {
        if (this.parkChannel == null) {
            ObjectResponse channelInfoResp = this.parkService.getInOutDeviceByCode(this.getParkId(), this.getChannelCode());
            ObjectResponse.notError((Response)channelInfoResp);
            this.parkChannel = (ParkInoutdevice)channelInfoResp.getData();
        }
        return this.parkChannel;
    }

    public Park getParkInfo() {
        if (this.parkInfo == null) {
            ObjectResponse parkResp = this.parkService.findByParkId(this.getParkId());
            ObjectResponse.notError((Response)parkResp);
            this.parkInfo = (Park)parkResp.getData();
        }
        return this.parkInfo;
    }

    public ParkConfig getParkConfig() {
        if (this.parkConfig == null) {
            ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(this.getParkId());
            ObjectResponse.notError((Response)parkConfigObjectResponse);
            this.parkConfig = (ParkConfig)parkConfigObjectResponse.getData();
        }
        return this.parkConfig;
    }

    public ParkFreespace getParkFreeSpace() {
        if (this.parkFreeSpace == null) {
            Park park = this.getParkInfo();
            if (park.getIsInterior() == null || Integer.valueOf(0).equals(park.getIsInterior())) {
                ObjectResponse spaceResp = this.parkService.getParkSpace(this.parkId);
                if (!ObjectResponse.isSuccess((Response)spaceResp)) {
                    return null;
                }
                this.parkFreeSpace = (ParkFreespace)spaceResp.getData();
            } else {
                ParkRegion parkRegion = this.getParkRegion();
                if (parkRegion != null) {
                    this.parkFreeSpace = new ParkFreespace();
                    this.parkFreeSpace.setFreeSpace(parkRegion.getFreePark());
                    this.parkFreeSpace.setRealFreeSpace(parkRegion.getRealFreePark());
                    this.parkFreeSpace.setTotalNum(parkRegion.getRegionPark());
                    this.parkFreeSpace.setParkId(parkRegion.getParkId());
                }
            }
        }
        return this.parkFreeSpace;
    }

    public ParkRegion getParkRegion() {
        if (this.parkRegion == null) {
            Long regionId = this.getParkChannel().getRegionId();
            if (regionId == null) {
                return null;
            }
            ObjectResponse regionObjectResponse = this.parkService.getParkRegionById(regionId);
            if (!ObjectResponse.isSuccess((Response)regionObjectResponse)) {
                return null;
            }
            this.parkRegion = (ParkRegion)regionObjectResponse.getData();
        }
        return this.parkRegion;
    }

    public ObjectResponse<LedConfig> getLedConfigResp() {
        if (this.ledConfigResp == null) {
            this.ledConfigResp = this.ledService.getLedConfigByChannel(this.getParkChannel().getId());
        }
        return this.ledConfigResp;
    }

    public ObjectResponse<LcdConfig> getLcdConfigResp() {
        if (this.lcdConfigResp == null) {
            this.lcdConfigResp = this.lcdService.getLcdConfigByChannel(this.getParkChannel().getId());
        }
        return this.lcdConfigResp;
    }

    public ObjectResponse<OrderInfo> getFuzzyInOrder() {
        if (this.fuzzyInOrder == null) {
            ParkInoutdevice parkChannel = this.getParkChannel();
            this.fuzzyInOrder = parkChannel.getIsOpenVaguetype() != null && parkChannel.getIsOpenVaguetype() == 1 ? this.orderService.fuzzyOrderPlate(this.getParkId().longValue(), this.getPlateNum(), 1, parkChannel.getVaguetype().intValue()) : ObjectResponse.returnNotFoundIfNull(null);
        }
        return this.fuzzyInOrder;
    }

    public ObjectResponse<OrderInfo> getFuzzyOutOrder() {
        if (this.fuzzyOutOrder == null) {
            ParkInoutdevice parkChannel = this.getParkChannel();
            this.fuzzyOutOrder = parkChannel.getIsOpenVaguetype() != null && parkChannel.getIsOpenVaguetype() == 1 ? this.orderService.fuzzyOutPlate(this.getParkId(), this.getPlateNum()) : ObjectResponse.returnNotFoundIfNull(null);
        }
        return this.fuzzyOutOrder;
    }

    public ObjectResponse<Blacklist> getBlacklistResp() {
        if (this.blacklistResp == null) {
            this.blacklistResp = this.blacklistService.getValidByPlate(this.getParkId(), this.getPlateNum());
        }
        return this.blacklistResp;
    }

    public MonthDetailDto getOtherRegionMonthDetail() {
        if (this.otherRegionMonthDetail != null) {
            return this.otherRegionMonthDetail;
        }
        this.otherRegionMonthDetail = new MonthDetailDto();
        this.otherRegionMonthDetail.setMonthType(MonthDetailDto.MonthType.\u975e\u6708\u5361\u8f66);
        Park park = this.getParkInfo();
        if (park.getIsInterior() == null || park.getIsInterior() == 0) {
            return this.otherRegionMonthDetail;
        }
        ParkInoutdevice channel = this.getParkChannel();
        if (Integer.valueOf(0).equals(channel.getIsMaster())) {
            return this.otherRegionMonthDetail;
        }
        ParkRegion parkRegion = this.getParkRegion();
        if (parkRegion == null) {
            return this.otherRegionMonthDetail;
        }
        if (parkRegion.getFatherRelationId() != null && !Long.valueOf(0L).equals(parkRegion.getFatherRelationId())) {
            return this.otherRegionMonthDetail;
        }
        ObjectResponse monthInfoResp = this.monthCarService.getMonthInfo(this.parkId.longValue(), this.plateNum, MonthCarServiceBase.VALID_CARD.intValue(), null);
        if (ObjectResponse.isSuccess((Response)monthInfoResp)) {
            MonthInfo monthInfo = (MonthInfo)monthInfoResp.getData();
            List monthRegions = this.monthRegionDao.selectByMonthId(monthInfo.getId().longValue());
            if (!CollectionUtils.isEmpty((Collection)monthRegions)) {
                Optional<MonthRegion> any = monthRegions.stream().filter(monthRegion -> !Long.valueOf(0L).equals(monthRegion.getRegionId()) && !parkRegion.getId().equals(monthRegion.getRegionId())).findAny();
                if (!any.isPresent()) {
                    return this.otherRegionMonthDetail;
                }
                this.otherRegionMonthDetail.setMonthInfo(monthInfo);
                this.otherRegionMonthDetail.setMonthType(MonthDetailDto.MonthType.\u6708\u5361\u8f66);
                MonthProduct monthProduct = this.monthProductService.selectMonthProductById(monthInfo.getProductId());
                this.otherRegionMonthDetail.setMonthProduct(monthProduct);
                MonthRegion monthRegion2 = any.get();
                ObjectResponse objectResponse = this.parkService.getParkRegionById(monthRegion2.getRegionId());
                this.otherRegionMonthDetail.setParkRegion((ParkRegion)objectResponse.getData());
            }
        } else {
            monthInfoResp = this.monthCarService.getMonthInfo(this.parkId.longValue(), this.plateNum, MonthCarServiceBase.TIMEOUT_CARD.intValue(), null);
            if (ObjectResponse.isSuccess((Response)monthInfoResp)) {
                MonthInfo monthInfo = (MonthInfo)monthInfoResp.getData();
                List monthRegions = this.monthRegionDao.selectByMonthId(monthInfo.getId().longValue());
                if (!CollectionUtils.isEmpty((Collection)monthRegions)) {
                    Optional<MonthRegion> any = monthRegions.stream().filter(monthRegion -> !Long.valueOf(0L).equals(monthRegion.getRegionId()) && !parkRegion.getId().equals(monthRegion.getRegionId())).findAny();
                    if (!any.isPresent()) {
                        return this.otherRegionMonthDetail;
                    }
                    MonthRegion monthRegion3 = any.get();
                    ObjectResponse objectResponse = this.parkService.getParkRegionById(monthRegion3.getRegionId());
                    this.otherRegionMonthDetail.setParkRegion((ParkRegion)objectResponse.getData());
                }
                this.otherRegionMonthDetail.setMonthType(MonthDetailDto.MonthType.\u8fc7\u671f\u4e34\u65f6\u8f66);
                this.otherRegionMonthDetail.setMonthInfo(monthInfo);
                ParkConfig parkConfig = this.getParkConfig();
                Integer expireMcDays = 0;
                Integer expireDaysMonth = 0;
                if (parkConfig != null) {
                    expireMcDays = parkConfig.getExpireMcDays();
                    expireDaysMonth = parkConfig.getIsExpireMc();
                }
                if (NumberUtils.toPrimitive((Integer)expireDaysMonth) == 1) {
                    MonthProduct monthProduct = this.monthProductService.selectMonthProductById(monthInfo.getProductId());
                    this.otherRegionMonthDetail.setMonthProduct(monthProduct);
                    if (this.otherRegionMonthDetail.getExpiredDays() <= NumberUtils.toPrimitive((Integer)expireMcDays)) {
                        this.otherRegionMonthDetail.setMonthType(MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66);
                    }
                }
            }
        }
        return this.otherRegionMonthDetail;
    }

    public MonthDetailDto getMonthDetail() {
        if (this.monthDetail != null) {
            return this.monthDetail;
        }
        this.monthDetail = new MonthDetailDto();
        this.monthDetail.setMonthType(MonthDetailDto.MonthType.\u975e\u6708\u5361\u8f66);
        Park park = this.getParkInfo();
        ParkInoutdevice channel = this.getParkChannel();
        Long innerRegionId = park.getIsInterior() != null && park.getIsInterior() == 1 ? channel.getRegionId() : null;
        ObjectResponse monthInfoResp = this.monthCarService.getMonthInfo(this.parkId.longValue(), this.plateNum, MonthCarServiceBase.VALID_CARD.intValue(), innerRegionId);
        if (ObjectResponse.isSuccess((Response)monthInfoResp)) {
            OrderTags orderTags;
            MonthInfo monthInfo = (MonthInfo)monthInfoResp.getData();
            this.monthDetail.setMonthInfo(monthInfo);
            this.monthDetail.setMonthType(MonthDetailDto.MonthType.\u6708\u5361\u8f66);
            if (this.enexType == 1) {
                ObjectResponse monthAbDtoObjectResponse;
                if (monthInfo.getMoreMonthType() != null && monthInfo.getMoreMonthType() == 1) {
                    MonthAbDto monthAbDto;
                    log.info("\u8fdb\u5165\u96c6\u56e2\u6708\u5361\u7684\u5904\u7406\u903b\u8f91 {},{}", (Object)monthInfo, (Object)this.plateNum);
                    monthAbDtoObjectResponse = this.monthCarService.groupAbMonthCar(this.plateNum, monthInfo.getId().longValue(), monthInfo.getPlotCount());
                    if (ObjectResponse.isSuccess((Response)monthAbDtoObjectResponse) && !(monthAbDto = (MonthAbDto)monthAbDtoObjectResponse.getData()).getMonthCar().booleanValue() && monthAbDto.getAbCar().booleanValue()) {
                        this.monthDetail.setMonthType(MonthDetailDto.MonthType.\u591a\u4f4d\u591a\u8f66\u5360\u7528);
                        this.monthDetail.setMonthAbDto(monthAbDto);
                    }
                } else {
                    MonthAbDto monthAbDto;
                    monthAbDtoObjectResponse = this.monthCarService.abMonthCar(this.parkId, this.plateNum, monthInfo.getId().longValue(), monthInfo.getPlotCount(), channel.getRegionId());
                    if (ObjectResponse.isSuccess((Response)monthAbDtoObjectResponse) && !(monthAbDto = (MonthAbDto)monthAbDtoObjectResponse.getData()).getMonthCar().booleanValue() && monthAbDto.getAbCar().booleanValue()) {
                        this.monthDetail.setMonthType(MonthDetailDto.MonthType.\u591a\u4f4d\u591a\u8f66\u5360\u7528);
                        this.monthDetail.setMonthAbDto(monthAbDto);
                    }
                }
            } else if (StringUtils.isNotBlank((CharSequence)this.orderNum) && (orderTags = this.orderTagsService.getListByOrderNumAndTagId(this.orderNum, Integer.valueOf(1), innerRegionId)) != null) {
                this.monthDetail.setMonthType(MonthDetailDto.MonthType.\u591a\u4f4d\u591a\u8f66\u5360\u7528);
            }
            MonthProduct monthProduct = this.monthProductService.selectMonthProductById(monthInfo.getProductId());
            this.monthDetail.setMonthProduct(monthProduct);
        } else {
            monthInfoResp = this.monthCarService.getMonthInfo(this.parkId.longValue(), this.plateNum, MonthCarServiceBase.TIMEOUT_CARD.intValue(), innerRegionId);
            if (ObjectResponse.isSuccess((Response)monthInfoResp)) {
                MonthInfo monthInfo = (MonthInfo)monthInfoResp.getData();
                this.monthDetail.setMonthType(MonthDetailDto.MonthType.\u8fc7\u671f\u4e34\u65f6\u8f66);
                this.monthDetail.setMonthInfo(monthInfo);
                ParkConfig parkConfig = this.getParkConfig();
                Integer expireMcDays = 0;
                Integer expireDaysMonth = 0;
                if (parkConfig != null) {
                    expireMcDays = parkConfig.getExpireMcDays();
                    expireDaysMonth = parkConfig.getIsExpireMc();
                }
                if (expireDaysMonth != null && expireDaysMonth == 1 && this.monthDetail.getExpiredDays() <= NumberUtils.toPrimitive((Integer)expireMcDays)) {
                    OrderTags orderTags;
                    MonthProduct monthProduct = this.monthProductService.selectMonthProductById(monthInfo.getProductId());
                    this.monthDetail.setMonthProduct(monthProduct);
                    this.monthDetail.setMonthType(MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66);
                    if (this.enexType == 1) {
                        MonthAbDto monthAbDto;
                        ObjectResponse monthAbDtoObjectResponse = this.monthCarService.abMonthCar(this.parkId, this.plateNum, monthInfo.getId().longValue(), monthInfo.getPlotCount(), innerRegionId);
                        if (ObjectResponse.isSuccess((Response)monthAbDtoObjectResponse) && !(monthAbDto = (MonthAbDto)monthAbDtoObjectResponse.getData()).getMonthCar().booleanValue() && monthAbDto.getAbCar().booleanValue()) {
                            this.monthDetail.setMonthType(MonthDetailDto.MonthType.\u591a\u4f4d\u591a\u8f66\u5360\u7528);
                            this.monthDetail.setMonthAbDto(monthAbDto);
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)this.orderNum) && (orderTags = this.orderTagsService.getListByOrderNumAndTagId(this.orderNum, Integer.valueOf(1), innerRegionId)) != null) {
                        this.monthDetail.setMonthType(MonthDetailDto.MonthType.\u591a\u4f4d\u591a\u8f66\u5360\u7528);
                    }
                }
            }
        }
        return this.monthDetail;
    }

    public ObjectResponse<VipType> getVipTypeResp() {
        if (this.vipTypeResp != null) {
            return this.vipTypeResp;
        }
        Park park = this.getParkInfo();
        ParkInoutdevice parkChannel = this.getParkChannel();
        Long regionId = park.getIsInterior() != null && park.getIsInterior() == 1 ? parkChannel.getRegionId() : null;
        this.vipTypeResp = this.vipCarService.getValidVipCar(this.getParkId(), this.getPlateNum(), regionId);
        return this.vipTypeResp;
    }

    public VipDetailDto getOtherRegionVipDetailDto() {
        VipRegion vipRegion;
        if (this.otherRegionVipDetailDto != null) {
            return this.otherRegionVipDetailDto;
        }
        Park parkInfo = this.getParkInfo();
        if (parkInfo.getIsInterior() == null || parkInfo.getIsInterior() == 0) {
            return null;
        }
        ParkInoutdevice parkChannel = this.getParkChannel();
        if (Integer.valueOf(0).equals(parkChannel.getIsMaster())) {
            return null;
        }
        if (parkChannel.getRegionId() == null) {
            return null;
        }
        ObjectResponse regionObjectResponse = this.parkService.getParkRegionById(parkChannel.getRegionId());
        if (!ObjectResponse.isSuccess((Response)regionObjectResponse)) {
            return null;
        }
        if (((ParkRegion)regionObjectResponse.getData()).getFatherRelationId() != null && !Long.valueOf(0L).equals(((ParkRegion)regionObjectResponse.getData()).getFatherRelationId())) {
            return null;
        }
        ObjectResponse vipTypeResp = this.vipCarService.getValidVipCar(this.getParkId(), this.getPlateNum(), null);
        if (!ObjectResponse.isSuccess((Response)vipTypeResp)) {
            return null;
        }
        VipType vipType = (VipType)vipTypeResp.getData();
        List vipRegionList = this.vipRegionService.getVipRegionsListByVipTypeId(vipType.getId());
        if (CollectionUtils.isNotEmpty((Collection)vipRegionList) && (vipRegion = (VipRegion)vipRegionList.stream().filter(v -> v.getRegionId() != 0L).filter(vr -> !vr.getRegionId().equals(parkChannel.getRegionId())).findFirst().orElse(null)) != null) {
            ObjectResponse objectResponse = this.parkService.getParkRegionById(vipRegion.getRegionId());
            this.otherRegionVipDetailDto = new VipDetailDto();
            this.otherRegionVipDetailDto.setVipType(vipType);
            this.otherRegionVipDetailDto.setParkRegion((ParkRegion)objectResponse.getData());
            ObjectResponse listObjectResponse = this.parkService.getInOutDevicesByRegionId(vipRegion.getRegionId(), Integer.valueOf(1));
            if (ObjectResponse.isSuccess((Response)listObjectResponse)) {
                List collect = ((List)listObjectResponse.getData()).stream().filter(parkInoutdevice -> Integer.valueOf(0).equals(parkInoutdevice.getIsMaster())).collect(Collectors.toList());
                this.otherRegionVipDetailDto.setEntranceChannelList(collect);
            }
            return this.otherRegionVipDetailDto;
        }
        return null;
    }

    public ObjectResponse<ParkVisit> getParkVisitResp() {
        if (this.parkVisitResp == null) {
            this.parkVisitResp = this.parkVisitService.checkVisitPlate(this.getParkId(), this.getPlateNum());
        }
        return this.parkVisitResp;
    }

    public ObjectResponse<VehiclePlate> getVehiclePlateResp() {
        if (this.vehiclePlateResp == null) {
            this.vehiclePlateResp = this.vehicleService.selectVip(this.getParkId(), this.getPlateNum());
        }
        return this.vehiclePlateResp;
    }

    public ObjectResponse<StoreCard> getStoreCardResp() {
        if (this.storeCardResp == null) {
            this.storeCardResp = this.storeCardService.getValidStoreCards(this.getPlateNum(), this.getParkId());
        }
        return this.storeCardResp;
    }

    public Object putDisplayParam(String name, Object value) {
        return this.displayParamMap.put(name, value);
    }

    public Object getDisplayParam(String name) {
        return this.displayParamMap.get(name);
    }

    public Integer getRegionType() {
        if (this.regionType != null) {
            return this.regionType;
        }
        ParkRegion parkRegion = this.getParkRegion();
        this.regionType = parkRegion != null ? Integer.valueOf(Long.valueOf(0L).equals(parkRegion.getFatherRelationId()) ? 1 : 2) : Integer.valueOf(1);
        return this.regionType;
    }

    public QueryNotPayResponse queryNotPayFee() {
        if (this.queryNotPayResponse != null) {
            return this.queryNotPayResponse;
        }
        List<ParkRecoveryVo> recoverys = this.parkRecoveryService.getOpenParkRecoveryByParkIds(Collections.singletonList(this.parkId));
        if (CollectionUtils.isEmpty(recoverys)) {
            this.queryNotPayResponse = new QueryNotPayResponse();
            return this.queryNotPayResponse;
        }
        List orderNotPays = this.orderNotpayService.queryNotPayFee(this.parkId, this.getPlateNum(), this.enexType, this.getParkConfig());
        if (CollectionUtils.isEmpty((Collection)orderNotPays)) {
            this.queryNotPayResponse = new QueryNotPayResponse();
            return this.queryNotPayResponse;
        }
        ArrayList<NotPayDetail> notPayDetails = new ArrayList<NotPayDetail>();
        BigDecimal sumPrice = new BigDecimal(0);
        this.queryNotPayResponse = new QueryNotPayResponse();
        for (OrderNotpay orderNotPay : orderNotPays) {
            if (orderNotPay.getOrderNum().equals(this.getOrderNum())) continue;
            NotPayDetail notPayDetail = NotPayDetail.builder().parkId(orderNotPay.getParkId()).orderNum(orderNotPay.getOrderNum()).enterTime(orderNotPay.getEnterTime()).exitTime(orderNotPay.getExitTime()).totalPrice(orderNotPay.getTotalPrice().toString()).discountPrice(orderNotPay.getDiscountPrice().toString()).unPayPrice(orderNotPay.getTotalPrice().toString()).parkTime(orderNotPay.getEnterTime() == null ? null : Long.valueOf(orderNotPay.getExitTime() - orderNotPay.getEnterTime())).orderSource(Integer.valueOf(orderNotPay.getOrderSource())).build();
            notPayDetails.add(notPayDetail);
            sumPrice = sumPrice.add(orderNotPay.getTotalPrice());
        }
        this.queryNotPayResponse.setNotPayDetails(notPayDetails);
        this.queryNotPayResponse.setTotalNotPayPrice(sumPrice.toString());
        return this.queryNotPayResponse;
    }

    public ParkService getParkService() {
        return this.parkService;
    }

    public ParkDeviceService getParkDeviceService() {
        return this.parkDeviceService;
    }

    public LcdService getLcdService() {
        return this.lcdService;
    }

    public LedService getLedService() {
        return this.ledService;
    }

    public BlacklistService getBlacklistService() {
        return this.blacklistService;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    public MonthCarService getMonthCarService() {
        return this.monthCarService;
    }

    public MonthProductService getMonthProductService() {
        return this.monthProductService;
    }

    public VipCarService getVipCarService() {
        return this.vipCarService;
    }

    public ParkVisitService getParkVisitService() {
        return this.parkVisitService;
    }

    public VehicleService getVehicleService() {
        return this.vehicleService;
    }

    public StoreCardService getStoreCardService() {
        return this.storeCardService;
    }

    public OrderTagsService getOrderTagsService() {
        return this.orderTagsService;
    }

    public MonthRegionDao getMonthRegionDao() {
        return this.monthRegionDao;
    }

    public VipRegionService getVipRegionService() {
        return this.vipRegionService;
    }

    public Long getParkId() {
        return this.parkId;
    }

    public String getParkCode() {
        return this.parkCode;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getVersionIndex() {
        return this.versionIndex;
    }

    public String getPlateNum() {
        return this.plateNum;
    }

    public String getOrderNum() {
        return this.orderNum;
    }

    public Integer getEnexType() {
        return this.enexType;
    }

    public Map<String, Object> getDisplayParamMap() {
        return this.displayParamMap;
    }

    public OrderNotpayService getOrderNotpayService() {
        return this.orderNotpayService;
    }

    public QueryNotPayResponse getQueryNotPayResponse() {
        return this.queryNotPayResponse;
    }

    public OrderInfo getReplenishOrder() {
        return this.replenishOrder;
    }

    public List<OrderSonInfo> getOrderSonInfos() {
        return this.orderSonInfos;
    }

    public ParkRecoveryService getParkRecoveryService() {
        return this.parkRecoveryService;
    }

    public void setParkService(ParkService parkService) {
        this.parkService = parkService;
    }

    public void setParkDeviceService(ParkDeviceService parkDeviceService) {
        this.parkDeviceService = parkDeviceService;
    }

    public void setLcdService(LcdService lcdService) {
        this.lcdService = lcdService;
    }

    public void setLedService(LedService ledService) {
        this.ledService = ledService;
    }

    public void setBlacklistService(BlacklistService blacklistService) {
        this.blacklistService = blacklistService;
    }

    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public void setMonthCarService(MonthCarService monthCarService) {
        this.monthCarService = monthCarService;
    }

    public void setMonthProductService(MonthProductService monthProductService) {
        this.monthProductService = monthProductService;
    }

    public void setVipCarService(VipCarService vipCarService) {
        this.vipCarService = vipCarService;
    }

    public void setParkVisitService(ParkVisitService parkVisitService) {
        this.parkVisitService = parkVisitService;
    }

    public void setVehicleService(VehicleService vehicleService) {
        this.vehicleService = vehicleService;
    }

    public void setStoreCardService(StoreCardService storeCardService) {
        this.storeCardService = storeCardService;
    }

    public void setOrderTagsService(OrderTagsService orderTagsService) {
        this.orderTagsService = orderTagsService;
    }

    public void setMonthRegionDao(MonthRegionDao monthRegionDao) {
        this.monthRegionDao = monthRegionDao;
    }

    public void setVipRegionService(VipRegionService vipRegionService) {
        this.vipRegionService = vipRegionService;
    }

    public void setParkId(Long parkId) {
        this.parkId = parkId;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersionIndex(Integer versionIndex) {
        this.versionIndex = versionIndex;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public void setEnexType(Integer enexType) {
        this.enexType = enexType;
    }

    public void setRegionType(Integer regionType) {
        this.regionType = regionType;
    }

    public void setChargeLiveCount(Integer chargeLiveCount) {
        this.chargeLiveCount = chargeLiveCount;
    }

    public void setOilLiveCount(Integer oilLiveCount) {
        this.oilLiveCount = oilLiveCount;
    }

    public void setDisplayParamMap(Map<String, Object> displayParamMap) {
        this.displayParamMap = displayParamMap;
    }

    public void setParkDevice(ParkDevice parkDevice) {
        this.parkDevice = parkDevice;
    }

    public void setParkRegion(ParkRegion parkRegion) {
        this.parkRegion = parkRegion;
    }

    public void setParkChannel(ParkInoutdevice parkChannel) {
        this.parkChannel = parkChannel;
    }

    public void setParkInfo(Park parkInfo) {
        this.parkInfo = parkInfo;
    }

    public void setParkConfig(ParkConfig parkConfig) {
        this.parkConfig = parkConfig;
    }

    public void setParkFreeSpace(ParkFreespace parkFreeSpace) {
        this.parkFreeSpace = parkFreeSpace;
    }

    public void setOrderNotpayService(OrderNotpayService orderNotpayService) {
        this.orderNotpayService = orderNotpayService;
    }

    public void setLedConfigResp(ObjectResponse<LedConfig> ledConfigResp) {
        this.ledConfigResp = ledConfigResp;
    }

    public void setLcdConfigResp(ObjectResponse<LcdConfig> lcdConfigResp) {
        this.lcdConfigResp = lcdConfigResp;
    }

    public void setFuzzyInOrder(ObjectResponse<OrderInfo> fuzzyInOrder) {
        this.fuzzyInOrder = fuzzyInOrder;
    }

    public void setFuzzyOutOrder(ObjectResponse<OrderInfo> fuzzyOutOrder) {
        this.fuzzyOutOrder = fuzzyOutOrder;
    }

    public void setBlacklistResp(ObjectResponse<Blacklist> blacklistResp) {
        this.blacklistResp = blacklistResp;
    }

    public void setMonthDetail(MonthDetailDto monthDetail) {
        this.monthDetail = monthDetail;
    }

    public void setOtherRegionMonthDetail(MonthDetailDto otherRegionMonthDetail) {
        this.otherRegionMonthDetail = otherRegionMonthDetail;
    }

    public void setVipTypeResp(ObjectResponse<VipType> vipTypeResp) {
        this.vipTypeResp = vipTypeResp;
    }

    public void setOtherRegionVipDetailDto(VipDetailDto otherRegionVipDetailDto) {
        this.otherRegionVipDetailDto = otherRegionVipDetailDto;
    }

    public void setParkVisitResp(ObjectResponse<ParkVisit> parkVisitResp) {
        this.parkVisitResp = parkVisitResp;
    }

    public void setVehiclePlateResp(ObjectResponse<VehiclePlate> vehiclePlateResp) {
        this.vehiclePlateResp = vehiclePlateResp;
    }

    public void setStoreCardResp(ObjectResponse<StoreCard> storeCardResp) {
        this.storeCardResp = storeCardResp;
    }

    public void setQueryNotPayResponse(QueryNotPayResponse queryNotPayResponse) {
        this.queryNotPayResponse = queryNotPayResponse;
    }

    public void setReplenishOrder(OrderInfo replenishOrder) {
        this.replenishOrder = replenishOrder;
    }

    public void setOrderSonInfos(List<OrderSonInfo> orderSonInfos) {
        this.orderSonInfos = orderSonInfos;
    }

    public void setParkRecoveryService(ParkRecoveryService parkRecoveryService) {
        this.parkRecoveryService = parkRecoveryService;
    }

    public String toString() {
        return "ReportParamHolder(parkService=" + this.getParkService() + ", parkDeviceService=" + this.getParkDeviceService() + ", lcdService=" + this.getLcdService() + ", ledService=" + this.getLedService() + ", blacklistService=" + this.getBlacklistService() + ", orderService=" + this.getOrderService() + ", monthCarService=" + this.getMonthCarService() + ", monthProductService=" + this.getMonthProductService() + ", vipCarService=" + this.getVipCarService() + ", parkVisitService=" + this.getParkVisitService() + ", vehicleService=" + this.getVehicleService() + ", storeCardService=" + this.getStoreCardService() + ", orderTagsService=" + this.getOrderTagsService() + ", monthRegionDao=" + this.getMonthRegionDao() + ", vipRegionService=" + this.getVipRegionService() + ", parkId=" + this.getParkId() + ", parkCode=" + this.getParkCode() + ", serialNumber=" + this.getSerialNumber() + ", channelCode=" + this.getChannelCode() + ", version=" + this.getVersion() + ", versionIndex=" + this.getVersionIndex() + ", plateNum=" + this.getPlateNum() + ", orderNum=" + this.getOrderNum() + ", enexType=" + this.getEnexType() + ", regionType=" + this.getRegionType() + ", chargeLiveCount=" + this.getChargeLiveCount() + ", oilLiveCount=" + this.getOilLiveCount() + ", displayParamMap=" + this.getDisplayParamMap() + ", parkDevice=" + this.getParkDevice() + ", parkRegion=" + this.getParkRegion() + ", parkChannel=" + this.getParkChannel() + ", parkInfo=" + this.getParkInfo() + ", parkConfig=" + this.getParkConfig() + ", parkFreeSpace=" + this.getParkFreeSpace() + ", orderNotpayService=" + this.getOrderNotpayService() + ", ledConfigResp=" + this.getLedConfigResp() + ", lcdConfigResp=" + this.getLcdConfigResp() + ", fuzzyInOrder=" + this.getFuzzyInOrder() + ", fuzzyOutOrder=" + this.getFuzzyOutOrder() + ", blacklistResp=" + this.getBlacklistResp() + ", monthDetail=" + this.getMonthDetail() + ", otherRegionMonthDetail=" + this.getOtherRegionMonthDetail() + ", vipTypeResp=" + this.getVipTypeResp() + ", otherRegionVipDetailDto=" + this.getOtherRegionVipDetailDto() + ", parkVisitResp=" + this.getParkVisitResp() + ", vehiclePlateResp=" + this.getVehiclePlateResp() + ", storeCardResp=" + this.getStoreCardResp() + ", queryNotPayResponse=" + this.getQueryNotPayResponse() + ", replenishOrder=" + this.getReplenishOrder() + ", orderSonInfos=" + this.getOrderSonInfos() + ", parkRecoveryService=" + this.getParkRecoveryService() + ")";
    }
}

