/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.redpack;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.redpack.RedpackOperService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.fee.dao.redpack.RedpackInfoDao;
import com.icetech.fee.domain.entity.RedpackInfo;
import com.icetech.park.domain.entity.park.Park;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RedpackOperServiceImpl
implements RedpackOperService {
    private static final Logger log = LoggerFactory.getLogger(RedpackOperServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedpackInfoDao redpackInfoDao;

    public ObjectResponse<Integer> queryBalance(String parkCode) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        RedpackInfo redpackInfo = this.redpackInfoDao.selectByParkId(park.getId());
        if (redpackInfo == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)redpackInfo.getBalance());
    }

    @Transactional
    public ObjectResponse deduct(String parkCode, Integer amount) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        RedpackInfo redpackInfo = this.redpackInfoDao.selectByParkId(park.getId());
        if (redpackInfo == null) {
            return ObjectResponse.failed((String)"404");
        }
        int newBalance = redpackInfo.getBalance() - amount;
        redpackInfo.setBalance(Integer.valueOf(newBalance));
        this.redpackInfoDao.updateByParkId(redpackInfo);
        return ObjectResponse.success();
    }

    @Transactional
    public ObjectResponse refund(String parkCode, Integer amount) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        RedpackInfo redpackInfo = this.redpackInfoDao.selectByParkId(park.getId());
        if (redpackInfo == null) {
            return ObjectResponse.failed((String)"404");
        }
        int newBalance = redpackInfo.getBalance() + amount;
        redpackInfo.setBalance(Integer.valueOf(newBalance));
        this.redpackInfoDao.updateByParkId(redpackInfo);
        return ObjectResponse.success();
    }
}

