/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.multipleareachain;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.discount.ParkDiscountUsercharge;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.merchant.DiscountDayDao;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.order.dao.OrderAuthDao;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.domain.entity.OrderAuthInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.park.service.discount.ParkDiscountUserchargeService;
import com.icetech.park.service.queryfee.DiscountOverHandle;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import com.icetech.third.utils.RedisUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TotalFeeHandleChain
extends MultipleAreaQueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(TotalFeeHandleChain.class);
    @Autowired
    private DiscountDayDao discountDayDao;
    @Autowired
    private OrderDiscountDao orderDiscountDao;
    @Autowired
    private DiscountOverHandle discountOverHandle;
    private static final Integer STATUS = 0;
    @Autowired
    private ParkDiscountUserchargeService parkDiscountUserchargeService;
    @Autowired
    private OrderAuthDao orderAuthDao;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        return this.queryFeeObject(feeParamHolder);
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {
        OrderAuthInfo orderAuthInfo;
        boolean hasCoupon;
        BigDecimal surplusfee = feeParamHolder.getSurplusfee();
        QueryOrderFeeResponse queryOrderFeeResponse = feeParamHolder.getQueryOrderFeeResponse();
        QueryOrderFeeResponse innerOrderFeeResponse = feeParamHolder.getInnerQueryOrderFeeResponse();
        boolean hasInnerFee = innerOrderFeeResponse != null && innerOrderFeeResponse.getUnpayPrice() != null;
        boolean isResetStatus = false;
        if (hasInnerFee) {
            BigDecimal allDiscountPrice = new BigDecimal(innerOrderFeeResponse.getDiscountPrice()).add(new BigDecimal(queryOrderFeeResponse.getDiscountPrice()));
            BigDecimal allUnPayPrice = new BigDecimal(innerOrderFeeResponse.getUnpayPrice()).add(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(allUnPayPrice));
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(allDiscountPrice));
            queryOrderFeeResponse.setTotalAmount(FORMAT.format(allDiscountPrice.add(allUnPayPrice).add(new BigDecimal(queryOrderFeeResponse.getPaidAmount())).add(new BigDecimal(queryOrderFeeResponse.getDiscountAmount()))));
            if (NumberUtils.parseFloat((Object)innerOrderFeeResponse.getUnpayPrice()) > 0.0f) {
                queryOrderFeeResponse.setHasInnerAreaFee(Boolean.valueOf(true));
            }
            isResetStatus = true;
        }
        float thisFee = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
        float totalAmount = Float.parseFloat(queryOrderFeeResponse.getTotalAmount());
        Float unPayPrice = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getUnpayPrice()));
        float sourceUnpayPrice = unPayPrice.floatValue();
        boolean bl = hasCoupon = sourceUnpayPrice != (unPayPrice = Float.valueOf(this.couponHandle(feeParamHolder, feeParamHolder.getPark().getId(), feeParamHolder.getOrderSumFeeDto(), thisFee, feeParamHolder.getParkChargeConfig(), feeParamHolder.getOrderInfo(), unPayPrice.floatValue()))).floatValue();
        if (hasCoupon) {
            float substractValue = sourceUnpayPrice - unPayPrice.floatValue();
            BigDecimal addDiscountPrice = new BigDecimal(queryOrderFeeResponse.getDiscountPrice()).add(new BigDecimal(substractValue)).setScale(2, 4);
            queryOrderFeeResponse.setDiscountPrice(addDiscountPrice.toString());
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(unPayPrice));
        }
        Float allDiscountPrice = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getDiscountPrice()));
        Float totalAmountPrice = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getTotalAmount()));
        if (innerOrderFeeResponse == null) {
            innerOrderFeeResponse = new QueryOrderFeeResponse();
        }
        Float innerTotalPrice = Float.valueOf(NumberUtils.parseFloat((Object)innerOrderFeeResponse.getTotalAmount()));
        Float outTotalPrice = Float.valueOf(totalAmountPrice.floatValue() - innerTotalPrice.floatValue());
        log.debug("[\u53e0\u52a0\u4f18\u60e0-\u5c0f\u573a\u4fee\u6539] alldiscountPrice {} outTotalPrice {} innerTotalPrice {}", new Object[]{allDiscountPrice, outTotalPrice, innerTotalPrice});
        if (hasCoupon && allDiscountPrice.floatValue() >= outTotalPrice.floatValue()) {
            Float innerDiscountPrice = Float.valueOf(allDiscountPrice.floatValue() - outTotalPrice.floatValue());
            if (innerDiscountPrice.floatValue() > innerTotalPrice.floatValue()) {
                innerDiscountPrice = innerTotalPrice;
            }
            Float innerUnPaidPrice = Float.valueOf(innerTotalPrice.floatValue() - innerDiscountPrice.floatValue());
            innerOrderFeeResponse.setDiscountPrice(FORMAT.format(innerDiscountPrice));
            innerOrderFeeResponse.setUnpayPrice(FORMAT.format(innerUnPaidPrice));
        }
        log.debug("[\u53e0\u52a0\u4f18\u60e0-\u5c0f\u573a\u4fee\u6539] innerOrderFeeResponse {} ", (Object)innerOrderFeeResponse);
        log.debug("[\u53e0\u52a0\u4f18\u60e0-\u5c0f\u573a\u4fee\u6539] queryFee {} inner {}", (Object)queryOrderFeeResponse, (Object)innerOrderFeeResponse);
        this.redisUtils.set("sub:" + queryOrderFeeResponse.getOrderNum(), (Object)innerOrderFeeResponse, 1L, TimeUnit.DAYS);
        String unpayPrice = queryOrderFeeResponse.getUnpayPrice();
        float aFloat = Float.parseFloat(unpayPrice);
        if (surplusfee != null && aFloat > surplusfee.floatValue()) {
            isResetStatus = true;
            this.updateUnpayPrice(queryOrderFeeResponse, innerOrderFeeResponse, aFloat, surplusfee.floatValue());
            log.info("[\u67e5\u8d39-\u4fee\u6539\u8d39\u7528\u6a21\u5757] \u6700\u5927\u6536\u8d39\u903b\u8f91\u5904\u7406\u540e\u5f85\u7f34\u8d39[{}]", (Object)queryOrderFeeResponse.getUnpayPrice());
        }
        if ((orderAuthInfo = this.orderAuthDao.selectByOrderNum(queryOrderFeeResponse.getOrderNum(), Integer.valueOf(1))) != null && orderAuthInfo.getAuthStatus().equals(1)) {
            isResetStatus = true;
            this.updateUnpayPrice(queryOrderFeeResponse, innerOrderFeeResponse, aFloat, NumberUtils.toFloat((String)orderAuthInfo.getUpPrice()));
            log.info("[\u67e5\u8d39-\u4fee\u6539\u8d39\u7528\u6a21\u5757]\u8ba2\u5355\u53f7[{}]\u6709\u6388\u6743\u8fc7\u4fee\u6539\u91d1\u989d, before[{}], after[{}]", new Object[]{queryOrderFeeResponse.getOrderNum(), queryOrderFeeResponse.getUnpayPrice(), orderAuthInfo.getUpPrice()});
        }
        if (isResetStatus) {
            totalAmount = NumberUtils.toFloat((String)queryOrderFeeResponse.getTotalAmount());
            Float paidAmount = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getPaidAmount()));
            Float discountAmount = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getDiscountAmount()));
            Float finallyUnPayPrice = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getUnpayPrice()));
            Float discountPrice = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getDiscountPrice()));
            Integer status = this.getFeeStatus(paidAmount, finallyUnPayPrice, discountPrice, discountAmount, Float.valueOf(totalAmount));
            queryOrderFeeResponse.setStatus(status);
        }
        return queryOrderFeeResponse;
    }

    private float couponHandle(MultipleAreaFeeParamHolder feeParamHolder, Long parkId, OrderSumFeeDto orderSumFeeDto, float thisFee, ParkChargeconfig parkChargeconfig, OrderInfo orderInfo, float unPayPrice) {
        log.debug("[\u53e0\u52a0\u4f18\u60e0-\u4f18\u60e0\u8ba1\u7b97\u5f00\u59cb] parkChargeconfig {},orderInfo {}", (Object)parkChargeconfig, (Object)orderInfo);
        if (unPayPrice <= 0.0f) {
            return 0.0f;
        }
        List orderDiscounts = this.orderDiscountDao.selectByOrderNum(orderInfo.getOrderNum(), STATUS);
        if (CollectionUtils.isEmpty((Collection)orderDiscounts)) {
            orderDiscounts = Lists.newArrayList();
            log.debug("[\u53e0\u52a0\u4f18\u60e0] \u6682\u65e0\u4f18\u60e0\u4fe1\u606f orderNum {}", (Object)orderInfo.getOrderNum());
            DiscountDay discountDay = this.discountDayDao.selectLastByPlateNum(orderInfo.getPlateNum(), parkId);
            if (discountDay != null && discountDay.getEndTime().getTime() >= System.currentTimeMillis()) {
                OrderDiscount orderDiscount = (OrderDiscount)this.orderDiscountDao.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getDiscountNo, (Object)discountDay.getDiscountNo())).eq(OrderDiscount::getDelFlag, (Object)0)).last("limit 1"));
                if (Objects.nonNull(orderDiscount)) {
                    orderDiscounts.add(orderDiscount);
                }
            } else {
                return unPayPrice;
            }
        }
        log.debug("[\u53e0\u52a0\u4f18\u60e0] \u83b7\u53d6\u4f18\u60e0\u4fe1\u606f orderDiscounts {}", (Object)JsonUtils.toString((Object)orderDiscounts));
        ParkDiscountUsercharge parkDiscountUsercharge = this.parkDiscountUserchargeService.getParkDiscountUserchargeByParkId(parkId);
        if (Objects.isNull(parkDiscountUsercharge)) {
            parkDiscountUsercharge = new ParkDiscountUsercharge();
            parkDiscountUsercharge.setParkId(parkId);
            parkDiscountUsercharge.setPlateGetCoupons(Integer.valueOf(1));
            parkDiscountUsercharge.setSupportStackeUsage(Integer.valueOf(2));
            parkDiscountUsercharge.setThirdpartyStackeUsage(Integer.valueOf(1));
            parkDiscountUsercharge.setUserMultipleTimes(Integer.valueOf(2));
        }
        List orderDiscountsUsed = this.orderDiscountDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getOrderNum, (Object)orderInfo.getOrderNum())).eq(OrderDiscount::getStatus, (Object)1)).eq(OrderDiscount::getFrom, (Object)1));
        if (parkDiscountUsercharge.getUserMultipleTimes() == 1 && CollectionUtils.isNotEmpty((Collection)orderDiscountsUsed)) {
            log.info("[\u8ba2\u5355\u5df2\u7ecf\u4f7f\u7528\u8fc7\u4f18\u60e0\u4e0d\u80fd\u7ee7\u7eed\u4f7f\u7528] orderNum {}", (Object)orderInfo.getOrderNum());
            return unPayPrice;
        }
        DiscountOverHandle.DiscountInfo discount = this.discountOverHandle.getDiscount(feeParamHolder, parkChargeconfig, orderInfo, orderSumFeeDto, parkDiscountUsercharge, orderDiscounts, feeParamHolder.getParkTime(), BigDecimal.valueOf(unPayPrice), BigDecimal.valueOf(thisFee), Boolean.TRUE);
        BigDecimal discountPrice = discount.getDiscountPrice();
        unPayPrice = thisFee - discountPrice.floatValue();
        if (unPayPrice < 0.0f) {
            unPayPrice = 0.0f;
        }
        if (CollectionUtils.isNotEmpty(discount.getDiscountNos())) {
            this.redisUtils.set(RedisDiscountKeyConstant.DISCOUNT_USE_PRE + parkId + ":" + orderInfo.getOrderNum(), (Object)StrUtil.join((CharSequence)",", discount.getDiscountNos()), 86400L);
        }
        if (discount.getMerchantDiscountPrice() != null) {
            this.redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(), "1", (Object)discount.getMerchantCouponsInfo(), 86400L);
        }
        if (discount.getThirdDiscountPrice() != null) {
            this.redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(), "2", (Object)discount.getThirdCouponsInfo(), 86400L);
        }
        log.info("[\u4f18\u60e0\u5238-\u6807\u51c6\u4f18\u60e0] \u8f66\u724c\u53f7[{}], \u4f18\u60e0[{}],\u4f18\u60e0\u4e4b\u540e[{}]", new Object[]{orderInfo.getPlateNum(), discountPrice, Float.valueOf(unPayPrice)});
        return unPayPrice;
    }

    private void updateUnpayPrice(QueryOrderFeeResponse queryOrderFeeResponse, QueryOrderFeeResponse innerOrderFeeResponse, float aFloat, float upPrice) {
        float innerUnpayPrice;
        float v = aFloat - upPrice;
        if (innerOrderFeeResponse != null && NumberUtils.parseFloat((Object)innerOrderFeeResponse.getUnpayPrice()) > 0.0f && (innerUnpayPrice = NumberUtils.parseFloat((Object)innerOrderFeeResponse.getUnpayPrice())) > upPrice) {
            float totalAmountF = NumberUtils.toFloat((String)innerOrderFeeResponse.getTotalAmount());
            innerOrderFeeResponse.setUnpayPrice(String.valueOf(upPrice));
            innerOrderFeeResponse.setTotalAmount(String.valueOf(totalAmountF - v));
            this.redisUtils.set("sub:" + queryOrderFeeResponse.getOrderNum(), (Object)innerOrderFeeResponse, 1L, TimeUnit.DAYS);
        }
        float totalAmount = NumberUtils.toFloat((String)queryOrderFeeResponse.getTotalAmount());
        queryOrderFeeResponse.setTotalAmount(String.valueOf(totalAmount - v));
        queryOrderFeeResponse.setUnpayPrice(String.valueOf(upPrice));
    }
}

