/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.multipleareachain;

import cn.hutool.core.date.DateUtil;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.vo.ParkChargeRuleVO;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.dao.monthcar.MonthRegionDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthRegion;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.MonthFeeDto;
import com.icetech.park.service.queryfee.MonthFeeHandle;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import com.icetech.park.service.queryfee.multipleareachain.InnerAreaPreFeeHandleChain;
import com.icetech.park.service.queryfee.multipleareachain.OutAreaComputeFeeHandleChain;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutAreaPreFeeHandleChain
extends MultipleAreaQueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(OutAreaPreFeeHandleChain.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private MonthFeeHandle monthFeeHandle;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private MonthRegionDao monthRegionDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private InnerAreaPreFeeHandleChain innerAreaPreFeeHandleChain;
    private final OutAreaComputeFeeHandleChain nextChain;

    @Autowired
    public OutAreaPreFeeHandleChain(OutAreaComputeFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = this.queryFeeObject(feeParamHolder);
        feeParamHolder.setQueryOrderFeeResponse(queryOrderFeeResponse);
        if (!feeParamHolder.isBreak() && this.nextChain != null) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {
        Integer visitIscharge;
        QueryOrderFeeRequest queryOrderFeeRequest = feeParamHolder.getQueryOrderFeeRequest();
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        Park park = feeParamHolder.getPark();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Long parkId = park.getId();
        Integer carType = queryOrderFeeRequest.getCarType();
        if (carType != null) {
            orderInfo.setCarType(carType);
        }
        Long regionId = orderInfo.getRegionId();
        feeParamHolder.setRegionId(regionId);
        OrderSonInfo orderSonInfoParam = new OrderSonInfo();
        orderSonInfoParam.setOrderNum(orderInfo.getOrderNum());
        orderSonInfoParam.setParkId(parkId);
        List orderSonInfos = this.orderSonInfoDao.selectList((Object)orderSonInfoParam);
        AssertTools.notNull((Object)(CollectionUtils.isNotEmpty((Collection)orderSonInfos) ? orderSonInfos : null), (String)"400", (String)"\u7f3a\u5c11\u5b50\u8ba2\u5355");
        OrderSonInfo innerOrderSonInfo = null;
        for (OrderSonInfo orderSonInfo : orderSonInfos) {
            if (regionId.equals(orderSonInfo.getRegionId())) continue;
            innerOrderSonInfo = orderSonInfo;
            break;
        }
        if (innerOrderSonInfo == null) {
            throw new ResponseBodyException("400", "\u4e0d\u5b58\u5728\u5185\u573a\u5b50\u8ba2\u5355");
        }
        Long startTime = orderInfo.getEnterTime();
        Long endTime = feeParamHolder.getEndTime();
        if (endTime == null) {
            endTime = DateTools.unixTimestamp();
        }
        if (innerOrderSonInfo.getExitTime() == null) {
            if (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(innerOrderSonInfo.getType()) || PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(innerOrderSonInfo.getType())) {
                log.info("\u6708\u5361/vip\u8f66\u5185\u573a\u51fa\u53e3\u672a\u8bc6\u522b, \u8865\u51fa\u573a\u65f6\u95f4\u4e3a\u5916\u533a\u51fa\u573a\u65f6\u95f4, plateNum[{}]", (Object)innerOrderSonInfo.getPlateNum());
                innerOrderSonInfo.setExitTime(endTime);
            } else if (queryOrderFeeRequest.getChannelId() == null) {
                innerOrderSonInfo.setExitTime(endTime);
            } else {
                innerOrderSonInfo.setExitTime(innerOrderSonInfo.getEnterTime());
                boolean flag = false;
                ObjectResponse inOutDeviceByCode = this.parkService.getInOutDeviceByCode(parkId, queryOrderFeeRequest.getChannelId());
                if (ObjectResponse.isSuccess((Response)inOutDeviceByCode) && innerOrderSonInfo.getRegionId().equals(((ParkInoutdevice)inOutDeviceByCode.getData()).getRegionId())) {
                    innerOrderSonInfo.setExitTime(endTime);
                    flag = true;
                }
                if (!flag) {
                    MonthInfo monthInfo = this.monthFeeHandle.getMonthInfo(parkId, orderInfo.getPlateNum(), innerOrderSonInfo.getRegionId(), parkConfig);
                    if (monthInfo != null) {
                        log.info("\u6708\u5361\u8f66\u5185\u573a\u51fa\u53e3\u672a\u8bc6\u522b, \u8865\u51fa\u573a\u65f6\u95f4\u4e3a\u5916\u533a\u51fa\u573a\u65f6\u95f4, plateNum[{}]", (Object)innerOrderSonInfo.getPlateNum());
                        innerOrderSonInfo.setExitTime(endTime);
                    } else {
                        ObjectResponse objectResponse = this.vipCarService.getValidVipCar(parkId, orderInfo.getPlateNum(), innerOrderSonInfo.getRegionId());
                        if (ObjectResponse.isSuccess((Response)objectResponse)) {
                            log.info("vip\u8f66\u5185\u573a\u51fa\u53e3\u672a\u8bc6\u522b, \u8865\u51fa\u573a\u65f6\u95f4\u4e3a\u5916\u533a\u51fa\u573a\u65f6\u95f4, plateNum[{}]", (Object)innerOrderSonInfo.getPlateNum());
                            innerOrderSonInfo.setExitTime(endTime);
                        }
                    }
                }
            }
        }
        feeParamHolder.setInnerOrderSonInfo(innerOrderSonInfo);
        long parkTime = endTime - startTime;
        OrderSumFeeDto feeDto = this.getPaidFee(orderInfo.getOrderNum(), parkId);
        try {
            Integer batteryCarFreeTime = this.getBatteryCarForFree(orderInfo, feeDto, parkConfig, parkId, endTime - startTime);
            startTime = startTime + (long)batteryCarFreeTime.intValue();
            orderInfo.setEnterTime(startTime);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. queryOrderFeeRequest[{}], orderInfo[{}], park[{}], parkConfig[{}]", new Object[]{e.getMessage(), queryOrderFeeRequest, orderInfo, park, parkConfig, e});
        }
        int freeTimeAfterPay = NumberUtils.toPrimitive((Integer)parkConfig.getIsfreeAfterpay(Integer.valueOf(15)));
        if (NumberUtils.toPrimitive((Integer)parkConfig.getFreeOfficialCars()) == 1 && PlateTypeDto.officialCar((String)orderInfo.getPlateNum())) {
            QueryOrderFeeResponse freeRet = this.getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
            log.info("\u516c\u52a1\u8f66\u65e0\u9700\u7f34\u8d39\u8fd4\u56de\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)orderInfo.getPlateNum());
            feeParamHolder.setBreak(true);
            return freeRet;
        }
        Long newStartTime = null;
        Long newEndTime = null;
        MonthFeeDto monthFeeDto = this.monthFeeHandle.getMonthFeeParam(feeParamHolder, parkId, orderInfo, startTime, endTime, parkConfig, 1);
        if (monthFeeDto != null) {
            if (monthFeeDto.isMonthRet()) {
                QueryOrderFeeResponse monthCarRet = this.getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
                int monthType = this.getMonthType(monthFeeDto.getMonthInfo());
                if (monthType == 0) {
                    feeParamHolder.setBreak(true);
                } else {
                    feeParamHolder.setOutContinue(true);
                }
                return monthCarRet;
            }
            if (monthFeeDto.getNewStartTime() != null) {
                newStartTime = monthFeeDto.getNewStartTime();
            }
            if (monthFeeDto.getNewEndTime() != null) {
                newEndTime = monthFeeDto.getNewEndTime();
            }
            feeParamHolder.setCsFeeType(monthFeeDto.getCsFeeType());
            feeParamHolder.setCsMonthCarFee(monthFeeDto.isCsMonthCarFee());
            feeParamHolder.setCsStartTime(monthFeeDto.getCsStartTime());
            feeParamHolder.setCsEndTime(monthFeeDto.getCsEndTime());
            feeParamHolder.setCsSwitchTime(monthFeeDto.getCsSwitchTime());
            feeParamHolder.setBillIdList(monthFeeDto.getBillIdList());
        }
        Integer type = orderInfo.getType();
        if (PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType().equals(type) && (visitIscharge = parkConfig.getVisitIscharge()) != null && visitIscharge == 0) {
            QueryOrderFeeResponse monthCarRet = this.getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
            log.info("\u9884\u7ea6\u8f66\u65e0\u9700\u7f34\u8d39\u8fd4\u56de\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)orderInfo.getPlateNum());
            feeParamHolder.setBreak(true);
            return monthCarRet;
        }
        long outParkTime = this.getOutParkTime(newStartTime, newEndTime, startTime, endTime, innerOrderSonInfo, feeDto != null ? feeDto.getLastPayTime() : null);
        feeParamHolder.setParkTime(parkTime);
        feeParamHolder.setOutParkTime(outParkTime);
        feeParamHolder.setStartTime(startTime);
        feeParamHolder.setEndTime(endTime);
        feeParamHolder.setOrderSumFeeDto(feeDto);
        return new QueryOrderFeeResponse();
    }

    private int getMonthType(MonthInfo monthInfo) {
        Optional<MonthRegion> optional;
        if (monthInfo == null) {
            return 1;
        }
        int monthType = 0;
        List monthRegions = this.monthRegionDao.selectByMonthId(monthInfo.getId().longValue());
        if (CollectionUtils.isNotEmpty((Collection)monthRegions) && !(optional = monthRegions.stream().filter(monthRegion -> Long.valueOf(0L).equals(monthRegion.getRegionId())).findAny()).isPresent()) {
            monthType = 1;
        }
        return monthType;
    }

    private Integer getBatteryCarForFree(OrderInfo orderInfo, OrderSumFeeDto feeDto, ParkConfig parkConfig, Long parkId, Long parkTime) {
        boolean isOpenFlag = Integer.valueOf(1).equals(parkConfig.getIsNewenergyCharge());
        if (!isOpenFlag || feeDto != null) {
            return 0;
        }
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
        if (carInfo == null) {
            return 0;
        }
        String plateColor = carInfo.getPlateColor();
        if (StringUtils.isEmpty((CharSequence)plateColor) || !plateColor.contains("\u7eff")) {
            return 0;
        }
        Long startTimeForMatch = DateUtil.beginOfDay((Date)DateUtil.date()).getTime() / 1000L;
        Long endTimeForMatch = DateUtil.endOfDay((Date)DateUtil.date()).getTime() / 1000L;
        Integer count = this.orderInfoDao.countRecentExitByEnterTime(parkId, orderInfo.getPlateNum(), startTimeForMatch, endTimeForMatch);
        Integer newEnergyDiscountMinutes = parkConfig.getNewEnergyDiscountMinutes();
        ParkChargeRuleVO freeTimeLocal = this.parkService.getFreeTimeLocal(parkId, orderInfo.getRegionId());
        if (freeTimeLocal == null) {
            return 0;
        }
        int BATTERY_FREEDOM_SECONDS = Math.max(newEnergyDiscountMinutes * 60 - freeTimeLocal.getFreeTime() * 60, 0);
        Integer TWO_HOUR_SECONDS = newEnergyDiscountMinutes * 60;
        Long newFreeParkTime = count <= 0 ? (parkTime > (long)TWO_HOUR_SECONDS.intValue() ? (long)BATTERY_FREEDOM_SECONDS : parkTime - 1L) : 0L;
        log.info("\u8fd0\u7b97\u65b0\u80fd\u6e90\u9996\u514d\u7ed3\u679c, platenum[{}], parkTime[{}],  freeParkTime[{}]", new Object[]{orderInfo.getPlateNum(), parkTime, newFreeParkTime});
        return newFreeParkTime.intValue();
    }

    private long getOutParkTime(Long newStartTime, Long newEndTime, Long startTime, Long endTime, OrderSonInfo innerOrderSonInfo, Long lastPayTime) {
        Long innerAreaParkTime = this.innerAreaPreFeeHandleChain.getNewInnerAreaParkTime(innerOrderSonInfo);
        if (innerAreaParkTime != null) {
            long parkTime = endTime - startTime - innerAreaParkTime;
            return parkTime < 0L ? 0L : parkTime;
        }
        Long innerOrderSonExitTime = innerOrderSonInfo.getExitTime();
        Long innerOrderSonEnterTime = innerOrderSonInfo.getEnterTime();
        if (lastPayTime != null) {
            newStartTime = lastPayTime;
        }
        if (newStartTime != null && newEndTime == null) {
            if (newStartTime >= innerOrderSonExitTime) {
                return endTime - newStartTime;
            }
            if (newStartTime >= innerOrderSonEnterTime) {
                return endTime - innerOrderSonExitTime;
            }
            if (newStartTime >= startTime) {
                return innerOrderSonEnterTime - newStartTime;
            }
        }
        if (newEndTime != null && newStartTime == null) {
            if (newEndTime >= innerOrderSonExitTime) {
                return newEndTime - innerOrderSonExitTime;
            }
            if (newEndTime >= innerOrderSonEnterTime) {
                return innerOrderSonEnterTime - startTime;
            }
            if (newEndTime >= startTime) {
                return newEndTime - startTime;
            }
        }
        if (newEndTime != null && newStartTime != null) {
            startTime = newStartTime;
            endTime = newEndTime;
        }
        Long firstTime = innerOrderSonEnterTime - startTime;
        Long secondTime = endTime - innerOrderSonExitTime;
        return firstTime + secondTime < 0L ? 0L : firstTime + secondTime;
    }
}

