/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.multipleareachain;

import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import com.icetech.park.service.queryfee.multipleareachain.InnerAreaPreFeeHandleChain;
import com.icetech.third.utils.RedisUtils;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutAreaDiscountFeeHandleChain
extends MultipleAreaQueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(OutAreaDiscountFeeHandleChain.class);
    private MultipleAreaQueryFeeChainAbstract nextChain;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    public OutAreaDiscountFeeHandleChain(InnerAreaPreFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        if (feeParamHolder.isOutContinue() && this.nextChain != null) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        QueryOrderFeeResponse queryOrderFeeResponse = this.queryFeeObject(feeParamHolder);
        if (!feeParamHolder.isBreak() && this.nextChain != null) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Park park = feeParamHolder.getPark();
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        this.setBasePara(orderInfo, queryOrderFeeResponse, feeParamHolder.getParkTime(), parkConfig.getIsfreeAfterpay(Integer.valueOf(15)), park.getParkName(), feeParamHolder.getQueryTime());
        this.setQueryFeeInfo(feeParamHolder, queryOrderFeeResponse, park.getId(), orderInfo.getCarType());
        feeParamHolder.setQueryOrderFeeResponse(queryOrderFeeResponse);
        return queryOrderFeeResponse;
    }

    private void setQueryFeeInfo(MultipleAreaFeeParamHolder feeParamHolder, QueryOrderFeeResponse queryOrderFeeResponse, Long parkId, int carType) {
        OrderSumFeeDto orderSumFeeDto = feeParamHolder.getOrderSumFeeDto();
        VipType vipType = feeParamHolder.getVipType();
        float thisFee = feeParamHolder.getThisFee();
        float totalPrice = orderSumFeeDto != null ? orderSumFeeDto.getTotalPrice() : 0.0f;
        ParkChargeconfig parkChargeconfig = feeParamHolder.getParkChargeConfig();
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        float totalAmount = totalPrice + thisFee;
        float unPayPrice = this.vipDiscountHandle(feeParamHolder, parkId, orderSumFeeDto, vipType, thisFee, parkChargeconfig.getId(), orderInfo);
        float vipDiscountPrice = thisFee - unPayPrice;
        float discountPrice = thisFee - unPayPrice;
        OrderSumFeeDto feeDto = feeParamHolder.getOrderSumFeeDto();
        if (feeDto == null) {
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(0L));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(0L));
        } else {
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(feeDto.getPaidPrice()));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(feeDto.getDiscountPrice()));
            queryOrderFeeResponse.setPayTime(feeDto.getLastOrderTime() == null ? feeDto.getLastPayTime() : feeDto.getLastOrderTime());
        }
        Float paidAmount = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getPaidAmount()));
        Float discountAmount = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getDiscountAmount()));
        Integer status = this.getFeeStatus(paidAmount, Float.valueOf(unPayPrice), Float.valueOf(discountPrice), discountAmount, Float.valueOf(totalAmount));
        queryOrderFeeResponse.setStatus(status);
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(discountPrice));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(unPayPrice));
        queryOrderFeeResponse.setTotalAmount(FORMAT.format(totalAmount));
        if (vipDiscountPrice > 0.0f) {
            queryOrderFeeResponse.setVipDiscountPrice(FORMAT.format(vipDiscountPrice));
            OrderPayDiscount.VipCouponsInfo vipCouponsInfo = (OrderPayDiscount.VipCouponsInfo)this.redisUtils.hGet(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(), OrderPayDiscount.DiscountSourceEnum.VIP_COUPONS.getDesc(), OrderPayDiscount.VipCouponsInfo.class);
            if (vipCouponsInfo != null) {
                vipCouponsInfo.addTypeId(vipType.getType());
                vipCouponsInfo.addDiscountType(vipType.getType());
                vipCouponsInfo.addDiscountPrice(BigDecimal.valueOf(vipDiscountPrice).setScale(2, 4));
            } else {
                vipCouponsInfo = new OrderPayDiscount.VipCouponsInfo();
                vipCouponsInfo.setDiscountType(vipType.getType().toString());
                vipCouponsInfo.setTypeId(vipType.getId().toString());
                vipCouponsInfo.setDiscountPrice(BigDecimal.valueOf(vipDiscountPrice).setScale(2, 4));
            }
            this.redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(), OrderPayDiscount.DiscountSourceEnum.VIP_COUPONS.getDesc(), (Object)vipCouponsInfo, 86400L);
        }
    }

    private float vipDiscountHandle(MultipleAreaFeeParamHolder feeParamHolder, Long parkId, OrderSumFeeDto orderSumFeeDto, VipType vipType, float thisFee, Integer billId, OrderInfo orderInfo) {
        float unPayPrice;
        if (vipType == null || thisFee == 0.0f) {
            return thisFee;
        }
        feeParamHolder.setInnerUseAllVipDiscount(false);
        float vipDiscount = 0.0f;
        Integer type = vipType.getType();
        if (DiscountTypeEnum.\u5168\u514d.getType().equals(type)) {
            vipDiscount = thisFee;
        }
        if (DiscountTypeEnum.\u51cf\u514d\u91d1\u989d.getType().equals(type) && thisFee - (vipDiscount = NumberUtils.toFloat((String)vipType.getAmount())) < 0.0f) {
            feeParamHolder.setSurplusVipPrice(Math.abs(thisFee - vipDiscount));
        }
        if (DiscountTypeEnum.\u51cf\u514d\u65f6\u95f4.getType().equals(type)) {
            int vipMinutesDiscount = NumberUtils.toInt((String)vipType.getAmount());
            int surplusTime = (int)(((long)(vipMinutesDiscount * 60) - feeParamHolder.getOutParkTime()) / 60L);
            if (surplusTime > 0) {
                log.info("VIP\u5206\u949f\u4f18\u60e0\u5269\u4f59\u7ed9\u5185\u573a[{}]\u5206\u949f", (Object)surplusTime);
                feeParamHolder.setSurplusVipTime(surplusTime);
            }
            if (vipMinutesDiscount > 0) {
                vipDiscount = thisFee - this.chargeFee(feeParamHolder, parkId, billId, feeParamHolder.getStartTime().intValue(), feeParamHolder.getOutEndTime().intValue(), vipMinutesDiscount, orderSumFeeDto != null, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), feeParamHolder.isUseFreetime());
            }
        }
        if (DiscountTypeEnum.\u6298\u6263.getType().equals(type)) {
            float vipRateNum = NumberUtils.toFloat((String)vipType.getAmount());
            vipDiscount = BigDecimal.valueOf(thisFee).subtract(BigDecimal.valueOf(thisFee).multiply(BigDecimal.valueOf(vipRateNum)).multiply(BigDecimal.valueOf(0.1f))).setScale(2, 4).floatValue();
        }
        if ((unPayPrice = thisFee - vipDiscount) < 0.0f) {
            unPayPrice = 0.0f;
        }
        log.info("[VIP\u8f66\u8f86\u8ba1\u8d39\u4f18\u60e0] \u8f66\u724c\u53f7[{}], \u4f18\u60e0[{}],\u4f18\u60e0\u4e4b\u540e[{}]", new Object[]{orderInfo.getPlateNum(), Float.valueOf(vipDiscount), Float.valueOf(unPayPrice)});
        return unPayPrice;
    }
}

