/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.multipleareachain;

import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.domain.dto.ChargeConfigDTO;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.order.SumPayByOrderNumDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import com.icetech.park.service.queryfee.multipleareachain.OutAreaDiscountFeeHandleChain;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutAreaComputeFeeHandleChain
extends MultipleAreaQueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(OutAreaComputeFeeHandleChain.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private ChargeService chargeService;
    private static final BigDecimal FREE_VALUE = BigDecimal.ZERO;
    private MultipleAreaQueryFeeChainAbstract nextChain;
    @Autowired
    private VipRegionService vipRegionService;

    @Autowired
    public OutAreaComputeFeeHandleChain(OutAreaDiscountFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        if (feeParamHolder.isOutContinue() && this.nextChain != null) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        QueryOrderFeeResponse queryOrderFeeResponse = this.queryFeeObject(feeParamHolder);
        if (!feeParamHolder.isBreak() && this.nextChain != null) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {
        boolean isOutPayAndNoTimeOut;
        boolean isOutPay;
        OrderSumFeeDto feeDto;
        ParkChargeconfig parkChargeconfig;
        Integer billId;
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Park park = feeParamHolder.getPark();
        Long startTime = feeParamHolder.getStartTime();
        Long endTime = feeParamHolder.getEndTime();
        Long parkTime = feeParamHolder.getParkTime();
        Integer freeTimeAfterPay = parkConfig.getIsfreeAfterpay(Integer.valueOf(15));
        Long parkId = park.getId();
        Long regionId = feeParamHolder.getRegionId();
        OrderSonInfo innerOrderSonInfo = feeParamHolder.getInnerOrderSonInfo();
        Integer n = billId = CollectionUtils.isEmpty((Collection)feeParamHolder.getBillIdList()) || feeParamHolder.getBillIdList().stream().anyMatch(Objects::isNull) ? null : (Integer)feeParamHolder.getBillIdList().stream().filter(Objects::nonNull).findFirst().orElse(null);
        if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(orderInfo.getType())) {
            ObjectResponse recentVipCar = this.vipCarService.getRecentVipCar(parkId, orderInfo.getPlateNum(), null);
            if (ObjectResponse.isSuccess((Response)recentVipCar)) {
                billId = this.getVipOutBillIdAndSetInnerVip(feeParamHolder, regionId, innerOrderSonInfo, (VipType)recentVipCar.getData());
            }
        } else {
            ObjectResponse validVipCar = this.vipCarService.getValidVipCar(parkId, orderInfo.getPlateNum(), null);
            if (ObjectResponse.isSuccess((Response)validVipCar)) {
                billId = this.getVipOutBillIdAndSetInnerVip(feeParamHolder, regionId, innerOrderSonInfo, (VipType)validVipCar.getData());
            }
        }
        if (billId == null) {
            parkChargeconfig = this.chargeService.getParkChargeConfigByPlateColor(regionId, orderInfo.getOrderNum(), orderInfo.getPlateNum(), park.getId());
            if (Objects.isNull(parkChargeconfig)) {
                log.warn("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8f66\u573a\u672a\u914d\u7f6e\u9ed8\u8ba4\u7684\u8ba1\u8d39\u89c4\u5219\uff0cparkId\uff1a{}", (Object)parkId);
                throw new ResponseBodyException("3001", "\u672a\u914d\u7f6e\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219");
            }
            billId = parkChargeconfig.getId();
        } else {
            parkChargeconfig = this.parkChargeconfigDao.selectByPrimaryKey(billId);
            AssertTools.notNull((Object)parkChargeconfig, (String)"3001", (String)"vip\u8ba1\u8d39\u89c4\u5219\u6570\u636e\u4e0d\u5b8c\u6574");
        }
        feeParamHolder.putParkChargeConfig(billId, parkChargeconfig);
        ChargeConfigDTO chargeConfigDTO = this.parkService.getChargeByBillId(parkChargeconfig, orderInfo.getCarType());
        BigDecimal surplusfee = this.maxFee(feeParamHolder, chargeConfigDTO, orderInfo, parkTime);
        if (surplusfee != null) {
            if (new BigDecimal(0).compareTo(surplusfee) == 0) {
                QueryOrderFeeResponse freeRet = this.getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
                feeParamHolder.setBreak(true);
                return freeRet;
            }
            if (surplusfee.compareTo(BigDecimal.valueOf(0L)) > 0) {
                feeParamHolder.setSurplusfee(surplusfee);
            }
        }
        boolean isPaid = (feeDto = feeParamHolder.getOrderSumFeeDto()) != null;
        Integer overtimeBillType = parkConfig.getOvertimeBillType();
        long timeoutTime = 0L;
        boolean hasSmallParkExitPay = feeParamHolder.hasExitPay(orderInfo.getOrderNum());
        boolean bl = isOutPay = isPaid && innerOrderSonInfo.getExitTime() < feeDto.getLastPayTime();
        if (isPaid && !hasSmallParkExitPay) {
            if (isOutPay) {
                Long lastPayTime = feeDto.getLastPayTime();
                timeoutTime = endTime - lastPayTime;
                startTime = lastPayTime;
                log.info("\u5927\u573a\u9884\u7f34\u8d39\u540e\uff0c\u8d85\u65f6\u65f6\u95f4\u4e3a\uff1a{}", (Object)timeoutTime);
            } else {
                startTime = innerOrderSonInfo.getExitTime();
                log.info("\u5c0f\u573a\u9884\u7f34\u8d39\u540e\uff0c\u5f00\u59cb\u65f6\u95f4\u4e3a\u5c0f\u573a\u79bb\u573a\u65f6\u95f4\uff1a{}", (Object)startTime);
            }
        }
        Integer isFreetimeOnce = chargeConfigDTO.getIsFreetimeOnce();
        int freeTime = chargeConfigDTO.getFreeTime() * 60;
        boolean isUseFreetime = true;
        if (freeTime > 0 && isFreetimeOnce != null) {
            if (isFreetimeOnce < 0) {
                isUseFreetime = true;
            }
            if (isFreetimeOnce == 0) {
                freeTime = 0;
                isUseFreetime = false;
            } else {
                LocalDate today = LocalDate.now();
                long begin = DateUtils.toEpochSecond((LocalDateTime)today.atStartOfDay());
                long end = DateUtils.toEpochSecond((LocalDateTime)today.plusDays(1L).atStartOfDay()) - 1L;
                int count = this.orderInfoDao.countEnexTimesByEnterTime(parkId, orderInfo.getPlateNum(), Long.valueOf(begin), Long.valueOf(end));
                if (count > isFreetimeOnce) {
                    log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u5f53\u65e5\u514d\u8d39\u65f6\u957f\u4f7f\u7528\u6b21\u6570\u5df2\u7528\u5b8c|{}|{}|{}", new Object[]{orderInfo.getPlateNum(), count, isFreetimeOnce});
                    isUseFreetime = false;
                } else {
                    isUseFreetime = true;
                }
            }
        }
        Long bigParkTime = feeParamHolder.getOutParkTime();
        feeParamHolder.setUseFreetime(isUseFreetime);
        feeParamHolder.setStartTime(startTime);
        feeParamHolder.setOutEndTime(startTime + bigParkTime);
        float totalPrice = isPaid ? feeDto.getTotalPrice() : 0.0f;
        float thisFee = 0.0f;
        long freeSwitchTime = (long)NumberUtils.toPrimitive((Integer)park.getSwitchFeeTime()) * 60L;
        boolean firstPay = bigParkTime > (long)freeTime && bigParkTime - freeSwitchTime > 0L && timeoutTime == 0L;
        boolean secondPay = timeoutTime > 0L && timeoutTime > (long)(freeTimeAfterPay * 60);
        boolean bl2 = isOutPayAndNoTimeOut = isOutPay && timeoutTime <= (long)freeTimeAfterPay.intValue() * 60L;
        if (!isOutPayAndNoTimeOut && (firstPay || secondPay)) {
            List<BaseFeeParamHolder.ExtraComputeFeePara> computeFeeParaList = feeParamHolder.getExtraComputeFeeParaList();
            if (!feeParamHolder.isMonthCarFee() && CollectionUtils.isEmpty((Collection)computeFeeParaList)) {
                computeFeeParaList = this.resolveHolsFeeParams(feeParamHolder.getOrderInfo(), startTime, startTime + bigParkTime);
            }
            if (CollectionUtils.isEmpty((Collection)feeParamHolder.getExtraComputeFeeParaList())) {
                thisFee = this.chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), (int)(startTime + bigParkTime), 0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), isUseFreetime);
            } else {
                boolean currentIsUseFreetime = isUseFreetime;
                for (BaseFeeParamHolder.ExtraComputeFeePara touComputeFeePara : computeFeeParaList) {
                    thisFee += this.chargeFee(feeParamHolder, parkId, touComputeFeePara.getBillId() == null ? billId : touComputeFeePara.getBillId(), touComputeFeePara.getStartTime().intValue(), touComputeFeePara.getEndTime().intValue(), 0, isPaid, orderInfo.getCarType(), touComputeFeePara.isCsMonthCarFee(), touComputeFeePara.getCsFeeType(), touComputeFeePara.getCsStartTime(), touComputeFeePara.getCsEndTime(), touComputeFeePara.getCsSwitchTime(), currentIsUseFreetime);
                    currentIsUseFreetime = false;
                }
            }
            log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8f66\u724c\u53f7[{}], \u5e94\u6536\u91d1\u989d[{}]", (Object)orderInfo.getPlateNum(), (Object)Float.valueOf(thisFee));
            if (isPaid && overtimeBillType == 2) {
                log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8d85\u65f6\u7f34\u8d39\u8f66\u724c\u53f7[{}], \u51cf\u53bb\u5df2\u7b97\u8d39\u91d1\u989d\u540e\u5e94\u7f34[{}]", (Object)orderInfo.getPlateNum(), (Object)Float.valueOf(thisFee -= totalPrice));
            }
            feeParamHolder.setThisFee(thisFee);
        }
        return feeParamHolder.getQueryOrderFeeResponse();
    }

    private Integer getVipOutBillIdAndSetInnerVip(MultipleAreaFeeParamHolder feeParamHolder, Long regionId, OrderSonInfo innerOrderSonInfo, VipType vipType) {
        Integer billId = null;
        List vipRegionList = this.vipRegionService.getVipRegionsListByVipTypeId(vipType.getId());
        if (CollectionUtils.isNotEmpty((Collection)vipRegionList)) {
            VipRegion vipRegion = vipRegionList.stream().filter(vr -> Long.valueOf(0L).equals(vr.getRegionId())).findFirst().orElse(null);
            if (vipRegion != null) {
                billId = vipRegion.getBillId();
                feeParamHolder.setInnerVipBillId(billId);
                feeParamHolder.setInnerVipType(vipType);
                feeParamHolder.setVipType(vipType);
            } else {
                for (VipRegion region : vipRegionList) {
                    if (region.getRegionId().equals(regionId)) {
                        billId = region.getBillId();
                        feeParamHolder.setVipType(vipType);
                    }
                    if (!region.getRegionId().equals(innerOrderSonInfo.getRegionId())) continue;
                    feeParamHolder.setInnerVipBillId(region.getBillId());
                    feeParamHolder.setInnerVipType(vipType);
                }
            }
        }
        return billId;
    }

    private BigDecimal maxFee(MultipleAreaFeeParamHolder feeParamHolder, ChargeConfigDTO chargeConfigDTO, OrderInfo orderInfo, long parkTime) {
        log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u6700\u5927\u7f34\u8d39\u903b\u8f91\u5224\u65ad, \u8f66\u724c\u53f7[{}], \u8ba1\u8d39\u89c4\u5219\u914d\u7f6e[{}]", (Object)orderInfo.getPlateNum(), (Object)chargeConfigDTO);
        if (chargeConfigDTO == null) {
            return null;
        }
        if (Integer.valueOf(1).equals(chargeConfigDTO.getDaynightmaxfeeusing()) && Objects.nonNull(chargeConfigDTO.getDaynightmaxfee())) {
            return this.isFee(feeParamHolder, orderInfo, chargeConfigDTO, parkTime);
        }
        return null;
    }

    private BigDecimal isFee(MultipleAreaFeeParamHolder feeParamHolder, OrderInfo orderInfo, ChargeConfigDTO chargeConfigDTO, long parkTime) {
        Integer billId = chargeConfigDTO.getBillId();
        Integer maxFeeType = chargeConfigDTO.getMaxFeeType();
        Integer countType = chargeConfigDTO.getCountType();
        Date startDate = new Date(feeParamHolder.getStartTime() * 1000L);
        Date endDate = new Date(feeParamHolder.getEndTime() * 1000L);
        Calendar calendar = Calendar.getInstance();
        if (maxFeeType == null || maxFeeType == 1) {
            long diffDays = OutAreaComputeFeeHandleChain.getDiffDays(startDate, endDate);
            float maxFee = chargeConfigDTO.getDaynightmaxfee().floatValue() * (float)(diffDays == 0L ? 1L : diffDays);
            calendar.setTime(endDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date dayStart = calendar.getTime();
            long time = dayStart.getTime() / 1000L;
            if (time > orderInfo.getEnterTime()) {
                return null;
            }
            Long enterTime = orderInfo.getEnterTime();
            BigDecimal paidPrice = this.orderPayDao.sumPalteProOrderPay(orderInfo.getParkId(), orderInfo.getPlateNum(), enterTime);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u65e0\u9700\u7f34\u8d39\u8f66\u8f86\u8d85\u8fc7\u5355\u6b21\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff0c\u8f66\u724c\u53f7\uff1a{}\uff0c\u573a\u5185\u5df2\u7f34\u8d39:{},\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff1a{}", new Object[]{orderInfo.getPlateNum(), paidPrice, Float.valueOf(maxFee)});
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            return max.subtract(paidPrice);
        }
        if (maxFeeType == 2) {
            long diffDays = OutAreaComputeFeeHandleChain.getDiffDays(startDate, endDate);
            float maxFee = chargeConfigDTO.getDaynightmaxfee().floatValue() * (float)(diffDays == 0L ? 1L : diffDays);
            if (Integer.valueOf(1).equals(countType)) {
                calendar.setTime(startDate);
            } else if (Integer.valueOf(2).equals(countType)) {
                calendar.setTime(endDate);
            } else {
                calendar.setTime(startDate);
            }
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date dayStart = calendar.getTime();
            BigDecimal paidPrice = this.getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, dayStart, maxFee);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u65e0\u9700\u7f34\u8d39\u8f66\u8f86\u8d85\u8fc7\u5355\u5929\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff0c\u8f66\u724c\u53f7\uff1a{}\uff0c\u5f53\u5929\u5df2\u7f34\u8d39:{},\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff1a{}", new Object[]{orderInfo.getPlateNum(), paidPrice, Float.valueOf(maxFee)});
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            return max.subtract(paidPrice);
        }
        if (maxFeeType == 3) {
            long diffDays = parkTime / 86400L + (long)(parkTime % 86400L > 0L ? 1 : 0);
            float maxFee = chargeConfigDTO.getDaynightmaxfee().floatValue() * (float)(diffDays == 0L ? 1L : diffDays);
            if (Objects.nonNull(countType) && countType == 3) {
                Date enterDate = new Date(orderInfo.getEnterTime() * 1000L);
                calendar.setTime(enterDate);
                calendar.set(11, calendar.get(11) - 24);
                Date btime = calendar.getTime();
                BigDecimal maxFeePara = this.getMaxFeePara(feeParamHolder, orderInfo, billId, endDate, btime, chargeConfigDTO.getDaynightmaxfee());
                if (maxFeePara == null) {
                    return maxFeePara;
                }
                log.info("[\u65b0\u7248\u672c24\u5c0f\u65f6\u6309\u5165\u573a\u6700\u5927\u6536\u8d39] \u5f53\u524d\u8ba2\u5355\u6700\u5927\u6536\u8d39[{}], 24\u5c0f\u65f6\u6700\u5927\u6536\u8d39{}", (Object)Float.valueOf(maxFee), (Object)maxFeePara);
                return maxFeePara.compareTo(new BigDecimal(maxFee)) > 0 ? new BigDecimal(maxFee) : maxFeePara;
            }
            BigDecimal paidPrice = BigDecimal.ZERO;
            if (Objects.nonNull(countType) && countType == 1) {
                Date enterDate = new Date(orderInfo.getEnterTime() * 1000L);
                calendar.setTime(enterDate);
                calendar.set(11, calendar.get(11) - 24);
                Date btime = calendar.getTime();
                paidPrice = this.getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, btime, maxFee);
            } else if (Objects.nonNull(countType) && countType == 2) {
                calendar.setTime(endDate);
                calendar.set(11, calendar.get(11) - 24);
                Date btime = calendar.getTime();
                paidPrice = this.getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, btime, maxFee);
            }
            log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] 24\u5c0f\u65f6\u5df2\u652f\u4ed8\u91d1\u989d[{}]", (Object)paidPrice);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u65e0\u9700\u7f34\u8d39\u8f66\u8f86\u8d85\u8fc724\u5c0f\u65f6\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff0c\u8f66\u724c\u53f7\uff1a{}\uff0c24\u5c0f\u65f6\u5185\u5df2\u7f34\u8d39:{},\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff1a{}", new Object[]{orderInfo.getPlateNum(), paidPrice, Float.valueOf(maxFee)});
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            return max.subtract(paidPrice);
        }
        return null;
    }

    private BigDecimal getPaidFeeForMaxFee(MultipleAreaFeeParamHolder feeParamHolder, OrderInfo orderInfo, Integer billId, Date endDate, Date beginTime, float maxFee) {
        BigDecimal paidPrice = BigDecimal.ZERO;
        List sumPayByOrderNumDtos = this.orderPayDao.sumPaidPriceByPlateNum(orderInfo.getParkId(), orderInfo.getPlateNum(), Long.valueOf(beginTime.getTime() / 1000L), Long.valueOf(endDate.getTime() / 1000L));
        if (CollectionUtils.isEmpty((Collection)sumPayByOrderNumDtos)) {
            return paidPrice;
        }
        log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u83b7\u53d6\u8fd124\u5c0f\u65f6\u5df2\u6536\u8d39\u7528, 24\u5c0f\u65f6\u8303\u56f4\u5185\u652f\u4ed8\u8bb0\u5f55[{}]", (Object)sumPayByOrderNumDtos);
        SumPayByOrderNumDto sumPayByOrderNumDto = (SumPayByOrderNumDto)sumPayByOrderNumDtos.get(0);
        Long enterTime = sumPayByOrderNumDto.getEnterTime();
        double paidPriceSum = sumPayByOrderNumDtos.stream().collect(Collectors.summarizingDouble(orderNumPay -> orderNumPay.getPaidPrice().doubleValue())).getSum();
        if (enterTime >= beginTime.getTime() / 1000L) {
            paidPrice = new BigDecimal(paidPriceSum);
            log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u83b7\u53d6\u8fd124\u5c0f\u65f6\u5df2\u6536\u8d39\u7528, \u6700\u65e9\u652f\u4ed8\u8ba2\u5355\u7684\u5165\u573a\u65f6\u95f4\u572824\u5c0f\u65f6\u8303\u56f4\u5185,\u5b9e\u6536\u603b\u91d1\u989d\u4e3a[{}]", (Object)paidPriceSum);
        } else {
            log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u83b7\u53d6\u8fd124\u5c0f\u65f6\u5df2\u6536\u8d39\u7528, \u6700\u65e9\u652f\u4ed8\u8ba2\u5355\u7684\u5165\u573a\u65f6\u95f4\u572824\u5c0f\u65f6\u8303\u56f4\u5916,\u5f00\u59cb\u8ba1\u7b97\u8303\u56f4\u5185\u7684\u5b9e\u6536,plateNum[{}]", (Object)orderInfo.getPlateNum());
            if (new BigDecimal(paidPriceSum).subtract(sumPayByOrderNumDto.getPaidPrice()).compareTo(new BigDecimal(maxFee)) >= 0 || sumPayByOrderNumDto.getPaidPrice().compareTo(new BigDecimal(0)) == 0) {
                paidPrice = new BigDecimal(paidPriceSum);
                log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u83b7\u53d6\u8fd124\u5c0f\u65f6\u5df2\u6536\u8d39\u7528, \u603b\u5b9e\u6536\u51cf\u8de8\u65f6\u95f4\u70b9\u8ba2\u5355\u7684\u5b9e\u6536\u540e\u4ecd\u7136\u5927\u4e8e\u7b49\u4e8e\u6700\u5927\u6536\u8d39,\u6216\u8ba2\u5355\u5b9e\u65f6\u4e3a0,\u5b9e\u6536\u603b\u91d1\u989d\u4e3a[{}]", (Object)paidPriceSum);
            } else {
                float prefixFee = this.chargeFee(feeParamHolder, orderInfo.getParkId(), billId, enterTime.intValue(), (int)(beginTime.getTime() / 1000L), 0, false, orderInfo.getCarType(), false, 0, null, null, null, true);
                float totalFee = this.chargeFee(feeParamHolder, orderInfo.getParkId(), billId, enterTime.intValue(), sumPayByOrderNumDto.getExitTime().intValue(), 0, false, orderInfo.getCarType(), false, 0, null, null, null, true);
                BigDecimal paidPriceBd = sumPayByOrderNumDto.getPaidPrice();
                BigDecimal suffixFee = BigDecimal.valueOf(totalFee).subtract(new BigDecimal(prefixFee));
                if (suffixFee.compareTo(new BigDecimal(0)) < 0) {
                    suffixFee = new BigDecimal(0);
                }
                if ((paidPrice = new BigDecimal(paidPriceSum).subtract(paidPriceBd).add(suffixFee)).compareTo(new BigDecimal(paidPriceSum)) > 0) {
                    log.info("\u5e94\u6536{}\u5927\u4e8e\u5b9e\u6536{}\u65f6\uff0c\u4ee5\u5b9e\u6536\u4e3a\u51c6", (Object)paidPrice, (Object)paidPriceSum);
                    paidPrice = new BigDecimal(paidPriceSum);
                }
            }
        }
        return paidPrice;
    }

    public static long getDiffDays(Date start, Date end) {
        LocalDate endTime;
        LocalDate startTime = LocalDateTime.ofInstant(start.toInstant(), ZoneOffset.of("+8")).toLocalDate();
        if (startTime.isAfter(endTime = LocalDateTime.ofInstant(end.toInstant(), ZoneOffset.of("+8")).toLocalDate())) {
            return 0L;
        }
        if (startTime.isEqual(endTime)) {
            return 0L;
        }
        return endTime.toEpochDay() - startTime.toEpochDay() + 1L;
    }
}

