/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.multipleareachain;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderTrackMapper;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.MonthFeeDto;
import com.icetech.park.service.queryfee.MonthFeeHandle;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import com.icetech.park.service.queryfee.multipleareachain.InnerAreaComputeFeeHandleChain;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class InnerAreaPreFeeHandleChain
extends MultipleAreaQueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(InnerAreaPreFeeHandleChain.class);
    @Autowired
    private MonthFeeHandle monthFeeHandle;
    @Autowired
    private OrderTrackMapper orderTrackMapper;
    @Value(value="${innerArea.parkTime.parkIds:0}")
    private String innerAreaParkTimeParkIds;
    private final InnerAreaComputeFeeHandleChain nextChain;

    @Autowired
    public InnerAreaPreFeeHandleChain(InnerAreaComputeFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        if (feeParamHolder.isInnerContinue()) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        QueryOrderFeeResponse queryOrderFeeResponse = this.queryFeeObject(feeParamHolder);
        feeParamHolder.setInnerQueryOrderFeeResponse(queryOrderFeeResponse);
        return this.nextChain.queryFee(feeParamHolder);
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {
        Integer visitIscharge;
        OrderSumFeeDto feeDto;
        QueryOrderFeeRequest queryOrderFeeRequest = feeParamHolder.getQueryOrderFeeRequest();
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        Park park = feeParamHolder.getPark();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        OrderSonInfo innerOrderSonInfo = feeParamHolder.getInnerOrderSonInfo();
        Long parkId = park.getId();
        Long regionId = innerOrderSonInfo.getRegionId();
        Integer carType = queryOrderFeeRequest.getCarType();
        if (carType != null) {
            orderInfo.setCarType(carType);
        }
        boolean isInnerExitRec = true;
        if (innerOrderSonInfo.getExitTime() == null) {
            isInnerExitRec = false;
            innerOrderSonInfo.setExitTime(innerOrderSonInfo.getEnterTime());
        }
        boolean isPaid = (feeDto = feeParamHolder.getOrderSumFeeDto()) != null;
        boolean hasSmallParkExitPay = feeParamHolder.hasExitPay(orderInfo.getOrderNum());
        boolean isOutPay = isPaid && innerOrderSonInfo.getExitTime() < feeDto.getLastPayTime();
        int freeTimeAfterPay = NumberUtils.toPrimitive((Integer)parkConfig.getIsfreeAfterpay(Integer.valueOf(15)));
        Long startTime = innerOrderSonInfo.getEnterTime();
        Long endTime = innerOrderSonInfo.getExitTime();
        Long parkTime = this.getNewInnerAreaParkTime(innerOrderSonInfo);
        parkTime = parkTime == null ? endTime - startTime : parkTime;
        log.info("hasSmallParkExitPay : {}, isOutPay : {}, isInnerExitRec : {}, innerOrderSonInfo : {}", new Object[]{hasSmallParkExitPay, isOutPay, isInnerExitRec, innerOrderSonInfo});
        if (hasSmallParkExitPay || isOutPay || !isInnerExitRec) {
            feeParamHolder.setInnerContinue(true);
            QueryOrderFeeResponse freeCarRet = this.getFreeRet((OrderInfo)innerOrderSonInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
            feeParamHolder.setInnerContinue(true);
            return freeCarRet;
        }
        feeParamHolder.setInnerUseDiscount(feeParamHolder.getThisFee() == 0.0f);
        MonthFeeDto monthFeeDto = this.monthFeeHandle.getMonthFeeParam(feeParamHolder, parkId, (OrderInfo)innerOrderSonInfo, startTime, endTime, parkConfig, 2);
        if (monthFeeDto != null) {
            if (monthFeeDto.isMonthRet()) {
                QueryOrderFeeResponse monthCarRet = this.getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
                feeParamHolder.setInnerContinue(true);
                return monthCarRet;
            }
            if (monthFeeDto.getNewStartTime() != null) {
                startTime = monthFeeDto.getNewStartTime();
            }
            if (monthFeeDto.getNewEndTime() != null) {
                endTime = monthFeeDto.getNewEndTime();
            }
            feeParamHolder.setInnerCsFeeType(monthFeeDto.getCsFeeType());
            feeParamHolder.setInnerCsMonthCarFee(monthFeeDto.isCsMonthCarFee());
            feeParamHolder.setInnerCsStartTime(monthFeeDto.getCsStartTime());
            feeParamHolder.setInnerCsEndTime(monthFeeDto.getCsEndTime());
            feeParamHolder.setInnerCsSwitchTime(monthFeeDto.getCsSwitchTime());
            feeParamHolder.setInnerBillIdList(monthFeeDto.getBillIdList());
        }
        Integer type = orderInfo.getType();
        if (PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType().equals(type) && (visitIscharge = parkConfig.getVisitIscharge()) != null && visitIscharge == 0) {
            QueryOrderFeeResponse monthCarRet = this.getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
            log.info("\u9884\u7ea6\u8f66\u65e0\u9700\u7f34\u8d39\u8fd4\u56de\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)orderInfo.getPlateNum());
            feeParamHolder.setInnerContinue(true);
            return monthCarRet;
        }
        feeParamHolder.setInnerParkTime(parkTime);
        feeParamHolder.setInnerStartTime(startTime);
        feeParamHolder.setInnerEndTime(endTime);
        return new QueryOrderFeeResponse();
    }

    public Long getNewInnerAreaParkTime(OrderSonInfo innerOrderSonInfo) {
        if (Arrays.asList(this.innerAreaParkTimeParkIds.split(",")).contains(innerOrderSonInfo.getParkId().toString())) {
            List orderTracks = this.orderTrackMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderTrack.class).eq(OrderTrack::getOrderNum, (Object)innerOrderSonInfo.getOrderNum())).eq(OrderTrack::getRegionId, (Object)innerOrderSonInfo.getRegionId())).orderByAsc(OrderTrack::getEnexTime));
            if (orderTracks.isEmpty()) {
                return null;
            }
            long parkTime = 0L;
            OrderTrack lastOne = null;
            for (OrderTrack orderTrack : orderTracks) {
                if (lastOne != null && orderTrack.getRecordType().equals(2) && lastOne.getRecordType().equals(1)) {
                    parkTime += orderTrack.getEnexTime() - lastOne.getEnexTime();
                    log.info("[\u5c0f\u573a\u505c\u8f66\u65f6\u957f\u65b0\u7edf\u8ba1\u65b9\u5f0f] \u8f66\u724c\u53f7[{}], \u5165\u573a\u65f6\u95f4[{}]\uff0c\u79bb\u573a\u65f6\u95f4[{}]", new Object[]{innerOrderSonInfo.getPlateNum(), lastOne.getEnexTime(), orderTrack.getEnexTime()});
                }
                lastOne = orderTrack;
            }
            log.info("[\u5c0f\u573a\u505c\u8f66\u65f6\u957f\u65b0\u7edf\u8ba1\u65b9\u5f0f] \u8f66\u724c\u53f7[{}], \u505c\u8f66\u65f6\u957f[{}]", (Object)innerOrderSonInfo.getPlateNum(), (Object)parkTime);
            return parkTime;
        }
        return null;
    }
}

