/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.multipleareachain;

import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.domain.dto.ChargeConfigDTO;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateUtils;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import com.icetech.park.service.queryfee.multipleareachain.InnerAreaDiscountFeeHandleChain;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InnerAreaComputeFeeHandleChain
extends MultipleAreaQueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(InnerAreaComputeFeeHandleChain.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    private ChargeService chargeService;
    private MultipleAreaQueryFeeChainAbstract nextChain;

    @Autowired
    public InnerAreaComputeFeeHandleChain(InnerAreaDiscountFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        if (feeParamHolder.isInnerContinue()) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        QueryOrderFeeResponse queryOrderFeeResponse = this.queryFeeObject(feeParamHolder);
        feeParamHolder.setInnerQueryOrderFeeResponse(queryOrderFeeResponse);
        return this.nextChain.queryFee(feeParamHolder);
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {
        boolean secondPay;
        ParkChargeconfig parkChargeconfig;
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Park park = feeParamHolder.getPark();
        Long innerParkTime = feeParamHolder.getInnerParkTime();
        Integer freeTimeAfterPay = parkConfig.getIsfreeAfterpay(Integer.valueOf(15));
        Long parkId = park.getId();
        OrderSonInfo innerOrderSonInfo = feeParamHolder.getInnerOrderSonInfo();
        Long regionId = innerOrderSonInfo.getRegionId();
        Long startTime = feeParamHolder.getInnerStartTime();
        Long endTime = feeParamHolder.getInnerEndTime();
        Integer billId = feeParamHolder.getInnerVipBillId();
        Integer monthBillId = CollectionUtils.isEmpty((Collection)feeParamHolder.getInnerBillIdList()) || feeParamHolder.getInnerBillIdList().stream().anyMatch(Objects::isNull) ? null : (Integer)feeParamHolder.getInnerBillIdList().stream().filter(Objects::nonNull).findFirst().orElse(null);
        Integer n = billId = billId != null ? billId : monthBillId;
        if (billId == null) {
            parkChargeconfig = this.chargeService.getParkChargeConfigByPlateColor(regionId, orderInfo.getOrderNum(), orderInfo.getPlateNum(), park.getId());
            if (Objects.isNull(parkChargeconfig)) {
                log.warn("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8f66\u573a\u672a\u914d\u7f6e\u9ed8\u8ba4\u7684\u8ba1\u8d39\u89c4\u5219\uff0cparkId\uff1a{}", (Object)parkId);
                throw new ResponseBodyException("3001", "\u672a\u914d\u7f6e\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219");
            }
            billId = parkChargeconfig.getId();
        } else {
            parkChargeconfig = this.parkChargeconfigDao.selectByPrimaryKey(billId);
            AssertTools.notNull((Object)parkChargeconfig, (String)"3001", (String)"vip\u8ba1\u8d39\u89c4\u5219\u6570\u636e\u4e0d\u5b8c\u6574");
        }
        feeParamHolder.putParkChargeConfig(billId, parkChargeconfig);
        feeParamHolder.setInnerParkChargeconfig(parkChargeconfig);
        ChargeConfigDTO chargeConfigDTO = this.parkService.getChargeByBillId(parkChargeconfig, orderInfo.getCarType());
        int freeTime = chargeConfigDTO.getFreeTime() * 60;
        OrderSumFeeDto feeDto = feeParamHolder.getOrderSumFeeDto();
        boolean isInnerPaid = feeDto != null && feeDto.getLastPayTime() < innerOrderSonInfo.getExitTime();
        Integer overtimeBillType = parkConfig.getOvertimeBillType();
        long timeoutTime = 0L;
        if (isInnerPaid) {
            Long lastPayTime = feeDto.getLastPayTime();
            timeoutTime = endTime - lastPayTime;
            startTime = endTime - timeoutTime;
            log.info("[\u5c0f\u573a\u8ba1\u8d39] \u5c0f\u573a\u9884\u7f34\u8d39\u540e\uff0c\u8d85\u65f6\u65f6\u957f\u4e3a\uff1a{}\uff0c\u65b0\u7684\u8ba1\u8d39\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a{}", (Object)timeoutTime, (Object)startTime);
        }
        Integer isFreetimeOnce = chargeConfigDTO.getIsFreetimeOnce();
        boolean isUseFreetime = true;
        if (freeTime > 0 && isFreetimeOnce != null) {
            if (isFreetimeOnce < 0) {
                isUseFreetime = true;
            }
            if (isFreetimeOnce == 0) {
                freeTime = 0;
                isUseFreetime = false;
            } else {
                LocalDate today = LocalDate.now();
                long begin = DateUtils.toEpochSecond((LocalDateTime)today.atStartOfDay());
                long end = DateUtils.toEpochSecond((LocalDateTime)today.plusDays(1L).atStartOfDay()) - 1L;
                int count = this.orderInfoDao.countEnexTimesByEnterTime(parkId, orderInfo.getPlateNum(), Long.valueOf(begin), Long.valueOf(end));
                if (count > isFreetimeOnce) {
                    log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u5f53\u65e5\u514d\u8d39\u65f6\u957f\u4f7f\u7528\u6b21\u6570\u5df2\u7528\u5b8c|{}|{}|{}", new Object[]{orderInfo.getPlateNum(), count, isFreetimeOnce});
                    isUseFreetime = false;
                } else {
                    isUseFreetime = true;
                }
            }
        }
        feeParamHolder.setInnerStartTime(startTime);
        boolean isPaid = feeDto != null;
        float totalPrice = isPaid ? feeDto.getTotalPrice() : 0.0f;
        float thisFee = 0.0f;
        boolean firstPay = innerParkTime > (long)freeTime && timeoutTime == 0L;
        boolean bl = secondPay = timeoutTime > 0L && timeoutTime > (long)(freeTimeAfterPay * 60);
        if (firstPay || secondPay) {
            List<BaseFeeParamHolder.ExtraComputeFeePara> computeFeeParaList = feeParamHolder.getExtraComputeFeeParaList();
            int countFeeParkTime = endTime.intValue() - startTime.intValue();
            if (feeParamHolder.getInnerParkTime() != null) {
                countFeeParkTime = Math.min(countFeeParkTime, feeParamHolder.getInnerParkTime().intValue());
            }
            if (!feeParamHolder.isMonthCarFee() && CollectionUtils.isEmpty((Collection)computeFeeParaList)) {
                computeFeeParaList = this.resolveHolsFeeParams((OrderInfo)feeParamHolder.getInnerOrderSonInfo(), startTime, startTime.intValue() + countFeeParkTime);
            }
            if (CollectionUtils.isEmpty((Collection)feeParamHolder.getExtraComputeFeeParaList())) {
                log.info("[\u5c0f\u573a\u8ba1\u8d39] \u8f66\u724c\u53f7[{}], \u5b9e\u9645\u8ba1\u8d39\u65f6\u957f[{}]", (Object)orderInfo.getPlateNum(), (Object)countFeeParkTime);
                thisFee = this.chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), startTime.intValue() + countFeeParkTime, 0, isPaid, orderInfo.getCarType(), feeParamHolder.isInnerCsMonthCarFee(), feeParamHolder.getInnerCsFeeType(), feeParamHolder.getInnerCsStartTime(), feeParamHolder.getInnerCsEndTime(), feeParamHolder.getInnerCsSwitchTime(), isUseFreetime, parkChargeconfig, 2);
            } else {
                boolean currentIsUseFreetime = isUseFreetime;
                for (BaseFeeParamHolder.ExtraComputeFeePara touComputeFeePara : computeFeeParaList) {
                    Integer thisBillId = touComputeFeePara.getBillId() == null ? billId : touComputeFeePara.getBillId();
                    thisFee += this.chargeFee(feeParamHolder, parkId, thisBillId, touComputeFeePara.getStartTime().intValue(), touComputeFeePara.getEndTime().intValue(), 0, isPaid, orderInfo.getCarType(), touComputeFeePara.isCsMonthCarFee(), touComputeFeePara.getCsFeeType(), touComputeFeePara.getCsStartTime(), touComputeFeePara.getCsEndTime(), touComputeFeePara.getCsSwitchTime(), currentIsUseFreetime, feeParamHolder.getParkChargeConfig(thisBillId), 2);
                    currentIsUseFreetime = false;
                }
            }
            log.info("[\u5185\u573a\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8f66\u724c\u53f7[{}], \u5e94\u6536\u91d1\u989d[{}]", (Object)orderInfo.getPlateNum(), (Object)Float.valueOf(thisFee));
            if (isPaid && overtimeBillType == 2) {
                log.info("[\u5185\u573a\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8d85\u65f6\u7f34\u8d39\u8f66\u724c\u53f7[{}], \u51cf\u53bb\u5df2\u7b97\u8d39\u91d1\u989d\u540e\u5e94\u7f34[{}]", (Object)orderInfo.getPlateNum(), (Object)Float.valueOf(thisFee -= totalPrice));
            }
            feeParamHolder.setInnerThisFee(thisFee);
        } else {
            log.info("\u5185\u573a\u672a\u8ba1\u8d39, \u505c\u8f66\u65f6\u957f[{}], \u514d\u8d39\u65f6\u957f[{}], \u7f34\u8d39\u540e\u8d85\u65f6\u65f6\u957f[{}]", new Object[]{innerParkTime, freeTime, timeoutTime});
        }
        return feeParamHolder.getInnerQueryOrderFeeResponse();
    }
}

