/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.impl;

import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.fee.TestFeeService;
import com.icetech.cloudcenter.domain.request.TestFeeRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.runso.Clibrary;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="testFeeService")
public class TestFeeServiceImpl
implements TestFeeService {
    private static final Logger log = LoggerFactory.getLogger(TestFeeServiceImpl.class);
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    private static DecimalFormat FORMAT = new DecimalFormat("###.##");

    public ObjectResponse<Map<String, Object>> testFee(TestFeeRequest testFeeRequest) {
        ParkChargeconfig parkChargeconfig;
        ObjectResponse objectResponse = this.parkService.getParkConfig(testFeeRequest.getParkId());
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return ObjectResponse.failed((String)"400");
        }
        ParkConfig data = (ParkConfig)objectResponse.getData();
        String csStartTime = testFeeRequest.getCsStartTime();
        String csEndTime = testFeeRequest.getCsEndTime();
        Long billId = testFeeRequest.getBillId();
        if (billId == null) {
            parkChargeconfig = this.parkChargeconfigDao.selectDefaultBill(testFeeRequest.getParkId());
            if (parkChargeconfig == null) {
                return ObjectResponse.failed((String)"402", (String)"\u672a\u914d\u7f6e\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219");
            }
            billId = parkChargeconfig.getId().longValue();
        }
        parkChargeconfig = this.parkChargeconfigDao.selectByPrimaryKey(Integer.valueOf(billId.intValue()));
        FeeParamHolder feeParamHolder = new FeeParamHolder(data, parkChargeconfig);
        float fee = this.chargeFee(feeParamHolder, testFeeRequest.getParkId(), testFeeRequest.getStartTime().intValue(), testFeeRequest.getEndTime().intValue(), testFeeRequest.getDiscountTime(), testFeeRequest.getChargeFlag(), testFeeRequest.getCarType(), csStartTime, csEndTime, data.getIsnotgetsmallchange());
        HashMap<String, String> feeMap = new HashMap<String, String>();
        feeMap.put("fee", String.valueOf(FORMAT.format(fee)));
        return ObjectResponse.success(feeMap);
    }

    private float chargeFee(FeeParamHolder feeParamHolder, Long parkId, int startTime, int tmExit, int discountMinutes, Integer chargeFlag, Integer carType, String csStartTime, String csEndTime, Integer isnotgetsmallchange) {
        Clibrary instantce = Clibrary.INSTANTCE;
        int useFreeTime = 0;
        String sChargeConfigCfg = feeParamHolder.getSChargeConfigCfg(feeParamHolder.getParkConfig());
        String sChargeRule = feeParamHolder.getSChargeRule(feeParamHolder.getParkChargeConfig());
        log.info("[\u8ba1\u8d39\u6d4b\u8bd5] startTime:{},tmExit:{},discountMinutes:{},chargeFlag:{},carType:{},parkId:{},{},{},{},{},{}", new Object[]{startTime, tmExit, discountMinutes, chargeFlag, carType, parkId, csStartTime, csEndTime, 0, 0, useFreeTime});
        float fee = StringUtils.isNotBlank((CharSequence)csStartTime) && StringUtils.isNotBlank((CharSequence)csEndTime) ? instantce.chargeinterface_time_json(startTime, tmExit, discountMinutes, chargeFlag, carType, sChargeConfigCfg, sChargeRule, csStartTime, csEndTime, 0, 0, useFreeTime) : instantce.chargeinterface_json(startTime, tmExit, discountMinutes, chargeFlag, carType, sChargeConfigCfg, sChargeRule, useFreeTime);
        log.info("[\u8ba1\u8d39\u6d4b\u8bd5] \u8c03\u7528so\u83b7\u53d6\u8d39\u7528\uff1a{}\u5143", (Object)Float.valueOf(fee));
        if (fee < 0.0f) {
            log.warn("[\u8ba1\u8d39\u6d4b\u8bd5] \u8c03\u7528so\u83b7\u53d6\u8d39\u7528\u5931\u8d25");
            throw new ResponseBodyException("3001", "so\u8ba1\u8d39\u5931\u8d25");
        }
        if (isnotgetsmallchange != null && isnotgetsmallchange == 1) {
            float ys = fee % 1.0f;
            fee = (double)ys >= 0.5 ? (float)((int)fee) + 0.5f : (float)((int)fee);
        }
        return fee;
    }
}

