/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.impl;

import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.QueryExitPlateNumService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryExitPlateNumResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.impl.BaseQueryFeeTools;
import com.icetech.third.utils.RedisUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Deprecated
public class SubChannelQueryFeeHandler
extends BaseQueryFeeTools {
    private static final Logger log = LoggerFactory.getLogger(SubChannelQueryFeeHandler.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private QueryExitPlateNumService queryExitPlateNumService;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;

    public QueryOrderFeeResponse queryOrderFee(QueryOrderFeeRequest queryOrderFeeRequest, boolean isUseDiscount, Long regionId, ParkConfig parkConfig, Park park, int surplusMinutes, double surplusPrice) {
        Integer visitIscharge;
        Integer carType;
        OrderSonInfo orderSonInfo = new OrderSonInfo();
        log.info("[\u5c0f\u573a\u8ba1\u8d39] \u5269\u4f59\u4f18\u60e0\u5206\u949f\u6570\uff1a{}\uff0c\u5269\u4f59\u4f18\u60e0\u91d1\u989d\uff1a{}", (Object)surplusMinutes, (Object)surplusPrice);
        if (orderSonInfo.getId() == null) {
            ObjectResponse queryResponse = this.queryExitPlateNumService.query(queryOrderFeeRequest.getParkCode(), queryOrderFeeRequest.getChannelId());
            ObjectResponse.notError((Response)queryResponse);
            QueryExitPlateNumResponse data = (QueryExitPlateNumResponse)queryResponse.getData();
            QueryOrderFeeResponse cacheFee = data.getCacheFee();
            if (cacheFee != null) {
                log.info("[\u5c0f\u573a\u8ba1\u8d39] \u76f4\u63a5\u4ece\u51fa\u53e3\u7f13\u5b58\u83b7\u53d6\u8d39\u7528\uff0ccacheFee\uff1a{}", (Object)cacheFee);
                return cacheFee;
            }
            String orderNum = data.getOrderNum();
            Long exitTime = data.getExitTime();
            orderSonInfo = new OrderSonInfo();
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setParkId(park.getId());
            orderSonInfo = this.orderSonInfoDao.selectOneByEntity(orderSonInfo);
            orderSonInfo.setExitTime(exitTime);
        } else if (orderSonInfo.getServiceStatus().equals(4)) {
            orderSonInfo.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
        }
        if (orderSonInfo.getExitTime() == null) {
            orderSonInfo.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
        }
        if ((carType = queryOrderFeeRequest.getCarType()) != null) {
            orderSonInfo.setCarType(carType);
        }
        Long startTime = orderSonInfo.getEnterTime();
        Long endTime = orderSonInfo.getExitTime();
        Long parkTime = endTime - startTime;
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        Boolean isManthCard = this.isMonthCard((OrderInfo)orderSonInfo, regionId);
        if (isManthCard.booleanValue()) {
            return this.getFreeRet((OrderInfo)orderSonInfo, parkTime, parkConfig.getIsfreeAfterpay(Integer.valueOf(15)), park.getParkName(), endTime);
        }
        Integer type = orderSonInfo.getType();
        if (PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType().equals(type) && (visitIscharge = parkConfig.getVisitIscharge()) != null && visitIscharge == 0) {
            QueryOrderFeeResponse monthCarRet = this.getFreeRet((OrderInfo)orderSonInfo, parkTime, parkConfig.getIsfreeAfterpay(Integer.valueOf(15)), park.getParkName(), endTime);
            log.info("[\u5c0f\u573a\u8ba1\u8d39] \u9884\u7ea6\u8f66\u65e0\u9700\u7f34\u8d39\u8fd4\u56de\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)orderSonInfo.getPlateNum());
            return monthCarRet;
        }
        Long billId = this.getBillIdByVip((OrderInfo)orderSonInfo, null);
        boolean isVip = false;
        VipType vipType = null;
        if (billId == null) {
            billId = this.getBillIdByPlateColor(regionId, orderSonInfo.getOrderNum(), orderSonInfo.getPlateNum(), park.getId());
        } else {
            ObjectResponse validVipCar = this.vipCarService.getValidVipCar(orderSonInfo.getParkId(), orderSonInfo.getPlateNum(), null);
            vipType = (VipType)validVipCar.getData();
            isVip = true;
        }
        int freeTime = this.parkService.getFreeTimeByBillId(Integer.valueOf(billId.intValue())) * 60;
        OrderSumFeeDto feeDto = this.getPaidFee(orderSonInfo.getOrderNum(), orderSonInfo.getParkId());
        boolean isInnerPaid = feeDto != null && feeDto.getLastPayTime() < orderSonInfo.getExitTime();
        Integer overtimeBillType = parkConfig.getOvertimeBillType();
        long timeoutTime = 0L;
        if (isInnerPaid) {
            Long lastPayTime = feeDto.getLastPayTime();
            timeoutTime = endTime - lastPayTime;
            startTime = endTime - timeoutTime;
            log.info("[\u5c0f\u573a\u8ba1\u8d39] \u5c0f\u573a\u9884\u7f34\u8d39\u540e\uff0c\u8d85\u65f6\u65f6\u957f\u4e3a\uff1a{}\uff0c\u65b0\u7684\u8ba1\u8d39\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a{}", (Object)timeoutTime, (Object)startTime);
        }
        int freeTimeAfterPay = parkConfig.getIsfreeAfterpay(Integer.valueOf(15));
        float minutesDiscount = 0.0f;
        float vipMinutesDiscount = 0.0f;
        if (parkTime > (long)freeTime && timeoutTime == 0L || timeoutTime > 0L && timeoutTime > (long)freeTimeAfterPay * 60L) {
            List orderDiscounts = this.orderDiscountDao.selectByOrderNum(orderSonInfo.getOrderNum(), STATUS);
            int discountMinutes = isUseDiscount ? this.getDiscountMinutes(orderDiscounts) : surplusMinutes;
            float fee = this.chargeFee(park.getId(), Math.toIntExact(billId), startTime.intValue(), endTime.intValue(), 0, feeDto, orderSonInfo.getCarType(), false, 0, null, null, orderSonInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
            if (fee > 0.0f && discountMinutes > 0) {
                minutesDiscount = fee - this.chargeFee(park.getId(), Math.toIntExact(billId), startTime.intValue(), endTime.intValue(), discountMinutes, feeDto, orderSonInfo.getCarType(), false, 0, null, null, orderSonInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
                log.info("[\u5c0f\u573a\u8ba1\u8d39] \u4f18\u60e0\u5238\u8f66\u8f86\u51cf\u514d\u65f6\u95f4 \u8f66\u724c\u53f7{},\u51cf\u514d\u65f6\u95f4\u4e4b\u540e\u7684\u91d1\u989d{}", (Object)orderSonInfo.getPlateNum(), (Object)Float.valueOf(minutesDiscount));
            }
            if (isVip && fee > 0.0f && fee - minutesDiscount > 0.0f) {
                if (vipType.getType().equals(DiscountTypeEnum.\u51cf\u514d\u65f6\u95f4.getType())) {
                    vipMinutesDiscount = fee - this.chargeFee(park.getId(), Math.toIntExact(billId), startTime.intValue(), endTime.intValue(), Integer.parseInt(vipType.getAmount()), feeDto, orderSonInfo.getCarType(), false, 0, null, null, orderSonInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
                }
                if (isInnerPaid && overtimeBillType == 2) {
                    vipType = null;
                }
            }
            this.setBasePara((OrderInfo)orderSonInfo, queryOrderFeeResponse, parkTime, parkConfig.getIsfreeAfterpay(Integer.valueOf(15)), feeDto, park.getParkName(), endTime);
            queryOrderFeeResponse.setUnpayPrice(String.valueOf(fee));
            if (isVip && vipType != null) {
                this.vipDiscount(fee, vipMinutesDiscount, (OrderInfo)orderSonInfo, queryOrderFeeResponse, vipType);
            }
            if (isUseDiscount) {
                this.discountDeal(billId, fee, minutesDiscount, orderDiscounts, queryOrderFeeResponse, (OrderInfo)orderSonInfo, parkConfig);
            } else {
                this.subChannelDiscountDeal(billId, fee, minutesDiscount, orderDiscounts, queryOrderFeeResponse, (OrderInfo)orderSonInfo, parkConfig);
            }
            BigDecimal discountPrice = new BigDecimal(queryOrderFeeResponse.getDiscountPrice()).add(BigDecimal.valueOf(surplusPrice));
            discountPrice = discountPrice.floatValue() > fee ? new BigDecimal(fee) : discountPrice;
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(discountPrice));
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(new BigDecimal(fee).subtract(discountPrice)));
            queryOrderFeeResponse.setTotalAmount(NumberUtils.decimalAdd((Object)Float.valueOf(fee), (Object[])new Object[]{queryOrderFeeResponse.getTotalAmount()}).toString());
            Integer status = this.getFeeStatus(Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getPaidAmount())), Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getUnpayPrice())), Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getDiscountPrice())), Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getDiscountAmount())), Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getTotalAmount())));
            queryOrderFeeResponse.setStatus(status);
            this.redisUtils.set("sub:" + orderSonInfo.getOrderNum(), (Object)queryOrderFeeResponse, 1L, TimeUnit.DAYS);
            return queryOrderFeeResponse;
        }
        log.info("[\u5c0f\u573a\u8ba1\u8d39] \u514d\u8d39\u65f6\u957f\u5185\u6216\u7f34\u8d39\u540e\u672a\u8d85\u65f6\uff0c\u65e0\u9700\u7f34\u8d39\u8fd4\u56de\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)orderSonInfo.getPlateNum());
        return this.getFreeRet((OrderInfo)orderSonInfo, parkTime, parkConfig.getIsfreeAfterpay(Integer.valueOf(15)), park.getParkName(), endTime);
    }
}

