/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.impl;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.cloudcenter.api.QueryExitPlateNumService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryExitPlateNumResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.BaseQueryFeeChain;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.chain.PreFeeHandleChain;
import com.icetech.park.service.queryfee.multipleareachain.OutAreaPreFeeHandleChain;
import com.icetech.third.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class P2cQueryFeeServiceImpl
extends BaseQueryFeeChain {
    private static final Logger log = LoggerFactory.getLogger(P2cQueryFeeServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private QueryExitPlateNumService queryExitPlateNumService;
    @Autowired
    private PreFeeHandleChain preFeeChainHandleChain;
    @Autowired
    private OutAreaPreFeeHandleChain outAreaPreFeeHandleChain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectResponse<QueryOrderFeeResponse> queryFee(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, Park park, ParkConfig parkConfig) {
        QueryOrderFeeResponse queryOrderFeeResponse;
        boolean lock = orderInfo != null && orderInfo.getOrderNum() != null && orderInfo.getOrderNum().length() > 10;
        try {
            if (lock) {
                this.redisUtils.set("lock:queryFee:" + orderInfo.getOrderNum(), (Object)"1", 3000L);
            }
            queryOrderFeeResponse = park.getIsInterior() == null || park.getIsInterior() == 0 || orderInfo != null && orderInfo.getRegionId() == null ? this.queryFeeObject(queryOrderFeeRequest, orderInfo, park, parkConfig) : this.queryMultiFeeObject(queryOrderFeeRequest, orderInfo, park, parkConfig);
        }
        finally {
            if (lock) {
                this.redisUtils.remove("lock:queryFee:" + orderInfo.getOrderNum());
            }
        }
        return ObjectResponse.success((Object)queryOrderFeeResponse);
    }

    public QueryOrderFeeResponse queryMultiFeeObject(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, Park park, ParkConfig parkConfig) {
        String channelCode = queryOrderFeeRequest.getChannelId();
        Boolean isMasterChannel = null;
        if (channelCode != null) {
            ParkInoutdevice parkChannel = (ParkInoutdevice)this.parkService.getInoutDeviceByCode(channelCode).getData();
            isMasterChannel = Integer.valueOf(1).equals(parkChannel.getIsMaster());
        }
        if (isMasterChannel != null && !isMasterChannel.booleanValue()) {
            if (orderInfo.getId() == null) {
                ObjectResponse queryResponse = this.queryExitPlateNumService.query(queryOrderFeeRequest.getParkCode(), queryOrderFeeRequest.getChannelId());
                ObjectResponse.notError((Response)queryResponse, (String)"\u5f53\u524d\u901a\u9053\u672a\u627e\u5230\u8f66\u8f86");
                QueryExitPlateNumResponse data = (QueryExitPlateNumResponse)queryResponse.getData();
                QueryOrderFeeResponse cacheFee = data.getCacheFee();
                if (cacheFee != null) {
                    log.info("\u76f4\u63a5\u4ece\u51fa\u53e3\u7f13\u5b58\u83b7\u53d6\u8d39\u7528\uff0ccacheFee\uff1a{}", (Object)cacheFee);
                    return cacheFee;
                }
                String orderNum = data.getOrderNum();
                Long exitTime = data.getExitTime();
                orderInfo = new OrderInfo();
                orderInfo.setOrderNum(orderNum);
                orderInfo.setParkId(park.getId());
                orderInfo = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
                AssertTools.notNull((Object)orderInfo, (String)"3001", (String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
                orderInfo.setExitTime(exitTime);
            }
            Long endTime = orderInfo.getExitTime() == null ? DateTools.unixTimestamp() : orderInfo.getExitTime();
            long parkTime = endTime - orderInfo.getEnterTime();
            int freeTimeAfterPay = parkConfig.getIsfreeAfterpay(Integer.valueOf(15));
            log.info("\u9884\u7559\u514d\u8d39\u65f6\u957f\u4e3a[{}]\u79d2, \u5b50\u901a\u9053\u65e0\u9700\u7f34\u8d39\u8fd4\u56de, \u8f66\u724c\u53f7[{}]", (Object)(freeTimeAfterPay * 60), (Object)orderInfo.getPlateNum());
            return this.getFreeRetWithPaidPrice(orderInfo, endTime, parkTime, freeTimeAfterPay, park.getParkName());
        }
        if (orderInfo.getId() != null && NumberUtils.toPrimitive((Integer)orderInfo.getHasSon()) == 0) {
            return this.queryFeeObject(queryOrderFeeRequest, orderInfo, park, parkConfig);
        }
        return this.multipleAreaQueryOrderFee(queryOrderFeeRequest, orderInfo, parkConfig, park);
    }

    public QueryOrderFeeResponse queryFeeObject(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, Park park, ParkConfig parkConfig) {
        Long parkId = park.getId();
        if (orderInfo.getId() == null) {
            ObjectResponse queryResponse = this.queryExitPlateNumService.query(queryOrderFeeRequest.getParkCode(), queryOrderFeeRequest.getChannelId());
            ObjectResponse.notError((Response)queryResponse, (String)"\u5f53\u524d\u901a\u9053\u672a\u627e\u5230\u8f66\u8f86");
            QueryExitPlateNumResponse data = (QueryExitPlateNumResponse)queryResponse.getData();
            QueryOrderFeeResponse cacheFee = data.getCacheFee();
            if (cacheFee != null) {
                log.info("\u76f4\u63a5\u4ece\u51fa\u53e3\u7f13\u5b58\u83b7\u53d6\u8d39\u7528\uff0ccacheFee[{}]", (Object)cacheFee);
                return cacheFee;
            }
            String orderNum = data.getOrderNum();
            Long exitTime = data.getExitTime();
            orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            orderInfo.setParkId(parkId);
            orderInfo = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
            orderInfo.setExitTime(exitTime);
        } else {
            if (!orderInfo.getServiceStatus().equals(1)) {
                orderInfo.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
            }
            if (Integer.valueOf(1).equals(orderInfo.getNoneEnterFlag())) {
                return this.fixedFeeHandle(queryOrderFeeRequest, orderInfo, park, parkConfig);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)orderInfo.getOrderNum())) {
            this.redisUtils.remove(RedisDiscountKeyConstant.DISCOUNT_USE_PRE + parkId + ":" + orderInfo.getOrderNum());
            this.redisUtils.remove(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum());
        }
        return this.preFeeChainHandleChain.queryFee(new FeeParamHolder(queryOrderFeeRequest, orderInfo, parkConfig, park));
    }

    public QueryOrderFeeResponse multipleAreaQueryOrderFee(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, ParkConfig parkConfig, Park park) {
        log.info("[\u573a\u4e2d\u573a\u8ba1\u8d39] \u8bf7\u6c42\u53c2\u6570[{}]", (Object)queryOrderFeeRequest);
        if (orderInfo.getId() == null) {
            ObjectResponse queryResponse = this.queryExitPlateNumService.query(queryOrderFeeRequest.getParkCode(), queryOrderFeeRequest.getChannelId());
            ObjectResponse.notError((Response)queryResponse, (String)"\u5f53\u524d\u901a\u9053\u672a\u627e\u5230\u8f66\u8f86");
            QueryExitPlateNumResponse data = (QueryExitPlateNumResponse)queryResponse.getData();
            QueryOrderFeeResponse cacheFee = data.getCacheFee();
            if (cacheFee != null) {
                log.info("\u76f4\u63a5\u4ece\u51fa\u53e3\u7f13\u5b58\u83b7\u53d6\u8d39\u7528\uff0ccacheFee\uff1a{}", (Object)cacheFee);
                return cacheFee;
            }
            String orderNum = data.getOrderNum();
            Long exitTime = data.getExitTime();
            orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            orderInfo.setParkId(park.getId());
            orderInfo = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
            orderInfo.setExitTime(exitTime);
        } else if (!orderInfo.getServiceStatus().equals(1)) {
            orderInfo.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
        }
        if (StringUtils.isNotBlank((CharSequence)orderInfo.getOrderNum())) {
            this.redisUtils.remove(RedisDiscountKeyConstant.DISCOUNT_USE_PRE + park.getId() + ":" + orderInfo.getOrderNum());
            this.redisUtils.remove(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + park.getId() + ":" + orderInfo.getOrderNum());
        }
        return this.outAreaPreFeeHandleChain.queryFee(new MultipleAreaFeeParamHolder(queryOrderFeeRequest, orderInfo, parkConfig, park));
    }

    private QueryOrderFeeResponse fixedFeeHandle(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, Park park, ParkConfig parkConfig) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        queryOrderFeeResponse.setOrderNum(orderInfo.getOrderNum());
        queryOrderFeeResponse.setParkName(park.getParkName());
        queryOrderFeeResponse.setPlateNum(orderInfo.getPlateNum());
        queryOrderFeeResponse.setEnterTime(orderInfo.getEnterTime());
        queryOrderFeeResponse.setCarType(orderInfo.getCarType());
        queryOrderFeeResponse.setQueryTime(Long.valueOf(queryOrderFeeRequest.getExitTime() == null ? DateTools.unixTimestamp() : queryOrderFeeRequest.getExitTime()));
        queryOrderFeeResponse.setParkTime(Long.valueOf(0L));
        String fixedFee = String.valueOf(this.fixedFee(parkConfig, orderInfo.getCarType()));
        queryOrderFeeResponse.setTotalAmount(fixedFee);
        queryOrderFeeResponse.setUnpayPrice(fixedFee);
        queryOrderFeeResponse.setPaidAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountPrice(String.valueOf(0));
        queryOrderFeeResponse.setStatus(Integer.valueOf(2));
        queryOrderFeeResponse.setFreeTime(Long.valueOf(parkConfig.getIsfreeAfterpay(Integer.valueOf(15)).intValue()));
        queryOrderFeeResponse.setIsFixedFee(Boolean.valueOf(true));
        return queryOrderFeeResponse;
    }

    private float fixedFee(ParkConfig parkConfig, Integer carType) {
        if (parkConfig == null) {
            return -1.0f;
        }
        if (Integer.valueOf(3).equals(parkConfig.getNoenterHandleType()) || Integer.valueOf(2).equals(parkConfig.getNoenterHandleType()) && Integer.valueOf(1).equals(parkConfig.getIsfixedfees())) {
            return (carType == 1 ? parkConfig.getFixedfeevalue() : parkConfig.getFixedFeeValueBig()).intValue();
        }
        return -1.0f;
    }
}

