/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.impl;

import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.dao.park.RegionChargeconfigDao;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.constants.PlateColorEnum;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.ToolsUtil;
import com.icetech.common.utils.UUIDTools;
import com.icetech.fee.dao.merchant.DiscountDayDao;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.storecard.StoreCardDao;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.config.JdbcProperties;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.runso.Clibrary;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseQueryFeeTools {
    private static final Logger log = LoggerFactory.getLogger(BaseQueryFeeTools.class);
    @Resource
    protected OrderCarInfoDao orderCarInfoDao;
    @Autowired
    protected ChargeService chargeService;
    @Autowired
    protected ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    protected ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    protected RegionChargeconfigDao regionChargeconfigDao;
    @Autowired
    protected VipCarService vipCarService;
    @Autowired
    protected OrderDiscountDao orderDiscountDao;
    @Autowired
    protected DiscountDayDao discountDayDao;
    @Autowired
    protected MonthCarServiceImpl monthCarService;
    @Autowired
    private MonthInfoDao monthInfoDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    protected ParkServiceImpl parkService;
    @Autowired
    protected StoreCardDao storeCardDao;
    @Autowired
    private JdbcProperties jdbcProperties;
    protected static DecimalFormat FORMAT = new DecimalFormat("###.##");
    protected static final Integer STATUS = 0;
    @Autowired
    private VipRegionService vipRegionService;

    public Long getBillIdByPlateColor(Long regionId, String orderNum, String plateNum, Long parkId) {
        ParkChargeconfig parkChargeconfig = this.getParkChargeConfigByPlateColor(regionId, orderNum, plateNum, parkId);
        if (Objects.isNull(parkChargeconfig)) {
            log.info("\u8f66\u573a\u672a\u914d\u7f6e\u9ed8\u8ba4\u7684\u8ba1\u8d39\u89c4\u5219\uff0cparkId\uff1a{}", (Object)parkId);
            throw new ResponseBodyException("3001", "\u672a\u914d\u7f6e\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219");
        }
        return (long)parkChargeconfig.getId();
    }

    public ParkChargeconfig getParkChargeConfigByPlateColor(Long regionId, String orderNum, String plateNum, Long parkId) {
        ObjectResponse parkChargeconfig;
        RegionChargeconfig regionChargeconfig;
        ObjectResponse parkChargeconfig2;
        RegionChargeconfig regionChargeconfig2;
        StoreCard storeCard;
        log.info("\u83b7\u53d6\u8ba1\u8d39\u89c4\u5219\uff0c\u53c2\u6570\uff1aregionId\uff1a{}, orderNum\uff1a{}, plateNum\uff1a{}, parkId\uff1a{}", new Object[]{regionId, orderNum, plateNum, parkId});
        if (plateNum != null && (storeCard = this.storeCardDao.selectValidateCard(parkId, plateNum)) != null && regionId != null && regionId != 0L && Objects.nonNull(regionChargeconfig2 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(6))) && Objects.nonNull(parkChargeconfig2 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig2.getBilltypecode()))) {
            log.info("\u4f7f\u7528\u50a8\u503c\u5361\u8f66\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig2);
            return parkChargeconfig2;
        }
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
        Object billId = null;
        if (carInfo != null && regionId != null && regionId != 0L) {
            ParkChargeconfig parkChargeconfig3;
            RegionChargeconfig regionChargeconfig3;
            String plateColor = carInfo.getPlateColor();
            if (PlateColorEnum.BULE.getDesc().equals(plateColor) && Objects.nonNull(regionChargeconfig3 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(3))) && Objects.nonNull(parkChargeconfig3 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig3.getBilltypecode()))) {
                log.info("\u4f7f\u7528\u84dd\u724c\u8f66\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig3);
                return parkChargeconfig3;
            }
            if (PlateColorEnum.YELLOW.getDesc().equals(plateColor) && Objects.nonNull(regionChargeconfig3 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(4))) && Objects.nonNull(parkChargeconfig3 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig3.getBilltypecode()))) {
                log.info("\u4f7f\u7528\u9ec4\u724c\u8f66\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig3);
                return parkChargeconfig3;
            }
            if ((PlateColorEnum.GREEN.getDesc().equals(plateColor) || PlateColorEnum.YELLOW_GREEN.getDesc().equals(plateColor)) && Objects.nonNull(regionChargeconfig3 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(1))) && Objects.nonNull(parkChargeconfig3 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig3.getBilltypecode()))) {
                log.info("\u4f7f\u7528\u65b0\u80fd\u6e90\u8f66\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig3);
                return parkChargeconfig3;
            }
            if (billId == null && Objects.nonNull(regionChargeconfig3 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(0))) && Objects.nonNull(parkChargeconfig3 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig3.getBilltypecode()))) {
                log.info("\u4f7f\u7528\u533a\u57df\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig3);
                return parkChargeconfig3;
            }
            ObjectResponse parkChargeconfig4 = this.chargeService.selectDefaultBill(parkId);
            log.info("\u4f7f\u7528\u8f66\u573a\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig4);
            return (ParkChargeconfig)parkChargeconfig4.getData();
        }
        if (regionId != null && regionId != 0L && Objects.nonNull(regionChargeconfig = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(0))) && ObjectResponse.isSuccess((Response)(parkChargeconfig = this.chargeService.getConfigsBycode(parkId, regionChargeconfig.getBilltypecode())))) {
            log.info("\u4f7f\u7528\u533a\u57df\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, parkChargeconfig.getData());
            return (ParkChargeconfig)parkChargeconfig.getData();
        }
        parkChargeconfig2 = this.chargeService.selectDefaultBill(parkId);
        log.info("\u4f7f\u7528\u8f66\u573a\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig2);
        return (ParkChargeconfig)parkChargeconfig2.getData();
    }

    public Long getBillIdByVip(OrderInfo orderInfo, Long regionId) {
        Long billId = null;
        if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(orderInfo.getType())) {
            VipRegion vipRegion;
            ObjectResponse recentVipCar = this.vipCarService.getRecentVipCar(orderInfo.getParkId(), orderInfo.getPlateNum(), regionId);
            if (ObjectResponse.isSuccess((Response)recentVipCar) && (vipRegion = this.vipRegionService.getOneByVipTypeIdAndRegionId(((VipType)recentVipCar.getData()).getId(), Long.valueOf(0L))) != null && vipRegion.getBillId() != null) {
                billId = (long)vipRegion.getBillId();
            }
        } else {
            VipRegion vipRegion;
            ObjectResponse validVipCar = this.vipCarService.getValidVipCar(orderInfo.getParkId(), orderInfo.getPlateNum(), regionId);
            if (ObjectResponse.isSuccess((Response)validVipCar) && (vipRegion = this.vipRegionService.getOneByVipTypeIdAndRegionId(((VipType)validVipCar.getData()).getId(), Long.valueOf(0L))) != null && vipRegion.getBillId() != null) {
                billId = (long)vipRegion.getBillId();
            }
        }
        return billId;
    }

    public QueryOrderFeeResponse getFreeRet(OrderInfo orderInfo, Long parkTime, int freeTimeAfterPay, String parkName, Long endTime) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        this.setBasePara(orderInfo, queryOrderFeeResponse, parkTime, freeTimeAfterPay, null, parkName, endTime);
        queryOrderFeeResponse.setStatus(Integer.valueOf(1));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(0L));
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(0L));
        queryOrderFeeResponse.setTotalAmount(FORMAT.format(0L));
        return queryOrderFeeResponse;
    }

    public Boolean isMonthCard(OrderInfo orderInfo, Long regionId) {
        MonthInfo monthInfo = this.monthCarService.findMonthInfo(orderInfo.getParkId(), orderInfo.getPlateNum(), regionId, 1);
        return monthInfo == null;
    }

    public void vipDiscount(float thisFee, float vipDiscount, OrderInfo orderInfo, QueryOrderFeeResponse queryOrderFeeResponse, VipType vipType) {
        if (vipType != null) {
            log.info("[VIP\u8f66\u8f86\u8ba1\u8d39\u4f18\u60e0\u5f00\u59cb] \u8f66\u724c\u53f7{},\u521d\u59cb\u8d39\u7528{}", (Object)orderInfo.getPlateNum(), (Object)Float.valueOf(thisFee));
            Integer type = vipType.getType();
            if (DiscountTypeEnum.\u5168\u514d.getType().equals(type)) {
                vipDiscount = thisFee;
                log.info("[VIP\u8f66\u8f86\u8ba1\u8d39\u4f18\u60e0-\u51cf\u514d\u65f6\u95f4] \u8f66\u724c\u53f7{}.\u4f18\u60e0{},\u4f18\u60e0\u4e4b\u540e{}", new Object[]{orderInfo.getPlateNum(), Float.valueOf(vipDiscount), Float.valueOf(thisFee - vipDiscount)});
            } else if (DiscountTypeEnum.\u51cf\u514d\u91d1\u989d.getType().equals(type)) {
                float vip;
                vipDiscount = vip = ToolsUtil.parseFloat((Object)vipType.getAmount()).floatValue();
                log.info("[VIP\u8f66\u8f86\u8ba1\u8d39\u4f18\u60e0-\u51cf\u514d\u91d1\u989d] \u8f66\u724c\u53f7{}.\u4f18\u60e0{},\u4f18\u60e0\u4e4b\u540e{}", new Object[]{orderInfo.getPlateNum(), Float.valueOf(vipDiscount), Float.valueOf(thisFee - vipDiscount)});
            } else if (DiscountTypeEnum.\u51cf\u514d\u65f6\u95f4.getType().equals(type)) {
                log.info("[VIP\u8f66\u8f86\u8ba1\u8d39\u4f18\u60e0-\u51cf\u514d\u65f6\u95f4] \u8f66\u724c\u53f7{}.\u4f18\u60e0{},\u4f18\u60e0\u4e4b\u540e{}", new Object[]{orderInfo.getPlateNum(), Float.valueOf(vipDiscount), Float.valueOf(thisFee - vipDiscount)});
            } else if (DiscountTypeEnum.\u6298\u6263.getType().equals(type)) {
                float vipRateNum = ToolsUtil.parseFloat((Object)vipType.getAmount()).floatValue();
                float discountFee = thisFee * vipRateNum * 0.1f;
                vipDiscount = thisFee - discountFee;
                log.info("[VIP\u8f66\u8f86\u8ba1\u8d39\u4f18\u60e0-\u6298\u6263] \u8f66\u724c\u53f7{}.\u4f18\u60e0{},\u4f18\u60e0\u4e4b\u540e{}", new Object[]{orderInfo.getPlateNum(), Float.valueOf(vipDiscount), Float.valueOf(thisFee - vipDiscount)});
            }
        }
        if (vipDiscount > thisFee) {
            vipDiscount = thisFee;
        }
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(vipDiscount));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(thisFee - vipDiscount));
    }

    public float discountDeal(Long billId, float thisFee, float minutesDiscount, List<OrderDiscount> orderDiscounts, QueryOrderFeeResponse queryOrderFeeResponse, OrderInfo orderInfo, ParkConfig parkConfig) {
        return this.discountDeal(billId, thisFee, minutesDiscount, orderDiscounts, queryOrderFeeResponse, orderInfo, parkConfig, true);
    }

    public float discountDeal(Long billId, float thisFee, float minutesDiscount, List<OrderDiscount> orderDiscounts, QueryOrderFeeResponse queryOrderFeeResponse, OrderInfo orderInfo, ParkConfig parkConfig, boolean isUseFreetime) {
        float noUseDiscount = 0.0f;
        float unPayPrice = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
        float discountPrice = Float.parseFloat(queryOrderFeeResponse.getDiscountPrice()) + minutesDiscount;
        DiscountDay discountDay = this.discountDayDao.selectLastByPlateNum(queryOrderFeeResponse.getPlateNum(), orderInfo.getParkId());
        if (discountDay != null) {
            Date validStart = discountDay.getStartTime();
            Date validEnd = discountDay.getEndTime();
            Date startDate = new Date(queryOrderFeeResponse.getEnterTime() * 1000L);
            Date endDate = new Date(queryOrderFeeResponse.getQueryTime() * 1000L);
            if (endDate.compareTo(validStart) == 1 && validEnd.compareTo(endDate) == 1) {
                unPayPrice = 0.0f;
                discountPrice = thisFee;
                log.info("[\u4f18\u60e0\u5238-\u6309\u5929\u4f18\u514d\u5168\u514d] \u8f66\u724c\u53f7{}.\u4f18\u60e0{},\u4f18\u60e0\u4e4b\u540e{}", new Object[]{queryOrderFeeResponse.getPlateNum(), Float.valueOf(discountPrice), Float.valueOf(unPayPrice)});
            } else if (endDate.compareTo(validEnd) == 1 && validEnd.compareTo(startDate) == 1) {
                int startTime = (int)(validEnd.getTime() / 1000L);
                float newFee = this.chargeFee(orderInfo.getParkId(), Math.toIntExact(billId), startTime, queryOrderFeeResponse.getQueryTime().intValue(), 0, null, orderInfo.getCarType(), false, 0, null, null, orderInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange(), isUseFreetime);
                unPayPrice = newFee - discountPrice;
                discountPrice = thisFee - unPayPrice;
                log.info("[\u4f18\u60e0\u5238-\u6309\u5929\u4f18\u514d\u90e8\u5206\u8ba1\u8d39] \u8f66\u724c\u53f7{}.\u4f18\u60e0{},\u4f18\u60e0\u4e4b\u540e{}", new Object[]{queryOrderFeeResponse.getPlateNum(), Float.valueOf(discountPrice), Float.valueOf(unPayPrice)});
            }
        }
        if (orderDiscounts != null && orderDiscounts.size() > 0) {
            if (this.hasDiscountFree(orderDiscounts)) {
                unPayPrice = 0.0f;
                discountPrice = thisFee;
                log.info("[\u4f18\u60e0\u5238-\u5168\u514d] \u8f66\u724c\u53f7{}.\u4f18\u60e0{},\u4f18\u60e0\u4e4b\u540e{}", new Object[]{queryOrderFeeResponse.getPlateNum(), Float.valueOf(discountPrice), Float.valueOf(unPayPrice)});
            } else {
                float discountPriceNum = this.getDiscount(orderDiscounts, DiscountTypeEnum.\u51cf\u514d\u91d1\u989d.getType());
                log.info("[\u4f18\u60e0\u5238-\u91d1\u989d\u4f18\u60e0] \u8f66\u724c\u53f7{}.\u91d1\u989d{}", (Object)queryOrderFeeResponse.getPlateNum(), (Object)Float.valueOf(discountPriceNum));
                float discountRateNum = this.getDiscount(orderDiscounts, DiscountTypeEnum.\u6298\u6263.getType());
                log.info("[\u4f18\u60e0\u5238-\u6298\u6263\u4f18\u60e0] \u8f66\u724c\u53f7{}.\u6298\u6263{}", (Object)queryOrderFeeResponse.getPlateNum(), (Object)Float.valueOf(discountRateNum));
                if (discountPriceNum > 0.0f) {
                    unPayPrice = thisFee - (discountPrice += discountPriceNum);
                    if (unPayPrice <= 0.0f) {
                        discountPrice = thisFee;
                    }
                    noUseDiscount = discountPriceNum - thisFee;
                }
                if (discountRateNum > 0.0f) {
                    discountPrice = (unPayPrice = unPayPrice * discountRateNum * 0.1f) <= 0.0f ? thisFee : thisFee - unPayPrice;
                }
            }
        }
        if (discountPrice > thisFee) {
            noUseDiscount = discountPrice - thisFee;
            discountPrice = thisFee;
        }
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(discountPrice));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(thisFee - discountPrice));
        if (noUseDiscount < 0.0f) {
            noUseDiscount = 0.0f;
        }
        return noUseDiscount;
    }

    public void subChannelDiscountDeal(Long billId, float thisFee, float minutesDiscount, List<OrderDiscount> orderDiscounts, QueryOrderFeeResponse queryOrderFeeResponse, OrderInfo orderInfo, ParkConfig parkConfig) {
        float unPayPrice = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
        float discountPrice = Float.parseFloat(queryOrderFeeResponse.getDiscountPrice()) + minutesDiscount;
        DiscountDay discountDay = this.discountDayDao.selectLastByPlateNum(queryOrderFeeResponse.getPlateNum(), orderInfo.getParkId());
        if (discountDay != null) {
            Date validStart = discountDay.getStartTime();
            Date validEnd = discountDay.getEndTime();
            Date startDate = new Date(queryOrderFeeResponse.getEnterTime() * 1000L);
            Date endDate = new Date(queryOrderFeeResponse.getQueryTime() * 1000L);
            if (endDate.compareTo(validStart) == 1 && validEnd.compareTo(endDate) == 1) {
                unPayPrice = 0.0f;
                discountPrice = thisFee;
                log.info("[\u4f18\u60e0\u5238-\u6309\u5929\u4f18\u514d\u5168\u514d] \u8f66\u724c\u53f7{}.\u4f18\u60e0{},\u4f18\u60e0\u4e4b\u540e{}", new Object[]{queryOrderFeeResponse.getPlateNum(), Float.valueOf(discountPrice), Float.valueOf(unPayPrice)});
            } else if (endDate.compareTo(validEnd) == 1 && validEnd.compareTo(startDate) == 1) {
                int startTime = (int)(validEnd.getTime() / 1000L);
                float newFee = this.chargeFee(orderInfo.getParkId(), Math.toIntExact(billId), startTime, queryOrderFeeResponse.getQueryTime().intValue(), 0, null, orderInfo.getCarType(), false, 0, null, null, orderInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
                unPayPrice = newFee - discountPrice;
                discountPrice = thisFee - unPayPrice;
                log.info("[\u4f18\u60e0\u5238-\u6309\u5929\u4f18\u514d\u90e8\u5206\u8ba1\u8d39] \u8f66\u724c\u53f7{}.\u4f18\u60e0{},\u4f18\u60e0\u4e4b\u540e{}", new Object[]{queryOrderFeeResponse.getPlateNum(), Float.valueOf(discountPrice), Float.valueOf(unPayPrice)});
            }
        }
        if (orderDiscounts != null && orderDiscounts.size() > 0) {
            if (this.hasDiscountFree(orderDiscounts)) {
                unPayPrice = 0.0f;
                discountPrice = thisFee;
                log.info("[\u4f18\u60e0\u5238-\u5168\u514d] \u8f66\u724c\u53f7{}.\u4f18\u60e0{},\u4f18\u60e0\u4e4b\u540e{}", new Object[]{queryOrderFeeResponse.getPlateNum(), Float.valueOf(discountPrice), Float.valueOf(unPayPrice)});
            } else {
                float discountRateNum = this.getDiscount(orderDiscounts, DiscountTypeEnum.\u6298\u6263.getType());
                log.info("[\u4f18\u60e0\u5238-\u6298\u6263\u4f18\u60e0] \u8f66\u724c\u53f7{}.\u6298\u6263{}", (Object)queryOrderFeeResponse.getPlateNum(), (Object)Float.valueOf(discountRateNum));
                if (discountRateNum > 0.0f) {
                    discountPrice = (unPayPrice = unPayPrice * discountRateNum * 0.1f) <= 0.0f ? thisFee : thisFee - unPayPrice;
                }
            }
        }
        if (discountPrice > thisFee) {
            discountPrice = thisFee;
        }
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(discountPrice));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(thisFee - discountPrice));
    }

    protected Integer getFeeStatus(Float paidAmount, Float unPayPrice, Float discountPrice, Float discountAmount, Float totalAmount) {
        log.info("\u5224\u65ad\u8d39\u7528\u72b6\u6001\u53c2\u6570\uff1a{}\uff0c{}\uff0c{}\uff0c{}\uff0c{}", new Object[]{paidAmount, unPayPrice, discountPrice, discountAmount, totalAmount});
        if (totalAmount.floatValue() == 0.0f) {
            return 1;
        }
        if (discountAmount.equals(totalAmount)) {
            return 3;
        }
        if ((unPayPrice.floatValue() > 0.0f || discountPrice.floatValue() >= totalAmount.floatValue()) && paidAmount.floatValue() == 0.0f && discountAmount.floatValue() == 0.0f) {
            return 2;
        }
        if (unPayPrice.floatValue() == 0.0f && paidAmount.floatValue() > 0.0f) {
            return 3;
        }
        if (unPayPrice.floatValue() > 0.0f && (paidAmount.floatValue() > 0.0f || discountAmount.floatValue() > 0.0f)) {
            return 4;
        }
        if (unPayPrice.floatValue() > 0.0f) {
            return 2;
        }
        return 1;
    }

    protected float getDiscount(List<OrderDiscount> orderDiscounts, Integer disType) {
        float fee = 0.0f;
        for (OrderDiscount orderDiscount : orderDiscounts) {
            if (!orderDiscount.getType().equals(disType)) continue;
            fee += ToolsUtil.parseFloat((Object)orderDiscount.getAmount()).floatValue();
        }
        return fee;
    }

    protected boolean hasDiscountFree(List<OrderDiscount> orderDiscounts) {
        for (OrderDiscount orderDiscount : orderDiscounts) {
            if (!orderDiscount.getType().equals(DiscountTypeEnum.\u5168\u514d.getType())) continue;
            return true;
        }
        return false;
    }

    protected Integer getDiscountMinutes(List<OrderDiscount> orderDiscounts) {
        Integer minutes = 0;
        for (OrderDiscount orderDiscount : orderDiscounts) {
            if (!orderDiscount.getType().equals(DiscountTypeEnum.\u51cf\u514d\u65f6\u95f4.getType())) continue;
            minutes = minutes + ToolsUtil.parseInt((Object)orderDiscount.getAmount());
        }
        return minutes;
    }

    protected OrderSumFeeDto getPaidFee(String orderNum, Long parkId) {
        OrderPay orderPay = new OrderPay();
        orderPay.setParkId(parkId);
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(Integer.valueOf(2));
        OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumFee(orderPay);
        return orderSumFeeDto;
    }

    protected boolean hasExitPay(String orderNum) {
        List orderPays = this.orderPayDao.selectByOrderNum(orderNum);
        if (orderPays != null && orderPays.size() > 0) {
            for (OrderPay orderPay1 : orderPays) {
                String channelId = orderPay1.getChannelId();
                if (channelId == null) continue;
                return true;
            }
        }
        return false;
    }

    protected void setBasePara(OrderInfo orderInfo, QueryOrderFeeResponse queryOrderFeeResponse, Long parkTime, int freeTimeAfterPay, OrderSumFeeDto feeDto, String parkName, Long queryTime) {
        if (feeDto == null) {
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(0L));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(0L));
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(0L));
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(0L));
            queryOrderFeeResponse.setTotalAmount(FORMAT.format(0L));
        } else {
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(feeDto.getPaidPrice()));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(feeDto.getDiscountPrice()));
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(0L));
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(0L));
            queryOrderFeeResponse.setTotalAmount(FORMAT.format(feeDto.getTotalPrice()));
            queryOrderFeeResponse.setPayTime(feeDto.getLastPayTime());
        }
        queryOrderFeeResponse.setOrderNum(orderInfo.getOrderNum());
        queryOrderFeeResponse.setPlateNum(orderInfo.getPlateNum());
        queryOrderFeeResponse.setEnterTime(orderInfo.getEnterTime());
        queryOrderFeeResponse.setQueryTime(Long.valueOf(queryTime == null ? DateTools.unixTimestamp() : queryTime));
        queryOrderFeeResponse.setParkTime(parkTime);
        queryOrderFeeResponse.setParkName(parkName);
        queryOrderFeeResponse.setFreeTime(Long.valueOf(freeTimeAfterPay));
        queryOrderFeeResponse.setCarType(orderInfo.getCarType());
    }

    protected float chargeFee(Long parkId, Integer billId, int startTime, int tmExit, int discountMinutes, OrderSumFeeDto feeDto, Integer carType, boolean isCsMonthCarFee, int csFeeType, String csStartTime, String csEndTime, Long csSwitchTime, Integer isnotgetsmallchange) {
        return this.chargeFee(parkId, billId, startTime, tmExit, discountMinutes, feeDto, carType, isCsMonthCarFee, csFeeType, csStartTime, csEndTime, csSwitchTime, isnotgetsmallchange, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float chargeFee(Long parkId, Integer billId, int startTime, int tmExit, int discountMinutes, OrderSumFeeDto feeDto, Integer carType, boolean isCsMonthCarFee, int csFeeType, String csStartTime, String csEndTime, Long csSwitchTime, Integer isnotgetsmallchange, boolean isUseFreetime) {
        float fee;
        int chargeFlag = feeDto != null ? 1 : 0;
        Clibrary instantce = Clibrary.INSTANTCE;
        String feeSN = UUIDTools.generateShortUuid();
        String dbserver = this.jdbcProperties.getHost();
        String username = this.jdbcProperties.getUsername();
        String password = this.jdbcProperties.getPassword();
        log.debug("dbserver:{}, username:{}, password:{}", new Object[]{dbserver, username, password});
        log.info("[\u7f34\u8d39\u67e5\u8be2] feeSN\uff1a{}\uff0c\u8c03\u7528so\u83b7\u53d6\u8d39\u7528\u53c2\u6570\uff1astartTime:{},tmExit:{},discountMinutes:{},chargeFlag:{},carType:{},parkId:{},{},{},{},{},{}", new Object[]{feeSN, startTime, tmExit, discountMinutes, chargeFlag, carType, parkId, csStartTime, csEndTime, csFeeType, csSwitchTime, isUseFreetime ? 0 : 1});
        long before = System.currentTimeMillis();
        try {
            if (isCsMonthCarFee) {
                fee = instantce.chargeinterface_time_db_freetime(startTime, tmExit, discountMinutes, chargeFlag, carType, parkId.intValue(), billId, dbserver, username, password, csStartTime, csEndTime, csFeeType, ToolsUtil.parseInt((Object)csSwitchTime), isUseFreetime ? 0 : 1);
                if (fee < 0.0f) {
                    fee = instantce.chargeinterface_time_db_freetime(startTime, tmExit, discountMinutes, chargeFlag, carType, parkId.intValue(), billId, dbserver, username, password, csStartTime, csEndTime, csFeeType, ToolsUtil.parseInt((Object)csSwitchTime), isUseFreetime ? 0 : 1);
                    log.info("[\u7f34\u8d39\u67e5\u8be2] feeSN\uff1a{}\uff0c\u7b2c\u4e00\u6b21\u8ba1\u8d39\u5931\u8d25\uff0c\u4e8c\u6b21\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)feeSN, (Object)Float.valueOf(fee));
                }
                log.info("[\u7f34\u8d39\u67e5\u8be2] feeSN\uff1a{}\uff0c\u9519\u65f6\u8f66\u8c03\u7528so\u83b7\u53d6\u8d39\u7528\uff1a{}\u5143", (Object)feeSN, (Object)Float.valueOf(fee));
            } else {
                fee = instantce.chargeinterface_db_freetime(startTime, tmExit, discountMinutes, chargeFlag, carType, parkId.intValue(), billId, dbserver, username, password, isUseFreetime ? 0 : 1);
                if (fee < 0.0f) {
                    fee = instantce.chargeinterface_db_freetime(startTime, tmExit, discountMinutes, chargeFlag, carType, parkId.intValue(), billId, dbserver, username, password, isUseFreetime ? 0 : 1);
                    log.info("[\u7f34\u8d39\u67e5\u8be2] feeSN\uff1a{}\uff0c\u7b2c\u4e00\u6b21\u8ba1\u8d39\u5931\u8d25\uff0c\u4e8c\u6b21\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)feeSN, (Object)Float.valueOf(fee));
                }
                log.info("[\u7f34\u8d39\u67e5\u8be2] feeSN\uff1a{}\uff0c\u8c03\u7528so\u83b7\u53d6\u8d39\u7528\uff1a{}\u5143", (Object)feeSN, (Object)Float.valueOf(fee));
            }
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - before;
            if (elapsedTime > 2000L) {
                log.warn("[\u7f34\u8d39\u67e5\u8be2] feeSN\uff1a{}\uff0c\u67e5\u8be2\u65f6\u957f\u4e3a\uff1a{}\u6beb\u79d2", (Object)feeSN, (Object)elapsedTime);
            }
        }
        if (fee < 0.0f) {
            log.info("[\u7f34\u8d39\u67e5\u8be2] feeSN\uff1a{}\uff0c\u8c03\u7528so\u83b7\u53d6\u8d39\u7528\u5931\u8d25", (Object)feeSN);
            throw new ResponseBodyException("3001", "so\u8ba1\u8d39\u5931\u8d25");
        }
        BigDecimal bg = new BigDecimal(fee);
        fee = bg.setScale(2, 4).floatValue();
        log.info("[\u7f34\u8d39\u67e5\u8be2] feeSN\uff1a{}\uff0cso\u8ba1\u8d39\u540e\u518d\u56db\u820d\u4e94\u5165\u53d6\u4e24\u4f4d\u5c0f\u6570\u540e\u4e3a{}\u5143", (Object)feeSN, (Object)Float.valueOf(fee));
        if (isnotgetsmallchange != null && isnotgetsmallchange == 1) {
            float ys = fee % 1.0f;
            fee = (double)ys >= 0.5 ? (float)((int)fee) + 0.5f : (float)((int)fee);
        }
        return fee;
    }
}

