/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.chain;

import cn.hutool.core.date.DateUtil;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.MonthFeeDto;
import com.icetech.park.service.queryfee.MonthFeeHandle;
import com.icetech.park.service.queryfee.QueryFeeChainAbstract;
import com.icetech.park.service.queryfee.chain.ComputeFeeHandleChain;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PreFeeHandleChain
extends QueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(PreFeeHandleChain.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private MonthFeeHandle monthFeeHandle;
    @Autowired
    private ParkService parkService;
    private final ComputeFeeHandleChain nextChain;

    @Autowired
    public PreFeeHandleChain(ComputeFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(FeeParamHolder feeParamHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = this.queryFeeObject(feeParamHolder);
        feeParamHolder.setQueryOrderFeeResponse(queryOrderFeeResponse);
        if (!feeParamHolder.isBreak() && this.nextChain != null) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(FeeParamHolder feeParamHolder) {
        Integer visitIscharge;
        Long endTime;
        QueryOrderFeeRequest queryOrderFeeRequest = feeParamHolder.getQueryOrderFeeRequest();
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        Park park = feeParamHolder.getPark();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Long parkId = park.getId();
        Integer carType = queryOrderFeeRequest.getCarType();
        if (carType != null) {
            orderInfo.setCarType(carType);
        }
        if ((endTime = feeParamHolder.getEndTime()) == null) {
            endTime = DateTools.unixTimestamp();
        }
        Long startTime = orderInfo.getEnterTime();
        OrderSumFeeDto feeDto = this.getPaidFee(orderInfo.getOrderNum(), parkId);
        try {
            Integer batteryCarFreeTime = this.getBatteryCarForFree(orderInfo, feeDto, parkConfig, parkId, endTime - startTime);
            startTime = startTime + (long)batteryCarFreeTime.intValue();
            orderInfo.setEnterTime(startTime);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. queryOrderFeeRequest[{}], orderInfo[{}], park[{}], parkConfig[{}]", new Object[]{e.getMessage(), queryOrderFeeRequest, orderInfo, park, parkConfig, e});
        }
        long parkTime = endTime - startTime;
        int freeTimeAfterPay = NumberUtils.toPrimitive((Integer)parkConfig.getIsfreeAfterpay(Integer.valueOf(15)));
        if (NumberUtils.toPrimitive((Integer)parkConfig.getFreeOfficialCars()) == 1 && PlateTypeDto.officialCar((String)orderInfo.getPlateNum())) {
            QueryOrderFeeResponse freeRet = this.getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
            log.info("\u516c\u52a1\u8f66\u65e0\u9700\u7f34\u8d39\u8fd4\u56de\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)orderInfo.getPlateNum());
            feeParamHolder.setBreak(true);
            return freeRet;
        }
        MonthFeeDto monthFeeDto = this.monthFeeHandle.getMonthFeeParam((BaseFeeParamHolder)feeParamHolder, parkId, orderInfo, startTime, endTime, parkConfig, 0);
        if (monthFeeDto != null) {
            if (monthFeeDto.isMonthRet()) {
                QueryOrderFeeResponse monthCarRet = this.getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
                feeParamHolder.setBreak(true);
                return monthCarRet;
            }
            if (monthFeeDto.getNewStartTime() != null) {
                startTime = monthFeeDto.getNewStartTime();
            }
            if (monthFeeDto.getNewEndTime() != null) {
                endTime = monthFeeDto.getNewEndTime();
            }
            feeParamHolder.setCsFeeType(monthFeeDto.getCsFeeType());
            feeParamHolder.setCsMonthCarFee(monthFeeDto.isCsMonthCarFee());
            feeParamHolder.setCsStartTime(monthFeeDto.getCsStartTime());
            feeParamHolder.setCsEndTime(monthFeeDto.getCsEndTime());
            feeParamHolder.setCsSwitchTime(monthFeeDto.getCsSwitchTime());
            feeParamHolder.setBillIdList(monthFeeDto.getBillIdList());
        }
        Integer type = orderInfo.getType();
        if (PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType().equals(type) && (visitIscharge = parkConfig.getVisitIscharge()) != null && visitIscharge == 0) {
            QueryOrderFeeResponse monthCarRet = this.getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
            log.info("\u9884\u7ea6\u8f66\u65e0\u9700\u7f34\u8d39\u8fd4\u56de\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)orderInfo.getPlateNum());
            feeParamHolder.setBreak(true);
            return monthCarRet;
        }
        feeParamHolder.setParkTime(Long.valueOf(parkTime));
        feeParamHolder.setStartTime(startTime);
        feeParamHolder.setEndTime(endTime);
        feeParamHolder.setOrderInfo(orderInfo);
        feeParamHolder.setOrderSumFeeDto(feeDto);
        return new QueryOrderFeeResponse();
    }

    private Integer getBatteryCarForFree(OrderInfo orderInfo, OrderSumFeeDto feeDto, ParkConfig parkConfig, Long parkId, Long parkTime) {
        boolean isOpenFlag = Integer.valueOf(1).equals(parkConfig.getIsNewenergyCharge());
        if (!isOpenFlag || feeDto != null) {
            return 0;
        }
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
        if (carInfo == null) {
            return 0;
        }
        String plateColor = carInfo.getPlateColor();
        if (StringUtils.isEmpty((CharSequence)plateColor) || !plateColor.contains("\u7eff")) {
            return 0;
        }
        Long startTimeForMatch = DateUtil.beginOfDay((Date)DateUtil.date()).getTime() / 1000L;
        Long endTimeForMatch = DateUtil.endOfDay((Date)DateUtil.date()).getTime() / 1000L;
        Integer count = this.orderInfoDao.countRecentExitByEnterTime(parkId, orderInfo.getPlateNum(), startTimeForMatch, endTimeForMatch);
        Integer newEnergyDiscountMinutes = parkConfig.getNewEnergyDiscountMinutes();
        ObjectResponse parkFreeTime = this.parkService.getFreeTime(parkId);
        if (!ObjectResponse.isSuccess((Response)parkFreeTime) && parkFreeTime.getData() == null) {
            return 0;
        }
        int BATTERY_FREEDOM_SECONDS = Math.max(newEnergyDiscountMinutes * 60 - (Integer)parkFreeTime.getData() * 60, 0);
        Integer TWO_HOUR_SECONDS = newEnergyDiscountMinutes * 60;
        Long newFreeParkTime = count <= 0 ? (parkTime > (long)TWO_HOUR_SECONDS.intValue() ? (long)BATTERY_FREEDOM_SECONDS : parkTime - 1L) : 0L;
        log.info("\u8fd0\u7b97\u65b0\u80fd\u6e90\u9996\u514d\u7ed3\u679c, platenum[{}], parkTime[{}],  freeParkTime[{}]", new Object[]{orderInfo.getPlateNum(), parkTime, newFreeParkTime});
        return newFreeParkTime.intValue();
    }
}

