/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.chain;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.city.common.domain.entity.common.Coupon;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.discount.ParkDiscountUsercharge;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.merchant.DiscountDayDao;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.charge.ChargeServiceImpl;
import com.icetech.park.service.discount.ParkDiscountUserchargeService;
import com.icetech.park.service.queryfee.DiscountOverHandle;
import com.icetech.park.service.queryfee.QueryFeeChainAbstract;
import com.icetech.park.service.queryfee.chain.AuthFeeHandleChain;
import com.icetech.third.utils.RedisUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiscountFeeHandleChain
extends QueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(DiscountFeeHandleChain.class);
    @Autowired
    private OrderDiscountDao orderDiscountDao;
    @Autowired
    private DiscountDayDao discountDayDao;
    @Autowired
    private DiscountOverHandle discountOverHandle;
    @Autowired
    private ParkDiscountUserchargeService parkDiscountUserchargeService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ChargeServiceImpl chargeService;
    @Autowired
    private ParkService parkService;
    private static final Integer STATUS = 0;
    private QueryFeeChainAbstract nextChain;

    @Autowired
    public DiscountFeeHandleChain(AuthFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(FeeParamHolder feeParamHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = this.queryFeeObject(feeParamHolder);
        if (!feeParamHolder.isBreak() && this.nextChain != null) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(FeeParamHolder feeParamHolder) {
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Park park = feeParamHolder.getPark();
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        this.setBasePara(orderInfo, queryOrderFeeResponse, feeParamHolder.getParkTime(), parkConfig.getIsfreeAfterpay(Integer.valueOf(15)), park.getParkName(), feeParamHolder.getQueryTime());
        this.setQueryFeeInfo(feeParamHolder, queryOrderFeeResponse, park.getId(), orderInfo.getCarType());
        feeParamHolder.setQueryOrderFeeResponse(queryOrderFeeResponse);
        return queryOrderFeeResponse;
    }

    private void setQueryFeeInfo(FeeParamHolder feeParamHolder, QueryOrderFeeResponse queryOrderFeeResponse, Long parkId, int carType) {
        OrderSumFeeDto orderSumFeeDto = feeParamHolder.getOrderSumFeeDto();
        VipType vipType = feeParamHolder.getVipType();
        float thisFee = feeParamHolder.getThisFee();
        float totalPrice = orderSumFeeDto != null ? orderSumFeeDto.getTotalPrice() : 0.0f;
        ParkChargeconfig parkChargeconfig = feeParamHolder.getParkChargeConfig();
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        float totalAmount = totalPrice + thisFee;
        float unPayPrice = this.vipDiscountHandle(feeParamHolder, parkId, orderSumFeeDto, vipType, thisFee, parkChargeconfig.getId(), orderInfo);
        float vipDiscountPrice = thisFee - unPayPrice;
        unPayPrice = this.couponHandle(feeParamHolder, parkId, orderSumFeeDto, unPayPrice, parkChargeconfig, orderInfo, unPayPrice, queryOrderFeeResponse);
        float discountPrice = thisFee - unPayPrice;
        OrderSumFeeDto feeDto = feeParamHolder.getOrderSumFeeDto();
        if (feeDto == null) {
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(0L));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(0L));
        } else {
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(feeDto.getPaidPrice()));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(feeDto.getDiscountPrice()));
            queryOrderFeeResponse.setPayTime(feeDto.getLastOrderTime() == null ? feeDto.getLastPayTime() : feeDto.getLastOrderTime());
        }
        Float paidAmount = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getPaidAmount()));
        Float discountAmount = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getDiscountAmount()));
        Integer status = this.getFeeStatus(paidAmount, Float.valueOf(unPayPrice), Float.valueOf(discountPrice), discountAmount, Float.valueOf(totalAmount));
        queryOrderFeeResponse.setStatus(status);
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(discountPrice));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(unPayPrice));
        queryOrderFeeResponse.setTotalAmount(FORMAT.format(totalAmount));
        if (vipDiscountPrice > 0.0f) {
            queryOrderFeeResponse.setVipDiscountPrice(FORMAT.format(vipDiscountPrice));
            OrderPayDiscount.VipCouponsInfo vipCouponsInfo = new OrderPayDiscount.VipCouponsInfo();
            vipCouponsInfo.setDiscountType(vipType.getType().toString());
            vipCouponsInfo.setTypeId(vipType.getId().toString());
            vipCouponsInfo.setDiscountPrice(BigDecimal.valueOf(vipDiscountPrice));
            this.redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(), OrderPayDiscount.DiscountSourceEnum.VIP_COUPONS.getDesc(), (Object)vipCouponsInfo, 86400L);
        }
    }

    private float couponHandle(FeeParamHolder feeParamHolder, Long parkId, OrderSumFeeDto orderSumFeeDto, float thisFee, ParkChargeconfig parkChargeconfig, OrderInfo orderInfo, float unPayPrice, QueryOrderFeeResponse queryOrderFeeResponse) {
        DiscountOverHandle.DiscountInfo discount;
        BigDecimal discountPrice;
        if (unPayPrice <= 0.0f) {
            return 0.0f;
        }
        List orderDiscounts = this.orderDiscountDao.selectByOrderNum(orderInfo.getOrderNum(), STATUS);
        if (CollectionUtils.isEmpty((Collection)orderDiscounts)) {
            orderDiscounts = Lists.newArrayList();
            log.debug("[\u53e0\u52a0\u4f18\u60e0] \u6682\u65e0\u4f18\u60e0\u4fe1\u606f orderNum {}", (Object)orderInfo.getOrderNum());
            DiscountDay discountDay = this.discountDayDao.selectLastByPlateNum(orderInfo.getPlateNum(), parkId);
            if (discountDay != null) {
                OrderDiscount orderDiscount = (OrderDiscount)this.orderDiscountDao.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getDiscountNo, (Object)discountDay.getDiscountNo())).eq(OrderDiscount::getDelFlag, (Object)0)).last("limit 1"));
                if (Objects.nonNull(orderDiscount)) {
                    orderDiscounts.add(orderDiscount);
                }
            } else {
                return unPayPrice;
            }
        }
        log.debug("[\u53e0\u52a0\u4f18\u60e0] \u83b7\u53d6\u4f18\u60e0\u4fe1\u606f orderDiscounts {}", (Object)JsonUtils.toString((Object)orderDiscounts));
        ParkDiscountUsercharge parkDiscountUsercharge = this.parkDiscountUserchargeService.getParkDiscountUserchargeByParkId(parkId);
        if (Objects.isNull(parkDiscountUsercharge)) {
            parkDiscountUsercharge = new ParkDiscountUsercharge();
            parkDiscountUsercharge.setParkId(parkId);
            parkDiscountUsercharge.setPlateGetCoupons(Integer.valueOf(1));
            parkDiscountUsercharge.setSupportStackeUsage(Integer.valueOf(2));
            parkDiscountUsercharge.setThirdpartyStackeUsage(Integer.valueOf(1));
            parkDiscountUsercharge.setUserMultipleTimes(Integer.valueOf(2));
        }
        List orderDiscountsUsed = this.orderDiscountDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getOrderNum, (Object)orderInfo.getOrderNum())).eq(OrderDiscount::getStatus, (Object)1)).eq(OrderDiscount::getFrom, (Object)1));
        if (parkDiscountUsercharge.getUserMultipleTimes() == 1 && CollectionUtils.isNotEmpty((Collection)orderDiscountsUsed)) {
            log.info("[\u8ba2\u5355\u5df2\u7ecf\u4f7f\u7528\u8fc7\u4f18\u60e0\u4e0d\u80fd\u7ee7\u7eed\u4f7f\u7528] orderNum {}", (Object)orderInfo.getOrderNum());
            return unPayPrice;
        }
        if ((unPayPrice -= (discountPrice = (discount = this.discountOverHandle.getDiscount((BaseFeeParamHolder)feeParamHolder, parkChargeconfig, orderInfo, orderSumFeeDto, parkDiscountUsercharge, orderDiscounts, queryOrderFeeResponse.getParkTime(), BigDecimal.valueOf(unPayPrice), BigDecimal.valueOf(thisFee), Boolean.FALSE)).getDiscountPrice()).floatValue()) < 0.0f) {
            unPayPrice = 0.0f;
        }
        if (CollectionUtils.isNotEmpty(discount.getDiscountNos())) {
            this.redisUtils.set(RedisDiscountKeyConstant.DISCOUNT_USE_PRE + parkId + ":" + orderInfo.getOrderNum(), (Object)StrUtil.join((CharSequence)",", discount.getDiscountNos()), 86400L);
        }
        log.info("[\u4f18\u60e0\u5238-\u6807\u51c6\u4f18\u60e0] \u8f66\u724c\u53f7[{}], \u4f18\u60e0[{}],\u4f18\u60e0\u4e4b\u540e[{}]", new Object[]{orderInfo.getPlateNum(), discountPrice, Float.valueOf(unPayPrice)});
        if (discount.getMerchantDiscountPrice() != null) {
            queryOrderFeeResponse.setMerchantDiscountPrice(FORMAT.format(discount.getMerchantDiscountPrice()));
            this.redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(), OrderPayDiscount.DiscountSourceEnum.MERCHANT_COUPONS.getDesc(), (Object)discount.getMerchantCouponsInfo(), 86400L);
        }
        if (discount.getThirdDiscountPrice() != null) {
            queryOrderFeeResponse.setThirdDiscountPrice(FORMAT.format(discount.getThirdDiscountPrice()));
            this.redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(), OrderPayDiscount.DiscountSourceEnum.THIRD_COUPONS.getDesc(), (Object)discount.getThirdCouponsInfo(), 86400L);
        }
        return unPayPrice;
    }

    private float vipDiscountHandle(FeeParamHolder feeParamHolder, Long parkId, OrderSumFeeDto orderSumFeeDto, VipType vipType, float thisFee, Integer billId, OrderInfo orderInfo) {
        float unPayPrice;
        int vipMinutesDiscount;
        if (vipType == null) {
            return thisFee;
        }
        float vipDiscount = 0.0f;
        Integer type = vipType.getType();
        if (DiscountTypeEnum.\u5168\u514d.getType().equals(type)) {
            vipDiscount = thisFee;
        }
        if (DiscountTypeEnum.\u51cf\u514d\u91d1\u989d.getType().equals(type)) {
            vipDiscount = NumberUtils.toFloat((String)vipType.getAmount());
        }
        if (DiscountTypeEnum.\u51cf\u514d\u65f6\u95f4.getType().equals(type) && (vipMinutesDiscount = NumberUtils.toInt((String)vipType.getAmount())) > 0) {
            vipDiscount = thisFee - this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, feeParamHolder.getStartTime().intValue(), feeParamHolder.getEndTime().intValue(), vipMinutesDiscount, orderSumFeeDto != null, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), feeParamHolder.isUseFreetime());
        }
        if (DiscountTypeEnum.\u6298\u6263.getType().equals(type)) {
            float vipRateNum = NumberUtils.toFloat((String)vipType.getAmount());
            vipDiscount = BigDecimal.valueOf(thisFee).subtract(BigDecimal.valueOf(thisFee).multiply(BigDecimal.valueOf(vipRateNum)).multiply(BigDecimal.valueOf(0.1f))).setScale(2, 4).floatValue();
        }
        if ((unPayPrice = thisFee - vipDiscount) < 0.0f) {
            unPayPrice = 0.0f;
        }
        log.info("[VIP\u8f66\u8f86\u8ba1\u8d39\u4f18\u60e0] \u8f66\u724c\u53f7[{}], \u4f18\u60e0[{}],\u4f18\u60e0\u4e4b\u540e[{}]", new Object[]{orderInfo.getPlateNum(), Float.valueOf(vipDiscount), Float.valueOf(unPayPrice)});
        return unPayPrice;
    }

    public BigDecimal calcDiscAmount(OrderInfo orderInfo, Coupon coupon) {
        return this.calcDiscAmount(orderInfo, null, null, coupon);
    }

    public BigDecimal calcDiscAmount(OrderInfo orderInfo, @Nullable Park park, @Nullable ParkConfig parkConfig, Coupon coupon) {
        log.debug("\u901a\u505c\u4f18\u60e0\u8ba1\u7b97\u5f00\u59cb|{}|{}|{}|{}", new Object[]{orderInfo.getOrderNum(), orderInfo.getPlateNum(), coupon.getCouponType(), coupon.getCouponMsg()});
        BigDecimal unpaidAmount = new BigDecimal(orderInfo.getNeedPrice());
        if (unpaidAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        if (Coupon.COUPON_TYPE_AMOUNT.equals(coupon.getCouponType())) {
            return unpaidAmount.compareTo(coupon.getCouponMsg()) > 0 ? coupon.getCouponMsg() : unpaidAmount;
        }
        if (Coupon.COUPON_TYPE_ALL.equals(coupon.getCouponType())) {
            return unpaidAmount;
        }
        int freeMinutes = coupon.getCouponMsg().intValue();
        QueryOrderFeeRequest queryFeeRequest = new QueryOrderFeeRequest();
        queryFeeRequest.setOrderNum(orderInfo.getOrderNum());
        queryFeeRequest.setWithNotPay(Boolean.FALSE);
        if (park == null) {
            ObjectResponse parkResp = this.parkService.findByParkId(orderInfo.getParkId());
            ObjectResponse.notError((Response)parkResp);
            park = (Park)parkResp.getData();
        }
        if (parkConfig == null) {
            ObjectResponse parkConfigResp = this.parkService.getParkConfig(orderInfo.getParkId());
            ObjectResponse.notError((Response)parkConfigResp);
            parkConfig = (ParkConfig)parkConfigResp.getData();
        }
        FeeParamHolder feeParamHolder = new FeeParamHolder(queryFeeRequest, orderInfo, parkConfig, park);
        feeParamHolder.setStartTime(orderInfo.getEnterTime());
        ParkChargeconfig parkChargeconfig = this.chargeService.getParkChargeConfigByPlateColor(orderInfo.getRegionId(), orderInfo.getOrderNum(), orderInfo.getPlateNum(), park.getId());
        feeParamHolder.putParkChargeConfig(parkChargeconfig.getId(), parkChargeconfig);
        float discFeeCal = this.chargeFee((BaseFeeParamHolder)feeParamHolder, orderInfo.getParkId(), parkChargeconfig.getId(), feeParamHolder.getStartTime().intValue(), feeParamHolder.getEndTime().intValue(), freeMinutes, false, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), feeParamHolder.isUseFreetime());
        if (discFeeCal < 0.0f) {
            discFeeCal = 0.0f;
        }
        BigDecimal discAmt = NumberUtils.decimalSubtract((Object)orderInfo.getNeedPrice(), (Object[])new Object[]{Float.valueOf(discFeeCal)});
        log.debug("\u901a\u505c\u4f18\u60e0\u8ba1\u7b97\u7ed3\u675f|{}|{}", (Object)Float.valueOf(discFeeCal), (Object)discAmt);
        return discAmt;
    }
}

