/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.chain;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.domain.dto.ChargeConfigDTO;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.order.SumPayByOrderNumDto;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateUtils;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.QueryFeeChainAbstract;
import com.icetech.park.service.queryfee.chain.DiscountFeeHandleChain;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComputeFeeHandleChain
extends QueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(ComputeFeeHandleChain.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private ChargeService chargeService;
    private static final BigDecimal FREE_VALUE = BigDecimal.ZERO;
    private QueryFeeChainAbstract nextChain;
    @Autowired
    private VipRegionService vipRegionService;
    @Autowired
    private ThirdInfoService thirdInfoService;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    public static final Long ONE_DAY_SECONDS = 86400L;
    public static final ZoneId UTC8 = ZoneId.of("+8");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(UTC8);

    @Autowired
    public ComputeFeeHandleChain(DiscountFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(FeeParamHolder feeParamHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = this.queryFeeObject(feeParamHolder);
        if (!feeParamHolder.isBreak() && this.nextChain != null) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(FeeParamHolder feeParamHolder) {
        boolean secondPay;
        ParkChargeconfig parkChargeconfig;
        VipRegion vipRegion;
        Long parkTime;
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Park park = feeParamHolder.getPark();
        QueryOrderFeeRequest queryOrderFeeRequest = feeParamHolder.getQueryOrderFeeRequest();
        Long startTime = feeParamHolder.getStartTime();
        Long endTime = feeParamHolder.getEndTime();
        Long useParkTime = parkTime = feeParamHolder.getParkTime();
        Integer freeTimeAfterPay = parkConfig.getIsfreeAfterpay(Integer.valueOf(15));
        Long parkId = park.getId();
        boolean isVipCar = false;
        Integer billId = CollectionUtils.isEmpty((Collection)feeParamHolder.getBillIdList()) || feeParamHolder.getBillIdList().stream().anyMatch(Objects::isNull) ? null : (Integer)feeParamHolder.getBillIdList().stream().filter(Objects::nonNull).findFirst().orElse(null);
        VipType vipType = null;
        if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(orderInfo.getType())) {
            ObjectResponse recentVipCar = this.vipCarService.getRecentVipCar(parkId, orderInfo.getPlateNum(), orderInfo.getRegionId());
            if (ObjectResponse.isSuccess((Response)recentVipCar)) {
                isVipCar = true;
                vipType = (VipType)recentVipCar.getData();
                vipRegion = this.vipRegionService.getOneByVipTypeIdAndRegionId(((VipType)recentVipCar.getData()).getId(), orderInfo.getRegionId());
                if (vipRegion != null && vipRegion.getBillId() != null) {
                    billId = vipRegion.getBillId();
                }
            }
        } else {
            ObjectResponse validVipCar = this.vipCarService.getValidVipCar(parkId, orderInfo.getPlateNum(), orderInfo.getRegionId());
            if (ObjectResponse.isSuccess((Response)validVipCar)) {
                isVipCar = true;
                vipType = (VipType)validVipCar.getData();
                vipRegion = this.vipRegionService.getOneByVipTypeIdAndRegionId(((VipType)validVipCar.getData()).getId(), orderInfo.getRegionId());
                if (vipRegion != null && vipRegion.getBillId() != null) {
                    billId = vipRegion.getBillId();
                }
            }
        }
        Long regionId = null;
        if (billId == null) {
            if (queryOrderFeeRequest.getChannelId() != null) {
                ParkInoutdevice parkInoutdevice = (ParkInoutdevice)this.parkService.getInoutDeviceByCode(queryOrderFeeRequest.getChannelId()).getData();
                if (parkInoutdevice == null) {
                    throw new ResponseBodyException("3001", "\u65e0\u6548\u7684\u901a\u9053\u7f16\u53f7");
                }
                Long l = regionId = parkInoutdevice.getRegionId() == null ? null : parkInoutdevice.getRegionId();
            }
            if (Objects.isNull(parkChargeconfig = this.chargeService.getParkChargeConfigByPlateColor(regionId, orderInfo.getOrderNum(), orderInfo.getPlateNum(), park.getId()))) {
                log.warn("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8f66\u573a\u672a\u914d\u7f6e\u9ed8\u8ba4\u7684\u8ba1\u8d39\u89c4\u5219\uff0cparkId\uff1a{}", (Object)parkId);
                throw new ResponseBodyException("3001", "\u672a\u914d\u7f6e\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219");
            }
            billId = parkChargeconfig.getId();
        } else {
            parkChargeconfig = this.parkChargeconfigDao.selectByPrimaryKey(billId);
            AssertTools.notNull((Object)parkChargeconfig, (String)"3001", (String)"vip\u8ba1\u8d39\u89c4\u5219\u6570\u636e\u4e0d\u5b8c\u6574");
        }
        feeParamHolder.putParkChargeConfig(billId, parkChargeconfig);
        ChargeConfigDTO chargeConfigDTO = this.parkService.getChargeByBillId(parkChargeconfig, orderInfo.getCarType());
        BigDecimal surplusfee = this.maxFee(feeParamHolder, chargeConfigDTO, orderInfo, parkTime);
        if (surplusfee != null) {
            if (new BigDecimal(0).compareTo(surplusfee) == 0) {
                QueryOrderFeeResponse freeRet = this.getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
                feeParamHolder.setBreak(true);
                return freeRet;
            }
            if (surplusfee.compareTo(BigDecimal.valueOf(0L)) > 0) {
                feeParamHolder.setSurplusfee(surplusfee);
            }
        }
        Integer isFreetimeOnce = chargeConfigDTO.getIsFreetimeOnce();
        int freeTime = chargeConfigDTO.getFreeTime() * 60;
        Long configFreeTime = (long)chargeConfigDTO.getFreeTime().intValue() * 60L;
        boolean isUseFreetime = true;
        OrderSumFeeDto feeDto = feeParamHolder.getOrderSumFeeDto();
        if (freeTime > 0 && isFreetimeOnce != null) {
            if (isFreetimeOnce < 0) {
                isUseFreetime = true;
            } else if (isFreetimeOnce == 0) {
                freeTime = 0;
                isUseFreetime = false;
            } else {
                LocalDate today = LocalDate.now();
                long begin = DateUtils.toEpochSecond((LocalDateTime)today.atStartOfDay());
                long end = DateUtils.toEpochSecond((LocalDateTime)today.plusDays(1L).atStartOfDay()) - 1L;
                int count = this.orderInfoDao.countEnexTimesByEnterTime(parkId, orderInfo.getPlateNum(), Long.valueOf(begin), Long.valueOf(end));
                log.debug("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u5f53\u65e5\u514d\u8d39\u65f6\u957f\u4f7f\u7528\u6b21\u6570\u5224\u5b9a|{}|{}", (Object)count, (Object)isFreetimeOnce);
                if (count > isFreetimeOnce) {
                    log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u5f53\u65e5\u514d\u8d39\u65f6\u957f\u4f7f\u7528\u6b21\u6570\u5df2\u7528\u5b8c|{}|{}|{}", new Object[]{orderInfo.getPlateNum(), count, isFreetimeOnce});
                    freeTime = 0;
                    isUseFreetime = false;
                } else {
                    isUseFreetime = true;
                }
            }
        }
        boolean isPaid = feeDto != null;
        Integer overtimeBillType = parkConfig.getOvertimeBillType();
        long timeoutTime = 0L;
        if (isPaid) {
            Long lastOrderTime = feeDto.getLastOrderTime();
            if (lastOrderTime == null) {
                lastOrderTime = feeDto.getLastPayTime();
            }
            timeoutTime = endTime - lastOrderTime;
            log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8d85\u65f6\u65f6\u957f\u4e3a[{}]\u79d2", (Object)timeoutTime);
            if (overtimeBillType == 1) {
                startTime = lastOrderTime;
            } else if (isVipCar && overtimeBillType == 2) {
                vipType = null;
            }
        }
        float totalPrice = isPaid ? feeDto.getTotalPrice() : 0.0f;
        float thisFee = 0.0f;
        boolean firstPay = parkTime > (long)freeTime && timeoutTime == 0L;
        boolean bl = secondPay = timeoutTime > 0L && timeoutTime > (long)(freeTimeAfterPay * 60);
        if (firstPay || secondPay) {
            List<BaseFeeParamHolder.ExtraComputeFeePara> computeFeeParaList = feeParamHolder.getExtraComputeFeeParaList();
            if (!feeParamHolder.isMonthCarFee() && CollectionUtils.isEmpty((Collection)computeFeeParaList)) {
                computeFeeParaList = this.resolveHolsFeeParams(feeParamHolder.getOrderInfo(), startTime, endTime);
            }
            if (CollectionUtils.isEmpty((Collection)computeFeeParaList)) {
                Boolean jiNanFee = this.isJiNanFee(parkConfig, orderInfo.getOrderNum(), useParkTime, configFreeTime);
                thisFee = jiNanFee.booleanValue() ? this.jiNanFee(parkConfig, startTime, parkId, orderInfo, useParkTime, configFreeTime, endTime, feeParamHolder, billId, isPaid).floatValue() : this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(), 0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), isUseFreetime);
            } else {
                boolean currentIsUseFreetime = isUseFreetime;
                for (BaseFeeParamHolder.ExtraComputeFeePara touComputeFeePara : computeFeeParaList) {
                    float fee = this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, touComputeFeePara.getBillId() == null ? billId : touComputeFeePara.getBillId(), touComputeFeePara.getStartTime().intValue(), touComputeFeePara.getEndTime().intValue(), 0, isPaid, orderInfo.getCarType(), touComputeFeePara.isCsMonthCarFee(), touComputeFeePara.getCsFeeType(), touComputeFeePara.getCsStartTime(), touComputeFeePara.getCsEndTime(), touComputeFeePara.getCsSwitchTime(), currentIsUseFreetime);
                    log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8f66\u724c\u53f7[{}], \u53c2\u6570[{}], \u5f53\u524d\u5206\u6bb5\u91d1\u989d[{}], \u7d2f\u52a0\u91d1\u989d[{}]", new Object[]{orderInfo.getPlateNum(), touComputeFeePara, Float.valueOf(fee), Float.valueOf(thisFee += fee)});
                    currentIsUseFreetime = false;
                }
            }
            log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8f66\u724c\u53f7[{}], \u5e94\u6536\u91d1\u989d[{}]", (Object)orderInfo.getPlateNum(), (Object)Float.valueOf(thisFee));
            if (isPaid && overtimeBillType == 2) {
                log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u8d85\u65f6\u7f34\u8d39\u8f66\u724c\u53f7[{}], \u51cf\u53bb\u5df2\u7b97\u8d39\u91d1\u989d\u540e\u5e94\u7f34[{}]", (Object)orderInfo.getPlateNum(), (Object)Float.valueOf(thisFee -= totalPrice));
            }
        }
        feeParamHolder.setThisFee(thisFee);
        feeParamHolder.setUseFreetime(isUseFreetime);
        feeParamHolder.setStartTime(startTime);
        feeParamHolder.setVipType(vipType);
        return feeParamHolder.getQueryOrderFeeResponse();
    }

    private BigDecimal maxFee(FeeParamHolder feeParamHolder, ChargeConfigDTO chargeConfigDTO, OrderInfo orderInfo, long parkTime) {
        log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u6700\u5927\u7f34\u8d39\u903b\u8f91\u5224\u65ad, \u8f66\u724c\u53f7[{}], \u8ba1\u8d39\u89c4\u5219\u914d\u7f6e[{}]", (Object)orderInfo.getPlateNum(), (Object)chargeConfigDTO);
        if (chargeConfigDTO == null) {
            return null;
        }
        if (Integer.valueOf(1).equals(chargeConfigDTO.getDaynightmaxfeeusing()) && Objects.nonNull(chargeConfigDTO.getDaynightmaxfee())) {
            return this.isFee(feeParamHolder, orderInfo, chargeConfigDTO, parkTime);
        }
        return null;
    }

    private BigDecimal isFee(FeeParamHolder feeParamHolder, OrderInfo orderInfo, ChargeConfigDTO chargeConfigDTO, long parkTime) {
        Integer billId = chargeConfigDTO.getBillId();
        Integer maxFeeType = chargeConfigDTO.getMaxFeeType();
        Integer countType = chargeConfigDTO.getCountType();
        Date startDate = new Date(feeParamHolder.getStartTime() * 1000L);
        Date endDate = new Date(feeParamHolder.getEndTime() * 1000L);
        Calendar calendar = Calendar.getInstance();
        if (maxFeeType == null || maxFeeType == 1) {
            long diffDays = ComputeFeeHandleChain.getDiffDays(startDate, endDate);
            float maxFee = chargeConfigDTO.getDaynightmaxfee().floatValue() * (float)(diffDays == 0L ? 1L : diffDays);
            calendar.setTime(endDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date dayStart = calendar.getTime();
            long time = dayStart.getTime() / 1000L;
            if (time > orderInfo.getEnterTime()) {
                return null;
            }
            Long enterTime = orderInfo.getEnterTime();
            BigDecimal paidPrice = this.orderPayDao.sumPalteProOrderPay(orderInfo.getParkId(), orderInfo.getPlateNum(), enterTime);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u65e0\u9700\u7f34\u8d39\u8f66\u8f86\u8d85\u8fc7\u5355\u6b21\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff0c\u8f66\u724c\u53f7\uff1a{}\uff0c\u573a\u5185\u5df2\u7f34\u8d39:{},\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff1a{}", new Object[]{orderInfo.getPlateNum(), paidPrice, Float.valueOf(maxFee)});
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            return max.subtract(paidPrice);
        }
        if (maxFeeType == 2) {
            long diffDays = ComputeFeeHandleChain.getDiffDays(startDate, endDate);
            float maxFee = chargeConfigDTO.getDaynightmaxfee().floatValue() * (float)(diffDays == 0L ? 1L : diffDays);
            if (Integer.valueOf(1).equals(countType)) {
                calendar.setTime(startDate);
            } else if (Integer.valueOf(2).equals(countType)) {
                calendar.setTime(endDate);
            } else {
                calendar.setTime(startDate);
            }
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date dayStart = calendar.getTime();
            BigDecimal paidPrice = this.getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, dayStart, maxFee);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u65e0\u9700\u7f34\u8d39\u8f66\u8f86\u8d85\u8fc7\u5355\u5929\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff0c\u8f66\u724c\u53f7\uff1a{}\uff0c\u5f53\u5929\u5df2\u7f34\u8d39:{},\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff1a{}", new Object[]{orderInfo.getPlateNum(), paidPrice, Float.valueOf(maxFee)});
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            return max.subtract(paidPrice);
        }
        if (maxFeeType == 3) {
            long diffDays = parkTime / 86400L + (long)(parkTime % 86400L > 0L ? 1 : 0);
            float maxFee = chargeConfigDTO.getDaynightmaxfee().floatValue() * (float)(diffDays == 0L ? 1L : diffDays);
            if (Objects.nonNull(countType) && countType == 3) {
                Date enterDate = new Date(orderInfo.getEnterTime() * 1000L);
                calendar.setTime(enterDate);
                calendar.set(11, calendar.get(11) - 24);
                Date btime = calendar.getTime();
                BigDecimal maxFeePara = this.getMaxFeePara((BaseFeeParamHolder)feeParamHolder, orderInfo, billId, endDate, btime, chargeConfigDTO.getDaynightmaxfee());
                if (maxFeePara == null) {
                    return maxFeePara;
                }
                log.info("[\u65b0\u7248\u672c24\u5c0f\u65f6\u6309\u5165\u573a\u6700\u5927\u6536\u8d39] \u5f53\u524d\u8ba2\u5355\u6700\u5927\u6536\u8d39[{}], 24\u5c0f\u65f6\u6700\u5927\u6536\u8d39{}", (Object)Float.valueOf(maxFee), (Object)maxFeePara);
                return maxFeePara.compareTo(new BigDecimal(maxFee)) > 0 ? new BigDecimal(maxFee) : maxFeePara;
            }
            BigDecimal paidPrice = BigDecimal.ZERO;
            if (Objects.nonNull(countType) && countType == 1) {
                Date enterDate = new Date(orderInfo.getEnterTime() * 1000L);
                calendar.setTime(enterDate);
                calendar.set(11, calendar.get(11) - 24);
                Date btime = calendar.getTime();
                paidPrice = this.getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, btime, maxFee);
            } else if (Objects.nonNull(countType) && countType == 2) {
                calendar.setTime(endDate);
                calendar.set(11, calendar.get(11) - 24);
                Date btime = calendar.getTime();
                paidPrice = this.getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, btime, maxFee);
            }
            log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] 24\u5c0f\u65f6\u5df2\u652f\u4ed8\u91d1\u989d[{}]", (Object)paidPrice);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u65e0\u9700\u7f34\u8d39\u8f66\u8f86\u8d85\u8fc724\u5c0f\u65f6\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff0c\u8f66\u724c\u53f7\uff1a{}\uff0c24\u5c0f\u65f6\u5185\u5df2\u7f34\u8d39:{},\u6700\u5927\u7f34\u8d39\u989d\u5ea6\uff1a{}", new Object[]{orderInfo.getPlateNum(), paidPrice, Float.valueOf(maxFee)});
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            return max.subtract(paidPrice);
        }
        return null;
    }

    private BigDecimal getPaidFeeForMaxFee(FeeParamHolder feeParamHolder, OrderInfo orderInfo, Integer billId, Date endDate, Date beginTime, float maxFee) {
        BigDecimal paidPrice = BigDecimal.ZERO;
        List sumPayByOrderNumDtos = this.orderPayDao.sumPaidPriceByPlateNum(orderInfo.getParkId(), orderInfo.getPlateNum(), Long.valueOf(beginTime.getTime() / 1000L), Long.valueOf(endDate.getTime() / 1000L));
        if (CollectionUtils.isEmpty((Collection)sumPayByOrderNumDtos)) {
            return paidPrice;
        }
        log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u83b7\u53d6\u8fd124\u5c0f\u65f6\u5df2\u6536\u8d39\u7528, 24\u5c0f\u65f6\u8303\u56f4\u5185\u652f\u4ed8\u8bb0\u5f55[{}]", (Object)sumPayByOrderNumDtos);
        SumPayByOrderNumDto sumPayByOrderNumDto = (SumPayByOrderNumDto)sumPayByOrderNumDtos.get(0);
        Long enterTime = sumPayByOrderNumDto.getEnterTime();
        double paidPriceSum = sumPayByOrderNumDtos.stream().collect(Collectors.summarizingDouble(orderNumPay -> orderNumPay.getPaidPrice().doubleValue())).getSum();
        if (enterTime >= beginTime.getTime() / 1000L) {
            paidPrice = new BigDecimal(paidPriceSum);
            log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u83b7\u53d6\u8fd124\u5c0f\u65f6\u5df2\u6536\u8d39\u7528, \u6700\u65e9\u652f\u4ed8\u8ba2\u5355\u7684\u5165\u573a\u65f6\u95f4\u572824\u5c0f\u65f6\u8303\u56f4\u5185,\u5b9e\u6536\u603b\u91d1\u989d\u4e3a[{}]", (Object)paidPriceSum);
        } else {
            log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u83b7\u53d6\u8fd124\u5c0f\u65f6\u5df2\u6536\u8d39\u7528, \u6700\u65e9\u652f\u4ed8\u8ba2\u5355\u7684\u5165\u573a\u65f6\u95f4\u572824\u5c0f\u65f6\u8303\u56f4\u5916,\u5f00\u59cb\u8ba1\u7b97\u8303\u56f4\u5185\u7684\u5b9e\u6536,plateNum[{}]", (Object)orderInfo.getPlateNum());
            if (new BigDecimal(paidPriceSum).subtract(sumPayByOrderNumDto.getPaidPrice()).compareTo(new BigDecimal(maxFee)) >= 0 || sumPayByOrderNumDto.getPaidPrice().compareTo(new BigDecimal(0)) == 0) {
                paidPrice = new BigDecimal(paidPriceSum);
                log.info("[\u67e5\u8d39-\u8ba1\u7b97\u6a21\u5757] \u83b7\u53d6\u8fd124\u5c0f\u65f6\u5df2\u6536\u8d39\u7528, \u603b\u5b9e\u6536\u51cf\u8de8\u65f6\u95f4\u70b9\u8ba2\u5355\u7684\u5b9e\u6536\u540e\u4ecd\u7136\u5927\u4e8e\u7b49\u4e8e\u6700\u5927\u6536\u8d39,\u6216\u8ba2\u5355\u5b9e\u65f6\u4e3a0,\u5b9e\u6536\u603b\u91d1\u989d\u4e3a[{}]", (Object)paidPriceSum);
            } else {
                float prefixFee = this.chargeFee((BaseFeeParamHolder)feeParamHolder, orderInfo.getParkId(), billId, enterTime.intValue(), (int)(beginTime.getTime() / 1000L), 0, false, orderInfo.getCarType(), false, 0, null, null, null, true);
                float totalFee = this.chargeFee((BaseFeeParamHolder)feeParamHolder, orderInfo.getParkId(), billId, enterTime.intValue(), sumPayByOrderNumDto.getExitTime().intValue(), 0, false, orderInfo.getCarType(), false, 0, null, null, null, true);
                BigDecimal paidPriceBd = sumPayByOrderNumDto.getPaidPrice();
                BigDecimal suffixFee = BigDecimal.valueOf(totalFee).subtract(new BigDecimal(prefixFee));
                if (suffixFee.compareTo(new BigDecimal(0)) < 0) {
                    suffixFee = new BigDecimal(0);
                }
                if ((paidPrice = new BigDecimal(paidPriceSum).subtract(paidPriceBd).add(suffixFee)).compareTo(new BigDecimal(paidPriceSum)) > 0) {
                    log.info("\u5e94\u6536{}\u5927\u4e8e\u5b9e\u6536{}\u65f6\uff0c\u4ee5\u5b9e\u6536\u4e3a\u51c6", (Object)paidPrice, (Object)paidPriceSum);
                    paidPrice = new BigDecimal(paidPriceSum);
                }
            }
        }
        return paidPrice;
    }

    public static long getDiffDays(Date start, Date end) {
        LocalDate endTime;
        LocalDate startTime = LocalDateTime.ofInstant(start.toInstant(), ZoneOffset.of("+8")).toLocalDate();
        if (startTime.isAfter(endTime = LocalDateTime.ofInstant(end.toInstant(), ZoneOffset.of("+8")).toLocalDate())) {
            return 0L;
        }
        if (startTime.isEqual(endTime)) {
            return 0L;
        }
        return endTime.toEpochDay() - startTime.toEpochDay() + 1L;
    }

    public static LocalDateTime convertTimestampToLocalDateTime(Long timestamp) {
        return LocalDateTime.ofEpochSecond(timestamp, 0, ZoneOffset.ofHours(8));
    }

    public static long calculateTimeDifferenceInSeconds(LocalDateTime start, LocalDateTime end) {
        Duration duration = Duration.between(start, end);
        return duration.getSeconds();
    }

    private Boolean isJiNanFee(ParkConfig parkConfig, String orderNum, Long useParkTime, Long configFreeTime) {
        if (parkConfig.getNewEnergyChargeFlag() == null || parkConfig.getNewEnergyChargeFlag() == 0) {
            return false;
        }
        if (parkConfig.getNewEnergyVehiclesDiscountMinutes() == null || parkConfig.getNewEnergyVehiclesDiscountMinutes() <= 0) {
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u65b0\u80fd\u6e90\u9996\u505c\u4f18\u60e0\u65f6\u957f(\u5206\u949f)-\u6d4e\u5357\u4f7f\u7528:{}", (Object)parkConfig.getNewEnergyChargeFlag());
            return false;
        }
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
        if (carInfo == null) {
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u83b7\u53d6\u8fdb\u51fa\u573a\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a\u8d70\u9ed8\u8ba4\u8ba1\u8d39,\u8ba2\u5355\u53f7: {}", (Object)orderNum);
            return false;
        }
        String plateColor = carInfo.getPlateColor();
        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u83b7\u53d6\u8fdb\u51fa\u573a\u8ba2\u5355\u660e\u7ec6\u83b7\u53d6\u5230\u7684\u8f66\u724c\u989c\u8272\u4e3a: {}", (Object)plateColor);
        if (StringUtils.isEmpty((CharSequence)plateColor) || !plateColor.contains("\u7eff")) {
            return false;
        }
        if (useParkTime <= configFreeTime) {
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u505c\u8f66\u65f6\u957f:{},\u5c0f\u4e8e\u8ba1\u8d39\u89c4\u5219\u4e2d\u514d\u8d39\u65f6\u957f:{},\u8d70\u9ed8\u8ba4\u8ba1\u8d39", (Object)useParkTime, (Object)configFreeTime);
            return false;
        }
        return true;
    }

    private Float getNoOrderFee(Long startTime, Long useParkTime, Long configFreeTime, Long endTime, Integer discountTotalMinute, FeeParamHolder feeParamHolder, Long parkId, Integer billId, boolean isPaid, OrderInfo orderInfo) {
        Float soFee = Float.valueOf(0.0f);
        Float oneDayFee = null;
        Long cycleStart = startTime;
        Long cycleEnd = cycleStart + ONE_DAY_SECONDS;
        while (useParkTime > 0L) {
            Float currentFee;
            long minTime = Math.min(useParkTime, cycleEnd - cycleStart);
            if (minTime != useParkTime) {
                if (oneDayFee == null) {
                    Float dayFee = Float.valueOf(this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, cycleStart.intValue(), cycleEnd.intValue(), discountTotalMinute, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355,\u505c\u8f66\u65f6\u957f\u8de8\u5929,\u8c03\u7528so\u8ba1\u8d39\u4e00\u6574\u5929\u8d39\u7528:{}", (Object)dayFee);
                    oneDayFee = dayFee;
                    soFee = Float.valueOf(soFee.floatValue() + oneDayFee.floatValue());
                } else {
                    soFee = Float.valueOf(soFee.floatValue() + oneDayFee.floatValue());
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355,\u505c\u8f66\u65f6\u957f\u8de8\u5929\u7ee7\u7eed\u8de8\u5929\u4e0d\u8c03\u7528so\u76f4\u63a5\u7d2f\u52a0\u4e0a\u6b21\u8d39\u7528:{},\u5f53\u524d\u8d39\u7528:{}", (Object)oneDayFee, (Object)soFee);
                }
            } else if (oneDayFee != null && useParkTime <= configFreeTime) {
                currentFee = Float.valueOf(this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, cycleStart.intValue(), endTime.intValue(), 0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), true));
                soFee = Float.valueOf(soFee.floatValue() + currentFee.floatValue());
                log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355,\u505c\u8f66\u65f6\u8de8\u5929,\u6700\u540e\u4e00\u6bb5\u5c0f\u4e8e\u514d\u8d39\u505c\u8f66\u65f6\u957f\u76f4\u63a5\u8c03\u7528so\u8ba1\u8d39\u7ed3\u679c:{},\u5f53\u524d\u8d39\u7528:{}", (Object)currentFee, (Object)soFee);
            } else {
                currentFee = Float.valueOf(this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, cycleStart.intValue(), endTime.intValue(), discountTotalMinute, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                soFee = Float.valueOf(soFee.floatValue() + currentFee.floatValue());
                log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355,\u505c\u8f66\u65f6\u4e0d\u4e0d\u8de8\u5929,\u76f4\u63a5\u8c03\u7528so\u8ba1\u8d39\u7ed3\u679c:{},\u5f53\u524d\u8d39\u7528:{}", (Object)currentFee, (Object)soFee);
            }
            useParkTime = useParkTime - minTime;
            cycleStart = cycleEnd;
            cycleEnd = cycleEnd + ONE_DAY_SECONDS;
        }
        return soFee;
    }

    public Float jiNanFee(ParkConfig parkConfig, Long startTime, Long parkId, OrderInfo orderInfo, Long useParkTime, Long configFreeTime, Long endTime, FeeParamHolder feeParamHolder, Integer billId, boolean isPaid) {
        Float soFee = Float.valueOf(0.0f);
        Integer discountTotalMinute = parkConfig.getNewEnergyVehiclesDiscountMinutes();
        Long beforeEnterTime = startTime - ONE_DAY_SECONDS;
        LambdaQueryWrapper orderQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).eq(OrderInfo::getPlateNum, (Object)orderInfo.getPlateNum())).ge(OrderInfo::getExitTime, (Object)beforeEnterTime)).lt(OrderInfo::getExitTime, (Object)startTime)).eq(OrderInfo::getServiceStatus, (Object)2)).orderByAsc(OrderInfo::getEnterTime);
        List beforeOrders = this.orderInfoDao.selectList((Wrapper)orderQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)beforeOrders)) {
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355\u76f4\u63a5\u8ba1\u8d39");
            Float noOrderFee = this.getNoOrderFee(startTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355,\u8ba1\u8d39\u7ed3\u679c:{}", (Object)noOrderFee);
            soFee = Float.valueOf(soFee.floatValue() + noOrderFee.floatValue());
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355,\u6700\u7ec8\u8ba1\u8d39\u7ed3\u679c:{}", (Object)soFee);
            return soFee;
        }
        Optional<OrderInfo> orderOption = beforeOrders.stream().filter(beforeOrder -> beforeOrder.getExitTime() - beforeOrder.getEnterTime() > configFreeTime).findFirst();
        if (!orderOption.isPresent()) {
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355\u76f4\u63a5\u8ba1\u8d39");
            Float noOrderFee = this.getNoOrderFee(startTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355,\u8ba1\u8d39\u7ed3\u679c:{}", (Object)noOrderFee);
            soFee = Float.valueOf(soFee.floatValue() + noOrderFee.floatValue());
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355,\u6700\u7ec8\u8ba1\u8d39\u7ed3\u679c:{}", (Object)soFee);
            return soFee;
        }
        OrderInfo lastOrder = orderOption.get();
        Long lastEnterTime = lastOrder.getEnterTime();
        Long lastExitTime = lastOrder.getExitTime();
        String lastEnterDateTimeFormat = DateUtil.formatDateTime((Date)new Date(lastEnterTime * 1000L));
        String lastExitDateTimeFormat = DateUtil.formatDateTime((Date)new Date(lastExitTime * 1000L));
        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u524d\u4e00\u6b21\u505c\u8f66\u5df2\u4eab\u53d7\u4f18\u60e0,\u4e0a\u6b21\u505c\u8f66\u5165\u573a\u65f6\u95f4: {},\u4e0a\u6b21\u79bb\u573a\u65f6\u95f4:{}", (Object)lastEnterDateTimeFormat, (Object)lastExitDateTimeFormat);
        String currentStartDateTimeFormat = DateUtil.formatDateTime((Date)new Date(startTime * 1000L));
        String currentExitDateTimeFormat = DateUtil.formatDateTime((Date)new Date(endTime * 1000L));
        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u524d\u4e00\u6b21\u505c\u8f66\u5df2\u4eab\u53d7\u4f18\u60e0,\u672c\u6b21\u505c\u8f66\u5165\u573a\u65f6\u95f4: {},\u672c\u6b21\u79bb\u573a\u65f6\u95f4:{},\u505c\u8f66\u65f6\u957f:{}", new Object[]{currentStartDateTimeFormat, currentExitDateTimeFormat, useParkTime});
        Long discountEnd = lastEnterTime + ONE_DAY_SECONDS;
        String discountEndFormat = DateUtil.formatDateTime((Date)new Date(discountEnd * 1000L));
        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u524d\u4e00\u6b21\u505c\u8f66\u5165\u573a\u65f6\u95f4:{},\u524d\u4e00\u6b21\u505c\u8f66\u79bb\u573a\u65f6\u95f4:{},\u5f53\u6b21\u5165\u573a\u65f6\u95f4:{},\u5f53\u6b21\u79bb\u573a\u65f6\u95f4:{},\u52a01\u5929\u8ba1\u7b97\u4e0b\u6b21\u4f18\u60e0\u7ed3\u675f\u65f6\u95f4:{}", new Object[]{lastEnterDateTimeFormat, lastExitDateTimeFormat, currentStartDateTimeFormat, currentExitDateTimeFormat, discountEndFormat});
        if (startTime < discountEnd) {
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5728\u524d\u4e00\u6b21\u505c\u8f66\u4f18\u60e0\u5185,\u5f53\u6b21\u5165\u573a\u65f6\u95f4: {}, \u4e0a\u6b21\u4f18\u60e0\u622a\u6b62\u65f6\u95f4: {}", (Object)currentStartDateTimeFormat, (Object)discountEndFormat);
            if (endTime <= discountEnd) {
                soFee = Float.valueOf(soFee.floatValue() + this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(), 0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u79bb\u573a\u65f6\u95f4:{},\u5728\u4e0a\u6b21\u4f18\u60e0\u65f6\u95f4\u5185:{},\u6240\u4ee5\u6ca1\u6709\u4f18\u60e0,\u76f4\u63a5\u8c03\u7528so\u8ba1\u8d39\u4e3a:{}", new Object[]{currentExitDateTimeFormat, discountEndFormat, soFee});
            } else {
                Long firstFeeTime = discountEnd - startTime;
                useParkTime = useParkTime - firstFeeTime;
                soFee = Float.valueOf(soFee.floatValue() + this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), discountEnd.intValue(), 0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5728\u524d\u4e00\u6b21\u505c\u8f66\u4f18\u60e0\u5185,\u9700\u8981\u6536\u8d39\u7684\u65f6\u95f4\u662f:{},{},\u505c\u8f66\u65f6\u957f\u4e3a:{},\u51cf\u53bb\u8ba1\u8d39\u8fd9\u6bb5\u65f6\u95f4\u540e\u5269\u4f59\u505c\u8f66\u65f6\u957f:{},\u8fd9\u6bb5\u505c\u8f66\u8c03\u7528so\u8ba1\u8d39\u4e3a:{}", new Object[]{currentStartDateTimeFormat, discountEndFormat, firstFeeTime, useParkTime, soFee});
                Float noOrderFee = this.getNoOrderFee(discountEnd, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5728\u524d\u4e00\u6b21\u505c\u8f66\u4f18\u60e0\u5185,\u5269\u4e0b\u7684\u8ba1\u8d39\u91d1\u989d:{},", (Object)noOrderFee);
                soFee = Float.valueOf(soFee.floatValue() + noOrderFee.floatValue());
                log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6ca1\u6709\u5386\u53f2\u8ba2\u5355,\u6700\u7ec8\u8ba1\u8d39\u7ed3\u679c:{}", (Object)soFee);
            }
        } else {
            LocalDateTime lastExitDateTime = ComputeFeeHandleChain.convertTimestampToLocalDateTime(lastExitTime);
            LocalDateTime lastEnterDateTime = ComputeFeeHandleChain.convertTimestampToLocalDateTime(lastEnterTime);
            LocalDateTime currentStart = LocalDateTime.of(lastExitDateTime.toLocalDate(), lastEnterDateTime.toLocalTime());
            Long translationTime = currentStart.toEpochSecond(ZoneOffset.of("+8"));
            String translationTimFormat = DateUtil.formatDateTime((Date)new Date(translationTime * 1000L));
            if (translationTime.equals(lastEnterTime)) {
                log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5b58\u5728\u8de8\u5929,\u4e0a\u4e00\u6b21\u505c\u8f66\u5165\u573a\u65f6\u95f4:{},\u4e0a\u4e00\u6b21\u505c\u8f66\u79bb\u573a\u65f6\u95f4:{},\u5f53\u6b21\u5165\u573a\u65f6\u95f4:{},\u5f53\u6b21\u79bb\u573a\u65f6\u95f4:{},\u6839\u636e\u4e0a\u4e00\u6b21\u5165\u573a\u65f6\u95f4\u5e73\u79fb\u8ba1\u7b97\u4e0b\u6b21\u4f18\u60e0\u65f6\u95f4\u4e3a:{}", new Object[]{lastEnterDateTimeFormat, lastExitDateTimeFormat, currentStartDateTimeFormat, currentExitDateTimeFormat, translationTimFormat});
                if (startTime > translationTime) {
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5b58\u5728\u8de8\u5929,\u4f7f\u7528\u4f18\u60e0\u4e0d\u91cd\u53e0\u76f4\u63a5\u8ba1\u8d39");
                    Float noOrderFee = this.getNoOrderFee(startTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5b58\u5728\u8de8\u5929,\u4f7f\u7528\u4f18\u60e0\u4e0d\u91cd\u53e0\u76f4\u63a5\u8ba1\u8d39,\u8ba1\u8d39\u7ed3\u679c:{}", (Object)noOrderFee);
                    soFee = Float.valueOf(soFee.floatValue() + noOrderFee.floatValue());
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5b58\u5728\u8de8\u5929,\u4f7f\u7528\u4f18\u60e0\u4e0d\u91cd\u53e0\u76f4\u63a5\u8ba1\u8d39,\u6700\u7ec8\u8ba1\u8d39\u7ed3\u679c:{}", (Object)soFee);
                    return soFee;
                }
            }
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u5165\u573a\u65f6\u95f4:{}, \u4e0a\u6b21\u79bb\u573a\u65f6\u95f4: {}", (Object)lastEnterDateTimeFormat, (Object)lastExitDateTimeFormat);
            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u5165\u573a\u65f6\u95f4:{}, \u4e0a\u6b21\u79bb\u573a\u65f6\u95f4: {},\u4e0a\u6b21\u622a\u6b62\u4f18\u60e0\u65f6\u95f4:{}", new Object[]{lastEnterDateTime, lastExitDateTime, translationTimFormat});
            if (translationTime < lastExitTime) {
                long lastParkTime = ComputeFeeHandleChain.calculateTimeDifferenceInSeconds(currentStart, lastExitDateTime);
                if (lastParkTime > configFreeTime) {
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u5f53\u6b21\u4f18\u60e0");
                    LocalDateTime nextDateTime = currentStart.plusDays(1L);
                    String nextDateTimeFormat = nextDateTime.format(DATE_TIME_FORMATTER);
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5, \u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u5f53\u6b21\u4f18\u60e0,\u4e0b\u6b21\u4f7f\u7528\u4f18\u60e0\u5f00\u59cb\u65f6\u95f4: {}", (Object)nextDateTimeFormat);
                    Long nextStartTime = nextDateTime.toEpochSecond(ZoneOffset.of("+8"));
                    if (endTime <= nextStartTime) {
                        soFee = Float.valueOf(this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(), 0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u5f53\u6b21\u4f18\u60e0,\u5f53\u6b21\u79bb\u573a\u65f6\u95f4: {} \u5728\u4e0b\u6b21\u4f18\u60e0\u65f6\u95f4\u5185:{}, \u6240\u4ee5\u4e0d\u4f18\u60e0,so\u8ba1\u8d39\u4e3a:{}", new Object[]{currentExitDateTimeFormat, nextDateTimeFormat, soFee});
                    } else {
                        Long firstFeeTime = nextStartTime - startTime;
                        Long firstFeeEndTime = startTime + firstFeeTime;
                        useParkTime = useParkTime - firstFeeTime;
                        soFee = Float.valueOf(soFee.floatValue() + this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), nextStartTime.intValue(), 0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u5f53\u6b21\u4f18\u60e0,\u6240\u4ee5\u4e0d\u4f18\u60e0,\u7b2c\u4e00\u6bb5\u8ba1\u8d39\u5f00\u59cb\u65f6\u95f4:{},\u7ed3\u675f\u65f6\u95f4:{},\u505c\u8f66\u65f6\u957f:{}\u79d2,\u5355\u72ec\u7b2c\u4e00\u6bb5\u8c03\u7528so\u8ba1\u8d39\u4e3a:{}", new Object[]{currentStartDateTimeFormat, ComputeFeeHandleChain.convertTimestampToLocalDateTime(firstFeeEndTime).format(DATE_TIME_FORMATTER), firstFeeTime, soFee});
                        Float noOrderFee = this.getNoOrderFee(nextStartTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u5f53\u6b21\u4f18\u60e0,\u7b2c\u8c03\u7528so\u8ba1\u8d39\u4e3a:{}", (Object)noOrderFee);
                        soFee = Float.valueOf(soFee.floatValue() + noOrderFee.floatValue());
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6709\u5386\u53f2\u8ba2\u5355,\u6700\u7ec8\u8ba1\u8d39\u7ed3\u679c:{}", (Object)soFee);
                    }
                } else {
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4e0d\u8db3\u534a\u5c0f\u65f6\u4e0d\u5360\u7528\u4f18\u60e0\u65f6\u95f4\u957f");
                    LocalDateTime nextDateTime = currentStart.plusDays(1L);
                    String nextDateTimeFormat = nextDateTime.format(DATE_TIME_FORMATTER);
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4e0d\u8db3\u534a\u5c0f\u65f6\u4e0d\u5360\u7528\u4f18\u60e0\u65f6\u95f4\u957f,\u4e0b\u6b21\u4f18\u60e0\u65f6\u95f4:{}", (Object)nextDateTimeFormat);
                    Long nextStartTime = nextDateTime.toEpochSecond(ZoneOffset.of("+8"));
                    if (endTime <= nextStartTime) {
                        soFee = Float.valueOf(soFee.floatValue() + this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(), discountTotalMinute, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4e0d\u8db3\u534a\u5c0f\u65f6\u4e0d\u5360\u7528\u4f18\u60e0\u65f6\u95f4\u957f,\u76f4\u63a5\u8ba1\u8d39\u5f00\u59cb\u65f6\u95f4:{}, \u7ed3\u675f\u65f6\u95f4:{},so\u8d39\u7528:{}", new Object[]{currentStartDateTimeFormat, currentExitDateTimeFormat, soFee});
                    } else {
                        soFee = Float.valueOf(soFee.floatValue() + this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), nextStartTime.intValue(), discountTotalMinute, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4e0d\u8db3\u534a\u5c0f\u65f6\u4e0d\u5360\u7528\u4f18\u60e0\u65f6\u95f4\u957f,\u76f4\u63a5\u8ba1\u8d39\u5f00\u59cb\u65f6\u95f4:{}, \u4e0b\u6b21\u4f18\u60e0\u622a\u6b62\u65f6\u95f4:{},so\u8d39\u7528:{}", new Object[]{currentStartDateTimeFormat, nextDateTimeFormat, soFee});
                        useParkTime = useParkTime - (nextStartTime - startTime);
                        Float noOrderFee = this.getNoOrderFee(nextStartTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6709\u5386\u53f2\u8ba2\u5355,\u5269\u4e0b\u8ba1\u8d39\u7ed3\u679c:{}", (Object)noOrderFee);
                        soFee = Float.valueOf(soFee.floatValue() + noOrderFee.floatValue());
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6709\u5386\u53f2\u8ba2\u5355,\u6700\u7ec8\u8ba1\u8d39\u7ed3\u679c:{}", (Object)soFee);
                    }
                }
            } else {
                long lastParkTime = ComputeFeeHandleChain.calculateTimeDifferenceInSeconds(lastExitDateTime, currentStart);
                log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6709\u5386\u53f2\u8ba2\u5355\u8de8\u5929\uff0c\u4f18\u60e0\u65f6\u95f4:{}\uff0c\u5c0f\u4e8e\u4e0a\u6b21\u79bb\u573a\u8ba2\u5355\u65f6\u95f4:{}, \u8fd9\u6bb5\u65f6\u957f:{}", new Object[]{translationTimFormat, lastExitDateTimeFormat, lastParkTime});
                if (lastParkTime <= configFreeTime) {
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u514d\u8d39\u65f6\u957f,\u4f46\u662f\u4e0d\u7b97\u4e0a\u6b21\u4f18\u60e0");
                    LocalDateTime nextDateTime = currentStart.plusDays(1L);
                    String nextDateTimeFormat = nextDateTime.format(DATE_TIME_FORMATTER);
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u514d\u8d39\u65f6\u957f,\u5230\uff1a{}\u7ee7\u7eed\u4f7f\u7528\u65f6\u957f", (Object)nextDateTimeFormat);
                    Float noOrderFee = this.getNoOrderFee(startTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u514d\u8d39\u65f6\u957f,\u8ba1\u8d39\u7ed3\u679c{}", (Object)noOrderFee);
                    soFee = Float.valueOf(soFee.floatValue() + noOrderFee.floatValue());
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u514d\u8d39\u65f6\u957f,\u6700\u7ec8\u8ba1\u8d39\u7ed3\u679c{}", (Object)soFee);
                } else if (startTime >= translationTime) {
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u672c\u6b21\u505c\u8f66\u5728\u4e0a\u6b21\u4f18\u60e0\u4e4b\u5916\u76f4\u63a5so\u8ba1\u8d39");
                    soFee = Float.valueOf(this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(), discountTotalMinute, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                } else {
                    log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u5f53\u6b21\u4f18\u60e0");
                    if (startTime < translationTime) {
                        Long currentStartTime = currentStart.toEpochSecond(ZoneOffset.of("+8"));
                        Long firstTime = currentStartTime - startTime;
                        useParkTime = useParkTime - firstTime;
                        soFee = Float.valueOf(soFee.floatValue() + this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), currentStartTime.intValue(), 0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u5165\u573a\u65f6\u95f4:{},\u5728\u4e0b\u6b21\u4f18\u60e0\u65f6\u95f4:{}\u4e4b\u524d,\u8fd9\u6bb5\u65f6\u95f4:{}\u9700\u8981\u5355\u72ec\u8ba1\u8d39,\u8ba1\u8d39\u7ed3\u679c:{}", new Object[]{currentStartDateTimeFormat, translationTimFormat, firstTime, soFee});
                        Float noOrderFee = this.getNoOrderFee(currentStartTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u5269\u4e0b\u8ba1\u8d39\u7ed3\u679c:{}", (Object)noOrderFee);
                        soFee = Float.valueOf(soFee.floatValue() + noOrderFee.floatValue());
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u6700\u7ec8\u8ba1\u8d39\u7ed3\u679c:{}", (Object)soFee);
                    } else {
                        LocalDateTime nextDateTime = currentStart.plusDays(1L);
                        String nextDateTimeFormat = nextDateTime.format(DATE_TIME_FORMATTER);
                        log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5, \u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u5f53\u6b21\u4f18\u60e0,\u4e0b\u6b21\u4f7f\u7528\u4f18\u60e0\u5f00\u59cb\u65f6\u95f4: {}", (Object)nextDateTimeFormat);
                        Long nextStartTime = nextDateTime.toEpochSecond(ZoneOffset.of("+8"));
                        if (endTime <= nextStartTime) {
                            soFee = Float.valueOf(this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(), 0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u5f53\u6b21\u4f18\u60e0,\u5f53\u6b21\u79bb\u573a\u65f6\u95f4: {} \u5728\u4e0b\u6b21\u4f18\u60e0\u65f6\u95f4\u5185:{}, \u6240\u4ee5\u4e0d\u4f18\u60e0,so\u8ba1\u8d39\u4e3a:{}", new Object[]{currentExitDateTimeFormat, nextDateTimeFormat, soFee});
                        } else {
                            Long firstFeeTime = nextStartTime - startTime;
                            Long firstFeeEndTime = startTime + firstFeeTime;
                            useParkTime = useParkTime - firstFeeTime;
                            soFee = Float.valueOf(soFee.floatValue() + this.chargeFee((BaseFeeParamHolder)feeParamHolder, parkId, billId, startTime.intValue(), firstFeeEndTime.intValue(), 0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), false));
                            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u5f53\u6b21\u4f18\u60e0,\u6240\u4ee5\u4e0d\u4f18\u60e0,\u7b2c\u4e00\u6bb5\u8ba1\u8d39\u5f00\u59cb\u65f6\u95f4:{},\u7ed3\u675f\u65f6\u95f4:{},\u505c\u8f66\u65f6\u957f:{}\u79d2,\u5355\u72ec\u7b2c\u4e00\u6bb5\u8c03\u7528so\u8ba1\u8d39\u4e3a:{}", new Object[]{currentStartDateTimeFormat, ComputeFeeHandleChain.convertTimestampToLocalDateTime(firstFeeEndTime).format(DATE_TIME_FORMATTER), firstFeeTime, soFee});
                            Float noOrderFee = this.getNoOrderFee(nextStartTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u5f53\u6b21\u505c\u8f66\u5b58\u5728\u8de8\u5929\u8ba1\u7b97\u4f18\u60e0\u60c5\u51b5,\u4e0a\u6b21\u505c\u8f66\u4f7f\u7528\u4e86\u5f53\u6b21\u4f18\u60e0,\u8c03\u7528so\u8ba1\u8d39\u4e3a:{}", (Object)noOrderFee);
                            soFee = Float.valueOf(soFee.floatValue() + noOrderFee.floatValue());
                            log.info("[\u6d4e\u5357\u65b0\u80fd\u6e90\u8ba1\u8d39]\u6709\u5386\u53f2\u8ba2\u5355,\u6700\u7ec8\u8ba1\u8d39\u7ed3\u679c:{}", (Object)soFee);
                        }
                    }
                }
            }
        }
        return soFee;
    }
}

