/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee.chain;

import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderAuthDao;
import com.icetech.order.domain.entity.OrderAuthInfo;
import com.icetech.park.service.queryfee.QueryFeeChainAbstract;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthFeeHandleChain
extends QueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(AuthFeeHandleChain.class);
    @Autowired
    private OrderAuthDao orderAuthDao;
    private QueryFeeChainAbstract nextChain;

    @Override
    public QueryOrderFeeResponse queryFee(FeeParamHolder feeParamHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = this.queryFeeObject(feeParamHolder);
        if (!feeParamHolder.isBreak() && this.nextChain != null) {
            return this.nextChain.queryFee(feeParamHolder);
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(FeeParamHolder feeParamHolder) {
        OrderAuthInfo orderAuthInfo;
        BigDecimal surplusfee = feeParamHolder.getSurplusfee();
        QueryOrderFeeResponse queryOrderFeeResponse = feeParamHolder.getQueryOrderFeeResponse();
        String unpayPrice = queryOrderFeeResponse.getUnpayPrice();
        float aFloat = Float.parseFloat(unpayPrice);
        boolean isResetStatus = false;
        if (surplusfee != null && aFloat > surplusfee.floatValue()) {
            isResetStatus = true;
            float totalAmountF = NumberUtils.toFloat((String)queryOrderFeeResponse.getTotalAmount());
            queryOrderFeeResponse.setUnpayPrice(String.valueOf(surplusfee));
            queryOrderFeeResponse.setTotalAmount(String.valueOf(totalAmountF - (aFloat - surplusfee.floatValue())));
            log.info("[\u67e5\u8d39-\u4fee\u6539\u8d39\u7528\u6a21\u5757] \u6700\u5927\u6536\u8d39\u903b\u8f91\u5904\u7406\u540e\u5f85\u7f34\u8d39[{}]", (Object)queryOrderFeeResponse.getUnpayPrice());
        }
        if ((orderAuthInfo = this.orderAuthDao.selectByOrderNum(queryOrderFeeResponse.getOrderNum(), Integer.valueOf(1))) != null && orderAuthInfo.getAuthStatus().equals(1)) {
            isResetStatus = true;
            log.info("[\u67e5\u8d39-\u4fee\u6539\u8d39\u7528\u6a21\u5757]\u8ba2\u5355\u53f7[{}]\u6709\u6388\u6743\u8fc7\u4fee\u6539\u91d1\u989d, before[{}], after[{}]", new Object[]{queryOrderFeeResponse.getOrderNum(), queryOrderFeeResponse.getUnpayPrice(), orderAuthInfo.getUpPrice()});
            float upPrice = NumberUtils.toFloat((String)orderAuthInfo.getUpPrice());
            float totalAmount = NumberUtils.toFloat((String)queryOrderFeeResponse.getTotalAmount());
            queryOrderFeeResponse.setTotalAmount(String.valueOf(totalAmount - (aFloat - upPrice)));
            queryOrderFeeResponse.setUnpayPrice(orderAuthInfo.getUpPrice());
        }
        if (isResetStatus) {
            Float totalAmount = Float.valueOf(NumberUtils.toFloat((String)queryOrderFeeResponse.getTotalAmount()));
            Float paidAmount = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getPaidAmount()));
            Float discountAmount = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getDiscountAmount()));
            Float unPayPrice = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getUnpayPrice()));
            Float discountPrice = Float.valueOf(Float.parseFloat(queryOrderFeeResponse.getDiscountPrice()));
            Integer status = this.getFeeStatus(paidAmount, unPayPrice, discountPrice, discountAmount, totalAmount);
            queryOrderFeeResponse.setStatus(status);
        }
        return queryOrderFeeResponse;
    }
}

