/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee;

import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.dao.park.RegionChargeconfigDao;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.basics.service.other.NotWorkDayService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.monthcar.MonthPlateDao;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRegionDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRegion;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.dao.OrderTagsDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.park.service.monthcar.MonthCarServiceBase;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.queryfee.MonthFeeDto;
import com.icetech.park.service.queryfee.MonthTypeDto;
import com.icetech.park.service.queryfee.MonthTypeEnum;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class MonthFeeHandle {
    private static final Logger log = LoggerFactory.getLogger(MonthFeeHandle.class);
    @Autowired
    private MonthCarServiceImpl monthCarService;
    @Autowired
    private MonthProductDao monthProductDao;
    @Resource
    private MonthPlateDao monthPlateDao;
    @Autowired
    private OrderTagsDao orderTagsDao;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private MonthRegionDao monthRegionDao;
    @Autowired
    private NotWorkDayService notWorkDayService;
    @Autowired
    private RegionChargeconfigDao regionChargeconfigDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Value(value="${monthcard.expire.days:999}")
    private Integer monthCardExpireDays;
    private static final Integer TIMEOUT_CARD = 4;
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.of("+8"));

    public MonthFeeDto getMonthFeeParamOutArea(BaseFeeParamHolder feeParamHolder, Long parkId, OrderInfo orderInfo, long startTime, long endTime, ParkConfig parkConfig, OrderSonInfo innerOrderSonInfo) {
        Long regionId = orderInfo.getRegionId();
        MonthFeeDto monthFeeDto = null;
        MonthTypeDto monthTypeDto = this.getMonthTypeDto(parkId, orderInfo, startTime, endTime, parkConfig, regionId, 2);
        if (monthTypeDto.getMonthTypeEnum() != null) {
            log.info("\u6708\u5361\u5224\u65ad\u7ed3\u679c[{}]", (Object)monthTypeDto);
            feeParamHolder.setMonthCarFee(true);
            MonthInfo monthInfoRet = monthTypeDto.getCurrMonthInfo() != null ? monthTypeDto.getCurrMonthInfo() : monthTypeDto.getTimedOutMonthInfo();
            monthFeeDto = this.noDiffWorkday(feeParamHolder, orderInfo, parkConfig, startTime, endTime, monthTypeDto, monthInfoRet, 1);
        }
        return null;
    }

    public MonthFeeDto getMonthFeeParam(BaseFeeParamHolder feeParamHolder, Long parkId, OrderInfo orderInfo, long startTime, long endTime, ParkConfig parkConfig, int multipleAreaType) {
        Long regionId = orderInfo.getRegionId();
        MonthTypeDto monthTypeDto = this.getMonthTypeDto(parkId, orderInfo, startTime, endTime, parkConfig, regionId, multipleAreaType);
        if (monthTypeDto.getMonthTypeEnum() != null) {
            MonthInfo monthInfoRet;
            log.info("\u6708\u5361\u5224\u65ad\u7ed3\u679c[{}]", (Object)monthTypeDto);
            feeParamHolder.setMonthCarFee(true);
            MonthInfo monthInfo = monthInfoRet = monthTypeDto.getCurrMonthInfo() != null ? monthTypeDto.getCurrMonthInfo() : monthTypeDto.getTimedOutMonthInfo();
            if (Integer.valueOf(1).equals(monthTypeDto.getDiffWorkday())) {
                OrderSonInfo innerOrderSonInfo = feeParamHolder.getInnerOrderSonInfo();
                if (Integer.valueOf(1).equals(multipleAreaType) && innerOrderSonInfo != null && innerOrderSonInfo.getEnterTime() != null && innerOrderSonInfo.getExitTime() != null && !innerOrderSonInfo.getEnterTime().equals(innerOrderSonInfo.getExitTime())) {
                    return this.outAreaDiffWorkday(feeParamHolder, orderInfo, parkConfig, startTime, endTime, monthTypeDto, monthInfoRet);
                }
                return this.diffWorkday(feeParamHolder, orderInfo, parkConfig, startTime, endTime, monthTypeDto, monthInfoRet);
            }
            return this.noDiffWorkday(feeParamHolder, orderInfo, parkConfig, startTime, endTime, monthTypeDto, monthInfoRet, multipleAreaType);
        }
        return null;
    }

    private MonthFeeDto noDiffWorkday(BaseFeeParamHolder feeParamHolder, OrderInfo orderInfo, ParkConfig parkConfig, long startTime, long endTime, MonthTypeDto monthTypeDto, MonthInfo monthInfoRet, int multipleAreaType) {
        ArrayList<BaseFeeParamHolder.ExtraComputeFeePara> currFeeParaList = new ArrayList<BaseFeeParamHolder.ExtraComputeFeePara>();
        Long csSwitchTime = null;
        boolean isCsMonthCarFee = false;
        int csFeeType = 0;
        String csStartTime = null;
        String csEndTime = null;
        long newStartTime = startTime;
        long newEndTime = endTime;
        switch (monthTypeDto.getMonthTypeEnum()) {
            case FULL_MONTH: {
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                    }
                    if (orderInfo.getSwitchTime() == null) break;
                    newEndTime = orderInfo.getSwitchTime();
                    break;
                }
                MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                if (monthProduct == null) {
                    monthProduct = monthTypeDto.getTimedOutMonthProduct();
                }
                if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                    isCsMonthCarFee = true;
                    csStartTime = monthProduct.getStartTime().toString();
                    csEndTime = monthProduct.getEndTime().toString();
                    break;
                }
                if (orderInfo.getSwitchTime() == null) break;
                isCsMonthCarFee = true;
                csStartTime = monthProduct.getStartTime().toString();
                csEndTime = monthProduct.getEndTime().toString();
                csSwitchTime = orderInfo.getSwitchTime();
                csFeeType = 2;
                break;
            }
            case IN_PARK_START: {
                MonthInfo monthInfo = monthTypeDto.getCurrMonthInfo();
                int inParkRenewType = NumberUtils.toPrimitive((Integer)parkConfig.getInparkRenewType(), (int)1);
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        if (inParkRenewType == 1) {
                            newEndTime = monthInfo.getStartTime().getTime() / 1000L;
                            break;
                        }
                        log.info("\u573a\u5185\u529e\u6708\u5361\uff0c\u4e34\u65f6\u8f66\u90e8\u5206\u4e0d\u6536\u8d39\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)orderInfo.getPlateNum());
                        return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                    }
                    if (orderInfo.getSwitchTime() == null) break;
                    newEndTime = orderInfo.getSwitchTime();
                    break;
                }
                MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                    if (inParkRenewType == 1) {
                        isCsMonthCarFee = true;
                        csStartTime = monthProduct.getStartTime().toString();
                        csEndTime = monthProduct.getEndTime().toString();
                        csSwitchTime = monthInfo.getStartTime().getTime() / 1000L;
                        csFeeType = 2;
                        break;
                    }
                    isCsMonthCarFee = true;
                    csStartTime = monthProduct.getStartTime().toString();
                    csEndTime = monthProduct.getEndTime().toString();
                    break;
                }
                if (orderInfo.getSwitchTime() == null) break;
                isCsMonthCarFee = true;
                csStartTime = monthProduct.getStartTime().toString();
                csEndTime = monthProduct.getEndTime().toString();
                csSwitchTime = orderInfo.getSwitchTime();
                csFeeType = 2;
                break;
            }
            case TEMP_MIDDLE: {
                MonthInfo currMonthInfo = monthTypeDto.getCurrMonthInfo();
                MonthInfo timeoutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                int timeoutRenewType = NumberUtils.toPrimitive((Integer)parkConfig.getTimeoutRenewType(), (int)1);
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        if (timeoutRenewType == 1) {
                            newStartTime = this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L;
                            newEndTime = currMonthInfo.getStartTime().getTime() / 1000L;
                            break;
                        }
                        log.info("\u573a\u5185\u8fc7\u671f\u540e\u518d\u7eed\u8d39\uff0c\u4e2d\u95f4\u6709\u4e34\u65f6\u8f66\u7a7a\u6863\u671f\u4e0d\u6536\u8d39\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)orderInfo.getPlateNum());
                        return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                    }
                    if (orderInfo.getSwitchTime() == null) break;
                    newEndTime = orderInfo.getSwitchTime();
                    break;
                }
                MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                    if (timeoutRenewType == 1) {
                        isCsMonthCarFee = true;
                        csStartTime = monthProduct.getStartTime().toString();
                        csEndTime = monthProduct.getEndTime().toString();
                        long newStartTime2 = this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L;
                        BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(startTime)).endTime(Long.valueOf(newStartTime2)).isCsMonthCarFee(true).csStartTime(monthProduct.getStartTime().toString()).csEndTime(monthProduct.getEndTime().toString()).build();
                        currFeeParaList.add(feePara);
                        BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(newStartTime2)).endTime(Long.valueOf(endTime)).isCsMonthCarFee(true).csStartTime(monthProduct.getStartTime().toString()).csEndTime(monthProduct.getEndTime().toString()).csSwitchTime(Long.valueOf(currMonthInfo.getStartTime().getTime() / 1000L)).csFeeType(2).build();
                        currFeeParaList.add(feePara2);
                        break;
                    }
                    isCsMonthCarFee = true;
                    csStartTime = monthProduct.getStartTime().toString();
                    csEndTime = monthProduct.getEndTime().toString();
                    break;
                }
                if (orderInfo.getSwitchTime() == null) break;
                isCsMonthCarFee = true;
                csStartTime = monthProduct.getStartTime().toString();
                csEndTime = monthProduct.getEndTime().toString();
                csSwitchTime = orderInfo.getSwitchTime();
                csFeeType = 2;
                break;
            }
            case TIMEOUT_IN_PARK: {
                MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        newStartTime = this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L;
                        break;
                    }
                    if (orderInfo.getSwitchTime() == null) break;
                    newEndTime = orderInfo.getSwitchTime();
                    break;
                }
                MonthProduct monthProduct = monthTypeDto.getTimedOutMonthProduct();
                if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                    isCsMonthCarFee = true;
                    csStartTime = monthProduct.getStartTime().toString();
                    csEndTime = monthProduct.getEndTime().toString();
                    csSwitchTime = this.completeConvert(timedOutMonthInfo.getEndTime());
                    csFeeType = 1;
                    break;
                }
                if (orderInfo.getSwitchTime() == null) break;
                isCsMonthCarFee = true;
                csStartTime = monthProduct.getStartTime().toString();
                csEndTime = monthProduct.getEndTime().toString();
                long newEndTime2 = this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L;
                BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().isCsMonthCarFee(true).startTime(Long.valueOf(startTime)).endTime(Long.valueOf(newEndTime2)).csStartTime(monthProduct.getStartTime().toString()).csEndTime(monthProduct.getEndTime().toString()).csSwitchTime(orderInfo.getSwitchTime()).csFeeType(2).build();
                currFeeParaList.add(feePara);
                BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(newEndTime2)).endTime(Long.valueOf(endTime)).build();
                currFeeParaList.add(feePara2);
                break;
            }
            case MONTH_MIDDLE: {
                MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                long newStartTime2 = this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L;
                long newEndTime2 = timedOutMonthInfo.getStartTime().getTime() / 1000L;
                int inParkRenewType = NumberUtils.toPrimitive((Integer)parkConfig.getInparkRenewType(), (int)1);
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    BaseFeeParamHolder.ExtraComputeFeePara feePara;
                    if (monthTypeDto.isAbCard() && monthTypeDto.getAbCarType() == 2 && orderInfo.getSwitchTime() != null) {
                        if (inParkRenewType == 1) {
                            feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(startTime)).endTime(orderInfo.getSwitchTime()).build();
                            currFeeParaList.add(feePara);
                            log.info("\u8ba1\u8d39\u4ece\u5165\u573a\u5230AB\u8f66\u5207\u6362\u65f6\u95f4\u7684\u65f6\u95f4\u6bb5, {}, {}", (Object)startTime, (Object)newEndTime2);
                        } else {
                            feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(newEndTime2)).endTime(orderInfo.getSwitchTime()).build();
                            currFeeParaList.add(feePara);
                            log.info("\u8ba1\u8d39\u4ece\u6708\u5361\u751f\u6548\u65f6\u95f4\u5230AB\u8f66\u5207\u6362\u65f6\u95f4\u7684\u65f6\u95f4\u6bb5, {}, {}", (Object)startTime, (Object)newEndTime2);
                        }
                    } else if (inParkRenewType == 1) {
                        feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(startTime)).endTime(Long.valueOf(newEndTime2)).build();
                        currFeeParaList.add(feePara);
                        log.info("\u8ba1\u8d39\u4ece\u5165\u573a\u5230\u6708\u5361\u751f\u6548\u65f6\u95f4\u7684\u65f6\u95f4\u6bb5, {}, {}", (Object)startTime, (Object)newEndTime2);
                    }
                } else {
                    MonthProduct monthProduct = monthTypeDto.getTimedOutMonthProduct();
                    newStartTime = inParkRenewType == 2 ? newEndTime2 : startTime;
                    if (monthTypeDto.isAbCard() && monthTypeDto.getAbCarType() == 2 && orderInfo.getSwitchTime() != null) {
                        long switchTime = orderInfo.getSwitchTime();
                        BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().isCsMonthCarFee(true).startTime(Long.valueOf(newStartTime)).endTime(Long.valueOf(newStartTime2)).csStartTime(monthProduct.getStartTime().toString()).csEndTime(monthProduct.getEndTime().toString()).csSwitchTime(Long.valueOf(switchTime)).csFeeType(2).build();
                        currFeeParaList.add(feePara);
                        log.info("\u8ba1\u8d39\u4ece\u5165\u573a\u5230\u9519\u65f6\u6708\u5361AB\u8f66\u5207\u6362\u65f6\u95f4\u7684\u65f6\u95f4\u6bb5, {}, {}, {}", new Object[]{newStartTime, newStartTime2, switchTime});
                    } else if (inParkRenewType == 1) {
                        BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().isCsMonthCarFee(true).startTime(Long.valueOf(startTime)).endTime(Long.valueOf(newStartTime2)).csStartTime(monthProduct.getStartTime().toString()).csEndTime(monthProduct.getEndTime().toString()).csSwitchTime(Long.valueOf(newEndTime2)).csFeeType(2).build();
                        currFeeParaList.add(feePara);
                        log.info("\u8ba1\u8d39\u4ece\u5165\u573a\u5230\u9519\u65f6\u6708\u5361\u7ed3\u675f\u7684\u65f6\u95f4\u6bb5, {}, {}, {}", new Object[]{startTime, newStartTime2, newEndTime2});
                    } else {
                        BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().isCsMonthCarFee(true).startTime(Long.valueOf(startTime)).endTime(Long.valueOf(newStartTime2)).csStartTime(monthProduct.getStartTime().toString()).csEndTime(monthProduct.getEndTime().toString()).build();
                        currFeeParaList.add(feePara);
                        log.info("\u8ba1\u8d39\u4ece\u5165\u573a\u5230\u9519\u65f6\u6708\u5361\u7ed3\u675f\u7684\u65f6\u95f4\u6bb5, {}, {}", (Object)startTime, (Object)newStartTime2);
                    }
                }
                BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(newStartTime2)).endTime(Long.valueOf(endTime)).build();
                currFeeParaList.add(feePara2);
                log.info("\u8ba1\u8d39\u4ece\u6708\u5361\u8fc7\u671f\u5230\u79bb\u573a\u7684\u65f6\u95f4\u6bb5, {}, {}", (Object)newStartTime2, (Object)endTime);
                break;
            }
        }
        Integer billId = this.queryMonthBillId(feeParamHolder.getQueryOrderFeeRequest(), orderInfo, monthTypeDto);
        LinkedHashSet<Integer> billIdList = new LinkedHashSet<Integer>();
        billIdList.add(billId);
        if (billId != null) {
            MonthFeeHandle.splitExtraComputeFeePara(currFeeParaList, billId, csFeeType, newStartTime, csSwitchTime, csStartTime, csEndTime, newEndTime, billIdList);
            log.info("\u5206\u79bb\u6708\u5361\u548c\u4e34\u65f6\u65f6\u6bb5\u540e\u7684\u8ba1\u8d39\u65f6\u95f4\u6bb5\u4e3a[{}]", currFeeParaList);
        }
        feeParamHolder.addAllExtraFeePara(currFeeParaList);
        return MonthFeeDto.builder().isMonthRet(false).newStartTime(newStartTime).newEndTime(newEndTime).csFeeType(csFeeType).isCsMonthCarFee(isCsMonthCarFee).csStartTime(csStartTime).csEndTime(csEndTime).csSwitchTime(csSwitchTime).billIdList(billIdList).monthInfo(monthInfoRet).build();
    }

    private static void splitExtraComputeFeePara(List<BaseFeeParamHolder.ExtraComputeFeePara> currFeeParaList, Integer billId, int csFeeType, Long newStartTime, Long csSwitchTime, String csStartTime, String csEndTime, Long newEndTime, Set<Integer> billIdList) {
        ArrayList<BaseFeeParamHolder.ExtraComputeFeePara> addList = new ArrayList<BaseFeeParamHolder.ExtraComputeFeePara>();
        if (CollectionUtils.isNotEmpty(currFeeParaList)) {
            for (BaseFeeParamHolder.ExtraComputeFeePara extraComputeFeePara : currFeeParaList) {
                BaseFeeParamHolder.ExtraComputeFeePara feeParaTemp;
                Long csSwitchTime1;
                extraComputeFeePara.setBillId(billId);
                if (extraComputeFeePara.getCsFeeType() == 1) {
                    csSwitchTime1 = extraComputeFeePara.getCsSwitchTime();
                    Long endTime = extraComputeFeePara.getEndTime();
                    extraComputeFeePara.setCsFeeType(0);
                    extraComputeFeePara.setCsSwitchTime(null);
                    extraComputeFeePara.setEndTime(csSwitchTime1);
                    feeParaTemp = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(csSwitchTime1).endTime(endTime).build();
                    addList.add(feeParaTemp);
                    billIdList.add(null);
                    continue;
                }
                if (extraComputeFeePara.getCsFeeType() != 2) continue;
                csSwitchTime1 = extraComputeFeePara.getCsSwitchTime();
                Long startTime = extraComputeFeePara.getStartTime();
                extraComputeFeePara.setCsFeeType(0);
                extraComputeFeePara.setCsSwitchTime(null);
                extraComputeFeePara.setStartTime(csSwitchTime1);
                feeParaTemp = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(startTime).endTime(csSwitchTime1).build();
                addList.add(feeParaTemp);
                billIdList.add(null);
            }
        } else if (csFeeType == 1) {
            BaseFeeParamHolder.ExtraComputeFeePara feeParaMonth = BaseFeeParamHolder.ExtraComputeFeePara.builder().billId(billId).isCsMonthCarFee(true).startTime(newStartTime).endTime(csSwitchTime).csStartTime(csStartTime).csEndTime(csEndTime).build();
            addList.add(feeParaMonth);
            BaseFeeParamHolder.ExtraComputeFeePara feeParaTemp = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(csSwitchTime).endTime(newEndTime).build();
            addList.add(feeParaTemp);
            billIdList.add(null);
        } else if (csFeeType == 2) {
            BaseFeeParamHolder.ExtraComputeFeePara feeParaMonth = BaseFeeParamHolder.ExtraComputeFeePara.builder().billId(billId).isCsMonthCarFee(true).startTime(csSwitchTime).endTime(newEndTime).csStartTime(csStartTime).csEndTime(csEndTime).build();
            addList.add(feeParaMonth);
            BaseFeeParamHolder.ExtraComputeFeePara feeParaTemp = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(newStartTime).endTime(csSwitchTime).build();
            addList.add(feeParaTemp);
            billIdList.add(null);
        }
        if (!addList.isEmpty()) {
            currFeeParaList.addAll(addList);
        }
    }

    private Integer queryMonthBillId(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, MonthTypeDto monthTypeDto) {
        ParkChargeconfig parkChargeconfig;
        RegionChargeconfig regionChargeConfig;
        int ruleType = 0;
        if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
            MonthInfo timedOutMonthInfo;
            if (MonthTypeEnum.IN_PARK_START.equals((Object)monthTypeDto.getMonthTypeEnum())) {
                return null;
            }
            if (MonthTypeEnum.TIMEOUT.equals((Object)monthTypeDto.getMonthTypeEnum()) && (timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo()) != null && DateTools.differentDays((Date)timedOutMonthInfo.getEndTime(), (Date)new Date()) >= this.monthCardExpireDays) {
                return null;
            }
            ruleType = 5;
        } else {
            if (MonthTypeEnum.TIMEOUT.equals((Object)monthTypeDto.getMonthTypeEnum())) {
                return null;
            }
            ruleType = 8;
        }
        Long regionId = orderInfo.getRegionId();
        if (regionId == null) {
            if (queryOrderFeeRequest.getChannelId() != null) {
                ParkInoutdevice parkInoutdevice = (ParkInoutdevice)this.parkService.getInoutDeviceByCode(queryOrderFeeRequest.getChannelId()).getData();
                if (parkInoutdevice == null) {
                    throw new ResponseBodyException("3001", "\u65e0\u6548\u7684\u901a\u9053\u7f16\u53f7");
                }
                regionId = parkInoutdevice.getRegionId() == null ? null : parkInoutdevice.getRegionId();
            } else {
                ParkRegion parkRegion = this.parkRegionDao.selectOutByParkid(orderInfo.getParkId());
                Long l = regionId = parkRegion == null ? null : parkRegion.getId();
            }
        }
        if ((regionChargeConfig = this.regionChargeconfigDao.getRegionChargeconfig(orderInfo.getParkId(), regionId, Integer.valueOf(ruleType))) != null && Integer.valueOf(1).equals(regionChargeConfig.getEnabled()) && (parkChargeconfig = this.parkChargeconfigDao.selectByParkIdAndBillCode(orderInfo.getParkId(), regionChargeConfig.getBilltypecode())) != null) {
            log.info("\u4f7f\u7528\u6708\u5361\u8f66\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderInfo.getOrderNum(), (Object)parkChargeconfig);
            return parkChargeconfig.getId();
        }
        return null;
    }

    private MonthFeeDto diffWorkday(BaseFeeParamHolder feeParamHolder, OrderInfo orderInfo, ParkConfig parkConfig, long startTime, long endTime, MonthTypeDto monthTypeDto, MonthInfo monthInfoRet) {
        Long switchTime;
        Long csSwitchTime = null;
        boolean isCsMonthCarFee = false;
        int csFeeType = 0;
        String csStartTime = null;
        String csEndTime = null;
        Long newStartTime = null;
        Long newEndTime = null;
        long firstPartStart = startTime;
        Long l = switchTime = monthTypeDto.isAbCard() && monthTypeDto.getAbCarType() == 2 ? orderInfo.getSwitchTime() : null;
        if (switchTime != null && (switchTime <= startTime || switchTime >= endTime)) {
            switchTime = null;
        }
        long beforeSwitchParkTime = 0L;
        switch (monthTypeDto.getMonthTypeEnum()) {
            case FULL_MONTH: {
                boolean isMonth;
                boolean otherFee = false;
                if (switchTime != null) {
                    firstPartStart = switchTime;
                    BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(startTime)).endTime(switchTime).build();
                    feeParamHolder.addExtraFeePara(feePara);
                    otherFee = true;
                }
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    ParkTimeDetail parkTimeDetail = this.getParkTimeDetail(firstPartStart, endTime);
                    int parkTimeType = parkTimeDetail.getType();
                    if (parkTimeType == 1 || NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) == 1) {
                        if (otherFee) break;
                        return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                    }
                    if (parkTimeType != 2 && parkTimeType != 3 || NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) != 2) break;
                    BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail.getNotWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime())).build();
                    feeParamHolder.addExtraFeePara(feePara2);
                    break;
                }
                MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                if (monthProduct == null) {
                    monthProduct = monthTypeDto.getTimedOutMonthProduct();
                }
                if (!(isMonth = this.addCsWorkDayAndNotFeePara(feeParamHolder, firstPartStart, endTime, monthTypeDto, monthProduct)) || otherFee) break;
                return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
            }
            case IN_PARK_START: {
                boolean otherFee = false;
                MonthInfo monthInfo = monthTypeDto.getCurrMonthInfo();
                int inParkRenewType = NumberUtils.toPrimitive((Integer)parkConfig.getInparkRenewType(), (int)1);
                if (switchTime == null && inParkRenewType == 2 && Integer.valueOf(1).equals(monthTypeDto.getCardType()) && NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) == 1) {
                    return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                }
                if (inParkRenewType == 1) {
                    firstPartStart = monthInfo.getStartTime().getTime() / 1000L;
                    if (switchTime != null) {
                        firstPartStart = switchTime;
                        beforeSwitchParkTime = switchTime - monthInfo.getStartTime().getTime() / 1000L;
                    }
                    BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(startTime)).endTime(Long.valueOf(monthInfo.getStartTime().getTime() / 1000L + beforeSwitchParkTime)).build();
                    feeParamHolder.addExtraFeePara(feePara);
                    otherFee = true;
                }
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    ParkTimeDetail parkTimeDetail = this.getParkTimeDetail(firstPartStart, endTime);
                    if (parkTimeDetail.getType() == 1 || NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) == 1) {
                        if (otherFee) break;
                        return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                    }
                    BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail.getNotWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime())).build();
                    feeParamHolder.addExtraFeePara(feePara);
                    break;
                }
                MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                boolean isMonth = this.addCsWorkDayAndNotFeePara(feeParamHolder, firstPartStart, endTime, monthTypeDto, monthProduct);
                if (!isMonth || otherFee) break;
                return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
            }
            case TEMP_MIDDLE: {
                MonthInfo currMonthInfo = monthTypeDto.getCurrMonthInfo();
                MonthInfo timeoutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                int timeoutRenewType = NumberUtils.toPrimitive((Integer)parkConfig.getTimeoutRenewType(), (int)1);
                long secondPartStart = currMonthInfo.getStartTime().getTime() / 1000L;
                if (switchTime != null) {
                    if (switchTime < timeoutMonthInfo.getEndTime().getTime() / 1000L) {
                        firstPartStart = switchTime;
                        beforeSwitchParkTime = switchTime - startTime;
                    } else if (switchTime > currMonthInfo.getStartTime().getTime() / 1000L) {
                        secondPartStart = switchTime;
                        beforeSwitchParkTime = switchTime - currMonthInfo.getStartTime().getTime() / 1000L;
                    }
                }
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    if (timeoutRenewType == 1) {
                        ParkTimeDetail parkTimeDetail;
                        MonthProduct timedOutMonthProduct = monthTypeDto.getTimedOutMonthProduct();
                        if (NumberUtils.toPrimitive((Integer)timedOutMonthProduct.getDiffWorkday()) == 1 && ((parkTimeDetail = this.getParkTimeDetail(firstPartStart, this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L)).getType() == 2 || parkTimeDetail.getType() == 3) && NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) == 2) {
                            BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail.getNotWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime())).build();
                            feeParamHolder.addExtraFeePara(feePara2);
                        }
                        BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L)).endTime(Long.valueOf(currMonthInfo.getStartTime().getTime() / 1000L + beforeSwitchParkTime)).build();
                        feeParamHolder.addExtraFeePara(feePara);
                        ParkTimeDetail parkTimeDetail2 = this.getParkTimeDetail(secondPartStart, endTime);
                        if (parkTimeDetail2.getType() != 2 && parkTimeDetail2.getType() != 3 || NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) != 2) break;
                        BaseFeeParamHolder.ExtraComputeFeePara feePara3 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail2.getNotWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail2.getNotWorkDayStartTime() + parkTimeDetail2.getNotWorkDayParkTime())).build();
                        feeParamHolder.addExtraFeePara(feePara3);
                        break;
                    }
                    ParkTimeDetail parkTimeDetail = this.getParkTimeDetail(startTime, endTime);
                    if (parkTimeDetail.getType() == 1 || NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) == 1) {
                        log.info("\u573a\u5185\u8fc7\u671f\u540e\u518d\u7eed\u8d39\uff0c\u4e2d\u95f4\u6709\u4e34\u65f6\u8f66\u7a7a\u6863\u671f\u4e0d\u6536\u8d39\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)orderInfo.getPlateNum());
                        return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                    }
                    BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail.getNotWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime())).build();
                    feeParamHolder.addExtraFeePara(feePara2);
                    break;
                }
                MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                MonthProduct timedOutMonthProduct = monthTypeDto.getTimedOutMonthProduct();
                if (timeoutRenewType == 1) {
                    if (NumberUtils.toPrimitive((Integer)timedOutMonthProduct.getDiffWorkday()) == 1) {
                        this.addCsWorkDayAndNotFeePara(feeParamHolder, firstPartStart, this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L, monthTypeDto, timedOutMonthProduct);
                    }
                    BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L)).endTime(Long.valueOf(currMonthInfo.getStartTime().getTime() / 1000L + beforeSwitchParkTime)).build();
                    feeParamHolder.addExtraFeePara(feePara2);
                    this.addCsWorkDayAndNotFeePara(feeParamHolder, secondPartStart, endTime, monthTypeDto, timedOutMonthProduct);
                    break;
                }
                boolean isMonth = this.addCsWorkDayAndNotFeePara(feeParamHolder, startTime, endTime, monthTypeDto, monthProduct);
                if (!isMonth) break;
                return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
            }
            case TIMEOUT_IN_PARK: {
                MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                long beforeSwitchParkTime2 = 0L;
                if (switchTime != null) {
                    firstPartStart = switchTime;
                    beforeSwitchParkTime2 = switchTime - startTime;
                }
                BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L)).endTime(Long.valueOf(endTime + beforeSwitchParkTime2)).build();
                feeParamHolder.addExtraFeePara(feePara);
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    ParkTimeDetail parkTimeDetail = this.getParkTimeDetail(firstPartStart, this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L);
                    if (parkTimeDetail.getType() != 2 && parkTimeDetail.getType() != 3 || NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) != 2) break;
                    BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail.getNotWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime())).build();
                    feeParamHolder.addExtraFeePara(feePara2);
                    break;
                }
                MonthProduct monthProduct = monthTypeDto.getTimedOutMonthProduct();
                this.addCsWorkDayAndNotFeePara(feeParamHolder, firstPartStart, this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L, monthTypeDto, monthProduct);
                break;
            }
            case MONTH_MIDDLE: {
                MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                int inParkRenewType = NumberUtils.toPrimitive((Integer)parkConfig.getInparkRenewType(), (int)1);
                long newStartTime2 = this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L;
                long newEndTime2 = timedOutMonthInfo.getStartTime().getTime() / 1000L;
                long beforeTempParkTime = newEndTime2 - startTime;
                if (inParkRenewType == 2) {
                    beforeTempParkTime = 0L;
                }
                if (monthTypeDto.isAbCard() && monthTypeDto.getAbCarType() == 2 && switchTime != null) {
                    firstPartStart = switchTime;
                    beforeTempParkTime = inParkRenewType == 2 ? switchTime - newEndTime2 : switchTime - startTime;
                }
                BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(newStartTime2)).endTime(Long.valueOf(endTime + beforeTempParkTime)).build();
                feeParamHolder.addExtraFeePara(feePara);
                log.info("\u8ba1\u8d39\u4ece\u6708\u5361\u8fc7\u671f\u5230\u79bb\u573a(+\u524d\u9762\u4e34\u65f6\u8f66\u90e8\u5206)\u7684\u65f6\u95f4\u6bb5, {}, {}, {}", new Object[]{newStartTime2, endTime, beforeTempParkTime});
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    ParkTimeDetail parkTimeDetail = this.getParkTimeDetail(firstPartStart, newStartTime2);
                    if (parkTimeDetail.getType() != 2 && parkTimeDetail.getType() != 3 || NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) != 2) break;
                    BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail.getNotWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime())).build();
                    feeParamHolder.addExtraFeePara(feePara2);
                    break;
                }
                MonthProduct monthProduct = monthTypeDto.getTimedOutMonthProduct();
                this.addCsWorkDayAndNotFeePara(feeParamHolder, firstPartStart, newStartTime2, monthTypeDto, monthProduct);
                break;
            }
        }
        return MonthFeeDto.builder().isMonthRet(false).newStartTime(newStartTime).newEndTime(newEndTime).csFeeType(csFeeType).isCsMonthCarFee(isCsMonthCarFee).csStartTime(csStartTime).csEndTime(csEndTime).csSwitchTime(csSwitchTime).monthInfo(monthInfoRet).build();
    }

    /*
     * Enabled aggressive block sorting
     */
    private MonthFeeDto outAreaDiffWorkday(BaseFeeParamHolder feeParamHolder, OrderInfo orderInfo, ParkConfig parkConfig, long startTime, long endTime, MonthTypeDto monthTypeDto, MonthInfo monthInfoRet) {
        ParkTimeCompose monthCarParkTime8;
        Long csSwitchTime = null;
        boolean isCsMonthCarFee = false;
        int csFeeType = 0;
        String csStartTime = null;
        String csEndTime = null;
        Long newStartTime = null;
        Long newEndTime = null;
        Long switchTime = monthTypeDto.isAbCard() && monthTypeDto.getAbCarType() == 2 ? orderInfo.getSwitchTime() : null;
        OrderSonInfo innerOrderSonInfo = feeParamHolder.getInnerOrderSonInfo();
        Long innerAreaEnterTime = innerOrderSonInfo.getEnterTime();
        Long innerAreaExitTime = innerOrderSonInfo.getExitTime();
        ArrayList<ParkTimeCompose> list = new ArrayList<ParkTimeCompose>();
        if (switchTime == null) {
            switch (monthTypeDto.getMonthTypeEnum()) {
                case FULL_MONTH: {
                    this.twoPartMonthCar(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
                    break;
                }
                case IN_PARK_START: {
                    MonthInfo monthInfo = monthTypeDto.getCurrMonthInfo();
                    int inParkRenewType = NumberUtils.toPrimitive((Integer)parkConfig.getInparkRenewType(), (int)1);
                    if (inParkRenewType == 1) {
                        this.handleParkTimeComposeWithSwitchTime(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, monthInfo.getStartTime().getTime() / 1000L, list);
                        break;
                    }
                    this.twoPartMonthCar(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
                    break;
                }
                case TEMP_MIDDLE: {
                    ParkTimeCompose monthCarParkTime82;
                    MonthInfo currMonthInfo = monthTypeDto.getCurrMonthInfo();
                    MonthInfo timeoutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                    int timeoutRenewType = NumberUtils.toPrimitive((Integer)parkConfig.getTimeoutRenewType(), (int)1);
                    long secondPartStart = currMonthInfo.getStartTime().getTime() / 1000L;
                    if (timeoutRenewType == 1) {
                        ParkTimeCompose monthCarParkTime9;
                        ParkTimeCompose monthCarParkTime7;
                        ParkTimeCompose monthCarParkTime6;
                        ParkTimeCompose monthCarParkTime5;
                        if (currMonthInfo.getStartTime().getTime() / 1000L < innerAreaEnterTime) {
                            monthCarParkTime5 = ParkTimeCompose.builder().startTime(startTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                            list.add(monthCarParkTime5);
                            monthCarParkTime6 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(currMonthInfo.getStartTime().getTime() / 1000L).type(1).build();
                            list.add(monthCarParkTime6);
                            monthCarParkTime7 = ParkTimeCompose.builder().startTime(currMonthInfo.getStartTime().getTime() / 1000L).endTime(innerAreaEnterTime).type(2).build();
                            list.add(monthCarParkTime7);
                            monthCarParkTime82 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
                            list.add(monthCarParkTime82);
                        }
                        if (secondPartStart > innerAreaEnterTime && secondPartStart < innerAreaExitTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L > innerAreaEnterTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L < innerAreaExitTime) {
                            this.twoPartMonthCar(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
                        }
                        if (secondPartStart > innerAreaExitTime && secondPartStart < endTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L > innerAreaExitTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L < endTime) {
                            monthCarParkTime5 = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(2).build();
                            list.add(monthCarParkTime5);
                            monthCarParkTime6 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                            list.add(monthCarParkTime6);
                            monthCarParkTime7 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(secondPartStart).type(1).build();
                            list.add(monthCarParkTime7);
                            monthCarParkTime82 = ParkTimeCompose.builder().startTime(secondPartStart).endTime(endTime).type(2).build();
                            list.add(monthCarParkTime82);
                        }
                        if (secondPartStart > innerAreaEnterTime && secondPartStart < innerAreaExitTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L < innerAreaEnterTime) {
                            monthCarParkTime5 = ParkTimeCompose.builder().startTime(startTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                            list.add(monthCarParkTime5);
                            monthCarParkTime6 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(innerAreaEnterTime).type(1).build();
                            list.add(monthCarParkTime6);
                            monthCarParkTime8 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
                            list.add(monthCarParkTime8);
                        }
                        if (secondPartStart > innerAreaExitTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L < innerAreaEnterTime) {
                            monthCarParkTime5 = ParkTimeCompose.builder().startTime(startTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                            list.add(monthCarParkTime5);
                            monthCarParkTime6 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(innerAreaEnterTime).type(1).build();
                            list.add(monthCarParkTime6);
                            monthCarParkTime8 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(secondPartStart).type(1).build();
                            list.add(monthCarParkTime8);
                            monthCarParkTime9 = ParkTimeCompose.builder().startTime(secondPartStart).endTime(endTime).type(2).build();
                            list.add(monthCarParkTime9);
                        }
                        if (secondPartStart <= innerAreaExitTime || this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L >= innerAreaEnterTime) break;
                        monthCarParkTime5 = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(2).build();
                        list.add(monthCarParkTime5);
                        monthCarParkTime6 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                        list.add(monthCarParkTime6);
                        monthCarParkTime8 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(secondPartStart).type(1).build();
                        list.add(monthCarParkTime8);
                        monthCarParkTime9 = ParkTimeCompose.builder().startTime(secondPartStart).endTime(endTime).type(2).build();
                        list.add(monthCarParkTime9);
                        break;
                    }
                    this.twoPartMonthCar(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
                    break;
                }
                case TIMEOUT_IN_PARK: {
                    ParkTimeCompose monthCarParkTime6;
                    ParkTimeCompose monthCarParkTime5;
                    ParkTimeCompose monthCarParkTime82;
                    MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                    if (this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L < innerAreaEnterTime) {
                        monthCarParkTime5 = ParkTimeCompose.builder().startTime(startTime).endTime(this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L).type(2).build();
                        list.add(monthCarParkTime5);
                        monthCarParkTime6 = ParkTimeCompose.builder().startTime(this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L).endTime(innerAreaEnterTime).type(1).build();
                        list.add(monthCarParkTime6);
                        monthCarParkTime82 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(1).build();
                        list.add(monthCarParkTime82);
                    }
                    if (this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L > innerAreaEnterTime && this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L < innerAreaExitTime) {
                        monthCarParkTime5 = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(2).build();
                        list.add(monthCarParkTime5);
                        monthCarParkTime8 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(1).build();
                        list.add(monthCarParkTime8);
                    }
                    if (this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L <= innerAreaExitTime || this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L >= endTime) break;
                    monthCarParkTime5 = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(2).build();
                    list.add(monthCarParkTime5);
                    monthCarParkTime6 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L).type(2).build();
                    list.add(monthCarParkTime6);
                    ParkTimeCompose monthCarParkTime7 = ParkTimeCompose.builder().startTime(this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L).endTime(endTime).type(1).build();
                    list.add(monthCarParkTime7);
                    break;
                }
            }
        } else {
            switch (monthTypeDto.getMonthTypeEnum()) {
                case FULL_MONTH: 
                case IN_PARK_START: {
                    this.handleParkTimeComposeWithSwitchTime(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, switchTime, list);
                    break;
                }
                case TEMP_MIDDLE: {
                    MonthInfo currMonthInfo = monthTypeDto.getCurrMonthInfo();
                    MonthInfo timeoutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                    int timeoutRenewType = NumberUtils.toPrimitive((Integer)parkConfig.getTimeoutRenewType(), (int)1);
                    long secondPartStart = currMonthInfo.getStartTime().getTime() / 1000L;
                    if (timeoutRenewType == 1) {
                        ParkTimeCompose parkTimeCompose5;
                        ParkTimeCompose parkTimeCompose4;
                        ParkTimeCompose parkTimeCompose3;
                        ParkTimeCompose parkTimeCompose32;
                        ParkTimeCompose parkTimeCompose2;
                        ParkTimeCompose parkTimeCompose;
                        if (currMonthInfo.getStartTime().getTime() / 1000L < innerAreaEnterTime) {
                            ParkTimeCompose monthCarParkTime5;
                            if (switchTime < this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L) {
                                monthCarParkTime5 = ParkTimeCompose.builder().startTime(startTime).endTime(switchTime).type(1).build();
                                list.add(monthCarParkTime5);
                                ParkTimeCompose monthCarParkTime6 = ParkTimeCompose.builder().startTime(switchTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                                list.add(monthCarParkTime6);
                                ParkTimeCompose monthCarParkTime0 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(currMonthInfo.getStartTime().getTime() / 1000L).type(1).build();
                                list.add(monthCarParkTime0);
                                ParkTimeCompose monthCarParkTime7 = ParkTimeCompose.builder().startTime(currMonthInfo.getStartTime().getTime() / 1000L).endTime(innerAreaEnterTime).type(2).build();
                                list.add(monthCarParkTime7);
                                monthCarParkTime8 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
                                list.add(monthCarParkTime8);
                            } else {
                                ParkTimeCompose monthCarParkTime83;
                                ParkTimeCompose monthCarParkTime7;
                                monthCarParkTime5 = ParkTimeCompose.builder().startTime(startTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                                list.add(monthCarParkTime5);
                                ParkTimeCompose monthCarParkTime0 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(currMonthInfo.getStartTime().getTime() / 1000L).type(1).build();
                                list.add(monthCarParkTime0);
                                if (switchTime < innerAreaEnterTime) {
                                    monthCarParkTime7 = ParkTimeCompose.builder().startTime(currMonthInfo.getStartTime().getTime() / 1000L).endTime(switchTime).type(1).build();
                                    list.add(monthCarParkTime7);
                                    ParkTimeCompose monthCarParkTime9 = ParkTimeCompose.builder().startTime(switchTime).endTime(innerAreaEnterTime).type(2).build();
                                    list.add(monthCarParkTime9);
                                    monthCarParkTime8 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
                                    list.add(monthCarParkTime8);
                                } else if (switchTime < innerAreaExitTime) {
                                    monthCarParkTime7 = ParkTimeCompose.builder().startTime(currMonthInfo.getStartTime().getTime() / 1000L).endTime(innerAreaEnterTime).type(1).build();
                                    list.add(monthCarParkTime7);
                                    monthCarParkTime83 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
                                    list.add(monthCarParkTime83);
                                } else if (switchTime < endTime) {
                                    monthCarParkTime7 = ParkTimeCompose.builder().startTime(currMonthInfo.getStartTime().getTime() / 1000L).endTime(innerAreaEnterTime).type(1).build();
                                    list.add(monthCarParkTime7);
                                    monthCarParkTime83 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(switchTime).type(1).build();
                                    list.add(monthCarParkTime83);
                                    ParkTimeCompose monthCarParkTime9 = ParkTimeCompose.builder().startTime(switchTime).endTime(endTime).type(2).build();
                                    list.add(monthCarParkTime9);
                                }
                            }
                        }
                        if (secondPartStart > innerAreaEnterTime && secondPartStart < innerAreaExitTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L > innerAreaEnterTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L < innerAreaExitTime) {
                            if (switchTime < innerAreaEnterTime) {
                                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(switchTime).type(1).build();
                                list.add(parkTimeCompose);
                                parkTimeCompose2 = ParkTimeCompose.builder().startTime(switchTime).endTime(innerAreaEnterTime).type(2).build();
                                list.add(parkTimeCompose2);
                                parkTimeCompose32 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
                                list.add(parkTimeCompose32);
                            } else if (switchTime < innerAreaExitTime) {
                                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(1).build();
                                list.add(parkTimeCompose);
                                parkTimeCompose3 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
                                list.add(parkTimeCompose3);
                            } else if (switchTime < endTime) {
                                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(1).build();
                                list.add(parkTimeCompose);
                                parkTimeCompose2 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(switchTime).type(1).build();
                                list.add(parkTimeCompose2);
                                parkTimeCompose32 = ParkTimeCompose.builder().startTime(switchTime).endTime(endTime).type(2).build();
                                list.add(parkTimeCompose32);
                            }
                        }
                        if (secondPartStart > innerAreaExitTime && secondPartStart < endTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L > innerAreaExitTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L < endTime) {
                            ParkTimeCompose parkTimeCompose52;
                            if (switchTime < innerAreaEnterTime) {
                                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(switchTime).type(1).build();
                                list.add(parkTimeCompose);
                                parkTimeCompose2 = ParkTimeCompose.builder().startTime(switchTime).endTime(innerAreaEnterTime).type(2).build();
                                list.add(parkTimeCompose2);
                                parkTimeCompose32 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                                list.add(parkTimeCompose32);
                                ParkTimeCompose parkTimeCompose42 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(secondPartStart).type(1).build();
                                list.add(parkTimeCompose42);
                                parkTimeCompose52 = ParkTimeCompose.builder().startTime(secondPartStart).endTime(endTime).type(2).build();
                                list.add(parkTimeCompose52);
                            } else if (switchTime < innerAreaExitTime) {
                                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(1).build();
                                list.add(parkTimeCompose);
                                parkTimeCompose3 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                                list.add(parkTimeCompose3);
                                parkTimeCompose4 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(secondPartStart).type(1).build();
                                list.add(parkTimeCompose4);
                                parkTimeCompose5 = ParkTimeCompose.builder().startTime(secondPartStart).endTime(endTime).type(2).build();
                                list.add(parkTimeCompose5);
                            } else if (switchTime < this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L) {
                                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(1).build();
                                list.add(parkTimeCompose);
                                parkTimeCompose2 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(switchTime).type(1).build();
                                list.add(parkTimeCompose2);
                                parkTimeCompose4 = ParkTimeCompose.builder().startTime(switchTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                                list.add(parkTimeCompose4);
                                ParkTimeCompose parkTimeCompose6 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(secondPartStart).type(1).build();
                                list.add(parkTimeCompose6);
                                parkTimeCompose52 = ParkTimeCompose.builder().startTime(secondPartStart).endTime(endTime).type(2).build();
                                list.add(parkTimeCompose52);
                            } else if (switchTime < endTime) {
                                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(2).build();
                                list.add(parkTimeCompose);
                                parkTimeCompose2 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                                list.add(parkTimeCompose2);
                                ParkTimeCompose parkTimeCompose6 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(secondPartStart).type(1).build();
                                list.add(parkTimeCompose6);
                                parkTimeCompose5 = ParkTimeCompose.builder().startTime(secondPartStart).endTime(switchTime).type(1).build();
                                list.add(parkTimeCompose5);
                                ParkTimeCompose parkTimeCompose7 = ParkTimeCompose.builder().startTime(switchTime).endTime(endTime).type(2).build();
                                list.add(parkTimeCompose7);
                            }
                        }
                        if (secondPartStart > innerAreaEnterTime && secondPartStart < innerAreaExitTime && this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L < innerAreaEnterTime) {
                            if (switchTime < this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L) {
                                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(switchTime).type(1).build();
                                list.add(parkTimeCompose);
                                parkTimeCompose2 = ParkTimeCompose.builder().startTime(switchTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                                list.add(parkTimeCompose2);
                                parkTimeCompose32 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(innerAreaEnterTime).type(1).build();
                                list.add(parkTimeCompose32);
                                parkTimeCompose5 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
                                list.add(parkTimeCompose5);
                            } else if (switchTime < innerAreaExitTime) {
                                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                                list.add(parkTimeCompose);
                                parkTimeCompose3 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(innerAreaEnterTime).type(1).build();
                                list.add(parkTimeCompose3);
                                ParkTimeCompose parkTimeCompose53 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
                                list.add(parkTimeCompose53);
                            } else if (switchTime < endTime) {
                                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).type(2).build();
                                list.add(parkTimeCompose);
                                parkTimeCompose2 = ParkTimeCompose.builder().startTime(this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L).endTime(innerAreaEnterTime).type(1).build();
                                list.add(parkTimeCompose2);
                                parkTimeCompose4 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(switchTime).type(1).build();
                                list.add(parkTimeCompose4);
                                parkTimeCompose5 = ParkTimeCompose.builder().startTime(switchTime).endTime(endTime).type(2).build();
                                list.add(parkTimeCompose5);
                            }
                        }
                        if (secondPartStart <= innerAreaExitTime || this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L >= innerAreaEnterTime || switchTime < this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L || switchTime < endTime) {
                            // empty if block
                        }
                        if (secondPartStart <= innerAreaExitTime || this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L >= innerAreaEnterTime || switchTime < innerAreaEnterTime || switchTime < this.completeConvert(timeoutMonthInfo.getEndTime()) + 1L || switchTime >= endTime) break;
                        break;
                    }
                    this.twoPartMonthCar(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
                    break;
                }
                case TIMEOUT_IN_PARK: {
                    MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                    if (this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L < innerAreaEnterTime) {
                        // empty if block
                    }
                    if (this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L <= innerAreaEnterTime || this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L < innerAreaExitTime) {
                        // empty if block
                    }
                    if (this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L <= innerAreaExitTime || this.completeConvert(timedOutMonthInfo.getEndTime()) + 1L >= endTime) break;
                    break;
                }
            }
        }
        long tempCarParkTimeSum = list.stream().filter(ptc -> ptc.getType() == 1).mapToLong(ptc -> ptc.getEndTime() - ptc.getStartTime()).sum();
        if (tempCarParkTimeSum > 0L) {
            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(Long.valueOf(startTime)).endTime(Long.valueOf(startTime + tempCarParkTimeSum)).build();
            feeParamHolder.addExtraFeePara(feePara);
        }
        boolean isMonthRet = false;
        List monthCarParkTimeList = list.stream().filter(ptc -> ptc.getType() == 2).collect(Collectors.toList());
        for (int i = 0; i < monthCarParkTimeList.size(); ++i) {
            boolean thisIsMonthRet = false;
            ParkTimeCompose parkTimeCompose = (ParkTimeCompose)list.get(i);
            if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                ParkTimeDetail parkTimeDetail = this.getParkTimeDetail(parkTimeCompose.getStartTime(), parkTimeCompose.getEndTime());
                int parkTimeType = parkTimeDetail.getType();
                if (parkTimeType == 1 || NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) == 1) {
                    if (!isMonthRet) {
                        isMonthRet = true;
                    }
                    thisIsMonthRet = true;
                }
                if ((parkTimeType == 2 || parkTimeType == 3) && NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) == 2) {
                    BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail.getNotWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime())).build();
                    feeParamHolder.addExtraFeePara(feePara2);
                }
            } else {
                MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                if (monthProduct == null) {
                    monthProduct = monthTypeDto.getTimedOutMonthProduct();
                }
                this.addCsWorkDayAndNotFeePara(feeParamHolder, parkTimeCompose.getStartTime(), parkTimeCompose.getEndTime(), monthTypeDto, monthProduct);
            }
            isMonthRet = isMonthRet && thisIsMonthRet;
        }
        if (tempCarParkTimeSum == 0L && isMonthRet) {
            return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
        }
        return MonthFeeDto.builder().isMonthRet(false).newStartTime(newStartTime).newEndTime(newEndTime).csFeeType(csFeeType).isCsMonthCarFee(isCsMonthCarFee).csStartTime(csStartTime).csEndTime(csEndTime).csSwitchTime(csSwitchTime).monthInfo(monthInfoRet).build();
    }

    private void twoPartMonthCar(long startTime, long endTime, Long innerAreaEnterTime, Long innerAreaExitTime, List<ParkTimeCompose> list) {
        ParkTimeCompose monthCarParkTime = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(2).build();
        list.add(monthCarParkTime);
        ParkTimeCompose monthCarParkTime2 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
        list.add(monthCarParkTime2);
    }

    private void handleParkTimeComposeWithSwitchTime(long startTime, long endTime, long innerAreaEnterTime, long innerAreaExitTime, long switchTime, List<ParkTimeCompose> list) {
        if (switchTime > innerAreaEnterTime && switchTime < innerAreaExitTime) {
            ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime).type(1).build();
            list.add(parkTimeCompose);
            ParkTimeCompose parkTimeCompose2 = ParkTimeCompose.builder().startTime(innerAreaExitTime).endTime(endTime).type(2).build();
            list.add(parkTimeCompose2);
        } else {
            ParkTimeCompose parkTimeCompose;
            if (switchTime > startTime && switchTime < innerAreaEnterTime) {
                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(switchTime).type(1).build();
                list.add(parkTimeCompose);
                this.twoPartMonthCar(switchTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
            }
            if (switchTime > innerAreaExitTime && switchTime < endTime) {
                parkTimeCompose = ParkTimeCompose.builder().startTime(startTime).endTime(innerAreaEnterTime + (switchTime - innerAreaExitTime)).type(1).build();
                list.add(parkTimeCompose);
                ParkTimeCompose monthCarParkTime2 = ParkTimeCompose.builder().startTime(switchTime).endTime(endTime).type(2).build();
                list.add(monthCarParkTime2);
            }
        }
    }

    private ParkTimeDetail getParkTimeDetail(long startTime, long endTime, Long innerAreaEnterTime, Long innerAreaExitTime) {
        LocalDateTime currDayEndDateTime;
        long currStartTime;
        if (startTime >= innerAreaExitTime) {
            return this.getParkTimeDetail(startTime, endTime);
        }
        ParkTimeDetail parkTimeDetail = new ParkTimeDetail();
        LocalDateTime startDateTime = LocalDateTime.ofEpochSecond(startTime, 0, ZoneOffset.ofHours(8));
        LocalDateTime endDateTime = LocalDateTime.ofEpochSecond(endTime, 0, ZoneOffset.ofHours(8));
        LocalDateTime innerAreaStartDateTime = LocalDateTime.ofEpochSecond(innerAreaEnterTime, 0, ZoneOffset.ofHours(8));
        LocalDateTime innerAreaEndDateTime = LocalDateTime.ofEpochSecond(innerAreaExitTime, 0, ZoneOffset.ofHours(8));
        List notDays = this.notWorkDayService.queryNotDays(Integer.valueOf(startDateTime.getYear()));
        if (startDateTime.getYear() != endDateTime.getYear()) {
            notDays.addAll(this.notWorkDayService.queryNotDays(Integer.valueOf(endDateTime.getYear())));
        }
        boolean hasNotWorkDay = false;
        boolean hasWorkDay = false;
        long notWorkDayParkTime = 0L;
        while (startDateTime.compareTo(innerAreaStartDateTime) <= 0) {
            currStartTime = startDateTime.toEpochSecond(ZoneOffset.ofHours(8));
            currDayEndDateTime = startDateTime.plusDays(1L).withHour(0).withMinute(0).withSecond(0);
            if (currDayEndDateTime.compareTo(innerAreaStartDateTime) > 0) {
                currDayEndDateTime = innerAreaStartDateTime;
            }
            if (currDayEndDateTime.compareTo(innerAreaStartDateTime) > 0) {
                currDayEndDateTime = innerAreaStartDateTime;
            }
            if (notDays.contains(startDateTime.format(FORMATTER))) {
                if (!hasNotWorkDay) {
                    parkTimeDetail.setNotWorkDayStartTime(currStartTime);
                }
                notWorkDayParkTime += currDayEndDateTime.toEpochSecond(ZoneOffset.ofHours(8)) - startDateTime.toEpochSecond(ZoneOffset.ofHours(8));
                hasNotWorkDay = true;
            } else {
                if (!hasWorkDay) {
                    parkTimeDetail.setWorkDayStartTime(currStartTime);
                }
                hasWorkDay = true;
            }
            startDateTime = startDateTime.plusDays(1L).withHour(0).withMinute(0).withSecond(0);
        }
        while (innerAreaEndDateTime.compareTo(endDateTime) <= 0) {
            currStartTime = innerAreaEndDateTime.toEpochSecond(ZoneOffset.ofHours(8));
            currDayEndDateTime = innerAreaEndDateTime.plusDays(1L).withHour(0).withMinute(0).withSecond(0);
            if (currDayEndDateTime.compareTo(endDateTime) > 0) {
                currDayEndDateTime = endDateTime;
            }
            if (currDayEndDateTime.compareTo(endDateTime) > 0) {
                currDayEndDateTime = endDateTime;
            }
            if (notDays.contains(innerAreaEndDateTime.format(FORMATTER))) {
                if (!hasNotWorkDay) {
                    parkTimeDetail.setNotWorkDayStartTime(currStartTime);
                }
                notWorkDayParkTime += currDayEndDateTime.toEpochSecond(ZoneOffset.ofHours(8)) - innerAreaEndDateTime.toEpochSecond(ZoneOffset.ofHours(8));
                hasNotWorkDay = true;
            } else {
                if (!hasWorkDay) {
                    parkTimeDetail.setWorkDayStartTime(currStartTime);
                }
                hasWorkDay = true;
            }
            innerAreaEndDateTime = innerAreaEndDateTime.plusDays(1L).withHour(0).withMinute(0).withSecond(0);
        }
        if (hasWorkDay && hasNotWorkDay) {
            parkTimeDetail.setType(3);
        } else {
            if (hasWorkDay) {
                parkTimeDetail.setType(1);
            }
            if (hasNotWorkDay) {
                parkTimeDetail.setType(2);
            }
        }
        parkTimeDetail.setNotWorkDayParkTime(notWorkDayParkTime);
        parkTimeDetail.setWorkDayParkTime(innerAreaEnterTime - startTime + (endTime - innerAreaExitTime) - notWorkDayParkTime);
        log.info("\u5916\u533a\u5de5\u4f5c\u65e5\u975e\u5de5\u4f5c\u65e5\u60c5\u51b5:{}", (Object)parkTimeDetail);
        return parkTimeDetail;
    }

    private boolean addCsWorkDayAndNotFeePara(BaseFeeParamHolder feeParamHolder, long startTime, long endTime, MonthTypeDto monthTypeDto, MonthProduct monthProduct) {
        ParkTimeDetail parkTimeDetail = this.getParkTimeDetail(startTime, endTime);
        if (NumberUtils.toPrimitive((Integer)monthTypeDto.getNotWorkdayCharge()) == 1) {
            if (parkTimeDetail.getType() == 2) {
                return true;
            }
            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail.getWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail.getWorkDayStartTime() + parkTimeDetail.getWorkDayParkTime())).isCsMonthCarFee(true).csStartTime(monthProduct.getStartTime().toString()).csEndTime(monthProduct.getEndTime().toString()).build();
            feeParamHolder.addExtraFeePara(feePara);
        } else {
            BaseFeeParamHolder.ExtraComputeFeePara feePara;
            if (parkTimeDetail.getType() == 1 || parkTimeDetail.getType() == 3) {
                feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail.getWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail.getWorkDayStartTime() + parkTimeDetail.getWorkDayParkTime())).isCsMonthCarFee(true).csStartTime(monthProduct.getStartTime().toString()).csEndTime(monthProduct.getEndTime().toString()).build();
                feeParamHolder.addExtraFeePara(feePara);
            }
            if (parkTimeDetail.getType() == 2 || parkTimeDetail.getType() == 3) {
                feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder().startTime(parkTimeDetail.getNotWorkDayStartTime()).endTime(Long.valueOf(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime())).build();
                feeParamHolder.addExtraFeePara(feePara);
            }
        }
        return false;
    }

    public MonthTypeDto getMonthTypeDto(Long parkId, OrderInfo orderInfo, long startTime, long endTime, ParkConfig parkConfig, Long regionId, Integer multipleAreaType) {
        MonthProduct monthProduct;
        MonthTypeDto monthTypeDto = new MonthTypeDto();
        MonthInfo monthInfo = this.monthCarService.findMonthInfo(parkId, orderInfo.getPlateNum(), regionId, MonthCarServiceBase.VALID_CARD);
        if (monthInfo != null) {
            monthProduct = this.monthProductDao.selectById(monthInfo.getProductId().longValue());
            monthTypeDto.setCurrMonthInfo(monthInfo);
            monthTypeDto.setCurrMonthProduct(monthProduct);
            monthTypeDto.setCardType(monthProduct.getCardType());
            monthTypeDto.setDiffWorkday(monthProduct.getDiffWorkday());
            monthTypeDto.setNotWorkdayCharge(monthProduct.getNotWorkdayCharge());
            Date validateStartTime = monthInfo.getStartTime();
            Date validateEndTime = monthInfo.getEndTime();
            boolean fullMonthCard = this.isFullMonthCard(startTime, endTime, validateStartTime, validateEndTime);
            if (fullMonthCard) {
                monthTypeDto.setMonthTypeEnum(MonthTypeEnum.FULL_MONTH);
            } else if (this.isInParkStart(startTime, endTime, monthInfo)) {
                MonthInfo timeoutMonthInfo = this.monthCarService.findMonthInfo(parkId, orderInfo.getPlateNum(), regionId, TIMEOUT_CARD);
                if (timeoutMonthInfo != null) {
                    if (this.isTimeOutInPark(startTime, endTime, timeoutMonthInfo)) {
                        int days = DateTools.differentDays((Date)timeoutMonthInfo.getEndTime(), (Date)monthInfo.getStartTime());
                        if (days <= 1) {
                            monthTypeDto.setMonthTypeEnum(MonthTypeEnum.FULL_MONTH);
                            log.info("\u8fde\u7eed\u7eed\u8d39, \u5168\u90e8\u65f6\u957f\u4e3a\u6708\u5361, \u8f66\u724c\u53f7[{}]", (Object)orderInfo.getPlateNum());
                        } else {
                            monthTypeDto.setMonthTypeEnum(MonthTypeEnum.TEMP_MIDDLE);
                            monthTypeDto.setTimedOutMonthInfo(timeoutMonthInfo);
                            MonthProduct timedOutMonthProduct = this.monthProductDao.selectById(timeoutMonthInfo.getProductId().longValue());
                            monthTypeDto.setTimedOutMonthProduct(timedOutMonthProduct);
                        }
                    } else {
                        monthTypeDto.setMonthTypeEnum(MonthTypeEnum.IN_PARK_START);
                    }
                } else {
                    monthTypeDto.setMonthTypeEnum(MonthTypeEnum.IN_PARK_START);
                }
            } else {
                log.warn("\u7406\u8bba\u4e0a\u4e0d\u4f1a\u5b58\u5728\u6b64\u60c5\u51b5, month[{}], orderInfo[{}]", (Object)monthInfo, (Object)orderInfo);
            }
        } else {
            monthInfo = this.monthCarService.findMonthInfo(parkId, orderInfo.getPlateNum(), regionId, TIMEOUT_CARD);
            if (monthInfo == null) {
                return monthTypeDto;
            }
            monthTypeDto.setTimedOutMonthInfo(monthInfo);
            monthProduct = this.monthProductDao.selectById(monthInfo.getProductId().longValue());
            monthTypeDto.setTimedOutMonthProduct(monthProduct);
            monthTypeDto.setCardType(monthProduct.getCardType());
            this.expireMonthCard(parkConfig, monthTypeDto, monthInfo, monthProduct);
            if (this.isInParkStartAndTimeOut(startTime, endTime, monthInfo)) {
                if (MonthTypeEnum.FULL_MONTH.equals((Object)monthTypeDto.getMonthTypeEnum())) {
                    monthTypeDto.setMonthTypeEnum(MonthTypeEnum.IN_PARK_START);
                    monthTypeDto.setCurrMonthInfo(monthInfo);
                    monthTypeDto.setCurrMonthProduct(monthTypeDto.getTimedOutMonthProduct());
                } else {
                    monthTypeDto.setMonthTypeEnum(MonthTypeEnum.MONTH_MIDDLE);
                    monthTypeDto.setDiffWorkday(monthProduct.getDiffWorkday());
                    monthTypeDto.setNotWorkdayCharge(monthProduct.getNotWorkdayCharge());
                }
            }
            if (monthTypeDto.getMonthTypeEnum() == null) {
                if (this.isTimeOutInPark(startTime, endTime, monthInfo)) {
                    monthTypeDto.setMonthTypeEnum(MonthTypeEnum.TIMEOUT_IN_PARK);
                    monthTypeDto.setDiffWorkday(monthProduct.getDiffWorkday());
                    monthTypeDto.setNotWorkdayCharge(monthProduct.getNotWorkdayCharge());
                } else {
                    monthTypeDto.setMonthTypeEnum(MonthTypeEnum.TIMEOUT);
                }
            }
        }
        if (monthTypeDto.getMonthTypeEnum() != null) {
            if (orderInfo.getSwitchTime() != null) {
                monthTypeDto.setAbCard(true);
                monthTypeDto.setAbCarType(2);
            } else {
                List plateNumList = this.monthPlateDao.selectByMonthId(monthInfo.getId());
                boolean abCar = this.isAbCar(monthInfo.getPlotCount(), plateNumList);
                monthTypeDto.setAbCard(abCar);
                if (abCar) {
                    monthTypeDto.setAbCarType(1);
                    if (PlateTypeEnum.\u4e34\u65f6\u8f66.getType().equals(orderInfo.getType())) {
                        if (MonthTypeEnum.IN_PARK_START.equals((Object)monthTypeDto.getMonthTypeEnum())) {
                            int alreadyExitOrders = this.getAlreadyExitOrders(parkId, regionId, multipleAreaType, monthInfo, plateNumList);
                            if (alreadyExitOrders >= monthInfo.getPlotCount()) {
                                monthTypeDto.setAbCarType(2);
                            }
                        } else {
                            OrderTags orderTags = this.orderTagsDao.selectByOrderNum(orderInfo.getOrderNum(), Integer.valueOf(1), regionId);
                            if (orderTags != null) {
                                monthTypeDto.setAbCarType(2);
                            }
                        }
                    }
                }
            }
        }
        return monthTypeDto;
    }

    private void expireMonthCard(ParkConfig parkConfig, MonthTypeDto monthTypeDto, MonthInfo monthInfo, MonthProduct monthProduct) {
        int differentDays;
        Integer expireMcDays = parkConfig.getExpireMcDays();
        Integer expireMc = parkConfig.getIsExpireMc();
        if (expireMcDays != null && expireMcDays > 0 && expireMc != null && expireMc == 1 && (differentDays = DateTools.differentDays((Date)monthInfo.getEndTime(), (Date)new Date())) <= expireMcDays) {
            monthTypeDto.setMonthTypeEnum(MonthTypeEnum.FULL_MONTH);
            monthTypeDto.setDiffWorkday(monthProduct.getDiffWorkday());
            monthTypeDto.setNotWorkdayCharge(monthProduct.getNotWorkdayCharge());
        }
    }

    public MonthInfo getMonthInfo(Long parkId, String plateNum, Long regionId, ParkConfig parkConfig) {
        int differentDays;
        MonthInfo monthInfo = this.monthCarService.findMonthInfo(parkId, plateNum, regionId, MonthCarServiceBase.VALID_CARD);
        if (monthInfo != null) {
            return monthInfo;
        }
        monthInfo = this.monthCarService.findMonthInfo(parkId, plateNum, regionId, MonthCarServiceBase.TIMEOUT_CARD);
        if (monthInfo == null) {
            return null;
        }
        Integer expireMcDays = parkConfig.getExpireMcDays();
        Integer expireMc = parkConfig.getIsExpireMc();
        if (expireMcDays != null && expireMcDays > 0 && expireMc != null && expireMc == 1 && (differentDays = DateTools.differentDays((Date)monthInfo.getEndTime(), (Date)new Date())) <= expireMcDays) {
            return monthInfo;
        }
        return null;
    }

    private int getAlreadyExitOrders(Long parkId, Long regionId, Integer multipleAreaType, MonthInfo monthInfo, List<String> plateNumList) {
        MonthRegion parkRegion;
        List monthRegions;
        if ((Integer.valueOf(1).equals(multipleAreaType) || Integer.valueOf(2).equals(multipleAreaType)) && CollectionUtils.isNotEmpty((Collection)(monthRegions = this.monthRegionDao.selectByMonthId(monthInfo.getId().longValue()))) && (parkRegion = (MonthRegion)monthRegions.stream().filter(mr -> NumberUtils.toPrimitive((Long)mr.getRegionId()) == 0L).findFirst().orElse(null)) == null) {
            int orderSonCount = this.orderSonInfoDao.countExitRecordsFromStartTime(parkId, plateNumList, regionId, Long.valueOf(monthInfo.getStartTime().getTime() / 1000L));
            int orderCount = this.orderInfoDao.countMultipleAreaExitRecordsFromStartTime(parkId, plateNumList, regionId, Long.valueOf(monthInfo.getStartTime().getTime() / 1000L));
            return orderCount + orderSonCount;
        }
        return this.orderInfoDao.countExitRecordsFromStartTime(parkId, Long.valueOf(monthInfo.getStartTime().getTime() / 1000L), plateNumList);
    }

    public boolean isTimeOutInPark(Long startTime, Long endTime, MonthInfo monthInfo) {
        return monthInfo.getStartTime().getTime() / 1000L <= startTime && this.completeConvert(monthInfo.getEndTime()) > startTime && this.completeConvert(monthInfo.getEndTime()) < endTime;
    }

    public boolean isInParkStartAndTimeOut(Long startTime, Long endTime, MonthInfo monthInfo) {
        boolean inParkStart = this.isInParkStart(startTime, endTime, monthInfo);
        boolean timeOutInPark = this.completeConvert(monthInfo.getEndTime()) > startTime && this.completeConvert(monthInfo.getEndTime()) < endTime;
        return inParkStart && timeOutInPark;
    }

    public boolean isInParkStart(Long startTime, Long endTime, MonthInfo monthInfo) {
        return monthInfo.getStartTime().getTime() / 1000L > startTime && monthInfo.getStartTime().getTime() / 1000L <= endTime;
    }

    public boolean isFullMonthCard(Long startTime, Long endTime, Date validateStartTime, Date validateEndTime) {
        if (startTime == null || endTime == null || validateStartTime == null || validateEndTime == null) {
            return false;
        }
        long validateEndTimeLong = validateEndTime.getTime() / 1000L + 86400L - 1L;
        return validateStartTime.getTime() / 1000L <= startTime && validateEndTimeLong >= endTime;
    }

    private boolean isAbCar(int plotCount, List<String> plateNumList) {
        int plateCount = plateNumList.size();
        return plateCount > plotCount;
    }

    private long completeConvert(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime() / 1000L + 86400L - 1L;
    }

    private ParkTimeDetail getParkTimeDetail(long startTime, long endTime) {
        ParkTimeDetail parkTimeDetail = new ParkTimeDetail();
        LocalDateTime startDateTime = LocalDateTime.ofEpochSecond(startTime, 0, ZoneOffset.ofHours(8));
        LocalDateTime endDateTime = LocalDateTime.ofEpochSecond(endTime, 0, ZoneOffset.ofHours(8));
        List notDays = this.notWorkDayService.queryNotDays(Integer.valueOf(startDateTime.getYear()));
        if (startDateTime.getYear() != endDateTime.getYear()) {
            notDays.addAll(this.notWorkDayService.queryNotDays(Integer.valueOf(endDateTime.getYear())));
        }
        boolean hasNotWorkDay = false;
        boolean hasWorkDay = false;
        long notWorkDayParkTime = 0L;
        while (startDateTime.compareTo(endDateTime) <= 0) {
            long currStartTime = startDateTime.toEpochSecond(ZoneOffset.ofHours(8));
            LocalDateTime currDayEndDateTime = startDateTime.plusDays(1L).withHour(0).withMinute(0).withSecond(0);
            if (currDayEndDateTime.compareTo(endDateTime) > 0) {
                currDayEndDateTime = endDateTime;
            }
            if (currDayEndDateTime.compareTo(endDateTime) > 0) {
                currDayEndDateTime = endDateTime;
            }
            if (notDays.contains(startDateTime.format(FORMATTER))) {
                if (!hasNotWorkDay) {
                    parkTimeDetail.setNotWorkDayStartTime(currStartTime);
                }
                notWorkDayParkTime += currDayEndDateTime.toEpochSecond(ZoneOffset.ofHours(8)) - startDateTime.toEpochSecond(ZoneOffset.ofHours(8));
                hasNotWorkDay = true;
            } else {
                if (!hasWorkDay) {
                    parkTimeDetail.setWorkDayStartTime(currStartTime);
                }
                hasWorkDay = true;
            }
            startDateTime = startDateTime.plusDays(1L).withHour(0).withMinute(0).withSecond(0);
        }
        if (hasWorkDay && hasNotWorkDay) {
            parkTimeDetail.setType(3);
        } else {
            if (hasWorkDay) {
                parkTimeDetail.setType(1);
            }
            if (hasNotWorkDay) {
                parkTimeDetail.setType(2);
            }
        }
        parkTimeDetail.setNotWorkDayParkTime(notWorkDayParkTime);
        parkTimeDetail.setWorkDayParkTime(endTime - startTime - notWorkDayParkTime);
        log.info("\u5de5\u4f5c\u65e5\u975e\u5de5\u4f5c\u65e5\u60c5\u51b5:{}", (Object)parkTimeDetail);
        return parkTimeDetail;
    }

    public static class ParkTimeCompose {
        private int type;
        private long startTime;
        private long endTime;

        public static ParkTimeComposeBuilder builder() {
            return new ParkTimeComposeBuilder();
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public int getType() {
            return this.type;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public String toString() {
            return "MonthFeeHandle.ParkTimeCompose(type=" + this.getType() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
        }

        public ParkTimeCompose(int type, long startTime, long endTime) {
            this.type = type;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public ParkTimeCompose() {
        }

        public static class ParkTimeComposeBuilder {
            private int type;
            private long startTime;
            private long endTime;

            ParkTimeComposeBuilder() {
            }

            public ParkTimeComposeBuilder type(int type) {
                this.type = type;
                return this;
            }

            public ParkTimeComposeBuilder startTime(long startTime) {
                this.startTime = startTime;
                return this;
            }

            public ParkTimeComposeBuilder endTime(long endTime) {
                this.endTime = endTime;
                return this;
            }

            public ParkTimeCompose build() {
                return new ParkTimeCompose(this.type, this.startTime, this.endTime);
            }

            public String toString() {
                return "MonthFeeHandle.ParkTimeCompose.ParkTimeComposeBuilder(type=" + this.type + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ")";
            }
        }
    }

    public static class ParkTimeDetail {
        private int type;
        private Long workDayStartTime;
        private Long workDayParkTime;
        private Long notWorkDayStartTime;
        private Long notWorkDayParkTime;

        public int getType() {
            return this.type;
        }

        public Long getWorkDayStartTime() {
            return this.workDayStartTime;
        }

        public Long getWorkDayParkTime() {
            return this.workDayParkTime;
        }

        public Long getNotWorkDayStartTime() {
            return this.notWorkDayStartTime;
        }

        public Long getNotWorkDayParkTime() {
            return this.notWorkDayParkTime;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setWorkDayStartTime(Long workDayStartTime) {
            this.workDayStartTime = workDayStartTime;
        }

        public void setWorkDayParkTime(Long workDayParkTime) {
            this.workDayParkTime = workDayParkTime;
        }

        public void setNotWorkDayStartTime(Long notWorkDayStartTime) {
            this.notWorkDayStartTime = notWorkDayStartTime;
        }

        public void setNotWorkDayParkTime(Long notWorkDayParkTime) {
            this.notWorkDayParkTime = notWorkDayParkTime;
        }

        public String toString() {
            return "MonthFeeHandle.ParkTimeDetail(type=" + this.getType() + ", workDayStartTime=" + this.getWorkDayStartTime() + ", workDayParkTime=" + this.getWorkDayParkTime() + ", notWorkDayStartTime=" + this.getNotWorkDayStartTime() + ", notWorkDayParkTime=" + this.getNotWorkDayParkTime() + ")";
        }
    }
}

