/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee;

import cn.hutool.core.collection.CollectionUtil;
import com.google.common.collect.Lists;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.discount.ParkDiscountUsercharge;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.utils.JsonUtils;
import com.icetech.fee.dao.merchant.DiscountDayDao;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.QueryFeeChainAbstract;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiscountOverHandle
extends QueryFeeChainAbstract {
    private static final Logger log = LoggerFactory.getLogger(DiscountOverHandle.class);
    @Autowired
    private DiscountDayDao discountDayDao;

    public DiscountInfo getDiscount(BaseFeeParamHolder feeParamHolder, ParkChargeconfig parkChargeconfig, OrderInfo orderInfo, OrderSumFeeDto orderSumFeeDto, ParkDiscountUsercharge parkDiscountUsercharge, List<OrderDiscount> discountList, Long parkingTime, BigDecimal unPayPrice, BigDecimal totalPrice, Boolean multi) {
        boolean isTimeOver;
        boolean isPriceOver;
        List thirdOrderDiscount = discountList.stream().filter(orderDiscount -> orderDiscount.getFrom() == 2).collect(Collectors.toList());
        List cloudOrderDiscount = discountList.stream().filter(orderDiscount -> orderDiscount.getFrom() == 1).collect(Collectors.toList());
        Boolean isThird = parkDiscountUsercharge.getThirdpartyStackeUsage() == 1;
        if (StringUtils.isNotBlank((CharSequence)parkDiscountUsercharge.getSametypeTogetherUser())) {
            String[] discountTypes = parkDiscountUsercharge.getSametypeTogetherUser().split(",");
            ArrayList discountTypeList = Lists.newArrayList();
            for (String discountType : discountTypes) {
                discountTypeList.add(Integer.valueOf(discountType));
            }
            isPriceOver = parkDiscountUsercharge.getSupportStackeUsage() == 1 && discountTypeList.contains(DiscountTypeEnum.\u51cf\u514d\u91d1\u989d.getType());
            isTimeOver = parkDiscountUsercharge.getSupportStackeUsage() == 1 && discountTypeList.contains(DiscountTypeEnum.\u51cf\u514d\u65f6\u95f4.getType());
        } else {
            isPriceOver = false;
            isTimeOver = false;
        }
        DiscountInfo thirdDiscountInfo = new DiscountInfo(Lists.newArrayList(), BigDecimal.ZERO, BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty(thirdOrderDiscount)) {
            Map<Integer, List<OrderDiscount>> discountsMap = thirdOrderDiscount.stream().collect(Collectors.groupingBy(OrderDiscount::getType));
            List<OrderDiscount> orderDiscounts4Time = discountsMap.get(DiscountTypeEnum.\u51cf\u514d\u65f6\u95f4.getType());
            List<OrderDiscount> orderDiscounts4Price = discountsMap.get(DiscountTypeEnum.\u51cf\u514d\u91d1\u989d.getType());
            List<OrderDiscount> orderDiscounts4Rate = discountsMap.get(DiscountTypeEnum.\u6298\u6263.getType());
            List<OrderDiscount> orderDiscounts4Free = discountsMap.get(DiscountTypeEnum.\u5168\u514d.getType());
            List<OrderDiscount> orderDiscounts4Day = discountsMap.get(DiscountTypeEnum.\u6309\u5929\u4f18\u514d.getType());
            if (CollectionUtils.isNotEmpty(orderDiscounts4Free)) {
                return this.getDiscountFree(orderDiscounts4Free, unPayPrice);
            }
            if (CollectionUtils.isNotEmpty(orderDiscounts4Day)) {
                return this.getDiscountDay(feeParamHolder, parkChargeconfig, orderInfo, orderDiscounts4Day, unPayPrice);
            }
            log.info("[\u53e0\u52a0\u4f18\u60e0-\u4e09\u65b9\u5f00\u59cb\u8ba1\u7b97] orderNum {} thirdOrderDiscount{} isPriceOver {} isTimeOver {} isThird {}", new Object[]{orderInfo.getOrderNum(), thirdOrderDiscount, isPriceOver, isTimeOver, isThird});
            DiscountInfo discountInfoPrice = this.getDiscountPrice(orderDiscounts4Price, unPayPrice, true, true);
            DiscountInfo discountInfoTime = this.getDiscountTime(feeParamHolder, parkChargeconfig, orderInfo, orderSumFeeDto, orderDiscounts4Time, unPayPrice, parkingTime, true, multi, true);
            DiscountInfo discountInfoRate = this.getDiscountRate(orderDiscounts4Rate, totalPrice);
            List<Object> discountInfos = Lists.newArrayList((Object[])new DiscountInfo[]{discountInfoPrice, discountInfoTime, discountInfoRate});
            discountInfos = discountInfos.stream().sorted(Comparator.comparing(DiscountInfo::getMaxDiscountPrice).reversed()).collect(Collectors.toList());
            thirdDiscountInfo = discountInfos.stream().max(Comparator.comparing(DiscountInfo::getDiscountPrice)).get();
            log.info("[\u53e0\u52a0\u4f18\u60e0-\u4e09\u65b9\u6700\u7ec8] orderNum {} discountList {} discountInfo {} ", new Object[]{orderInfo.getOrderNum(), JsonUtils.toString(discountList), thirdDiscountInfo});
            if (!isThird.booleanValue()) {
                return thirdDiscountInfo;
            }
            if (thirdDiscountInfo.getDiscountPrice().compareTo(unPayPrice) >= 0) {
                return thirdDiscountInfo;
            }
        }
        DiscountInfo cloudDiscountInfo = new DiscountInfo(Lists.newArrayList(), BigDecimal.ZERO, BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty(cloudOrderDiscount)) {
            Map<Integer, List<OrderDiscount>> discountsMap = cloudOrderDiscount.stream().collect(Collectors.groupingBy(OrderDiscount::getType));
            List<OrderDiscount> orderDiscounts4Time = discountsMap.get(DiscountTypeEnum.\u51cf\u514d\u65f6\u95f4.getType());
            List<OrderDiscount> orderDiscounts4Price = discountsMap.get(DiscountTypeEnum.\u51cf\u514d\u91d1\u989d.getType());
            List<OrderDiscount> orderDiscounts4Rate = discountsMap.get(DiscountTypeEnum.\u6298\u6263.getType());
            List<OrderDiscount> orderDiscounts4Free = discountsMap.get(DiscountTypeEnum.\u5168\u514d.getType());
            List<OrderDiscount> orderDiscounts4Day = discountsMap.get(DiscountTypeEnum.\u6309\u5929\u4f18\u514d.getType());
            if (CollectionUtils.isNotEmpty(orderDiscounts4Free)) {
                return this.getDiscountFree(orderDiscounts4Free, unPayPrice);
            }
            if (CollectionUtils.isNotEmpty(orderDiscounts4Day)) {
                return this.getDiscountDay(feeParamHolder, parkChargeconfig, orderInfo, orderDiscounts4Day, unPayPrice);
            }
            log.info("[\u53e0\u52a0\u4f18\u60e0-\u5e73\u53f0\u5f00\u59cb\u8ba1\u7b97] orderNum {} cloudOrderDiscount {} isPriceOver {} isTimeOver {}", new Object[]{orderInfo.getOrderNum(), cloudOrderDiscount, isPriceOver, isTimeOver});
            DiscountInfo discountInfoPrice = this.getDiscountPrice(orderDiscounts4Price, unPayPrice, isPriceOver, false);
            DiscountInfo discountInfoTime = this.getDiscountTime(feeParamHolder, parkChargeconfig, orderInfo, orderSumFeeDto, orderDiscounts4Time, unPayPrice, parkingTime, isTimeOver, multi, false);
            DiscountInfo discountInfoRate = this.getDiscountRate(orderDiscounts4Rate, totalPrice.subtract(thirdDiscountInfo.getDiscountPrice()));
            List<Object> discountInfos = Lists.newArrayList((Object[])new DiscountInfo[]{discountInfoPrice, discountInfoTime, discountInfoRate});
            discountInfos = discountInfos.stream().sorted(Comparator.comparing(DiscountInfo::getMaxDiscountPrice).reversed()).collect(Collectors.toList());
            cloudDiscountInfo = discountInfos.stream().max(Comparator.comparing(DiscountInfo::getDiscountPrice)).get();
            log.info("[\u53e0\u52a0\u4f18\u60e0-\u5e73\u53f0\u6700\u7ec8] orderNum {} discountList {} discountInfo {} ", new Object[]{orderInfo.getOrderNum(), JsonUtils.toString(discountList), cloudDiscountInfo});
        }
        if (cloudDiscountInfo.getDiscountPrice().add(thirdDiscountInfo.getDiscountPrice()).compareTo(unPayPrice) >= 0) {
            BigDecimal subtract = totalPrice.subtract(thirdDiscountInfo.getDiscountPrice()).setScale(2, 4);
            cloudDiscountInfo.setDiscountPrice(subtract);
            cloudDiscountInfo.setMaxDiscountPrice(subtract);
            cloudDiscountInfo.setMerchantDiscountPrice(subtract);
            OrderPayDiscount.MerchantCouponsInfo merchantCouponsInfo = cloudDiscountInfo.getMerchantCouponsInfo();
            merchantCouponsInfo.setDiscountPrice(subtract);
        }
        DiscountInfo discountInfo = new DiscountInfo(CollectionUtil.addAllIfNotContains(thirdDiscountInfo.getDiscountNos(), cloudDiscountInfo.getDiscountNos()), thirdDiscountInfo.getDiscountPrice().add(cloudDiscountInfo.getDiscountPrice()), thirdDiscountInfo.getMaxDiscountPrice().add(cloudDiscountInfo.getMaxDiscountPrice()));
        discountInfo.setThirdCouponsInfo(thirdDiscountInfo.getThirdCouponsInfo());
        discountInfo.setThirdDiscountPrice(thirdDiscountInfo.getThirdDiscountPrice());
        discountInfo.setMerchantCouponsInfo(cloudDiscountInfo.getMerchantCouponsInfo());
        discountInfo.setMerchantDiscountPrice(cloudDiscountInfo.getMerchantDiscountPrice());
        return discountInfo;
    }

    private DiscountInfo getDiscountPrice(List<OrderDiscount> discountList, BigDecimal unpaidPrice, Boolean isOver, Boolean isThird) {
        if (CollectionUtils.isEmpty(discountList)) {
            return new DiscountInfo(Lists.newArrayList(), BigDecimal.ZERO, BigDecimal.ZERO);
        }
        discountList = discountList.stream().sorted(Comparator.comparingDouble(value -> Double.parseDouble(value.getAmount())).reversed()).collect(Collectors.toList());
        if (isOver.booleanValue()) {
            return this.getPriceOverDiscount(discountList, unpaidPrice, isThird);
        }
        return this.getPriceOverDiscount(Lists.newArrayList((Object[])new OrderDiscount[]{(OrderDiscount)discountList.get(0)}), unpaidPrice, isThird);
    }

    private DiscountInfo getDiscountTime(BaseFeeParamHolder feeParamHolder, ParkChargeconfig parkChargeconfig, OrderInfo orderInfo, OrderSumFeeDto orderSumFeeDto, List<OrderDiscount> discountList, BigDecimal unpaidPrice, Long parkingTime, Boolean isOver, Boolean multi, Boolean isThird) {
        if (CollectionUtils.isEmpty(discountList)) {
            return new DiscountInfo(Lists.newArrayList(), BigDecimal.ZERO, BigDecimal.ZERO);
        }
        discountList = discountList.stream().sorted(Comparator.comparingInt(value -> Integer.parseInt(value.getAmount())).reversed()).collect(Collectors.toList());
        if (isOver.booleanValue()) {
            if (multi.booleanValue()) {
                return this.getTimeOverDiscountMultiple((MultipleAreaFeeParamHolder)feeParamHolder, orderInfo, discountList, unpaidPrice, isThird);
            }
            return this.getTimeOverDiscount(feeParamHolder, parkChargeconfig, orderInfo, orderSumFeeDto, discountList, unpaidPrice, parkingTime, isThird);
        }
        if (multi.booleanValue()) {
            return this.getTimeOverDiscountMultiple((MultipleAreaFeeParamHolder)feeParamHolder, orderInfo, Lists.newArrayList((Object[])new OrderDiscount[]{(OrderDiscount)discountList.get(0)}), unpaidPrice, isThird);
        }
        return this.getTimeOverDiscount(feeParamHolder, parkChargeconfig, orderInfo, orderSumFeeDto, Lists.newArrayList((Object[])new OrderDiscount[]{(OrderDiscount)discountList.get(0)}), unpaidPrice, parkingTime, isThird);
    }

    private DiscountInfo getDiscountRate(List<OrderDiscount> discountList, BigDecimal totalPrice) {
        if (CollectionUtils.isEmpty(discountList)) {
            return new DiscountInfo(Lists.newArrayList(), BigDecimal.ZERO, BigDecimal.ZERO);
        }
        discountList = discountList.stream().sorted(Comparator.comparing(OrderDiscount::getAmount)).collect(Collectors.toList());
        OrderDiscount orderDiscount = (OrderDiscount)discountList.get(0);
        DiscountInfo rateOverDiscount = this.getRateOverDiscount(orderDiscount, totalPrice);
        log.info("[\u53e0\u52a0\u4f18\u60e0-\u6298\u62634] discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)rateOverDiscount);
        return rateOverDiscount;
    }

    private DiscountInfo getDiscountFree(List<OrderDiscount> discountList, BigDecimal unpaidPrice) {
        OrderDiscount orderDiscount = discountList.stream().max(Comparator.comparing(OrderDiscount::getSendTime)).get();
        DiscountInfo discountInfo = new DiscountInfo(Lists.newArrayList((Object[])new String[]{orderDiscount.getDiscountNo()}), unpaidPrice, unpaidPrice);
        discountInfo.setCouponsDiscountInfo(Lists.newArrayList((Object[])new OrderDiscount[]{orderDiscount}), orderDiscount.getThirdId() != null, unpaidPrice);
        log.info("[\u53e0\u52a0\u4f18\u60e0-\u5168\u514d] discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo);
        return discountInfo;
    }

    private DiscountInfo getDiscountDay(BaseFeeParamHolder feeParamHolder, ParkChargeconfig parkChargeconfig, OrderInfo orderInfo, List<OrderDiscount> discountList, BigDecimal unpaidPrice) {
        DiscountDay discountDay = this.discountDayDao.selectLastByPlateNum(orderInfo.getPlateNum(), orderInfo.getParkId());
        if (discountDay != null) {
            float discountDayAfterFee = unpaidPrice.floatValue();
            Date validStart = discountDay.getStartTime();
            Date validEnd = discountDay.getEndTime();
            Date startDate = new Date(orderInfo.getEnterTime() * 1000L);
            Date endDate = new Date(feeParamHolder.getEndTime() * 1000L);
            if (endDate.compareTo(validStart) > 0 && validEnd.compareTo(endDate) > 0) {
                discountDayAfterFee = 0.0f;
            } else if (endDate.compareTo(validEnd) > 0 && validEnd.compareTo(startDate) > 0) {
                int startTime = (int)(validEnd.getTime() / 1000L);
                discountDayAfterFee = this.chargeFee(feeParamHolder, orderInfo.getParkId(), parkChargeconfig.getId(), startTime, feeParamHolder.getEndTime().intValue(), 0, false, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), feeParamHolder.isUseFreetime());
            }
            List<OrderDiscount> orderDiscounts = discountList.stream().filter(od -> od.getDiscountNo().equals(discountDay.getDiscountNo())).collect(Collectors.toList());
            if (discountDayAfterFee > unpaidPrice.floatValue()) {
                DiscountInfo discountInfo = new DiscountInfo(Lists.newArrayList((Object[])new String[]{discountDay.getDiscountNo()}), unpaidPrice, BigDecimal.valueOf(discountDayAfterFee));
                discountInfo.setCouponsDiscountInfo(orderDiscounts, ((OrderDiscount)orderDiscounts.get(0)).getThirdId() != null, unpaidPrice);
                log.info("[\u53e0\u52a0\u4f18\u60e0-\u6309\u5929\u4f18\u514d1] discountList {} discountInfo {} ", (Object)JsonUtils.toString((Object)discountDay), (Object)discountInfo);
                return discountInfo;
            }
            DiscountInfo discountInfo = new DiscountInfo(Lists.newArrayList((Object[])new String[]{discountDay.getDiscountNo()}), unpaidPrice.subtract(BigDecimal.valueOf(discountDayAfterFee)).setScale(2, 4), unpaidPrice.subtract(BigDecimal.valueOf(discountDayAfterFee)).setScale(2, 4));
            discountInfo.setCouponsDiscountInfo(orderDiscounts, orderDiscounts.get(0).getThirdId() != null, unpaidPrice.subtract(BigDecimal.valueOf(discountDayAfterFee)).setScale(2, 4));
            log.info("[\u53e0\u52a0\u4f18\u60e0-\u6309\u5929\u4f18\u514d2] discountList {} discountInfo {} ", (Object)JsonUtils.toString((Object)discountDay), (Object)discountInfo);
            return discountInfo;
        }
        DiscountInfo discountInfo = new DiscountInfo(Lists.newArrayList(), BigDecimal.ZERO, BigDecimal.ZERO);
        log.info("[\u53e0\u52a0\u4f18\u60e0-\u6309\u5929\u4f18\u514d3] discountList {} discountInfo {} ", (Object)JsonUtils.toString((Object)discountDay), (Object)discountInfo);
        return discountInfo;
    }

    private DiscountInfo getRateOverDiscount(OrderDiscount orderDiscount, BigDecimal totalPrice) {
        BigDecimal rate = new BigDecimal(orderDiscount.getAmount());
        BigDecimal discountPrice = totalPrice.subtract(totalPrice.multiply(rate.multiply(BigDecimal.valueOf(0.1f))).setScale(2, 4));
        DiscountInfo discountInfo = new DiscountInfo(Lists.newArrayList((Object[])new String[]{orderDiscount.getDiscountNo()}), discountPrice, discountPrice);
        discountInfo.setCouponsDiscountInfo(Lists.newArrayList((Object[])new OrderDiscount[]{orderDiscount}), orderDiscount.getThirdId() != null, discountPrice);
        return discountInfo;
    }

    private DiscountInfo getTimeOverDiscountMultiple(MultipleAreaFeeParamHolder feeParamHolder, OrderInfo orderInfo, List<OrderDiscount> discountList, BigDecimal unpaidPrice, Boolean isThird) {
        int discountMinutesSum = discountList.stream().mapToInt(orderDiscount -> Integer.parseInt(orderDiscount.getAmount())).sum();
        if (discountMinutesSum <= 0 && isThird.booleanValue()) {
            DiscountInfo discountInfo = new DiscountInfo(Lists.newArrayList(), BigDecimal.ZERO, BigDecimal.ZERO);
            log.info("[\u53e0\u52a0\u4f18\u60e0-\u4f18\u60e0\u65f6\u957f\u5c0f\u4e8e0],discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo);
            return discountInfo;
        }
        Long outParkingTime = feeParamHolder.getOutParkTime();
        Long innerParkingTime = feeParamHolder.getInnerParkTime();
        ParkChargeconfig parkChargeconfig = feeParamHolder.getParkChargeConfig();
        ParkChargeconfig innerParkChargeconfig = feeParamHolder.getInnerParkChargeconfig();
        OrderSumFeeDto orderSumFeeDto = feeParamHolder.getOrderSumFeeDto();
        BigDecimal outUnPaidPrice = unpaidPrice;
        BigDecimal innerUnPayPrice = unpaidPrice;
        QueryOrderFeeResponse innerQueryOrderFeeResponse = feeParamHolder.getInnerQueryOrderFeeResponse();
        if (innerQueryOrderFeeResponse != null) {
            innerUnPayPrice = new BigDecimal(innerQueryOrderFeeResponse.getUnpayPrice());
            outUnPaidPrice = unpaidPrice.subtract(innerUnPayPrice).setScale(2, 4);
            log.info("[\u53e0\u52a0\u4f18\u60e0\u573a\u4e2d\u573a] innerunPaidPrice {}, outUnPaidPrice {} ", (Object)innerUnPayPrice, (Object)outUnPaidPrice);
        }
        if (outUnPaidPrice.compareTo(BigDecimal.ZERO) > 0 && outParkingTime >= (long)discountMinutesSum * 60L) {
            DiscountInfo discountInfo;
            float maxDiscountPrice = this.chargeFee(feeParamHolder, orderInfo.getParkId(), parkChargeconfig.getId(), feeParamHolder.getStartTime().intValue(), Math.toIntExact((long)feeParamHolder.getStartTime().intValue() + outParkingTime), discountMinutesSum, orderSumFeeDto != null, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), feeParamHolder.isUseFreetime());
            BigDecimal discountPrice = outUnPaidPrice.subtract(BigDecimal.valueOf(maxDiscountPrice));
            discountPrice = discountPrice.compareTo(BigDecimal.ZERO) > 0 ? discountPrice : BigDecimal.ZERO;
            discountPrice = discountPrice.compareTo(unpaidPrice) > 0 ? unpaidPrice : discountPrice;
            ArrayList discountNos = Lists.newArrayList();
            ArrayList usedDiscountList = Lists.newArrayList();
            int discountTime = 0;
            for (OrderDiscount orderDiscount2 : discountList) {
                discountNos.add(orderDiscount2.getDiscountNo());
                usedDiscountList.add(orderDiscount2);
                if ((long)(discountTime += Integer.parseInt(orderDiscount2.getAmount())) * 60L < outParkingTime) continue;
                break;
            }
            if ((long)discountTime * 60L > outParkingTime) {
                discountInfo = new DiscountInfo(discountNos, outUnPaidPrice, discountPrice);
                discountInfo.setCouponsDiscountInfo(usedDiscountList, isThird, outUnPaidPrice);
                log.info("[\u53e0\u52a0\u4f18\u60e0\u573a\u4e2d\u573a-\u65f6\u95f41] discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo);
                return discountInfo;
            }
            discountInfo = new DiscountInfo(discountNos, discountPrice, discountPrice);
            discountInfo.setCouponsDiscountInfo(usedDiscountList, isThird, discountPrice);
            log.info("[\u53e0\u52a0\u4f18\u60e0\u573a\u4e2d\u573a-\u65f6\u95f42] discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo);
            return discountInfo;
        }
        BigDecimal outDiscountPrice = BigDecimal.ZERO;
        long innerParkingDiscountMinutes = discountMinutesSum;
        if (outUnPaidPrice.compareTo(BigDecimal.ZERO) > 0) {
            float maxDiscountPrice = this.chargeFee(feeParamHolder, orderInfo.getParkId(), parkChargeconfig.getId(), feeParamHolder.getStartTime().intValue(), Math.toIntExact((long)feeParamHolder.getStartTime().intValue() + outParkingTime), discountMinutesSum, orderSumFeeDto != null, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), feeParamHolder.isUseFreetime());
            outDiscountPrice = outUnPaidPrice.subtract(BigDecimal.valueOf(maxDiscountPrice));
            outDiscountPrice = outDiscountPrice.compareTo(BigDecimal.ZERO) > 0 ? outDiscountPrice : BigDecimal.ZERO;
            outDiscountPrice = outDiscountPrice.compareTo(outUnPaidPrice) > 0 ? unpaidPrice : outDiscountPrice;
            log.info("[\u53e0\u52a0\u4f18\u60e0\u573a\u4e2d\u573a-\u5927\u573a\u4f18\u60e0] maxDiscountPrice {} outDiscountPrice {} ", (Object)Float.valueOf(maxDiscountPrice), (Object)outDiscountPrice);
            innerParkingDiscountMinutes = (long)discountMinutesSum - outParkingTime / 60L;
        }
        BigDecimal innerDiscountPrice = BigDecimal.ZERO;
        if (innerUnPayPrice.compareTo(BigDecimal.ZERO) > 0 && innerParkingDiscountMinutes > 0L) {
            float innerMaxDiscountPrice = this.chargeFee(feeParamHolder, orderInfo.getParkId(), innerParkChargeconfig.getId(), feeParamHolder.getInnerStartTime().intValue(), feeParamHolder.getInnerEndTime().intValue(), (int)innerParkingDiscountMinutes, orderSumFeeDto != null, orderInfo.getCarType(), feeParamHolder.isInnerCsMonthCarFee(), feeParamHolder.getInnerCsFeeType(), feeParamHolder.getInnerCsStartTime(), feeParamHolder.getInnerCsEndTime(), feeParamHolder.getInnerCsSwitchTime(), feeParamHolder.isUseFreetime(), parkChargeconfig, 2);
            innerDiscountPrice = innerUnPayPrice.subtract(BigDecimal.valueOf(innerMaxDiscountPrice));
            innerDiscountPrice = innerDiscountPrice.compareTo(BigDecimal.ZERO) > 0 ? innerDiscountPrice : BigDecimal.ZERO;
            innerDiscountPrice = innerDiscountPrice.compareTo(innerUnPayPrice) > 0 ? innerUnPayPrice : innerDiscountPrice;
            log.info("[\u53e0\u52a0\u4f18\u60e0\u573a\u4e2d\u573a-\u5c0f\u573a\u4f18\u60e0] innerMaxDiscountPrice {} innerDiscountPrice {} ", (Object)Float.valueOf(innerMaxDiscountPrice), (Object)innerDiscountPrice);
        }
        BigDecimal totalDiscountPrice = innerDiscountPrice.add(outDiscountPrice);
        ArrayList discountNos = Lists.newArrayList();
        ArrayList usedDiscountList = Lists.newArrayList();
        int discountTime = 0;
        for (OrderDiscount orderDiscount3 : discountList) {
            discountNos.add(orderDiscount3.getDiscountNo());
            usedDiscountList.add(orderDiscount3);
            if ((long)(discountTime += Integer.parseInt(orderDiscount3.getAmount())) * 60L <= outParkingTime + innerParkingTime) continue;
            break;
        }
        DiscountInfo discountInfo = new DiscountInfo(discountNos, totalDiscountPrice, totalDiscountPrice);
        discountInfo.setCouponsDiscountInfo(usedDiscountList, isThird, totalDiscountPrice);
        log.info("[\u53e0\u52a0\u4f18\u60e0\u573a\u4e2d\u573a-\u65f6\u95f43] discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo);
        return discountInfo;
    }

    private DiscountInfo getTimeOverDiscount(BaseFeeParamHolder feeParamHolder, ParkChargeconfig parkChargeconfig, OrderInfo orderInfo, OrderSumFeeDto orderSumFeeDto, List<OrderDiscount> discountList, BigDecimal unpaidPrice, Long parkingTime, Boolean isThird) {
        DiscountInfo discountInfo;
        int discountMinutesSum = discountList.stream().mapToInt(orderDiscount -> Integer.parseInt(orderDiscount.getAmount())).sum();
        if (discountMinutesSum <= 0 && isThird.booleanValue()) {
            DiscountInfo discountInfo2 = new DiscountInfo(Lists.newArrayList(), BigDecimal.ZERO, BigDecimal.ZERO);
            log.info("[\u53e0\u52a0\u4f18\u60e0-\u4f18\u60e0\u65f6\u957f\u5c0f\u4e8e0],discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo2);
            return discountInfo2;
        }
        float maxDiscountPrice = this.chargeFee(feeParamHolder, orderInfo.getParkId(), parkChargeconfig.getId(), feeParamHolder.getStartTime().intValue(), feeParamHolder.getEndTime().intValue(), discountMinutesSum, orderSumFeeDto != null, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(), feeParamHolder.isUseFreetime());
        if (isThird.booleanValue()) {
            BigDecimal discountPrice = unpaidPrice.subtract(BigDecimal.valueOf(maxDiscountPrice));
            discountPrice = discountPrice.compareTo(BigDecimal.ZERO) > 0 ? discountPrice : BigDecimal.ZERO;
            discountPrice = discountPrice.compareTo(unpaidPrice) > 0 ? unpaidPrice : discountPrice;
            DiscountInfo discountInfo3 = new DiscountInfo(discountList.stream().map(OrderDiscount::getDiscountNo).collect(Collectors.toList()), discountPrice, discountPrice);
            discountInfo3.setCouponsDiscountInfo(discountList, isThird, discountPrice);
            return discountInfo3;
        }
        BigDecimal discountPrice = unpaidPrice.subtract(BigDecimal.valueOf(maxDiscountPrice));
        discountPrice = discountPrice.compareTo(BigDecimal.ZERO) > 0 ? discountPrice : BigDecimal.ZERO;
        discountPrice = discountPrice.compareTo(unpaidPrice) > 0 ? unpaidPrice : discountPrice;
        ArrayList discountNos = Lists.newArrayList();
        ArrayList usedList = Lists.newArrayList();
        int discountTime = 0;
        for (OrderDiscount orderDiscount2 : discountList) {
            discountNos.add(orderDiscount2.getDiscountNo());
            usedList.add(orderDiscount2);
            if ((long)(discountTime += Integer.parseInt(orderDiscount2.getAmount())) < parkingTime / 60L) continue;
            break;
        }
        if ((long)discountTime >= parkingTime / 60L) {
            discountInfo = new DiscountInfo(discountNos, unpaidPrice, discountPrice);
            discountInfo.setCouponsDiscountInfo(usedList, isThird, unpaidPrice);
            log.info("[\u53e0\u52a0\u4f18\u60e0-\u65f6\u95f41] discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo);
            return discountInfo;
        }
        discountInfo = new DiscountInfo(discountNos, discountPrice, discountPrice);
        discountInfo.setCouponsDiscountInfo(usedList, isThird, discountPrice);
        log.info("[\u53e0\u52a0\u4f18\u60e0-\u65f6\u95f42] discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo);
        return discountInfo;
    }

    private DiscountInfo getPriceOverDiscount(List<OrderDiscount> discountList, BigDecimal unpaidPrice, Boolean isThird) {
        DiscountInfo discountInfo;
        double discountPriceSum = discountList.stream().mapToDouble(orderDiscount -> Double.parseDouble(orderDiscount.getAmount())).sum();
        if (discountPriceSum <= 0.0 && isThird.booleanValue()) {
            DiscountInfo discountInfo2 = new DiscountInfo(Lists.newArrayList(), BigDecimal.ZERO, BigDecimal.ZERO);
            log.info("[\u53e0\u52a0\u4f18\u60e0-\u4f18\u60e0\u91d1\u989d\u5c0f\u4e8e0],discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo2);
            return discountInfo2;
        }
        if (isThird.booleanValue()) {
            if (BigDecimal.valueOf(discountPriceSum).compareTo(unpaidPrice) > 0) {
                DiscountInfo discountInfo3 = new DiscountInfo(discountList.stream().map(OrderDiscount::getDiscountNo).collect(Collectors.toList()), unpaidPrice, BigDecimal.valueOf(discountPriceSum));
                discountInfo3.setCouponsDiscountInfo(discountList, isThird, unpaidPrice);
                return discountInfo3;
            }
            DiscountInfo discountInfo4 = new DiscountInfo(discountList.stream().map(OrderDiscount::getDiscountNo).collect(Collectors.toList()), BigDecimal.valueOf(discountPriceSum), BigDecimal.valueOf(discountPriceSum));
            discountInfo4.setCouponsDiscountInfo(discountList, isThird, BigDecimal.valueOf(discountPriceSum));
            return discountInfo4;
        }
        ArrayList discountNos = Lists.newArrayList();
        BigDecimal discountPrice = BigDecimal.ZERO;
        ArrayList usedDiscountList = Lists.newArrayList();
        for (OrderDiscount orderDiscount2 : discountList) {
            discountNos.add(orderDiscount2.getDiscountNo());
            usedDiscountList.add(orderDiscount2);
            if ((discountPrice = discountPrice.add(BigDecimal.valueOf(Double.parseDouble(orderDiscount2.getAmount())))).compareTo(unpaidPrice) < 0) continue;
            break;
        }
        if (discountPrice.compareTo(unpaidPrice) > 0) {
            discountInfo = new DiscountInfo(discountNos, unpaidPrice, BigDecimal.valueOf(discountPriceSum));
            discountInfo.setCouponsDiscountInfo(usedDiscountList, isThird, unpaidPrice);
            log.info("[\u53e0\u52a0\u4f18\u60e0-\u91d1\u989d1] discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo);
            return discountInfo;
        }
        discountInfo = new DiscountInfo(discountNos, BigDecimal.valueOf(discountPriceSum), BigDecimal.valueOf(discountPriceSum));
        discountInfo.setCouponsDiscountInfo(usedDiscountList, isThird, BigDecimal.valueOf(discountPriceSum));
        log.info("[\u53e0\u52a0\u4f18\u60e0-\u91d1\u989d2] discountList {} discountInfo {} ", (Object)JsonUtils.toString(discountList), (Object)discountInfo);
        return discountInfo;
    }

    public static class DiscountInfo
    implements Serializable {
        private List<String> discountNos;
        private BigDecimal discountPrice;
        private BigDecimal maxDiscountPrice;
        private BigDecimal thirdDiscountPrice;
        private BigDecimal merchantDiscountPrice;
        private OrderPayDiscount.ThirdCouponsInfo thirdCouponsInfo;
        private OrderPayDiscount.MerchantCouponsInfo merchantCouponsInfo;

        public DiscountInfo(List<String> discountNos, BigDecimal discountPrice, BigDecimal maxDiscountPrice) {
            this.discountNos = discountNos;
            this.discountPrice = discountPrice;
            this.maxDiscountPrice = maxDiscountPrice;
        }

        public void setThirdCouponsInfo(OrderPayDiscount.ThirdCouponsInfo thirdCouponsInfo) {
            this.thirdCouponsInfo = thirdCouponsInfo;
        }

        public void setMerchantCouponsInfo(OrderPayDiscount.MerchantCouponsInfo merchantCouponsInfo) {
            this.merchantCouponsInfo = merchantCouponsInfo;
        }

        public void setCouponsDiscountInfo(List<OrderDiscount> usedDiscountList, Boolean isThird, BigDecimal discountPrice) {
            for (OrderDiscount orderDiscount : usedDiscountList) {
                if (orderDiscount.getFrom() == 2) {
                    this.thirdCouponsInfo = this.thirdCouponsInfo == null ? new OrderPayDiscount.ThirdCouponsInfo() : this.thirdCouponsInfo;
                    this.thirdCouponsInfo.addThirdId(orderDiscount.getThirdId());
                    this.thirdCouponsInfo.addDiscountType(orderDiscount.getType());
                    this.thirdCouponsInfo.addDiscountName(orderDiscount.getDiscountName());
                    this.thirdCouponsInfo.setDiscountPrice(discountPrice);
                    continue;
                }
                if (orderDiscount.getFrom() != 1) continue;
                this.merchantCouponsInfo = this.merchantCouponsInfo == null ? new OrderPayDiscount.MerchantCouponsInfo() : this.merchantCouponsInfo;
                this.merchantCouponsInfo.addMerchantId(orderDiscount.getMerchantId());
                this.merchantCouponsInfo.addDiscountType(orderDiscount.getType());
                this.merchantCouponsInfo.addDiscountName(orderDiscount.getDiscountName());
                this.merchantCouponsInfo.setDiscountPrice(discountPrice);
            }
            if (isThird.booleanValue()) {
                this.thirdDiscountPrice = discountPrice;
            } else {
                this.merchantDiscountPrice = discountPrice;
            }
        }

        public List<String> getDiscountNos() {
            return this.discountNos;
        }

        public BigDecimal getDiscountPrice() {
            return this.discountPrice;
        }

        public BigDecimal getMaxDiscountPrice() {
            return this.maxDiscountPrice;
        }

        public BigDecimal getThirdDiscountPrice() {
            return this.thirdDiscountPrice;
        }

        public BigDecimal getMerchantDiscountPrice() {
            return this.merchantDiscountPrice;
        }

        public OrderPayDiscount.ThirdCouponsInfo getThirdCouponsInfo() {
            return this.thirdCouponsInfo;
        }

        public OrderPayDiscount.MerchantCouponsInfo getMerchantCouponsInfo() {
            return this.merchantCouponsInfo;
        }

        public void setDiscountNos(List<String> discountNos) {
            this.discountNos = discountNos;
        }

        public void setDiscountPrice(BigDecimal discountPrice) {
            this.discountPrice = discountPrice;
        }

        public void setMaxDiscountPrice(BigDecimal maxDiscountPrice) {
            this.maxDiscountPrice = maxDiscountPrice;
        }

        public void setThirdDiscountPrice(BigDecimal thirdDiscountPrice) {
            this.thirdDiscountPrice = thirdDiscountPrice;
        }

        public void setMerchantDiscountPrice(BigDecimal merchantDiscountPrice) {
            this.merchantDiscountPrice = merchantDiscountPrice;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiscountInfo)) {
                return false;
            }
            DiscountInfo other = (DiscountInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$discountNos = this.getDiscountNos();
            List<String> other$discountNos = other.getDiscountNos();
            if (this$discountNos == null ? other$discountNos != null : !((Object)this$discountNos).equals(other$discountNos)) {
                return false;
            }
            BigDecimal this$discountPrice = this.getDiscountPrice();
            BigDecimal other$discountPrice = other.getDiscountPrice();
            if (this$discountPrice == null ? other$discountPrice != null : !((Object)this$discountPrice).equals(other$discountPrice)) {
                return false;
            }
            BigDecimal this$maxDiscountPrice = this.getMaxDiscountPrice();
            BigDecimal other$maxDiscountPrice = other.getMaxDiscountPrice();
            if (this$maxDiscountPrice == null ? other$maxDiscountPrice != null : !((Object)this$maxDiscountPrice).equals(other$maxDiscountPrice)) {
                return false;
            }
            BigDecimal this$thirdDiscountPrice = this.getThirdDiscountPrice();
            BigDecimal other$thirdDiscountPrice = other.getThirdDiscountPrice();
            if (this$thirdDiscountPrice == null ? other$thirdDiscountPrice != null : !((Object)this$thirdDiscountPrice).equals(other$thirdDiscountPrice)) {
                return false;
            }
            BigDecimal this$merchantDiscountPrice = this.getMerchantDiscountPrice();
            BigDecimal other$merchantDiscountPrice = other.getMerchantDiscountPrice();
            if (this$merchantDiscountPrice == null ? other$merchantDiscountPrice != null : !((Object)this$merchantDiscountPrice).equals(other$merchantDiscountPrice)) {
                return false;
            }
            OrderPayDiscount.ThirdCouponsInfo this$thirdCouponsInfo = this.getThirdCouponsInfo();
            OrderPayDiscount.ThirdCouponsInfo other$thirdCouponsInfo = other.getThirdCouponsInfo();
            if (this$thirdCouponsInfo == null ? other$thirdCouponsInfo != null : !this$thirdCouponsInfo.equals(other$thirdCouponsInfo)) {
                return false;
            }
            OrderPayDiscount.MerchantCouponsInfo this$merchantCouponsInfo = this.getMerchantCouponsInfo();
            OrderPayDiscount.MerchantCouponsInfo other$merchantCouponsInfo = other.getMerchantCouponsInfo();
            return !(this$merchantCouponsInfo == null ? other$merchantCouponsInfo != null : !this$merchantCouponsInfo.equals(other$merchantCouponsInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DiscountInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $discountNos = this.getDiscountNos();
            result = result * 59 + ($discountNos == null ? 43 : ((Object)$discountNos).hashCode());
            BigDecimal $discountPrice = this.getDiscountPrice();
            result = result * 59 + ($discountPrice == null ? 43 : ((Object)$discountPrice).hashCode());
            BigDecimal $maxDiscountPrice = this.getMaxDiscountPrice();
            result = result * 59 + ($maxDiscountPrice == null ? 43 : ((Object)$maxDiscountPrice).hashCode());
            BigDecimal $thirdDiscountPrice = this.getThirdDiscountPrice();
            result = result * 59 + ($thirdDiscountPrice == null ? 43 : ((Object)$thirdDiscountPrice).hashCode());
            BigDecimal $merchantDiscountPrice = this.getMerchantDiscountPrice();
            result = result * 59 + ($merchantDiscountPrice == null ? 43 : ((Object)$merchantDiscountPrice).hashCode());
            OrderPayDiscount.ThirdCouponsInfo $thirdCouponsInfo = this.getThirdCouponsInfo();
            result = result * 59 + ($thirdCouponsInfo == null ? 43 : $thirdCouponsInfo.hashCode());
            OrderPayDiscount.MerchantCouponsInfo $merchantCouponsInfo = this.getMerchantCouponsInfo();
            result = result * 59 + ($merchantCouponsInfo == null ? 43 : $merchantCouponsInfo.hashCode());
            return result;
        }

        public String toString() {
            return "DiscountOverHandle.DiscountInfo(discountNos=" + this.getDiscountNos() + ", discountPrice=" + this.getDiscountPrice() + ", maxDiscountPrice=" + this.getMaxDiscountPrice() + ", thirdDiscountPrice=" + this.getThirdDiscountPrice() + ", merchantDiscountPrice=" + this.getMerchantDiscountPrice() + ", thirdCouponsInfo=" + this.getThirdCouponsInfo() + ", merchantCouponsInfo=" + this.getMerchantCouponsInfo() + ")";
        }

        public DiscountInfo() {
        }

        public DiscountInfo(List<String> discountNos, BigDecimal discountPrice, BigDecimal maxDiscountPrice, BigDecimal thirdDiscountPrice, BigDecimal merchantDiscountPrice, OrderPayDiscount.ThirdCouponsInfo thirdCouponsInfo, OrderPayDiscount.MerchantCouponsInfo merchantCouponsInfo) {
            this.discountNos = discountNos;
            this.discountPrice = discountPrice;
            this.maxDiscountPrice = maxDiscountPrice;
            this.thirdDiscountPrice = thirdDiscountPrice;
            this.merchantDiscountPrice = merchantDiscountPrice;
            this.thirdCouponsInfo = thirdCouponsInfo;
            this.merchantCouponsInfo = merchantCouponsInfo;
        }
    }
}

