/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.queryfee;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.icetech.basics.constants.RegionChargePlateTypeConsts;
import com.icetech.basics.domain.entity.NotWorkDay;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.basics.service.charge.impl.ParkChargeConfigServiceImpl;
import com.icetech.basics.service.other.NotWorkDayServiceImpl;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.order.SumPayByOrderNumDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.PlateColorEnum;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.DateUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.service.impl.OrderCarInfoServiceImpl;
import com.icetech.park.config.JdbcProperties;
import com.icetech.park.service.park.impl.ParkRegionServiceImpl;
import com.icetech.park.service.park.impl.RegionChargeconfigServiceImpl;
import com.icetech.park.service.runso.Clibrary;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseQueryFeeChain {
    private static final Logger log = LoggerFactory.getLogger(BaseQueryFeeChain.class);
    private static final Long SYS_START_TIME = 1546272000L;
    @Autowired
    private JdbcProperties jdbcProperties;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private ParkRegionServiceImpl parkRegionService;
    @Autowired
    private OrderCarInfoServiceImpl orderCarInfoService;
    @Autowired
    private RegionChargeconfigServiceImpl regionChargeconfigService;
    @Autowired
    private ParkChargeConfigServiceImpl parkChargeConfigService;
    @Autowired
    private NotWorkDayServiceImpl notWorkDayService;
    protected static DecimalFormat FORMAT = new DecimalFormat("###.##");

    protected float chargeFee(BaseFeeParamHolder feeParamHolder, Long parkId, Integer billId, int startTime, int tmExit, int discountMinutes, boolean isPaid, Integer carType, boolean isCsMonthCarFee, int csFeeType, String csStartTime, String csEndTime, Long csSwitchTime, boolean isUseFreetime) {
        return this.chargeFee(feeParamHolder, parkId, billId, startTime, tmExit, discountMinutes, isPaid, carType, isCsMonthCarFee, csFeeType, csStartTime, csEndTime, csSwitchTime, isUseFreetime, feeParamHolder.getParkChargeConfig(billId), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float chargeFee(BaseFeeParamHolder feeParamHolder, Long parkId, Integer billId, int startTime, int tmExit, int discountMinutes, boolean isPaid, Integer carType, boolean isCsMonthCarFee, int csFeeType, String csStartTime, String csEndTime, Long csSwitchTime, boolean isUseFreetime, ParkChargeconfig parkChargeconfig, int areaType) {
        float fee;
        if ((long)startTime < SYS_START_TIME) {
            throw new ResponseBodyException("3001", "\u8ba1\u8d39\u5f00\u59cb\u65f6\u95f4\u975e\u6cd5");
        }
        Clibrary instance = Clibrary.INSTANTCE;
        int chargeFlag = isPaid ? 1 : 0;
        int useFreeTime = isUseFreetime ? 0 : 1;
        long before = System.currentTimeMillis();
        try {
            String sChargeConfigCfg = feeParamHolder.getSChargeConfigCfg(feeParamHolder.getParkConfig());
            parkChargeconfig = parkChargeconfig == null ? feeParamHolder.getParkChargeConfig(billId) : parkChargeconfig;
            String sChargeRule = feeParamHolder.getSChargeRule(parkChargeconfig);
            log.info("[SO\u8ba1\u7b97\u8d39\u7528] startTime:{},tmExit:{}, \u8ba1\u8d39\u65f6\u957f:{}, discountMinutes:{},chargeFlag:{},carType:{},parkId:{},{},{},{},{},{}, {}", new Object[]{startTime, tmExit, tmExit - startTime, discountMinutes, chargeFlag, carType, parkId, csStartTime, csEndTime, csFeeType, csSwitchTime, useFreeTime, parkChargeconfig.getBilltypename()});
            fee = isCsMonthCarFee ? instance.chargeinterface_time_json(startTime, tmExit, discountMinutes, chargeFlag, carType, sChargeConfigCfg, sChargeRule, csStartTime, csEndTime, csFeeType, csSwitchTime == null ? 0 : csSwitchTime.intValue(), useFreeTime) : instance.chargeinterface_json(startTime, tmExit, discountMinutes, chargeFlag, carType, sChargeConfigCfg, sChargeRule, useFreeTime);
            log.info("[SO\u8ba1\u7b97\u8d39\u7528] [{}]\u5143", (Object)Float.valueOf(fee));
            if (fee < 0.0f) {
                float old;
                String dbserver = this.jdbcProperties.getHost();
                String username = this.jdbcProperties.getUsername();
                String password = this.jdbcProperties.getPassword();
                if (isCsMonthCarFee) {
                    log.info("[SO\u8ba1\u7b97\u8d39\u7528] startTime:{},tmExit:{}, \u8ba1\u8d39\u65f6\u957f:{},discountMinutes:{},chargeFlag:{},carType:{},parkId:{},billId:{},{},{},{},{},{},{},{},{}", new Object[]{startTime, tmExit, tmExit - startTime, discountMinutes, chargeFlag, carType, parkId.intValue(), billId, dbserver, username, password, csStartTime, csEndTime, csFeeType, csSwitchTime == null ? 0 : csSwitchTime.intValue(), useFreeTime});
                    old = instance.chargeinterface_time_db_freetime(startTime, tmExit, discountMinutes, chargeFlag, carType, parkId.intValue(), billId, dbserver, username, password, csStartTime, csEndTime, csFeeType, csSwitchTime == null ? 0 : csSwitchTime.intValue(), useFreeTime);
                } else {
                    old = instance.chargeinterface_db_freetime(startTime, tmExit, discountMinutes, chargeFlag, carType, parkId.intValue(), billId, dbserver, username, password, useFreeTime);
                }
                log.info("[SO\u65e7\u7248\u8ba1\u7b97\u8d39\u7528] \u65e7\u7248\u672c\u8c03\u7528so\u83b7\u53d6\u8d39\u7528[{}]\u5143", (Object)Float.valueOf(old));
                if (NumberUtils.parseDecimal((Object)Float.valueOf(fee)).compareTo(NumberUtils.parseDecimal((Object)Float.valueOf(old))) == 0) {
                    log.warn("[\u76d1\u63a7\u57cb\u70b9] \u8ba1\u8d39SO\u65b0\u65e7\u7248\u672c\u83b7\u53d6\u8d39\u7528\u4e0d\u4e00\u81f4, new[{}], old[{}]", (Object)Float.valueOf(fee), (Object)Float.valueOf(old));
                    fee = old;
                }
            }
            if (fee < 0.0f) {
                log.warn("[SO\u8ba1\u7b97\u8d39\u7528] \u8c03\u7528so\u83b7\u53d6\u8d39\u7528\u5931\u8d25, sChargeConfigCfg[{}], sChargeRule[{}]", (Object)sChargeConfigCfg, (Object)sChargeRule);
                throw new ResponseBodyException("3001", "so\u8ba1\u8d39\u5931\u8d25");
            }
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - before;
            if (elapsedTime > 2000L) {
                log.warn("[SO\u8ba1\u7b97\u8d39\u7528] \u8ba1\u8d39\u7528\u65f6[{}]\u6beb\u79d2", (Object)elapsedTime);
            }
        }
        BigDecimal bg = new BigDecimal(fee);
        fee = bg.setScale(2, RoundingMode.HALF_UP).floatValue();
        log.info("[SO\u8ba1\u7b97\u8d39\u7528] \u56db\u820d\u4e94\u5165\u53d6\u4e24\u4f4d\u5c0f\u6570\u540e\u4e3a[{}]\u5143", (Object)Float.valueOf(fee));
        Integer isnotgetsmallchange = feeParamHolder.getParkConfig().getIsnotgetsmallchange();
        if (isnotgetsmallchange != null && isnotgetsmallchange == 1) {
            float ys = fee % 1.0f;
            fee = (double)ys >= 0.5 ? (float)((int)fee) + 0.5f : (float)((int)fee);
        }
        return fee;
    }

    protected Integer getFeeStatus(Float paidAmount, Float unPayPrice, Float discountPrice, Float discountAmount, Float totalAmount) {
        log.info("[\u5224\u65ad\u8d39\u7528\u72b6\u6001] paidAmount[{}], unPayPrice[{}], discountPrice[{}], discountAmount[{}], totalAmount[{}]", new Object[]{paidAmount, unPayPrice, discountPrice, discountAmount, totalAmount});
        if (totalAmount.floatValue() == 0.0f) {
            return 1;
        }
        if (discountAmount.equals(totalAmount)) {
            return 3;
        }
        if ((unPayPrice.floatValue() > 0.0f || discountPrice.floatValue() >= totalAmount.floatValue()) && paidAmount.floatValue() == 0.0f && discountAmount.floatValue() == 0.0f) {
            return 2;
        }
        if (unPayPrice.floatValue() == 0.0f && paidAmount.floatValue() > 0.0f) {
            return 3;
        }
        if (unPayPrice.floatValue() > 0.0f && (paidAmount.floatValue() > 0.0f || discountAmount.floatValue() > 0.0f)) {
            return 4;
        }
        if (unPayPrice.floatValue() > 0.0f) {
            return 2;
        }
        return 1;
    }

    protected QueryOrderFeeResponse getFreeRet(OrderInfo orderInfo, Long queryTime, Long parkTime, int freeTimeAfterPay, String parkName) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        this.setBasePara(orderInfo, queryOrderFeeResponse, parkTime, freeTimeAfterPay, parkName, queryTime);
        queryOrderFeeResponse.setStatus(Integer.valueOf(1));
        queryOrderFeeResponse.setPaidAmount(FORMAT.format(0L));
        queryOrderFeeResponse.setDiscountAmount(FORMAT.format(0L));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(0L));
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(0L));
        queryOrderFeeResponse.setTotalAmount(FORMAT.format(0L));
        return queryOrderFeeResponse;
    }

    protected QueryOrderFeeResponse getFreeRetWithPaidPrice(OrderInfo orderInfo, Long queryTime, Long parkTime, int freeTimeAfterPay, String parkName) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        this.setBasePara(orderInfo, queryOrderFeeResponse, parkTime, freeTimeAfterPay, parkName, queryTime);
        OrderSumFeeDto feeDto = this.getPaidFee(orderInfo.getOrderNum(), orderInfo.getParkId());
        if (feeDto == null) {
            queryOrderFeeResponse.setStatus(Integer.valueOf(1));
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(0L));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(0L));
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(0L));
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(0L));
            queryOrderFeeResponse.setTotalAmount(FORMAT.format(0L));
        } else {
            queryOrderFeeResponse.setStatus(Integer.valueOf(3));
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(feeDto.getPaidPrice()));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(feeDto.getDiscountPrice()));
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(0L));
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(0L));
            queryOrderFeeResponse.setTotalAmount(FORMAT.format(feeDto.getTotalPrice()));
            queryOrderFeeResponse.setPayTime(feeDto.getLastPayTime());
        }
        return queryOrderFeeResponse;
    }

    protected void setBasePara(OrderInfo orderInfo, QueryOrderFeeResponse queryOrderFeeResponse, Long parkTime, int freeTimeAfterPay, String parkName, Long queryTime) {
        queryOrderFeeResponse.setOrderNum(orderInfo.getOrderNum());
        queryOrderFeeResponse.setPlateNum(orderInfo.getPlateNum());
        queryOrderFeeResponse.setEnterTime(orderInfo.getEnterTime());
        queryOrderFeeResponse.setQueryTime(Long.valueOf(queryTime == null ? DateTools.unixTimestamp() : queryTime));
        queryOrderFeeResponse.setParkTime(parkTime);
        queryOrderFeeResponse.setParkName(parkName);
        queryOrderFeeResponse.setFreeTime(Long.valueOf(freeTimeAfterPay));
        queryOrderFeeResponse.setCarType(orderInfo.getCarType());
    }

    protected OrderSumFeeDto getPaidFee(String orderNum, Long parkId) {
        OrderPay orderPay = new OrderPay();
        orderPay.setParkId(parkId);
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(Integer.valueOf(2));
        return this.orderPayDao.sumFee(orderPay);
    }

    protected BigDecimal getMaxFeePara(BaseFeeParamHolder feeParamHolder, OrderInfo orderInfo, Integer billId, Date endDate, Date beginTime, Float dayNightMaxfee) {
        List sumPayByOrderNumDtos = this.orderPayDao.sumPaidPriceByPlateNum(orderInfo.getParkId(), orderInfo.getPlateNum(), Long.valueOf(beginTime.getTime() / 1000L), Long.valueOf(endDate.getTime() / 1000L));
        if (CollectionUtils.isEmpty((Collection)sumPayByOrderNumDtos)) {
            return null;
        }
        List geBeginTimeDtos = sumPayByOrderNumDtos.stream().filter(sumPayByOrderNumDto -> sumPayByOrderNumDto.getEnterTime() > beginTime.getTime() / 1000L).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(geBeginTimeDtos) && sumPayByOrderNumDtos.size() > 0) {
            long next24HoursOfFirstEnterTime;
            long firstDiffDays;
            SumPayByOrderNumDto lqBeginTimeDto = (SumPayByOrderNumDto)sumPayByOrderNumDtos.get(0);
            log.info("[\u65b0\u7248\u672c24\u5c0f\u65f6\u6309\u5165\u573a\u6700\u5927\u6536\u8d39] \u4e0a\u4e2a\u8ba2\u5355\u5165\u573a\u5728\u5f53\u524d\u8ba2\u5355\u5165\u573a\u524d24\u5c0f\u65f6\u4e4b\u524d[{}]", (Object)lqBeginTimeDto);
            Long firstEnterTime = lqBeginTimeDto.getEnterTime();
            Long firstExitTime = lqBeginTimeDto.getExitTime();
            long firstOrderParkTime = 0L;
            if (firstExitTime != null && firstEnterTime != 0L) {
                firstOrderParkTime = firstExitTime - firstEnterTime;
            }
            long l = firstDiffDays = firstOrderParkTime <= 0L ? 1L : firstOrderParkTime / 86400L + 1L;
            if (firstEnterTime + firstDiffDays * 24L * 3600L <= orderInfo.getEnterTime()) {
                return null;
            }
            float paidPriceSum = lqBeginTimeDto.getTotalPrice().floatValue() - dayNightMaxfee.floatValue() * (float)(firstDiffDays - 1L);
            if (paidPriceSum == 0.0f) {
                return null;
            }
            if (lqBeginTimeDto.getPaidPrice().floatValue() < paidPriceSum) {
                log.info("[\u65b0\u7248\u672c24\u5c0f\u65f6\u6309\u5165\u573a\u6700\u5927\u6536\u8d39] \u5b9e\u6536\u5c0f\u4e8e\u5e94\u6536, \u5b9e\u6536[{}]", (Object)Float.valueOf(paidPriceSum));
                paidPriceSum = lqBeginTimeDto.getPaidPrice().floatValue();
            }
            if ((next24HoursOfFirstEnterTime = firstEnterTime + 86400L * firstDiffDays) >= endDate.getTime() / 1000L) {
                return new BigDecimal(dayNightMaxfee.floatValue()).subtract(new BigDecimal(paidPriceSum));
            }
            float suffixFee = this.chargeFee(feeParamHolder, orderInfo.getParkId(), billId, (int)next24HoursOfFirstEnterTime, (int)(endDate.getTime() / 1000L), 0, false, orderInfo.getCarType(), false, 0, null, null, null, false);
            return new BigDecimal(dayNightMaxfee.floatValue()).subtract(new BigDecimal(paidPriceSum)).add(new BigDecimal(suffixFee));
        }
        if (CollectionUtils.isNotEmpty(geBeginTimeDtos)) {
            SumPayByOrderNumDto sumPayByOrderNumDto2 = (SumPayByOrderNumDto)geBeginTimeDtos.get(0);
            log.info("[\u65b0\u7248\u672c24\u5c0f\u65f6\u6309\u5165\u573a\u6700\u5927\u6536\u8d39] \u4e0a\u4e2a\u8ba2\u5355\u5165\u573a\u5728\u5f53\u524d\u8ba2\u5355\u5165\u573a\u524d24\u5c0f\u65f6\u4e4b\u540e[{}]", (Object)sumPayByOrderNumDto2);
            Long firstEnterTime = sumPayByOrderNumDto2.getEnterTime();
            double paidPriceSum = geBeginTimeDtos.stream().collect(Collectors.summarizingDouble(orderNumPay -> orderNumPay.getPaidPrice().doubleValue())).getSum();
            if (firstEnterTime + 86400L >= endDate.getTime() / 1000L) {
                return new BigDecimal(dayNightMaxfee.floatValue()).subtract(new BigDecimal(paidPriceSum));
            }
            float suffixFee = this.chargeFee(feeParamHolder, orderInfo.getParkId(), billId, (int)(firstEnterTime + 86400L), (int)(endDate.getTime() / 1000L), 0, false, orderInfo.getCarType(), false, 0, null, null, null, false);
            return new BigDecimal(dayNightMaxfee.floatValue()).subtract(new BigDecimal(paidPriceSum)).add(new BigDecimal(suffixFee));
        }
        return null;
    }

    protected List<BaseFeeParamHolder.ExtraComputeFeePara> resolveHolsFeeParams(OrderInfo orderInfo, long beginTimeSec, long endTimeSec) {
        Object[] objectArray;
        String holsBillCode;
        log.debug("\u8282\u5047\u65e5\u89c4\u5219\u5224\u5b9a|{}|{}|{}|{}|{}", new Object[]{orderInfo.getParkId(), orderInfo.getOrderNum(), orderInfo.getPlateNum(), beginTimeSec, endTimeSec});
        ArrayList<BaseFeeParamHolder.ExtraComputeFeePara> partFeeParams = new ArrayList<BaseFeeParamHolder.ExtraComputeFeePara>();
        ParkRegion parkRegion = NumberUtils.toPrimitive((Long)orderInfo.getRegionId()) == 0L ? (ParkRegion)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.parkRegionService.lambdaQuery().eq(ParkRegion::getParkId, (Object)orderInfo.getParkId())).eq(ParkRegion::getFatherRelationId, (Object)0)).last("limit 1")).one() : (ParkRegion)this.parkRegionService.getById(orderInfo.getRegionId());
        List chargeConfigs = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.regionChargeconfigService.lambdaQuery().eq(RegionChargeconfig::getParkId, (Object)orderInfo.getParkId())).eq(RegionChargeconfig::getRegionId, (Object)parkRegion.getId())).in(RegionChargeconfig::getLicensePlateType, new Object[]{RegionChargePlateTypeConsts.HOLIDAY, RegionChargePlateTypeConsts.HOLS_GREEN_PLATE})).list();
        if (CollectionUtils.isEmpty((Collection)chargeConfigs)) {
            return partFeeParams;
        }
        RegionChargeconfig holsChargeConfig = null;
        RegionChargeconfig evHolsChargeConfig = null;
        for (RegionChargeconfig chargeconfig : chargeConfigs) {
            if (RegionChargePlateTypeConsts.HOLIDAY.equals(chargeconfig.getLicensePlateType())) {
                holsChargeConfig = chargeconfig;
                continue;
            }
            if (!RegionChargePlateTypeConsts.HOLS_GREEN_PLATE.equals(chargeconfig.getLicensePlateType())) continue;
            evHolsChargeConfig = chargeconfig;
        }
        assert (holsChargeConfig != null);
        OrderCarInfo carInfo = this.orderCarInfoService.getByOrderNum(orderInfo.getOrderNum());
        boolean useEv = PlateColorEnum.GREEN.getDesc().equals(carInfo.getPlateColor()) && evHolsChargeConfig != null;
        String string = holsBillCode = useEv ? evHolsChargeConfig.getBilltypecode() : holsChargeConfig.getBilltypecode();
        if (StringUtils.isBlank((CharSequence)holsBillCode)) {
            return partFeeParams;
        }
        ParkChargeconfig chargeConfig = (ParkChargeconfig)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.parkChargeConfigService.lambdaQuery().eq(ParkChargeconfig::getParkId, (Object)orderInfo.getParkId())).eq(ParkChargeconfig::getBilltypecode, (Object)holsBillCode)).one();
        if (chargeConfig == null) {
            return partFeeParams;
        }
        if (useEv ? evHolsChargeConfig.getIsNewenergyIncludeWeekends() == 1 : holsChargeConfig.getIsIncludeWeekends() == 1) {
            Integer[] integerArray = new Integer[2];
            integerArray[0] = NotWorkDay.DATE_TYPE_HOLIDAY;
            objectArray = integerArray;
            integerArray[1] = NotWorkDay.DATE_TYPE_WEEKEND;
        } else {
            Object[] objectArray2 = new Integer[1];
            objectArray = objectArray2;
            objectArray2[0] = NotWorkDay.DATE_TYPE_HOLIDAY;
        }
        Object[] dateTypes = objectArray;
        LocalDateTime beginTime = DateUtils.toLocalDateTimeOfSecond((long)beginTimeSec);
        LocalDateTime endTime = DateUtils.toLocalDateTimeOfSecond((long)endTimeSec);
        LocalDate beginDate = beginTime.toLocalDate();
        LocalDate endDate = endTime.toLocalDate();
        Set notWorkDaySet = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.notWorkDayService.lambdaQuery().between(NotWorkDay::getYmd, (Object)beginDate, (Object)endDate)).in(NotWorkDay::getDateType, dateTypes)).orderByAsc(NotWorkDay::getYmd)).list().stream().map(NotWorkDay::getYmd).collect(Collectors.toSet());
        long beginEpochDay = beginDate.toEpochDay();
        long endEpochDay = endDate.toEpochDay();
        LocalDateTime lastBegin = beginTime;
        LocalDateTime lastEnd = beginEpochDay == endEpochDay ? endTime : beginDate.plusDays(1L).atStartOfDay();
        boolean lastFlag = notWorkDaySet.contains(beginDate);
        for (long i = beginEpochDay; i <= endEpochDay; ++i) {
            LocalDate date = LocalDate.ofEpochDay(i);
            boolean flag = notWorkDaySet.contains(date);
            if (flag != lastFlag) {
                partFeeParams.add(new BaseFeeParamHolder.ExtraComputeFeePara().setStartTime(Long.valueOf(DateUtils.toEpochSecond((LocalDateTime)lastBegin))).setEndTime(Long.valueOf(DateUtils.toEpochSecond((LocalDateTime)lastEnd))).setBillId(lastFlag ? chargeConfig.getId() : null));
                lastBegin = date.atStartOfDay();
            }
            if (i != endEpochDay) {
                lastEnd = date.plusDays(1L).atStartOfDay();
                lastFlag = flag;
                continue;
            }
            if (lastBegin.equals(endTime)) continue;
            partFeeParams.add(new BaseFeeParamHolder.ExtraComputeFeePara().setStartTime(Long.valueOf(DateUtils.toEpochSecond((LocalDateTime)lastBegin))).setEndTime(Long.valueOf(endTimeSec)).setBillId(flag ? chargeConfig.getId() : null));
        }
        return partFeeParams;
    }
}

