/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.parkvip.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.parkvip.ParkVip;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.parkvip.ParkVipMapper;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.parkvip.ParkVipService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParkVipServiceImpl
extends BaseServiceImpl<ParkVipMapper, ParkVip>
implements ParkVipService {
    @Autowired
    private ParkService parkService;

    @Override
    public ParkVip getParkVipById(Long id) {
        return (ParkVip)this.getById(id);
    }

    @Override
    public ParkVip getParkVipByParkId(Serializable parkId) {
        return (ParkVip)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkVip.class).eq(ParkVip::getParkId, (Object)parkId)).last("limit 1"));
    }

    @Override
    public ParkVip getParkVipByParkCode(String parkCode) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        return this.getParkVipByParkId(park.getId());
    }

    @Override
    public Boolean addParkVip(ParkVip entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyParkVip(ParkVip entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeParkVipById(Long id) {
        return this.removeById(id);
    }
}

