/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.parkvip.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.domain.parkvip.CallSip;
import com.icetech.common.utils.UUIDTools;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.parkvip.CallSipMapper;
import com.icetech.park.service.parkvip.CallSipService;
import com.icetech.third.utils.RedisUtils;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CallSipServiceImpl
extends BaseServiceImpl<CallSipMapper, CallSip>
implements CallSipService {
    private static final String LOCK_KEY = "LOCK:SIP:";
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public CallSip getCallSipById(Long id) {
        return (CallSip)this.getById(id);
    }

    @Override
    public Boolean addCallSip(CallSip entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyCallSip(CallSip entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeCallSipById(Long id) {
        return this.removeById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSip() {
        String requestId = UUIDTools.getUuid();
        try {
            if (this.redisUtils.tryGetDistributedLock(LOCK_KEY, requestId)) {
                CallSip callSip = (CallSip)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CallSip.class).eq(CallSip::getStatus, (Object)1)).orderByAsc(CallSip::getSip)).last("limit 1"));
                if (Objects.isNull(callSip)) {
                    this.log.warn("-------------[SIP\u6c60\u7528\u5c3d]-------------");
                    String string = null;
                    return string;
                }
                callSip.setStatus(Integer.valueOf(0));
                this.updateById(callSip);
                String string = callSip.getSip();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.redisUtils.releaseDistributedLock(LOCK_KEY, requestId);
        }
        this.log.warn("-------------[\u70ed\u7ebf\u53f7\u7801\u6c60\u83b7\u53d6\u5931\u8d25]-------------");
        return "";
    }

    @Override
    public void receiveSip(String sip) {
        CallSip callSip = (CallSip)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CallSip.class).eq(CallSip::getSip, (Object)sip)).last("limit 1"));
        if (Objects.nonNull(callSip)) {
            callSip.setStatus(Integer.valueOf(1));
            this.updateById(callSip);
        }
    }
}

