/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.parkvip.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.cloudcenter.domain.parkvip.CallPhoneNum;
import com.icetech.common.utils.UUIDTools;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.parkvip.CallPhoneNumMapper;
import com.icetech.park.service.parkvip.CallPhoneNumService;
import com.icetech.third.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CallPhoneNumServiceImpl
extends BaseServiceImpl<CallPhoneNumMapper, CallPhoneNum>
implements CallPhoneNumService {
    private static final String LOCK_KEY = "LOCK:CALL";
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public CallPhoneNum getCallPhoneNumById(Long id) {
        return (CallPhoneNum)this.getById(id);
    }

    @Override
    public Boolean addCallPhoneNum(CallPhoneNum entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyCallPhoneNum(CallPhoneNum entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeCallPhoneNumById(Long id) {
        return this.removeById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPhoneNum() {
        String requestId = UUIDTools.getUuid();
        try {
            if (this.redisUtils.tryGetDistributedLock(LOCK_KEY, requestId)) {
                CallPhoneNum phoneNum = (CallPhoneNum)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CallPhoneNum.class).eq(CallPhoneNum::getStatus, (Object)1)).orderByAsc(CallPhoneNum::getPhoneNum)).last("limit 1"));
                if (Objects.isNull(phoneNum)) {
                    this.log.warn("-------------[\u70ed\u7ebf\u53f7\u7801\u6c60\u7528\u5c3d]-------------");
                    String string = "";
                    return string;
                }
                phoneNum.setStatus(Integer.valueOf(0));
                this.updateById(phoneNum);
                String string = phoneNum.getPhoneNum();
                return string;
            }
            this.log.warn("-------------[\u70ed\u7ebf\u53f7\u7801\u6c60\u83b7\u53d6\u5931\u8d25]-------------");
        }
        catch (Exception exception) {
        }
        finally {
            this.redisUtils.releaseDistributedLock(LOCK_KEY, requestId);
        }
        return "";
    }

    @Override
    public Boolean initPhoneNum() {
        DateTime date = DateUtil.date();
        ArrayList callPhoneNums = Lists.newArrayList();
        for (int i = 1021; i < 2000; ++i) {
            CallPhoneNum callPhoneNum = new CallPhoneNum();
            callPhoneNum.setPhoneNum(i + "");
            callPhoneNum.setStatus(Integer.valueOf(1));
            callPhoneNum.setCreateTime((Date)date);
            callPhoneNums.add(callPhoneNum);
        }
        return this.saveBatch(callPhoneNums);
    }
}

