/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.park.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.request.ParkVisitBatchDeleteParam;
import com.icetech.cloudcenter.api.IBatchDownSendService;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.discount.MerchantUserService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.constants.ParkVisitMoreType;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.response.MerchantDiscountDto;
import com.icetech.cloudcenter.domain.response.ParkVisitDto;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.park.domain.dto.VisitQueryDto;
import com.icetech.park.domain.entity.ParkVisituser;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.service.visit.ParkVisituserService;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.utils.RedisUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service(value="parkVisitService")
public class ParkVisitServiceImpl
implements ParkVisitService {
    private static final Logger log = LoggerFactory.getLogger(ParkVisitServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkVisitDao parkVisitDao;
    @Autowired
    private ParkConfigDao parkConfigDao;
    @Autowired
    private SendInfoService sendInfoService;
    @Autowired
    private IBatchDownSendService batchDownSendService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private MerchantDiscountService merchantDiscountService;
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private MerchantUserService merchantUserService;
    @Autowired
    private ParkVisituserService parkVisituserService;
    public static final Integer CHECK_STATUS = 2;

    public ObjectResponse selectVisitByid(Long vId) {
        ParkVisit parkVisit = this.parkVisitDao.selectvisitById(vId);
        if (Objects.isNull(parkVisit)) {
            return ObjectResponse.failed((String)"404", (String)"\u8bbf\u5ba2\u8f66\u8f86\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ParkVisitDto parkVisitDto = new ParkVisitDto();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        parkVisitDto.setVisitNum(parkVisit.getVisitNum());
        parkVisitDto.setId(parkVisit.getId());
        Park park = (Park)this.parkService.findByParkId(Long.valueOf(parkVisit.getParkId().intValue())).getData();
        if (park != null) {
            parkVisitDto.setParkCode(park.getParkCode());
            parkVisitDto.setParkName(park.getParkName());
        }
        parkVisitDto.setPlateNums(parkVisit.getPlateNums());
        parkVisitDto.setVisitStatus(parkVisit.getVisitStatus());
        parkVisitDto.setVisitPhone(parkVisit.getVisitPhone());
        parkVisitDto.setVisitName(parkVisit.getVisitName());
        parkVisitDto.setMasterName(parkVisit.getMasterName());
        parkVisitDto.setMasterNum(parkVisit.getMasterNum());
        parkVisitDto.setReason(parkVisit.getReason());
        parkVisitDto.setCheckReason(parkVisit.getCheckReason());
        parkVisitDto.setCheckStatus(parkVisit.getCheckStatus());
        parkVisitDto.setStartTime(simpleDateFormat.format(parkVisit.getStartTime()));
        parkVisitDto.setEndTime(simpleDateFormat.format(parkVisit.getEndTime()));
        parkVisitDto.setInoutMore(parkVisit.getInoutMore());
        parkVisitDto.setInoutNum(parkVisit.getInoutNum());
        return ObjectResponse.success((Object)parkVisitDto);
    }

    public ObjectResponse<ParkVisit> checkVisitPlate(Long parkId, String plateNum) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        ParkVisit parkVisit = this.parkVisitDao.selectVisitByParkidPlate(parkId, plateNum, simpleDateFormat.format(new Date()));
        if (parkVisit != null) {
            if (parkVisit.getInoutMore() == 0 && StringUtil.isNotEmpty((String)parkVisit.getOrderNum())) {
                return ObjectResponse.failed((String)"404");
            }
            return ObjectResponse.success((Object)parkVisit);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<ParkVisitDto>> getMpVisit(String parkCode, Integer userId, Integer pageNo, Integer pageSize) {
        PageHelper.startPage((int)pageNo, (int)pageSize);
        List<ParkVisit> parkVisits = this.parkVisitDao.selectVisitRecords(userId);
        ArrayList list = Lists.newArrayList();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (ParkVisit parkVisit : parkVisits) {
            ParkVisitDto parkVisitDto = new ParkVisitDto();
            parkVisitDto.setVisitNum(parkVisit.getVisitNum());
            Park park = (Park)this.parkService.findByParkId(Long.valueOf(parkVisit.getParkId().intValue())).getData();
            if (park != null) {
                parkVisitDto.setParkCode(park.getParkCode());
                parkVisitDto.setParkName(park.getParkName());
            }
            parkVisitDto.setCheckReason(parkVisit.getCheckReason());
            parkVisitDto.setPlateNums(parkVisit.getPlateNums());
            parkVisitDto.setStartTime(simpleDateFormat.format(parkVisit.getStartTime()));
            parkVisitDto.setEndTime(simpleDateFormat.format(parkVisit.getEndTime()));
            parkVisitDto.setVisitPhone(parkVisit.getVisitPhone());
            parkVisitDto.setVisitName(parkVisit.getVisitName());
            parkVisitDto.setMasterName(parkVisit.getMasterName());
            parkVisitDto.setMasterNum(parkVisit.getMasterNum());
            parkVisitDto.setMasterPhone(parkVisit.getMasterPhone());
            parkVisitDto.setReason(parkVisit.getReason());
            parkVisitDto.setVisitStatus(parkVisit.getVisitStatus());
            parkVisitDto.setCheckStatus(parkVisit.getCheckStatus());
            list.add(parkVisitDto);
        }
        return ObjectResponse.success((Object)list);
    }

    public ObjectResponse<com.icetech.common.domain.Page<ParkVisitDto>> getMpVisitV2(Long accountId, VisitQueryDto visitVo) {
        Page parkVisitPage = PageHelper.startPage((int)visitVo.getPageNo(), (int)visitVo.getPageSize()).doSelectPage(() -> this.parkVisitDao.selectVisitRecordsV2(Math.toIntExact(accountId), visitVo.getCheckStatus(), visitVo.getVisitStatus(), visitVo.getFrom()));
        ArrayList list = Lists.newArrayList();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (ParkVisit parkVisit : parkVisitPage.getResult()) {
            ParkVisitDto parkVisitDto = new ParkVisitDto();
            parkVisitDto.setVisitNum(parkVisit.getVisitNum());
            Park park = (Park)this.parkService.findByParkId(Long.valueOf(parkVisit.getParkId().intValue())).getData();
            if (park != null) {
                parkVisitDto.setParkCode(park.getParkCode());
                parkVisitDto.setParkName(park.getParkName());
            }
            parkVisitDto.setCheckReason(parkVisit.getCheckReason());
            parkVisitDto.setPlateNums(parkVisit.getPlateNums());
            parkVisitDto.setStartTime(simpleDateFormat.format(parkVisit.getStartTime()));
            parkVisitDto.setEndTime(simpleDateFormat.format(parkVisit.getEndTime()));
            parkVisitDto.setVisitPhone(parkVisit.getVisitPhone());
            parkVisitDto.setVisitName(parkVisit.getVisitName());
            parkVisitDto.setMasterName(parkVisit.getMasterName());
            parkVisitDto.setMasterNum(parkVisit.getMasterNum());
            parkVisitDto.setMasterPhone(parkVisit.getMasterPhone());
            parkVisitDto.setReason(parkVisit.getReason());
            parkVisitDto.setFrom(parkVisit.getFrom());
            parkVisitDto.setVisitStatus(parkVisit.getVisitStatus());
            parkVisitDto.setCheckStatus(parkVisit.getCheckStatus());
            parkVisitDto.setEnterTime(parkVisit.getEnterTime());
            parkVisitDto.setExitTime(parkVisit.getExitTime());
            parkVisitDto.setEditer(parkVisit.getEditer());
            list.add(parkVisitDto);
        }
        return ObjectResponse.success((Object)com.icetech.common.domain.Page.instance((int)parkVisitPage.getPages(), (long)parkVisitPage.getTotal(), (List)list));
    }

    public ObjectResponse countMpVisit(String parkCode, Integer userId) {
        int count = this.parkVisitDao.countVisitRecords(userId);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("count", count);
        return ObjectResponse.success(map);
    }

    public ObjectResponse<ParkVisitDto> getMpVisitByVisitNum(String visitNum) {
        ParkVisit parkVisit = this.parkVisitDao.selectByVisitNum(visitNum);
        ParkVisitDto parkVisitDto = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (parkVisit != null) {
            parkVisitDto = new ParkVisitDto();
            parkVisitDto.setId(parkVisit.getId());
            parkVisitDto.setPlateNums(parkVisit.getPlateNums());
            parkVisitDto.setVisitNum(parkVisit.getVisitNum());
            parkVisitDto.setStartTime(simpleDateFormat.format(parkVisit.getStartTime()));
            parkVisitDto.setEndTime(simpleDateFormat.format(parkVisit.getEndTime()));
            parkVisitDto.setVisitName(parkVisit.getVisitName());
            parkVisitDto.setVisitPhone(parkVisit.getVisitPhone());
            parkVisitDto.setMasterName(parkVisit.getMasterName());
            parkVisitDto.setMasterPhone(parkVisit.getMasterPhone());
            parkVisitDto.setMasterNum(parkVisit.getMasterNum());
            parkVisitDto.setCheckReason(parkVisit.getCheckReason());
            parkVisitDto.setReason(parkVisit.getReason());
            Park park = (Park)this.parkService.findByParkId(Long.valueOf(parkVisit.getParkId().intValue())).getData();
            if (park != null) {
                parkVisitDto.setParkCode(park.getParkCode());
                parkVisitDto.setParkName(park.getParkName());
            }
            parkVisitDto.setCheckStatus(parkVisit.getCheckStatus());
            parkVisitDto.setVisitStatus(parkVisit.getVisitStatus());
            parkVisitDto.setEnterTime(parkVisit.getEnterTime());
            parkVisitDto.setExitTime(parkVisit.getExitTime());
            parkVisitDto.setEditer(parkVisit.getEditer());
            parkVisitDto.setFrom(parkVisit.getFrom());
            parkVisitDto.setInoutMore(parkVisit.getInoutMore());
            parkVisitDto.setInoutNum(parkVisit.getInoutNum());
            parkVisitDto.setCreateTime(parkVisit.getCreateTime());
            parkVisitDto.setIsAuto(parkVisit.getIsAuto());
        }
        return ObjectResponse.success(parkVisitDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Void> addGuoKongParkVisit(ParkVisit parkVisit) {
        ObjectResponse inPark;
        parkVisit.setVisitNum(System.currentTimeMillis() / 1000L + "" + (int)((Math.random() * 9.0 + 1.0) * 10000.0));
        parkVisit.setCreateTime(new Date());
        parkVisit.setCheckStatus(Integer.valueOf(parkVisit.getIsAuto() == 2 ? 2 : 1));
        parkVisit.setVisitStatus(Integer.valueOf(1));
        this.parkVisitDao.insert(parkVisit);
        if (CHECK_STATUS.equals(parkVisit.getCheckStatus())) {
            SendInfo sendInfo = new SendInfo();
            sendInfo.setParkId(Long.valueOf(parkVisit.getParkId().intValue()));
            sendInfo.setLevel(Integer.valueOf(2));
            sendInfo.setServiceType(DownServiceEnum.\u8f66\u8f86\u9884\u7ea6.getServiceType());
            sendInfo.setInclude("1");
            sendInfo.setServiceId(parkVisit.getId());
            sendInfo.setSendNum(Integer.valueOf(0));
            sendInfo.setNextFireTime(Integer.valueOf(0));
            this.sendInfoService.insert(sendInfo);
        }
        if (ObjectResponse.isSuccess((Response)(inPark = this.orderService.findInParkId(parkVisit.getPlateNums(), Long.valueOf(parkVisit.getParkId().longValue()))))) {
            ObjectResponse discountObj;
            OrderInfo orderInfo = (OrderInfo)inPark.getData();
            orderInfo.setType(PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType());
            this.orderService.updateOrderInfo(orderInfo);
            parkVisit.setVisitStatus(Integer.valueOf(2));
            if (ParkVisitMoreType.ONE.getType().equals(parkVisit.getInoutMore())) {
                parkVisit.setInoutNum(Integer.valueOf(0));
            }
            if (parkVisit.getIsDiscount() != null && parkVisit.getIsDiscount() == 1 && ObjectResponse.isSuccess((Response)(discountObj = this.merchantDiscountService.findMerchantDiscountById(Long.valueOf(parkVisit.getMerchantDisId().intValue()))))) {
                MerchantDiscountDto merchantDiscountDto = (MerchantDiscountDto)discountObj.getData();
                BigDecimal deductMoney = merchantDiscountDto.getDeductMoney() == null ? BigDecimal.ZERO : merchantDiscountDto.getDeductMoney();
                OrderDiscount addOrderDis = new OrderDiscount();
                addOrderDis.setMerchantDisId(Long.valueOf(merchantDiscountDto.getId().intValue()));
                addOrderDis.setDiscountNo(CodeTools.GenerateDiscountNo());
                addOrderDis.setParkId(Long.valueOf(parkVisit.getParkId().intValue()));
                addOrderDis.setType(Integer.valueOf(merchantDiscountDto.getType()));
                addOrderDis.setMerchantId(Long.valueOf(merchantDiscountDto.getMerchantId()));
                addOrderDis.setAmount(merchantDiscountDto.getAmount());
                addOrderDis.setFrom(Integer.valueOf(1));
                addOrderDis.setOrderNum(orderInfo.getOrderNum());
                addOrderDis.setPlateNum(orderInfo.getPlateNum());
                addOrderDis.setDiscountName(merchantDiscountDto.getName());
                addOrderDis.setDeductMoney(Double.valueOf(merchantDiscountDto.getDeductMoney().doubleValue()));
                addOrderDis.setSendTime(new Date());
                addOrderDis.setStatus(Integer.valueOf(0));
                addOrderDis.setUseTime(new Date());
                ObjectResponse addDiscount = this.orderDiscountService.addDiscount(addOrderDis);
                if (ObjectResponse.isSuccess((Response)addDiscount)) {
                    parkVisit.setSendFlag(Integer.valueOf(1));
                    log.info("[\u8bbf\u5ba2\u8f66\u4f18\u60e0]\u6dfb\u52a0\u6210\u529f,\u8fd4\u56de\u7684id:{}", addDiscount.getData());
                }
                this.merchantUserService.subMerchantMoney(Integer.valueOf(merchantDiscountDto.getMerchantId()), deductMoney);
            }
            parkVisit.setOrderNum(orderInfo.getOrderNum());
            parkVisit.setEnterTime(Integer.valueOf(Math.toIntExact(orderInfo.getEnterTime())));
            this.parkVisitDao.updateVisit(parkVisit);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<ParkVisit> getGuoKongParkVisitByParkIdAndPlateNum(Integer parkId, String plateNum) {
        ParkVisit visit = this.parkVisitDao.selectVisitByParkIdAndPlate(parkId, plateNum);
        return ObjectResponse.success((Object)visit);
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Void> deleteVisit(Long id, String loginName) {
        ObjectResponse orderInfoObj;
        ParkVisit parkVisit = this.parkVisitDao.selectvisitById(id);
        if (parkVisit == null) {
            return ObjectResponse.failed((String)"1000", (String)"\u8bbf\u5ba2\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (parkVisit.getDeleteFlag().booleanValue()) {
            return ObjectResponse.success();
        }
        parkVisit.setDeleteFlag(Boolean.TRUE);
        this.parkVisitDao.updateVisit(parkVisit);
        SendInfo sendInfo = new SendInfo(Long.valueOf(parkVisit.getParkId().longValue()), parkVisit.getId(), DownServiceEnum.\u8f66\u8f86\u9884\u7ea6.getServiceType());
        this.sendInfoService.insert(sendInfo);
        SendRequest sendRequest = new SendRequest();
        sendRequest.setServiceId(sendInfo.getServiceId());
        sendRequest.setParkId(sendInfo.getParkId());
        sendRequest.setTaskId(sendInfo.getId());
        sendRequest.setServiceType(sendInfo.getServiceType());
        this.batchDownSendService.execute(Collections.singletonList(sendRequest));
        if (StringUtils.isNotBlank((CharSequence)parkVisit.getOrderNum()) && ObjectResponse.isSuccess((Response)(orderInfoObj = this.orderService.findByOrderNum(parkVisit.getOrderNum())))) {
            ObjectResponse orderDiscountObj;
            OrderInfo orderInfo = (OrderInfo)orderInfoObj.getData();
            orderInfo.setType(Integer.valueOf(1));
            if (orderInfo.getServiceStatus() == 1 && ObjectResponse.isSuccess((Response)(orderDiscountObj = this.orderDiscountService.findOneByPlateNum(Long.valueOf(parkVisit.getParkId().intValue()), parkVisit.getVisitNum())))) {
                OrderDiscount orderDiscount = (OrderDiscount)orderDiscountObj.getData();
                this.orderDiscountService.cancelDiscount(orderDiscount.getId(), orderDiscount.getParkId());
            }
            this.orderService.updateOrderInfo(orderInfo);
        }
        return ObjectResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Void> addMpVisit(ParkVisit parkVisit) {
        ObjectResponse inPark;
        ParkConfig parkConfig = this.parkConfigDao.selectByParkId((long)parkVisit.getParkId().intValue());
        if (parkConfig.getIsAuto() == null) {
            parkConfig.setIsAuto(CHECK_STATUS);
        }
        if (StringUtils.isEmpty((CharSequence)parkVisit.getVisitNum())) {
            parkVisit.setVisitNum(System.currentTimeMillis() / 1000L + "" + (int)((Math.random() * 9.0 + 1.0) * 10000.0));
            parkVisit.setCheckStatus(Integer.valueOf(parkConfig.getIsAuto() == 2 ? 2 : 1));
            parkVisit.setFrom(Integer.valueOf(2));
            parkVisit.setInoutMore(Integer.valueOf(2));
            parkVisit.setIsAuto(Integer.valueOf(1));
            parkVisit.setVisitStatus(Integer.valueOf(1));
            if (parkConfig.getDataCollection() == 2) {
                parkVisit.setInoutMore(ParkVisitMoreType.CUSTOM.getType());
                parkVisit.setInoutNum(parkConfig.getVisitInoutNum() == null ? Integer.valueOf(1) : parkConfig.getVisitInoutNum());
            } else {
                parkVisit.setInoutMore(ParkVisitMoreType.MANY.getType());
            }
            parkVisit.setCreateTime(new Date());
            this.parkVisitDao.insert(parkVisit);
            log.info("\u516c\u4f17\u53f7\u9884\u7ea6\u6210\u529f\u63d2\u5165\u7684id{}", (Object)parkVisit.getId());
            if (CHECK_STATUS.equals(parkVisit.getCheckStatus())) {
                SendInfo sendInfo = new SendInfo();
                sendInfo.setParkId(parkConfig.getParkId());
                sendInfo.setLevel(Integer.valueOf(2));
                sendInfo.setServiceType(DownServiceEnum.\u8f66\u8f86\u9884\u7ea6.getServiceType());
                sendInfo.setInclude("1");
                sendInfo.setServiceId(parkVisit.getId());
                sendInfo.setSendNum(Integer.valueOf(0));
                sendInfo.setNextFireTime(Integer.valueOf(0));
                this.sendInfoService.insert(sendInfo);
            }
        } else {
            ParkVisit parkVisitOld = this.parkVisitDao.selectByVisitNum(parkVisit.getVisitNum());
            parkVisitOld.setStartTime(parkVisit.getStartTime());
            parkVisitOld.setEndTime(parkVisit.getEndTime());
            parkVisitOld.setVisitName(parkVisit.getVisitName());
            parkVisitOld.setVisitPhone(parkVisit.getVisitPhone());
            parkVisitOld.setMasterPhone(parkVisit.getMasterPhone());
            parkVisitOld.setMasterName(parkVisit.getMasterName());
            parkVisitOld.setMasterNum(parkVisit.getMasterNum());
            parkVisitOld.setReason(parkVisit.getReason());
            this.parkVisitDao.updateVisit(parkVisitOld);
        }
        if (ObjectResponse.isSuccess((Response)(inPark = this.orderService.findInParkId(parkVisit.getPlateNums(), Long.valueOf(parkVisit.getParkId().longValue()))))) {
            OrderInfo orderInfo = (OrderInfo)inPark.getData();
            orderInfo.setType(PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType());
            this.orderService.updateOrderInfo(orderInfo);
            parkVisit.setVisitStatus(Integer.valueOf(2));
            if (ParkVisitMoreType.ONE.getType().equals(parkVisit.getInoutMore())) {
                parkVisit.setInoutNum(Integer.valueOf(0));
            }
            parkVisit.setOrderNum(orderInfo.getOrderNum());
            parkVisit.setEnterTime(Integer.valueOf(Math.toIntExact(orderInfo.getEnterTime())));
            this.parkVisitDao.updateVisit(parkVisit);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse addMpVisitByOhter(ParkVisit parkVisit) {
        if (!ObjectUtils.isEmpty((Object)parkVisit)) {
            parkVisit.setCreateTime(new Date());
            this.parkVisitDao.insert(parkVisit);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse updateMpVisitByOhter(ParkVisit parkVisit) {
        if (!ObjectUtils.isEmpty((Object)parkVisit)) {
            parkVisit.setUpdateTime(new Date());
            this.parkVisitDao.updateVisit(parkVisit);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<List<String>> findVisitNumOtherByDate(Long parkId, Integer from, String startTime, Integer checkStatus) {
        List<String> stringList = this.parkVisitDao.selectVisitOtherByDate(parkId, from, startTime, checkStatus);
        return ObjectResponse.success(stringList);
    }

    public ObjectResponse<Void> deleteVisitBatch(List<Long> parkIds, ParkVisitBatchDeleteParam parkVisitBatchDeleteParam) {
        String version;
        if (Objects.isNull(parkVisitBatchDeleteParam) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)parkVisitBatchDeleteParam.getVisitIds())) {
            return ObjectResponse.failed((String)"404");
        }
        ObjectResponse parkConfigResp = this.parkService.getParkConfig(parkVisitBatchDeleteParam.getParkCode());
        ParkConfig parkConfig = (ParkConfig)parkConfigResp.getData();
        if (parkConfig.getDataCollection() == 2 && (version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(parkConfig.getParkId()), String.class)) != null && PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c6.getIndex()) {
            return ObjectResponse.failed((String)"500", (String)"\u8ba1\u8d39\u7cfb\u7edf\u7248\u672c\u4e0d\u652f\u6301");
        }
        ObjectResponse allOnline = this.parkDeviceService.isAllOnline(parkConfig.getParkId(), 1, parkConfig.getDataCollection().intValue());
        if (!ObjectResponse.isSuccess((Response)allOnline) || !((Boolean)allOnline.getData()).booleanValue()) {
            return ObjectResponse.failed((String)"500", (String)"\u76f8\u673a\u4e0d\u5728\u7ebf");
        }
        List<ParkVisit> lists = this.parkVisitDao.findAllByIds(parkVisitBatchDeleteParam.getVisitIds(), Boolean.FALSE);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(lists)) {
            return ObjectResponse.failed((String)"404");
        }
        List visitIds = lists.stream().filter(t -> parkIds.contains(-1L) || parkIds.contains(t.getParkId().longValue())).filter(t -> parkVisitBatchDeleteParam.getIsOnsiteCar() != 0 || t.getVisitStatus() != 2).map(ParkVisit::getId).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(visitIds)) {
            return ObjectResponse.failed((String)"404");
        }
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ParkVisit.class).eq(ParkVisit::getDeleteFlag, (Object)Boolean.FALSE)).in(ParkVisit::getId, visitIds);
        ParkVisit update = new ParkVisit();
        update.setDeleteFlag(Boolean.TRUE);
        this.parkVisitDao.update(update, (Wrapper)wrapper);
        List sendInfoList = lists.stream().filter(t -> visitIds.contains(t.getId())).map(t -> new SendInfo(Long.valueOf(t.getParkId().longValue()), t.getId(), DownServiceEnum.\u8f66\u8f86\u9884\u7ea6.getServiceType())).collect(Collectors.toList());
        this.sendInfoService.batchInsert(sendInfoList);
        List orderNums = lists.stream().filter(t -> t.getVisitStatus() == 2).filter(t -> visitIds.contains(t.getId())).map(ParkVisit::getOrderNum).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orderNums)) {
            this.orderService.updateOrderType(orderNums, Integer.valueOf(1));
        }
        List sendRequestList = sendInfoList.stream().map(t -> {
            SendRequest sendRequest = new SendRequest();
            sendRequest.setServiceId(t.getServiceId());
            sendRequest.setParkId(t.getParkId());
            sendRequest.setTaskId(t.getId());
            sendRequest.setServiceType(t.getServiceType());
            return sendRequest;
        }).collect(Collectors.toList());
        this.batchDownSendService.execute(sendRequestList);
        return ObjectResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse addMpVisits(List<ParkVisit> parkVisits, Integer userId) {
        ParkVisituser parkVisitUser = this.parkVisituserService.getParkVisituserByUserId(userId);
        if (parkVisitUser == null) {
            return ObjectResponse.failed((String)"1000", (String)"\u672a\u83b7\u53d6\u5230\u8bbf\u5ba2\u6b21\u6570");
        }
        if (parkVisitUser.getNowNums() <= 0) {
            return ObjectResponse.failed((String)"1000", (String)"\u8bbf\u5ba2\u6b21\u6570\u4e0d\u591f\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ParkVisit visit = parkVisits.get(0);
        long days = DateUtil.betweenDay((Date)visit.getStartTime(), (Date)visit.getEndTime(), (boolean)Boolean.TRUE);
        if (days > (long)parkVisitUser.getMonthMaxDay().intValue()) {
            return ObjectResponse.failed((String)"1000", (String)("\u9884\u7ea6\u65f6\u95f4\u6700\u5927\u53ef\u4ee5\u9009\u62e9" + parkVisitUser.getMonthMaxDay() + "\u5929"));
        }
        ArrayList<SendInfo> sendInfos = new ArrayList<SendInfo>(parkVisits.size());
        for (ParkVisit parkVisit : parkVisits) {
            ObjectResponse inPark = this.orderService.findInParkId(parkVisit.getPlateNums(), Long.valueOf(parkVisit.getParkId().intValue()));
            if (ObjectResponse.isSuccess((Response)inPark)) {
                OrderInfo orderInfo = (OrderInfo)inPark.getData();
                orderInfo.setType(PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType());
                this.orderService.updateOrderInfo(orderInfo);
                parkVisit.setVisitStatus(Integer.valueOf(2));
                if (ParkVisitMoreType.ONE.getType().equals(parkVisit.getInoutMore())) {
                    parkVisit.setInoutNum(Integer.valueOf(0));
                }
                parkVisit.setOrderNum(orderInfo.getOrderNum());
                parkVisit.setEnterTime(Integer.valueOf(Math.toIntExact(orderInfo.getEnterTime())));
                this.parkVisitDao.updateVisit(parkVisit);
            }
            this.parkVisitDao.insert(parkVisit);
            SendInfo sendInfo = new SendInfo();
            sendInfo.setParkId(Long.valueOf(parkVisit.getParkId().intValue()));
            sendInfo.setLevel(Integer.valueOf(2));
            sendInfo.setServiceType(DownServiceEnum.\u8f66\u8f86\u9884\u7ea6.getServiceType());
            sendInfo.setInclude("1");
            sendInfo.setServiceId(parkVisit.getId());
            sendInfo.setSendNum(Integer.valueOf(0));
            sendInfo.setNextFireTime(Integer.valueOf(0));
            sendInfos.add(sendInfo);
        }
        this.sendInfoService.batchInsert(sendInfos);
        parkVisitUser.setNowNums(Integer.valueOf(parkVisitUser.getNowNums() - 1));
        parkVisitUser.setSendNums(Integer.valueOf(parkVisitUser.getSendNums() + 1));
        this.parkVisituserService.updateById(parkVisitUser);
        return ObjectResponse.success();
    }

    public com.icetech.common.domain.Page<ParkVisit> haiDaPage(List<Integer> parkIds, String plateNum, Integer pageNo, Integer pageSize, List<Integer> visitStatus, String startTime, String endTime) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)pageNo.intValue());
        page.setSize((long)pageSize.intValue());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(ParkVisit.class);
        queryWrapper.eq(ParkVisit::getFrom, (Object)7);
        queryWrapper.in(ParkVisit::getParkId, parkIds);
        queryWrapper.orderByDesc(ParkVisit::getId);
        if (CollectionUtils.isNotEmpty(visitStatus)) {
            queryWrapper.in(ParkVisit::getVisitStatus, visitStatus);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)startTime)) {
            queryWrapper.ge(ParkVisit::getStartTime, (Object)startTime);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)endTime)) {
            queryWrapper.le(ParkVisit::getEndTime, (Object)endTime);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)plateNum)) {
            queryWrapper.eq(ParkVisit::getPlateNums, (Object)plateNum);
        }
        IPage parkVisitPage = this.parkVisitDao.selectPage((IPage)page, (Wrapper)queryWrapper);
        return com.icetech.common.domain.Page.instance((int)Math.toIntExact(parkVisitPage.getPages()), (long)parkVisitPage.getTotal(), (List)parkVisitPage.getRecords());
    }

    public com.icetech.common.domain.Page<ParkVisit> guoKongPage(Integer mpUserId, String plateNum, Integer pageNo, Integer pageSize, List<Integer> visitStatus, String startTime, String endTime) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)pageNo.intValue());
        page.setSize((long)pageSize.intValue());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(ParkVisit.class);
        queryWrapper.eq(ParkVisit::getFrom, (Object)8);
        queryWrapper.eq(ParkVisit::getDeleteFlag, (Object)Boolean.FALSE);
        queryWrapper.eq(ParkVisit::getMpUserId, (Object)mpUserId);
        queryWrapper.orderByDesc(ParkVisit::getId);
        if (CollectionUtils.isNotEmpty(visitStatus)) {
            queryWrapper.in(ParkVisit::getVisitStatus, visitStatus);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)startTime)) {
            queryWrapper.ge(ParkVisit::getStartTime, (Object)startTime);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)endTime)) {
            queryWrapper.le(ParkVisit::getEndTime, (Object)endTime);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)plateNum)) {
            queryWrapper.eq(ParkVisit::getPlateNums, (Object)plateNum);
        }
        IPage parkVisitPage = this.parkVisitDao.selectPage((IPage)page, (Wrapper)queryWrapper);
        return com.icetech.common.domain.Page.instance((int)Math.toIntExact(parkVisitPage.getPages()), (long)parkVisitPage.getTotal(), (List)parkVisitPage.getRecords());
    }

    public Integer getTotalNum(List<Integer> parkIds) {
        return this.parkVisitDao.haiDaCount(parkIds);
    }

    public ObjectResponse<String> addShiJiaZhuangVisit(ParkVisit parkVisit) {
        ObjectResponse inPark;
        String visitNum = "";
        ParkConfig parkConfig = this.parkConfigDao.selectByParkId((long)parkVisit.getParkId().intValue());
        if (parkConfig.getIsAuto() == null) {
            parkConfig.setIsAuto(CHECK_STATUS);
        }
        if (StringUtils.isEmpty((CharSequence)parkVisit.getVisitNum())) {
            parkVisit.setVisitNum(System.currentTimeMillis() / 1000L + "" + (int)((Math.random() * 9.0 + 1.0) * 10000.0));
            visitNum = parkVisit.getVisitNum();
            parkVisit.setCheckStatus(Integer.valueOf(parkConfig.getIsAuto() == 2 ? 2 : 1));
            parkVisit.setFrom(Integer.valueOf(2));
            parkVisit.setInoutMore(Integer.valueOf(2));
            parkVisit.setIsAuto(Integer.valueOf(1));
            parkVisit.setVisitStatus(Integer.valueOf(1));
            if (parkConfig.getDataCollection() == 2) {
                parkVisit.setInoutMore(ParkVisitMoreType.CUSTOM.getType());
                parkVisit.setInoutNum(parkConfig.getVisitInoutNum() == null ? Integer.valueOf(1) : parkConfig.getVisitInoutNum());
            } else {
                parkVisit.setInoutMore(ParkVisitMoreType.MANY.getType());
            }
            parkVisit.setCreateTime(new Date());
            this.parkVisitDao.insert(parkVisit);
            log.info("\u516c\u4f17\u53f7\u9884\u7ea6\u6210\u529f\u63d2\u5165\u7684id{}", (Object)parkVisit.getId());
            if (CHECK_STATUS.equals(parkVisit.getCheckStatus())) {
                SendInfo sendInfo = new SendInfo();
                sendInfo.setParkId(parkConfig.getParkId());
                sendInfo.setLevel(Integer.valueOf(2));
                sendInfo.setServiceType(DownServiceEnum.\u8f66\u8f86\u9884\u7ea6.getServiceType());
                sendInfo.setInclude("1");
                sendInfo.setServiceId(parkVisit.getId());
                sendInfo.setSendNum(Integer.valueOf(0));
                sendInfo.setNextFireTime(Integer.valueOf(0));
                this.sendInfoService.insert(sendInfo);
            }
        } else {
            ParkVisit parkVisitOld = this.parkVisitDao.selectByVisitNum(parkVisit.getVisitNum());
            parkVisitOld.setStartTime(parkVisit.getStartTime());
            parkVisitOld.setEndTime(parkVisit.getEndTime());
            parkVisitOld.setVisitName(parkVisit.getVisitName());
            parkVisitOld.setVisitPhone(parkVisit.getVisitPhone());
            parkVisitOld.setMasterPhone(parkVisit.getMasterPhone());
            parkVisitOld.setMasterName(parkVisit.getMasterName());
            parkVisitOld.setMasterNum(parkVisit.getMasterNum());
            parkVisitOld.setReason(parkVisit.getReason());
            this.parkVisitDao.updateVisit(parkVisitOld);
        }
        if (ObjectResponse.isSuccess((Response)(inPark = this.orderService.findInParkId(parkVisit.getPlateNums(), Long.valueOf(parkVisit.getParkId().longValue()))))) {
            OrderInfo orderInfo = (OrderInfo)inPark.getData();
            orderInfo.setType(PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType());
            this.orderService.updateOrderInfo(orderInfo);
            parkVisit.setVisitStatus(Integer.valueOf(2));
            if (ParkVisitMoreType.ONE.getType().equals(parkVisit.getInoutMore())) {
                parkVisit.setInoutNum(Integer.valueOf(0));
            }
            parkVisit.setOrderNum(orderInfo.getOrderNum());
            parkVisit.setEnterTime(Integer.valueOf(Math.toIntExact(orderInfo.getEnterTime())));
            this.parkVisitDao.updateVisit(parkVisit);
        }
        return ObjectResponse.success((Object)visitNum);
    }

    public ObjectResponse<List<ParkVisit>> getParkVisitList(Long parkId, Date date) {
        List<ParkVisit> visits = this.parkVisitDao.selectParkVisitList(parkId, date);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(visits)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success(visits);
    }
}

