/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.park.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.cloudcenter.domain.park.query.ParkTrusteeshipParam;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.ParkTrusteeshipMapper;
import com.icetech.park.domain.entity.ParkTrusteeship;
import com.icetech.park.service.park.ParkTrusteeshipService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ParkTrusteeshipServiceImpl
extends BaseServiceImpl<ParkTrusteeshipMapper, ParkTrusteeship>
implements ParkTrusteeshipService {
    @Override
    public ParkTrusteeship getParkTrusteeshipById(Long id) {
        return (ParkTrusteeship)this.getById(id);
    }

    @Override
    public Boolean addParkTrusteeship(ParkTrusteeship entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyParkTrusteeship(ParkTrusteeship entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeParkTrusteeshipById(Long id) {
        return this.removeById(id);
    }

    @Override
    public Boolean saveParkTrusteeship(ParkTrusteeship parkTrusteeship) {
        return this.saveOrUpdate(parkTrusteeship);
    }

    @Override
    public ParkTrusteeship getParkTrusteeshipByParkId(Long parkId) {
        return (ParkTrusteeship)this.getOne((Wrapper)Wrappers.lambdaQuery(ParkTrusteeship.class).eq(ParkTrusteeship::getParkId, (Object)parkId));
    }

    @Override
    public com.icetech.common.domain.Page<ParkTrusteeship> searchParkTrusteeship(ParkTrusteeshipParam parkTrusteeshipParam, Date currentDate) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ParkTrusteeship.class);
        wrapper.eq(ParkTrusteeship::getStatus, (Object)1);
        wrapper.in(CollectionUtils.isNotEmpty((Collection)parkTrusteeshipParam.getParkIds()), ParkTrusteeship::getParkId, (Collection)parkTrusteeshipParam.getParkIds());
        wrapper.in(CollectionUtils.isNotEmpty((Collection)parkTrusteeshipParam.getInstitutionIds()), ParkTrusteeship::getInstitutionId, (Collection)parkTrusteeshipParam.getInstitutionIds());
        wrapper.like(StringUtils.isNotEmpty((CharSequence)parkTrusteeshipParam.getSipNum()), ParkTrusteeship::getSipNum, (Object)parkTrusteeshipParam.getSipNum());
        wrapper.in(CollectionUtils.isNotEmpty((Collection)parkTrusteeshipParam.getTrusteeshipModels()), ParkTrusteeship::getTrusteeshipModel, (Collection)parkTrusteeshipParam.getTrusteeshipModels());
        if (StringUtils.isNotEmpty((CharSequence)parkTrusteeshipParam.getStartTime()) && StringUtils.isNotEmpty((CharSequence)parkTrusteeshipParam.getEndTime())) {
            wrapper.le(ParkTrusteeship::getStartTime, (Object)parkTrusteeshipParam.getEndTime());
            wrapper.le(ParkTrusteeship::getEndTime, (Object)parkTrusteeshipParam.getStartTime());
        }
        if (Objects.nonNull(parkTrusteeshipParam.getDueFewDays())) {
            wrapper.le(ParkTrusteeship::getEndTime, (Object)DateUtil.offsetDay((Date)currentDate, (int)parkTrusteeshipParam.getDueFewDays()));
        }
        String currentDateStr = DateUtil.formatDate((Date)currentDate);
        if (CollectionUtils.isNotEmpty((Collection)parkTrusteeshipParam.getTrusteeshipStatus())) {
            StringJoiner trusteeshipStatus = new StringJoiner(",");
            parkTrusteeshipParam.getTrusteeshipStatus().stream().map(Object::toString).forEach(trusteeshipStatus::add);
            wrapper.last(String.format(" and case when start_time > '%s' then 1 when start_time <= '%s' and end_time >= '%s' then 2 when  end_time < '%s' then 3 end in (%s) order by id desc", currentDateStr, currentDateStr, currentDateStr, currentDateStr, trusteeshipStatus));
        } else {
            wrapper.orderByDesc(ParkTrusteeship::getId);
        }
        Page page = this.page((Wrapper)wrapper, parkTrusteeshipParam.getPageNo().intValue(), parkTrusteeshipParam.getPageSize().intValue());
        return com.icetech.common.domain.Page.instance((int)((int)page.getPages()), (long)page.getTotal(), (List)page.getRecords());
    }

    @Override
    public List<ParkTrusteeship> getNearExpireWarnPark() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ParkTrusteeship.class);
        wrapper.eq(ParkTrusteeship::getOpenWarn, (Object)1);
        wrapper.last("  and end_time > DATE_FORMAT(NOW(), '%Y-%m-%d') and end_time  <= DATE_FORMAT(NOW() + INTERVAL near_expire_day DAY,'%Y-%m-%d')");
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<ParkTrusteeship> getExpireWarnPark() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ParkTrusteeship.class);
        wrapper.eq(ParkTrusteeship::getOpenWarn, (Object)1);
        wrapper.last(" and end_time < DATE_FORMAT(NOW(), '%Y-%m-%d') and  end_time >= DATE_FORMAT(NOW() - INTERVAL expire_day DAY,'%Y-%m-%d')");
        return this.list((Wrapper)wrapper);
    }
}

