/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.park.ParkRecoverySettleMapper;
import com.icetech.park.domain.entity.park.ParkRecoverySettle;
import com.icetech.park.domain.request.ParkRecoverySettleQuery;
import com.icetech.park.service.park.ParkRecoverySettleService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ParkRecoverySettleServiceImpl
extends BaseServiceImpl<ParkRecoverySettleMapper, ParkRecoverySettle>
implements ParkRecoverySettleService {
    @Override
    public ParkRecoverySettle getParkRecoverySettleById(Long id) {
        return (ParkRecoverySettle)this.getById(id);
    }

    @Override
    public Boolean addParkRecoverySettle(ParkRecoverySettle entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyParkRecoverySettle(ParkRecoverySettle entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeParkRecoverySettleById(Long id) {
        return this.removeById(id);
    }

    @Override
    public com.icetech.common.domain.Page<ParkRecoverySettle> getParkRecoverySettlePage(ParkRecoverySettleQuery parkRecoverySettleQuery, List<Long> parkIds) {
        Page page = this.page((Wrapper)this.getWrapper(parkRecoverySettleQuery, parkIds), parkRecoverySettleQuery.getPageNo().intValue(), parkRecoverySettleQuery.getPageSize().intValue());
        return com.icetech.common.domain.Page.instance((int)((int)page.getPages()), (long)page.getTotal(), (List)page.getRecords());
    }

    @Override
    public ParkRecoverySettle totalMoney(ParkRecoverySettleQuery parkRecoverySettleQuery, List<Long> parkIds) {
        LambdaQueryWrapper<ParkRecoverySettle> wrapper = this.getWrapper(parkRecoverySettleQuery, parkIds);
        wrapper.select(new SFunction[]{ParkRecoverySettle::getRecoveryMoney, ParkRecoverySettle::getCommission});
        List recordList = this.list((Wrapper)wrapper);
        ParkRecoverySettle parkRecoverySettle = new ParkRecoverySettle();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            parkRecoverySettle.setRecoveryMoney(recordList.stream().map(ParkRecoverySettle::getRecoveryMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
            parkRecoverySettle.setCommission(recordList.stream().map(ParkRecoverySettle::getCommission).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return parkRecoverySettle;
    }

    @Override
    public ParkRecoverySettle getParkRecoverySettleByNo(String orderNum) {
        return (ParkRecoverySettle)this.getOne((Wrapper)Wrappers.lambdaQuery(ParkRecoverySettle.class).eq(ParkRecoverySettle::getOrderNum, (Object)orderNum));
    }

    @Override
    public ParkRecoverySettle getParkRecoverySettleByParKMonth(Long parkId, String settleMonth) {
        return (ParkRecoverySettle)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkRecoverySettle.class).eq(ParkRecoverySettle::getParkId, (Object)parkId)).eq(ParkRecoverySettle::getSettleMonth, (Object)settleMonth));
    }

    private LambdaQueryWrapper<ParkRecoverySettle> getWrapper(ParkRecoverySettleQuery parkRecoverySettleQuery, List<Long> parkIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ParkRecoverySettle.class);
        wrapper.in(CollectionUtils.isNotEmpty((Collection)parkRecoverySettleQuery.getParkId()), ParkRecoverySettle::getParkId, (Collection)parkRecoverySettleQuery.getParkId());
        wrapper.in(CollectionUtils.isNotEmpty((Collection)parkRecoverySettleQuery.getInstitutionId()), ParkRecoverySettle::getInstitutionId, (Collection)parkRecoverySettleQuery.getInstitutionId());
        wrapper.between(StringUtils.isNotBlank((CharSequence)parkRecoverySettleQuery.getStartMonth()) && StringUtils.isNotBlank((CharSequence)parkRecoverySettleQuery.getEndMonth()), ParkRecoverySettle::getSettleMonth, (Object)parkRecoverySettleQuery.getStartMonth(), (Object)parkRecoverySettleQuery.getEndMonth());
        wrapper.in(!parkIds.contains(-1L), ParkRecoverySettle::getParkId, parkIds);
        wrapper.orderByDesc(ParkRecoverySettle::getId);
        return wrapper;
    }
}

