/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.constants.CommonConsts;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.park.ParkRecoveryMapper;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkRecovery;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.service.park.ParkRecoveryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ParkRecoveryServiceImpl
extends BaseServiceImpl<ParkRecoveryMapper, ParkRecovery>
implements ParkRecoveryService {
    private final ParkService parkService;

    @Override
    public ParkRecovery getParkRecoveryById(Long id) {
        return (ParkRecovery)this.getById(id);
    }

    @Override
    public Boolean addParkRecovery(ParkRecovery entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyParkRecovery(ParkRecovery entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeParkRecoveryById(Long id) {
        return this.removeById(id);
    }

    @Override
    public ParkRecoveryVo getParkRecoveryByParkId(Long parkId) {
        return this.buildVirtualRecovery(parkId);
    }

    @Override
    public List<ParkRecoveryVo> getParkRecoveryByParkIds(List<Long> parkIds) {
        return this.buildVirtualRecoveryVo(parkIds);
    }

    @Override
    public List<ParkRecoveryVo> getOpenParkRecoveryByParkIds(List<Long> parkIds) {
        return this.buildVirtualRecoveryVo(parkIds);
    }

    @Override
    public List<ParkRecoveryVo> getBaseParkName(String name, Collection<Long> parkIds, Integer limit) {
        return this.buildVirtualRecoveryVo(new ArrayList<Long>(parkIds));
    }

    @Override
    public Integer getOpenedCount(List<Long> parkIds) {
        return this.count((Wrapper)Wrappers.lambdaQuery(ParkRecovery.class).in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L), ParkRecovery::getParkId, parkIds));
    }

    private ParkRecoveryVo buildVirtualRecovery(Long parkId) {
        List<ParkRecoveryVo> recoveries = this.buildVirtualRecoveryVo(Collections.singletonList(parkId));
        if (CollectionUtils.isEmpty(recoveries)) {
            return null;
        }
        return recoveries.get(0);
    }

    private List<ParkRecoveryVo> buildVirtualRecoveryVo(List<Long> parkIds) {
        List parks;
        List list = parks = parkIds.contains(-1L) ? this.parkService.fidAll() : this.parkService.findByParkIds(parkIds);
        if (CollectionUtils.isEmpty((Collection)parks)) {
            return Collections.emptyList();
        }
        parkIds = parks.stream().map(BasePark::getId).collect(Collectors.toList());
        ObjectResponse configMapResp = this.parkService.getParkConfigs(parkIds);
        if (!ObjectResponse.isSuccess((Response)configMapResp)) {
            return Collections.emptyList();
        }
        Map configMap = (Map)configMapResp.getData();
        ArrayList<ParkRecoveryVo> recoveries = new ArrayList<ParkRecoveryVo>(parks.size());
        for (Park park : parks) {
            ParkConfig config = (ParkConfig)configMap.get(park.getId());
            if (config == null || !CommonConsts.YES.equals(config.getIsEnableRecovery())) continue;
            ParkRecoveryVo recovery = new ParkRecoveryVo();
            recovery.setId(Integer.valueOf(park.getId().intValue()));
            recovery.setParkId(park.getId());
            recovery.setInstitutionId(park.getInstitutionId());
            recovery.setApplyType(Integer.valueOf(2));
            recovery.setStartTime("2000-01-01");
            recovery.setEndTime("2999-12-32");
            recovery.setStatus(Integer.valueOf(1));
            recovery.setCreateTime(park.getCreateTime());
            recovery.setUpdateTime(park.getUpdateTime());
            recovery.setOperator(park.getAdder());
            recovery.setParkName(park.getParkName());
            recovery.setRecoveryStatus(Integer.valueOf(2));
            recovery.setEnableRecovery(CommonConsts.YES.equals(config.getIsEnableRecovery()));
            recovery.setOnlyRecoverySelf(CommonConsts.YES.equals(config.getOnlyRecoverySelf()));
            recovery.setAllowRecoveryRoad(CommonConsts.YES.equals(config.getAllowRecoveryRoad()));
            recoveries.add(recovery);
        }
        return recoveries;
    }

    private List<ParkRecovery> buildVirtualRecovery(List<Long> parkIds) {
        List<ParkRecoveryVo> recoveries = this.buildVirtualRecoveryVo(parkIds);
        if (CollectionUtils.isEmpty(recoveries)) {
            return Collections.emptyList();
        }
        return new ArrayList<ParkRecoveryVo>(recoveries);
    }

    public ParkRecoveryServiceImpl(ParkService parkService) {
        this.parkService = parkService;
    }
}

