/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.park.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.park.ParkRecoveryApplyMapper;
import com.icetech.park.domain.entity.park.ParkRecovery;
import com.icetech.park.domain.entity.park.ParkRecoveryApply;
import com.icetech.park.domain.request.ParkRecoveryApplyQuery;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.service.park.ParkRecoveryApplyService;
import com.icetech.park.service.park.ParkRecoveryService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RefreshScope
public class ParkRecoveryApplyServiceImpl
extends BaseServiceImpl<ParkRecoveryApplyMapper, ParkRecoveryApply>
implements ParkRecoveryApplyService {
    private final ParkRecoveryService parkRecoveryService;
    @Value(value="${park.recovery.trialDays}")
    private Integer trialDays;

    @Override
    public ParkRecoveryApply getParkRecoveryApplyById(Long id) {
        return (ParkRecoveryApply)this.getById(id);
    }

    @Override
    public Boolean addParkRecoveryApply(ParkRecoveryApply entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyParkRecoveryApply(ParkRecoveryApply entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeParkRecoveryApplyById(Long id) {
        return this.removeById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean parkRecoveryApply(ParkRecoveryApply parkRecoveryApply) {
        if (parkRecoveryApply.getApplyType() == 1) {
            parkRecoveryApply.setOpenStatus(Integer.valueOf(1));
            parkRecoveryApply.setOpenBy(parkRecoveryApply.getOperator());
            parkRecoveryApply.setOpenTime(new Date());
            parkRecoveryApply.setStartTime(DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.NORM_DATE_FORMAT));
            parkRecoveryApply.setEndTime(DateUtil.format((Date)DateUtil.offsetDay((Date)new Date(), (int)(this.trialDays - 1)), (DatePrinter)DatePattern.NORM_DATE_FORMAT));
            ParkRecoveryVo parkRecoveryByParkId = this.parkRecoveryService.getParkRecoveryByParkId(parkRecoveryApply.getParkId());
            if (Objects.nonNull(parkRecoveryByParkId)) {
                throw new ResponseBodyException(CodeConstantsEnum.ERROR_402.getCode(), "\u8be5\u9879\u76ee\u5df2\u7ecf\u8bd5\u7528\u8fc7\u3002");
            }
        }
        parkRecoveryApply.setOrderNum(CodeTools.GenerateOrderNum());
        parkRecoveryApply.setApplyTime(new Date());
        if (this.addParkRecoveryApply(parkRecoveryApply).booleanValue() && parkRecoveryApply.getApplyType() == 1) {
            ParkRecovery parkRecovery = new ParkRecovery();
            BeanUtils.copyProperties((Object)parkRecoveryApply, (Object)parkRecovery);
            parkRecovery.setStartTime(DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.NORM_DATE_FORMAT));
            parkRecovery.setEndTime(DateUtil.format((Date)DateUtil.offsetDay((Date)new Date(), (int)(this.trialDays - 1)), (DatePrinter)DatePattern.NORM_DATE_FORMAT));
            this.parkRecoveryService.save(parkRecovery);
        }
        return true;
    }

    @Override
    public com.icetech.common.domain.Page<ParkRecoveryApply> getParkRecoveryApplyPage(ParkRecoveryApplyQuery parkRecoveryApplyQuery, List<Long> parkIds) {
        Page page = this.page((Wrapper)this.getWrapper(parkRecoveryApplyQuery, parkIds), parkRecoveryApplyQuery.getPageNo().intValue(), parkRecoveryApplyQuery.getPageSize().intValue());
        return com.icetech.common.domain.Page.instance((int)((int)page.getPages()), (long)page.getTotal(), (List)page.getRecords());
    }

    @Override
    public BigDecimal totalServiceCharge(ParkRecoveryApplyQuery parkRecoveryApplyQuery, List<Long> parkIds) {
        LambdaQueryWrapper<ParkRecoveryApply> wrapper = this.getWrapper(parkRecoveryApplyQuery, parkIds);
        wrapper.select(new SFunction[]{ParkRecoveryApply::getServiceCharge});
        List recordList = this.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            return recordList.stream().map(ParkRecoveryApply::getServiceCharge).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public ParkRecoveryApply getParkRecoveryApplyByOrder(String orderNum) {
        return (ParkRecoveryApply)this.getOne((Wrapper)Wrappers.lambdaQuery(ParkRecoveryApply.class).eq(ParkRecoveryApply::getOrderNum, (Object)orderNum));
    }

    @Override
    public ParkRecoveryApply getParkRecoveryApplyByOrder(Long parkId) {
        List applyList = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkRecoveryApply.class).eq(ParkRecoveryApply::getParkId, (Object)parkId)).eq(ParkRecoveryApply::getPayModel, (Object)3));
        if (CollectionUtils.isEmpty((Collection)applyList)) {
            return null;
        }
        Date currentDate = new Date();
        Optional<ParkRecoveryApply> applyOptional = applyList.stream().filter(a -> DateUtil.compare((Date)currentDate, (Date)DateUtil.parse((CharSequence)a.getStartTime())) >= 0 && DateUtil.compare((Date)currentDate, (Date)DateUtil.offsetDay((Date)DateUtil.parse((CharSequence)a.getEndTime()), (int)1)) < 0).findFirst();
        return applyOptional.orElse(null);
    }

    @Override
    public Integer getApplyCount(List<Long> parkIds) {
        return this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkRecoveryApply.class).eq(ParkRecoveryApply::getOpenStatus, (Object)0)).in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L), ParkRecoveryApply::getParkId, parkIds));
    }

    @Override
    public ParkRecoveryApply getParkRecoveryApplyByParkId(Long parkId) {
        return (ParkRecoveryApply)this.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkRecoveryApply.class).eq(ParkRecoveryApply::getParkId, (Object)parkId)).orderByDesc(ParkRecoveryApply::getParkId));
    }

    @Override
    public ParkRecoveryApply getValidateRecoveryApplyByParkId(Long parkId) {
        String todayDate = DateTools.getFormat((String)"yyyy-MM-dd", (Date)new Date());
        return (ParkRecoveryApply)this.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkRecoveryApply.class).eq(ParkRecoveryApply::getParkId, (Object)parkId)).le(ParkRecoveryApply::getStartTime, (Object)todayDate)).ge(ParkRecoveryApply::getEndTime, (Object)todayDate)).orderByDesc(ParkRecoveryApply::getParkId));
    }

    private LambdaQueryWrapper<ParkRecoveryApply> getWrapper(ParkRecoveryApplyQuery parkRecoveryApplyQuery, List<Long> parkIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ParkRecoveryApply.class);
        wrapper.eq(ParkRecoveryApply::getStatus, (Object)1);
        wrapper.in(CollectionUtils.isNotEmpty((Collection)parkRecoveryApplyQuery.getParkId()), ParkRecoveryApply::getParkId, (Collection)parkRecoveryApplyQuery.getParkId());
        wrapper.in(CollectionUtils.isNotEmpty((Collection)parkRecoveryApplyQuery.getInstitutionId()), ParkRecoveryApply::getInstitutionId, (Collection)parkRecoveryApplyQuery.getInstitutionId());
        wrapper.in(CollectionUtils.isNotEmpty((Collection)parkRecoveryApplyQuery.getApplyType()), ParkRecoveryApply::getApplyType, (Collection)parkRecoveryApplyQuery.getApplyType());
        wrapper.between(StringUtils.isNotEmpty((CharSequence)parkRecoveryApplyQuery.getOpenStartTime()) && StringUtils.isNotEmpty((CharSequence)parkRecoveryApplyQuery.getOpenEndTime()), ParkRecoveryApply::getOpenTime, (Object)parkRecoveryApplyQuery.getOpenStartTime(), (Object)parkRecoveryApplyQuery.getOpenEndTime());
        wrapper.in(!parkIds.contains(-1L), ParkRecoveryApply::getParkId, parkIds);
        String currentDate = DateUtil.formatDate((Date)new Date());
        if (CollectionUtils.isNotEmpty((Collection)parkRecoveryApplyQuery.getRecordStatus())) {
            StringJoiner recordStatus = new StringJoiner(",");
            parkRecoveryApplyQuery.getRecordStatus().stream().map(Object::toString).forEach(recordStatus::add);
            wrapper.last(String.format(" and case when open_status = 0 then 1 when start_time > '%s' then 1 when start_time <= '%s' and end_time >= '%s' then 2 when  end_time < '%s' then 3 end in (%s) order by id desc ", currentDate, currentDate, currentDate, currentDate, recordStatus));
        } else {
            wrapper.orderByDesc(ParkRecoveryApply::getId);
        }
        return wrapper;
    }

    public ParkRecoveryApplyServiceImpl(ParkRecoveryService parkRecoveryService) {
        this.parkRecoveryService = parkRecoveryService;
    }
}

