/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.park.impl;

import com.icetech.cloudcenter.api.park.ParkLicenseService;
import com.icetech.cloudcenter.domain.response.AccessInfoDto;
import com.icetech.cloudcenter.domain.response.ParkLicenseDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.dao.access.AccessInfoDao;
import com.icetech.park.dao.park.ParkLicenseDao;
import com.icetech.park.domain.entity.AccessInfo;
import com.icetech.park.domain.entity.park.ParkLicense;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="parkLicenseService")
@Transactional
public class ParkLicenseServiceImpl
implements ParkLicenseService {
    private static final Logger log = LoggerFactory.getLogger(ParkLicenseServiceImpl.class);
    private int LICENSE_STATUS_OK = 1;
    private int LICENSE_STATUS_NO = 2;
    private int LICENSE_STATUS_USE = 3;
    private int LICENSE_STATUS_INVALID = 4;
    private int LICENSE_STATUS_OVER = 5;
    @Autowired
    private ParkLicenseDao parkLicenseDao;
    @Autowired
    private AccessInfoDao accessInfoDao;

    public ObjectResponse<ParkLicenseDto> selectParkLicense(String licenseNumber) {
        ParkLicense parkLicense = this.parkLicenseDao.selectByLicense(licenseNumber);
        if (parkLicense != null) {
            ParkLicenseDto parkLicenseDto = new ParkLicenseDto();
            parkLicenseDto.setId(parkLicense.getId());
            parkLicenseDto.setLicenseNumber(parkLicense.getLicenseNumber());
            parkLicenseDto.setGrantStatus(parkLicense.getGrantStatus());
            parkLicenseDto.setEnableStatus(parkLicense.getEnableStatus());
            parkLicenseDto.setType(parkLicense.getType());
            return ObjectResponse.success((Object)parkLicenseDto);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<ParkLicenseDto> registerParkLicense(Long parkId, String licenseNumber) {
        int i;
        ParkLicenseDto parkLicenseDto = new ParkLicenseDto();
        ParkLicense parkLicense = this.parkLicenseDao.selectByLicense(licenseNumber);
        if (parkLicense == null) {
            parkLicenseDto.setLicenceStatus(2);
            return ObjectResponse.instance((String)"500", (String)"\u65e0\u6548", (Object)parkLicenseDto);
        }
        if (parkLicense.getGrantStatus() == 1) {
            parkLicenseDto.setLicenceStatus(this.LICENSE_STATUS_NO);
            return ObjectResponse.instance((String)"500", (String)"\u672a\u53d1\u653e", (Object)parkLicenseDto);
        }
        if (parkLicense.getEnableStatus() == 3) {
            parkLicenseDto.setLicenceStatus(this.LICENSE_STATUS_INVALID);
            return ObjectResponse.instance((String)"500", (String)"\u4f5c\u5e9f", (Object)parkLicenseDto);
        }
        if (parkLicense.getEnableStatus() == 4) {
            parkLicenseDto.setLicenceStatus(this.LICENSE_STATUS_OVER);
            return ObjectResponse.instance((String)"500", (String)"\u8fc7\u671f", (Object)parkLicenseDto);
        }
        if (parkLicense.getEnableStatus() == 2) {
            if (parkLicense.getParkId().intValue() != parkId.intValue()) {
                parkLicenseDto.setLicenceStatus(this.LICENSE_STATUS_USE);
                return ObjectResponse.instance((String)"500", (String)"\u5df2\u88ab\u4f7f\u7528", (Object)parkLicenseDto);
            }
            parkLicenseDto = (ParkLicenseDto)JsonUtils.convert2bean((Object)parkLicense, ParkLicenseDto.class);
            parkLicenseDto.setLicenceStatus(this.LICENSE_STATUS_OK);
            if (parkLicense.getType() == 2) {
                int day = this.daysBetween(new Date(), parkLicense.getInvalidTime());
                parkLicenseDto.setUseDays(day);
                if (day <= 0) {
                    parkLicenseDto.setLicenceStatus(this.LICENSE_STATUS_OVER);
                    parkLicenseDto.setUseDays(0);
                    parkLicense.setEnableStatus(4);
                    this.parkLicenseDao.updateLicense(parkLicense);
                }
            }
            return ObjectResponse.success((Object)parkLicenseDto);
        }
        if (parkLicense.getParkId() != null) {
            ParkLicense parkLicense1 = this.parkLicenseDao.selectByParkId(String.valueOf(parkId));
            parkLicense1.setEnableStatus(3);
            this.parkLicenseDao.updateLicense(parkLicense1);
        }
        parkLicense.setParkId(parkId);
        parkLicense.setEnableTime(new Date());
        parkLicense.setEnableStatus(2);
        parkLicense.setUpdateTime(new Date());
        if (parkLicense.getType() == 2 && parkLicense.getValidDays() > 0) {
            Date d = new Date();
            Calendar ca = Calendar.getInstance();
            ca.add(5, parkLicense.getValidDays());
            d = ca.getTime();
            parkLicense.setInvalidTime(d);
        }
        if ((i = this.parkLicenseDao.updateLicense(parkLicense)) > 0) {
            parkLicenseDto = (ParkLicenseDto)JsonUtils.convert2bean((Object)parkLicense, ParkLicenseDto.class);
            int day = this.daysBetween(parkLicense.getEnableTime(), parkLicense.getInvalidTime());
            parkLicenseDto.setUseDays(day);
            parkLicenseDto.setLicenceStatus(this.LICENSE_STATUS_OK);
            return ObjectResponse.success((Object)parkLicenseDto);
        }
        return ObjectResponse.failed((String)"500");
    }

    public ObjectResponse<AccessInfoDto> getAccessInfoByType(int type) {
        AccessInfo accessInfo = this.accessInfoDao.selectByType(type);
        if (accessInfo != null) {
            AccessInfoDto accessInfoDto = new AccessInfoDto();
            accessInfoDto.setId(accessInfo.getId());
            accessInfoDto.setAccessKeyId(accessInfo.getAccessKeyId());
            accessInfoDto.setAccessKeySecret(accessInfo.getAccessKeySecret());
            accessInfoDto.setName(accessInfo.getAccessName());
            accessInfoDto.setType(accessInfo.getAccessType());
            return ObjectResponse.success((Object)accessInfoDto);
        }
        return ObjectResponse.failed((String)"404");
    }

    private int daysBetween(Date smdate, Date bdate) {
        int result = 0;
        if (smdate == null || bdate == null) {
            return result;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
            Calendar cal = Calendar.getInstance();
            cal.setTime(smdate);
            long time1 = cal.getTimeInMillis();
            cal.setTime(bdate);
            long time2 = cal.getTimeInMillis();
            long between_days = (time2 - time1) / 86400000L;
            result = Integer.parseInt(String.valueOf(between_days));
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. smdate[{}], bdate[{}]", new Object[]{e.getMessage(), smdate, bdate, e});
        }
        return result;
    }
}

