/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="parkFreeSpaceService")
public class ParkFreeSpaceServiceImpl
extends BaseServiceImpl<ParkFreespaceDao, ParkFreespace>
implements ParkFreeSpaceService {
    private static final Logger log = LoggerFactory.getLogger(ParkFreeSpaceServiceImpl.class);
    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private ParkService parkService;

    public ObjectResponse<ParkFreespace> getSpaceByPark(long parkId) {
        ParkFreespace space = (ParkFreespace)((ParkFreespaceDao)this.getBaseMapper()).selectLimitOne((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkFreespace.class).eq(ParkFreespace::getParkId, (Object)parkId));
        return ObjectResponse.returnNotFoundIfNull((Object)space);
    }

    public ObjectResponse<Map<Long, ParkFreespace>> getSpacesByPark(Collection<Long> parkIds) {
        List spaces = ((ParkFreespaceDao)this.getBaseMapper()).selectList((Wrapper)Wrappers.lambdaQuery(ParkFreespace.class).in(ParkFreespace::getParkId, parkIds));
        if (CollectionUtils.isEmpty((Collection)spaces)) {
            return ObjectResponse.returnNotFoundIfNull(null);
        }
        return ObjectResponse.success(spaces.stream().collect(Collectors.toMap(space -> (long)space.getParkId(), Function.identity(), (older, newer) -> newer)));
    }

    public boolean insertFreeSpace(ParkFreespace space) {
        return this.save(space);
    }

    public boolean updateByPark(ParkFreespace space) {
        space.setId(null);
        Long parkId = space.getParkId();
        return this.update(space, (Wrapper)Wrappers.lambdaQuery(ParkFreespace.class).eq(ParkFreespace::getParkId, (Object)parkId));
    }

    public int addFreeSpaceByPark(long parkId, int num) {
        return ((ParkFreespaceDao)this.getBaseMapper()).addFreeSpaceByPark(parkId, num);
    }

    public int addFreeSpaceByParks(Map<Long, Integer> parkMap) {
        return ((ParkFreespaceDao)this.getBaseMapper()).addFreeSpaceByParkMap(parkMap);
    }

    public boolean updateBatchByParkId(Collection<ParkFreespace> list) {
        String sqlStatement = this.getSqlStatement(SqlMethod.UPDATE);
        return this.executeBatch(list, 1000, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            param.put((Object)"ew", ((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate((Class)this.entityClass).setSql("`free_space` = (case            when `real_free_space` < 0 then 0            when `real_free_space` > `total_num` then `total_num`            else `real_free_space`        end)")).eq(ParkFreespace::getParkId, (Object)entity.getParkId())).ne(ParkFreespace::getRealFreeSpace, (Object)entity.getRealFreeSpace()));
            sqlSession.update(sqlStatement, (Object)param);
        });
    }

    public int updateFreeSpace(Long parkId) {
        return ((ParkFreespaceDao)this.getBaseMapper()).updateFreeSpace(parkId);
    }

    private boolean isInteriorPark(Long parkId) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        if (ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            Park park = (Park)parkObjectResponse.getData();
            return Integer.valueOf(1).equals(park.getIsInterior());
        }
        return false;
    }
}

