/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.park.impl;

import com.icetech.basics.dao.area.AreaCityDao;
import com.icetech.basics.dao.area.AreaDistrictDao;
import com.icetech.basics.dao.area.AreaProvinceDao;
import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.basics.domain.entity.AreaCity;
import com.icetech.basics.domain.entity.AreaDistrict;
import com.icetech.basics.domain.entity.AreaProvince;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkConfigService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.park.ParkConfigInfo;
import com.icetech.cloudcenter.domain.park.ParkConfigInfoFind;
import com.icetech.cloudcenter.domain.response.ParkConfigDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.service.third.SendInfoServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="parkConfigService")
public class ParkConfigServiceImpl
extends BaseServiceImpl<ParkConfigDao, ParkConfig>
implements ParkConfigService {
    private static final Logger log = LoggerFactory.getLogger(ParkConfigServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkConfigDao parkConfigDao;
    @Autowired
    private AreaCityDao areaCityDao;
    @Autowired
    private AreaDistrictDao areaDistrictDao;
    @Autowired
    private AreaProvinceDao areaProvinceDao;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private StringRedisTemplate redisTemplate;

    public ObjectResponse<ParkConfigDto> selectByParkCode(String parkCode) {
        ParkConfig parkConfig = (ParkConfig)this.parkService.getParkConfig(parkCode).getData();
        if (Objects.isNull(parkConfig)) {
            return ObjectResponse.failed((String)"404");
        }
        ParkConfigDto parkConfigDto = new ParkConfigDto();
        BeanUtils.copyProperties((Object)parkConfig, (Object)parkConfigDto);
        return ObjectResponse.success((Object)parkConfigDto);
    }

    public ObjectResponse<ParkConfigDto> selectByParkId(Long parkId) {
        ParkConfig parkConfig = (ParkConfig)this.parkService.getParkConfig(parkId).getData();
        if (Objects.isNull(parkConfig)) {
            return ObjectResponse.failed((String)"404");
        }
        ParkConfigDto parkConfigDto = new ParkConfigDto();
        BeanUtils.copyProperties((Object)parkConfig, (Object)parkConfigDto);
        return ObjectResponse.success((Object)parkConfigDto);
    }

    public ObjectResponse saveParkConfigInfo(ParkConfigInfo parkConfigInfo) {
        Park park = (Park)this.parkService.findByParkCode(parkConfigInfo.getParkCode()).getData();
        if (Objects.nonNull(park)) {
            parkConfigInfo.setParkId(Integer.valueOf(park.getId().intValue()));
            Integer parkConfigSize = this.parkConfigDao.selectCountByParkId(park.getId().longValue());
            if (parkConfigSize <= 0) {
                this.parkConfigDao.saveParkConfigInfo(parkConfigInfo);
                this.removeParkConfigFromRedis(park.getId(), park.getParkCode());
                return ObjectResponse.success();
            }
        }
        return ObjectResponse.failed((String)"406");
    }

    private void removeParkConfigFromRedis(Long parkId, String parkCode) {
        this.redisTemplate.delete(Arrays.asList("park:config:park:id:" + parkId, "park:config:park:code:", parkCode));
    }

    public ObjectResponse<Void> updateParkConfigInfo(ParkConfigInfo parkConfigInfo) {
        ObjectResponse parkResp = this.parkService.findByParkCode(parkConfigInfo.getParkCode());
        if (ObjectResponse.isSuccess((Response)parkResp)) {
            Park park = (Park)parkResp.getData();
            ObjectResponse parkConfigResp = this.parkService.getParkConfig(park.getId());
            ObjectResponse.notError((Response)parkConfigResp);
            parkConfigInfo.setParkId(Integer.valueOf(park.getId().intValue()));
            this.parkConfigDao.updateParkConfigInfo(parkConfigInfo);
            this.sendInfoService.save((Object)new SendInfo(park.getId(), ((ParkConfig)parkConfigResp.getData()).getId(), DownServiceEnum.\u8f66\u573a\u914d\u7f6e.getServiceType()));
            this.removeParkConfigFromRedis(park.getId(), park.getParkCode());
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)"402");
    }

    public ObjectResponse<ParkConfigInfoFind> selectParkConfigInfoByParkCode(String parkCode) {
        ParkConfigInfoFind parkConfigInfo = this.parkConfigDao.selectParkConfigInfoByParkCode(parkCode);
        log.info("selectParkConfigInfoByParkCode parkConfigInfo [{}] ", (Object)parkConfigInfo);
        return ObjectResponse.success((Object)parkConfigInfo);
    }

    public ObjectResponse<List<AreaCity>> selectAllAreaCityData(Integer id) {
        if (Objects.isNull(id)) {
            return ObjectResponse.success((Object)this.areaCityDao.selectAllData());
        }
        return ObjectResponse.success((Object)this.areaCityDao.selectByUpperId(id));
    }

    public ObjectResponse<List<AreaDistrict>> selectAllAreaDistrictData(Integer id) {
        if (Objects.isNull(id)) {
            return ObjectResponse.success((Object)this.areaDistrictDao.selectAllData());
        }
        return ObjectResponse.success((Object)this.areaDistrictDao.selectByUpperId(id));
    }

    public ObjectResponse<List<AreaProvince>> selectAllAreaProvinceData(Integer id) {
        if (Objects.isNull(id)) {
            return ObjectResponse.success((Object)this.areaProvinceDao.selectAllData());
        }
        return ObjectResponse.success(Collections.singletonList(this.areaProvinceDao.selectById((Serializable)id)));
    }

    @Transactional
    public ObjectResponse<Boolean> batchUpdateParkConfigPayWayByParkId(Map<Long, String> payWayMap) {
        if (payWayMap == null || payWayMap.isEmpty()) {
            return ObjectResponse.success();
        }
        List parks = (List)this.parkService.getBaseParkList(payWayMap.keySet()).getData();
        if (CollectionUtils.isEmpty((Collection)parks)) {
            return ObjectResponse.success();
        }
        List updateParks = payWayMap.entrySet().stream().map(entry -> new ParkConfig().setParkId((Long)entry.getKey()).setIsEpayment(Integer.valueOf(1)).setEPayment((String)entry.getValue())).collect(Collectors.toList());
        boolean result = this.updateBatchByColumn(updateParks, ParkConfig::getParkId);
        parks.forEach(park -> this.removeParkConfigFromRedis(park.getId(), park.getParkCode()));
        return ObjectResponse.success((Object)result);
    }
}

