/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.park.ParkAdvertMapper;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkAdvert;
import com.icetech.park.service.park.ParkAdvertService;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParkAdvertServiceImpl
extends BaseServiceImpl<ParkAdvertMapper, ParkAdvert>
implements ParkAdvertService {
    @Autowired
    private ParkService parkService;

    @Override
    public ParkAdvert getParkAdvertById(Long id) {
        return (ParkAdvert)this.getById(id);
    }

    @Override
    public Boolean addParkAdvert(ParkAdvert entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyParkAdvert(ParkAdvert entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeParkAdvertById(Long id) {
        return this.removeById(id);
    }

    @Override
    public ParkAdvert getByParkId(Integer parkId) {
        ParkAdvert query = new ParkAdvert();
        query.setParkId(parkId);
        return (ParkAdvert)this.getOne((Wrapper)Wrappers.lambdaQuery((Object)query).last("limit 1"));
    }

    @Override
    public ParkAdvert getByParkCode(String parkCode) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        if (Objects.isNull(park)) {
            return null;
        }
        ParkAdvert query = new ParkAdvert();
        query.setParkId(Integer.valueOf(Math.toIntExact(park.getId())));
        return (ParkAdvert)this.getOne((Wrapper)Wrappers.lambdaQuery((Object)query).last("limit 1"));
    }
}

