/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.other.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ReUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.icetech.base.api.IcePushApi;
import com.icetech.base.request.PushMessageRequest;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.utils.RegStr;
import com.icetech.cloudcenter.api.park.ChannelAlarmService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IParkVipService;
import com.icetech.cloudcenter.api.parkvip.IVipEquitiesService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.parkvip.VipEquitiesEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.ChannelAlarmDto;
import com.icetech.cloudcenter.domain.vo.InOutYuneasyInfoVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.StringUtils;
import com.icetech.oss.OssService;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.ParkTrusteeship;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.park.ParkTrusteeshipService;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.user.domain.entity.user.SaasUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class ChannelAlarmServiceImpl
implements ChannelAlarmService {
    private static final Logger log = LoggerFactory.getLogger(ChannelAlarmServiceImpl.class);
    @Autowired
    private ChannelAlarmDao channelAlarmDao;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OssService ossService;
    @Autowired
    private IcePushApi icePushApi;
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private ParkDao parkDao;
    @Value(value="${alarm.appMsg.parkCodes}")
    public String alarmAppMsgParkCodes;
    @Autowired
    private IVipEquitiesService vipEquitiesService;
    @Autowired
    private IParkVipService parkVipService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private ParkTrusteeshipService parkTrusteeshipService;
    @Autowired
    private MqPushService mqPushService;
    @Value(value="${mor.videoUrl:default}")
    private String morVideoUrl;

    public ObjectResponse addAlarm(ChannelAlarm channelAlarm) {
        if (channelAlarm.getParkId() == null || channelAlarm.getChannelCode() == null) {
            return ObjectResponse.failed((String)"400");
        }
        String channelCode = channelAlarm.getChannelCode();
        Long parkId = channelAlarm.getParkId();
        ChannelAlarm channelAlarmOld = this.channelAlarmDao.selectOneByParkIdAndChannelCode(parkId, channelCode, channelAlarm.getAlarmType());
        if (channelAlarmOld != null) {
            ChannelAlarm channelAlarmUpdate = new ChannelAlarm();
            channelAlarmUpdate.setId(channelAlarmOld.getId());
            channelAlarmUpdate.setStatus(Integer.valueOf(ChannelAlarm.Status.\u8d85\u65f6\u672a\u5904\u7406.getStatus()));
            channelAlarmUpdate.setOperator("system");
            this.channelAlarmDao.updateById(channelAlarmUpdate);
        }
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(channelAlarm.getParkId());
        ObjectResponse.isSuccess((Response)parkObjectResponse);
        Park park = (Park)parkObjectResponse.getData();
        ParkInoutdevice parkInoutdevice = null;
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            parkInoutdevice = (ParkInoutdevice)this.parkService.getInoutDeviceByCode(channelCode).getData();
        }
        if (channelAlarm.getAlarmType() == 3) {
            if (StringUtils.isNotBlank((CharSequence)channelCode)) {
                this.channelAlarmDao.insert(channelAlarm);
            }
            this.sendAppMessage(park, parkInoutdevice, channelAlarm.getRemark());
            return ObjectResponse.success();
        }
        if (Objects.isNull(parkInoutdevice)) {
            log.warn("[\u901a\u9053\u4e0d\u5b58\u5728] {}", (Object)channelCode);
            return null;
        }
        if (!DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(this.publicHandle.cloudType(park.getParkCode())) && !this.p2cChannelDeal(channelAlarm, park, parkInoutdevice).booleanValue()) {
            return ObjectResponse.success();
        }
        this.channelAlarmDao.insert(channelAlarm);
        this.mqPushService.pushChannelAlarm(channelAlarm);
        this.sendAppMessage(park, channelAlarm.getChannelCode(), channelAlarm.getImage(), parkInoutdevice.getInandoutName());
        return ObjectResponse.success();
    }

    private Boolean p2cChannelDeal(ChannelAlarm channelAlarm, Park park, ParkInoutdevice parkInoutdevice) {
        if (parkInoutdevice.getInandoutType() == 1) {
            CarEnterRequest carEnterRequest = this.cacheHandle.getEntrance(park.getParkCode(), channelAlarm.getChannelCode());
            if (Objects.isNull(carEnterRequest)) {
                return Boolean.FALSE;
            }
            if (channelAlarm.getOrderNum() != null && !channelAlarm.getOrderNum().equals(carEnterRequest.getOrderNum())) {
                log.info("[\u6ede\u7559\u62a5\u8b66] \u8ba2\u5355\u548c\u5f53\u524d\u7f13\u5b58\u8ba2\u5355\u4e0d\u4e00\u81f4, orderNum[{}]", (Object)channelAlarm.getOrderNum());
                return Boolean.FALSE;
            }
            channelAlarm.setImage(carEnterRequest.getSmallImage());
            channelAlarm.setOrderNum(carEnterRequest.getOrderNum());
        }
        if (parkInoutdevice.getInandoutType() == 2) {
            CarExitRequest carExitRequest = this.cacheHandle.getExit(park.getParkCode(), channelAlarm.getChannelCode());
            if (Objects.isNull(carExitRequest)) {
                if (channelAlarm.getAlarmType() == 2) {
                    channelAlarm.setImage("default");
                    channelAlarm.setOrderNum("default");
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (channelAlarm.getOrderNum() != null && !channelAlarm.getOrderNum().equals(carExitRequest.getOrderNum())) {
                log.info("[\u6ede\u7559\u62a5\u8b66] \u6ede\u7559\u8ba2\u5355\u548c\u5f53\u524d\u7f13\u5b58\u8ba2\u5355\u4e0d\u4e00\u81f4, orderNum[{}]", (Object)channelAlarm.getOrderNum());
                return Boolean.FALSE;
            }
            channelAlarm.setImage(carExitRequest.getSmallImage());
            channelAlarm.setOrderNum(carExitRequest.getOrderNum());
        }
        return Boolean.TRUE;
    }

    public ObjectResponse updateStatus(ChannelAlarm channelAlarm) {
        this.channelAlarmDao.update(channelAlarm);
        return ObjectResponse.success();
    }

    public List<ChannelAlarm> getChannelAlarmByPark(Long parkId, String channelCode) {
        return this.channelAlarmDao.selectByParkIdAndChannelCode(parkId, channelCode);
    }

    public List<ChannelAlarm> getChannelAlarmTimeOut(Long parkId, Integer status, Date time) {
        return this.channelAlarmDao.getChannelAlarmTimeOut(parkId, status, time);
    }

    @DS_SLAVE
    public ObjectResponse<List<ChannelAlarmDto>> getChannelAlarm(String parkCodes, Integer pageNo, Integer pageSize) {
        ArrayList<ChannelAlarmDto> channelAlarmDtoList = new ArrayList<ChannelAlarmDto>();
        try {
            String[] split = parkCodes.split(",");
            if (split.length == 0) {
                return ObjectResponse.success(channelAlarmDtoList);
            }
            String parkid = this.parkDao.selectByCodes(split);
            if (parkid == null) {
                return ObjectResponse.success(channelAlarmDtoList);
            }
            if (parkid.endsWith(",")) {
                parkid = parkid.substring(0, parkid.length() - 1);
            }
            List<ChannelAlarm> list = this.channelAlarmDao.selectAlarmList(new Page((long)pageNo.intValue(), (long)pageSize.intValue()), parkid);
            for (int i = 0; i < list.size(); ++i) {
                ParkInoutdevice parkInoutdevice;
                ChannelAlarmDto channelAlarmDto = new ChannelAlarmDto();
                ChannelAlarm channelAlarm = list.get(i);
                Park park = (Park)this.parkService.findByParkId(channelAlarm.getParkId()).getData();
                channelAlarmDto.setParkCode(park.getParkCode());
                channelAlarmDto.setParkId(channelAlarm.getParkId());
                channelAlarmDto.setAisleCode(channelAlarm.getChannelCode());
                channelAlarmDto.setParkName(park.getParkName());
                if (StringUtils.isNotEmpty((CharSequence)channelAlarm.getImage())) {
                    channelAlarmDto.setImage(this.ossService.getImageUrl(channelAlarm.getImage()));
                }
                if ((parkInoutdevice = this.parkService.getChannelByCodeAndParkId(channelAlarm.getParkId(), channelAlarm.getChannelCode())) == null) {
                    log.warn("[\u901a\u9053\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\uff1a] [{}]", (Object)channelAlarm);
                    continue;
                }
                channelAlarmDto.setAisleName(parkInoutdevice.getInandoutName());
                channelAlarmDto.setAisleType(parkInoutdevice.getInandoutType().intValue());
                channelAlarmDto.setRemark(channelAlarm.getRemark());
                channelAlarmDto.setCreateTime(channelAlarm.getCreateTime());
                ArrayList<Integer> status = new ArrayList<Integer>();
                status.add(1);
                status.add(2);
                ArrayList<Integer> deviceType = new ArrayList<Integer>();
                deviceType.add(1);
                deviceType.add(4);
                deviceType.add(6);
                deviceType.add(9);
                ArrayList<String> inandoutCode = new ArrayList<String>();
                inandoutCode.add(channelAlarm.getChannelCode());
                ParkTrusteeship parkTrusteeship = this.parkTrusteeshipService.getParkTrusteeshipByParkId(park.getId());
                if (Objects.nonNull(parkTrusteeship)) {
                    Date currentDate = new Date();
                    channelAlarmDto.setTrusteeshipStatus(Integer.valueOf(DateUtil.compare((Date)currentDate, (Date)parkTrusteeship.getStartTime()) < 0 ? 1 : (DateUtil.compare((Date)currentDate, (Date)parkTrusteeship.getStartTime()) > 0 && DateUtil.compare((Date)currentDate, (Date)parkTrusteeship.getEndTime()) < 0 ? 2 : 3)));
                    channelAlarmDto.setTrusteeshipEndTime(parkTrusteeship.getEndTime());
                } else {
                    channelAlarmDto.setTrusteeshipStatus(Integer.valueOf(0));
                }
                List parkDevices = this.parkDeviceDao.selectDeviceList(parkInoutdevice.getParkId(), inandoutCode, status, deviceType);
                for (int j = 0; j < parkDevices.size(); ++j) {
                    ParkDevice parkDevice = (ParkDevice)parkDevices.get(j);
                    channelAlarmDto.setSerialNumber(parkDevice.getSerialNumber());
                    if (parkDevice.getType() == 4) {
                        channelAlarmDto.setVoiceDeviceId(parkDevice.getSerialNumber());
                    }
                    if (parkDevice.getType() == 4 && Objects.nonNull(parkDevice.getVoicevendorType()) && parkDevice.getVoicevendorType() == 1) {
                        channelAlarmDto.setYuneasyNumber(parkDevice.getSerialNumber());
                    }
                    if (parkDevice.getType() == 6) {
                        channelAlarmDto.setVideoUrl(parkDevice.getVideoUrl());
                    }
                    if (parkDevice.getType() == 9) {
                        channelAlarmDto.setIceMorSn(parkDevice.getSerialNumber());
                        channelAlarmDto.setIceMorVideoUrl(String.format(this.morVideoUrl, parkDevice.getSerialNumber()));
                    }
                    if (parkDevice.getType() != 1) continue;
                    channelAlarmDto.setIp(parkDevice.getIp());
                    channelAlarmDto.setPort(parkDevice.getPort());
                }
                channelAlarmDtoList.add(channelAlarmDto);
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5931\u8d25: {}. parkCodes[{}]", new Object[]{e.getMessage(), parkCodes, e});
        }
        return ObjectResponse.success(channelAlarmDtoList);
    }

    @DS_SLAVE
    public ObjectResponse<Integer> getChannelAlarmCount(String parkCodes) {
        String[] split = parkCodes.split(",");
        String parkIds = this.parkDao.selectByCodes(split);
        if (StringUtils.isNotEmpty((CharSequence)parkIds) && parkIds.endsWith(",")) {
            parkIds = parkIds.substring(0, parkIds.length() - 1);
        }
        return ObjectResponse.success((Object)this.channelAlarmDao.selectAlarmCount(parkIds));
    }

    public void sendAppMessage(Park park, String channelCode, String imgUrl, String aisleName) {
        String[] parkCodes;
        if (StringUtils.isNotEmpty((CharSequence)this.alarmAppMsgParkCodes) && Arrays.stream(parkCodes = this.alarmAppMsgParkCodes.split(",")).noneMatch(t -> t.equals(park.getParkCode()))) {
            log.info("[\u5f53\u524d\u8f66\u573a\u4e0d\u5728\u767d\u540d\u5355\u4e2d], {}", (Object)park.getParkCode());
            return;
        }
        List<ChannelAlarm> channelAlarmList = this.getChannelAlarmByPark(park.getId(), channelCode);
        if (CollectionUtils.isNotEmpty(channelAlarmList) && channelAlarmList.size() > 1) {
            log.info("[\u5df2\u7ecf\u53d1\u8fc7\u6ede\u7559\u6d88\u606f],{},{}", (Object)park.getId(), (Object)channelCode);
            return;
        }
        ObjectResponse inOutYuneasyInfoVoResp = this.parkDeviceService.getInOutYuneasyInfoVo(park.getId(), channelCode);
        if (!ObjectResponse.isSuccess((Response)inOutYuneasyInfoVoResp) || Objects.isNull(inOutYuneasyInfoVoResp.getData())) {
            log.warn("[inOutYuneasyInfoVo \u67e5\u8be2\u5f02\u5e38]\uff0c {}, {}", (Object)park.getId(), (Object)channelCode);
            return;
        }
        InOutYuneasyInfoVo inOutYuneasyInfoVo = (InOutYuneasyInfoVo)inOutYuneasyInfoVoResp.getData();
        List<String> usernames = this.getUserNames(park);
        if (CollectionUtils.isEmpty(usernames)) {
            log.warn("[\u672a\u627e\u5230\u8f66\u573a\u7684\u7528\u6237\u4fe1\u606f-\u6682\u4e0d\u63a8\u9001] {},{}", (Object)park.getParkName(), (Object)park.getParkCode());
            return;
        }
        PushMessageRequest pushMessageRequest = new PushMessageRequest();
        pushMessageRequest.setTemplateCode("7C5FAEBEA4214991BF5BDCFC420B303F");
        pushMessageRequest.setSendAccount("system");
        pushMessageRequest.setReceiveAccounts(usernames);
        HashMap<String, String> pushParamMap = new HashMap<String, String>();
        pushParamMap.put("parkName", park.getParkName());
        pushParamMap.put("aisleName", aisleName);
        pushMessageRequest.setPushParamMap(pushParamMap);
        if (StringUtils.isNotEmpty((CharSequence)imgUrl)) {
            pushMessageRequest.setMinIcon(this.ossService.getImageUrl(imgUrl));
        }
        HashMap target = Maps.newHashMap();
        target.put("serialNumber", inOutYuneasyInfoVo.getSerialNumber());
        target.put("yuneasyNumber", inOutYuneasyInfoVo.getYuneasyNumber());
        target.put("parkCode", park.getParkCode());
        pushMessageRequest.setSkipTarget(JSON.toJSONString((Object)target));
        this.icePushApi.pushMessage(pushMessageRequest);
        log.info("[app\u63a8\u9001\u53d1\u8d77],pushMessageRequest {}", (Object)pushMessageRequest);
        ObjectResponse judgeParkVip = this.parkVipService.judgeParkVip(park.getParkCode());
        if (((Boolean)judgeParkVip.getData()).booleanValue()) {
            this.vipEquitiesService.countEquities(park.getParkCode(), null, VipEquitiesEnum.\u6ede\u7559\u8f66\u8f86\u63a8\u9001.getType());
        }
    }

    public void sendAppMessage(Park park, ParkInoutdevice parkInoutdevice, String mobile) {
        String[] parkCodes;
        if (StringUtils.isNotEmpty((CharSequence)this.alarmAppMsgParkCodes) && Arrays.stream(parkCodes = this.alarmAppMsgParkCodes.split(",")).noneMatch(t -> t.equals(park.getParkCode()))) {
            log.info("[\u5f53\u524d\u8f66\u573a\u4e0d\u5728\u767d\u540d\u5355\u4e2d], {}", (Object)park.getParkCode());
            return;
        }
        List<String> usernames = this.getUserNames(park);
        if (CollectionUtils.isEmpty(usernames)) {
            log.warn("[\u672a\u627e\u5230\u8f66\u573a\u7684\u7528\u6237\u4fe1\u606f-\u6682\u4e0d\u63a8\u9001] {},{}", (Object)park.getParkName(), (Object)park.getParkCode());
            return;
        }
        String s = (String)this.redisUtils.get("PUSH:APP:CALL:" + park.getParkCode() + ":" + mobile, String.class);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            log.warn("[\u5f53\u524d\u547c\u53eb\u5df2\u7ecf\u63a8\u9001],{}", (Object)mobile);
            return;
        }
        PushMessageRequest pushMessageRequest = new PushMessageRequest();
        if (Objects.isNull(parkInoutdevice)) {
            pushMessageRequest.setTemplateCode("35A786EE797B4B2EA0604B907D78E902");
            pushMessageRequest.setSendAccount("system");
            pushMessageRequest.setReceiveAccounts(usernames);
            HashMap<String, String> pushParamMap = new HashMap<String, String>();
            pushParamMap.put("parkName", park.getParkName());
            pushParamMap.put("callTime", DateUtil.formatTime((Date)DateUtil.date()));
            pushParamMap.put("phoneNumber", mobile);
            pushMessageRequest.setPushParamMap(pushParamMap);
            HashMap target = Maps.newHashMap();
            target.put("parkCode", park.getParkCode());
            target.put("phoneNumber", mobile);
            pushMessageRequest.setSkipTarget(JSON.toJSONString((Object)target));
        } else {
            pushMessageRequest.setTemplateCode("D2BDDBA11E3D48FABA1908548D9D1F0B");
            pushMessageRequest.setSendAccount("system");
            pushMessageRequest.setReceiveAccounts(usernames);
            HashMap<String, String> pushParamMap = new HashMap<String, String>();
            pushParamMap.put("parkName", park.getParkName());
            pushParamMap.put("aisleName", parkInoutdevice.getInandoutName());
            pushParamMap.put("callTime", DateUtil.formatTime((Date)DateUtil.date()));
            HashMap target = Maps.newHashMap();
            ObjectResponse inOutYuneasyInfoVoResp = this.parkDeviceService.getInOutYuneasyInfoVo(park.getId(), parkInoutdevice.getInandoutCode());
            if (ObjectResponse.isSuccess((Response)inOutYuneasyInfoVoResp)) {
                InOutYuneasyInfoVo inOutYuneasyInfoVo = (InOutYuneasyInfoVo)inOutYuneasyInfoVoResp.getData();
                target.put("serialNumber", inOutYuneasyInfoVo.getSerialNumber());
                target.put("yuneasyNumber", inOutYuneasyInfoVo.getYuneasyNumber());
            }
            target.put("parkCode", park.getParkCode());
            if (ReUtil.isMatch((Pattern)RegStr.MOBILE, (CharSequence)mobile)) {
                pushParamMap.put("phoneNumber", mobile);
                target.put("phoneNumber", mobile);
            } else {
                pushParamMap.put("phoneNumber", "");
                target.put("phoneNumber", "");
            }
            pushMessageRequest.setPushParamMap(pushParamMap);
            pushMessageRequest.setSkipTarget(JSON.toJSONString((Object)target));
            ObjectResponse judgeParkVip = this.parkVipService.judgeParkVip(park.getParkCode());
            if (((Boolean)judgeParkVip.getData()).booleanValue()) {
                this.vipEquitiesService.countEquities(park.getParkCode(), null, VipEquitiesEnum.\u6ede\u7559\u8f66\u8f86\u63a8\u9001.getType());
            }
        }
        this.redisUtils.set("PUSH:APP:CALL:" + park.getParkCode() + ":" + mobile, (Object)mobile, 30L);
        this.icePushApi.pushMessage(pushMessageRequest);
    }

    private List<String> getUserNames(Park park) {
        ArrayList roleNames = Lists.newArrayList((Object[])new String[]{"\u8f66\u573a\u7ba1\u7406\u5458", "\u4e91\u5c97\u4ead\u7ba1\u7406\u5458", "\u7cfb\u7edf\u7ba1\u7406\u5458"});
        String subInstitutionId = this.saasUserDao.getSubInstitutionId(park.getInstitutionId());
        List<String> subInstitutionIdsStr = Arrays.asList(subInstitutionId.split(","));
        List subInstitutionIds = (subInstitutionIdsStr = subInstitutionIdsStr.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList())).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List userIds = this.saasUserDao.getUserIdsSaasUserParkByInstitutionIds(subInstitutionIds);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            userIds = Lists.newArrayList();
        }
        List userIdsPark = this.saasUserDao.getUserIdsSaasUserParkByParkId(park.getId());
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            userIdsPark = Lists.newArrayList();
        }
        userIds.addAll(userIdsPark);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return Lists.newArrayList();
        }
        userIds = userIds.stream().distinct().collect(Collectors.toList());
        List saasUsers = this.saasUserDao.getUserByUserIdAndRoleName(userIds, (List)roleNames);
        List<String> usernames = saasUsers.stream().map(SaasUser::getUsername).collect(Collectors.toList());
        return usernames;
    }
}

