/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.other.impl;

import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.MoneyTool;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.service.other.AutopayService;
import com.icetech.paycenter.api.IPayCenterService;
import com.icetech.paycenter.domain.PlatformPayType;
import com.icetech.paycenter.domain.request.autopay.EnterNotifyRequest;
import com.icetech.paycenter.domain.request.autopay.ExitNotifyRequest;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="autoPayServiceImpl")
public class AutopayServiceImpl
implements AutopayService {
    private static final Logger log = LoggerFactory.getLogger(AutopayServiceImpl.class);
    @Autowired
    private ParkConfigDao parkConfigDao;
    @Autowired
    private IPayCenterService payCenterService;
    private static final String SUCCESS = "SUCCESS";
    private static final String FAIL = "FAIL";

    @Override
    public String enterNotify(Long parkId, String orderNum, String parkCode, String plateNum, Long enterTime, Integer type) {
        ParkConfig parkConfig = this.parkConfigDao.selectByParkId(parkId.longValue());
        if (Objects.nonNull(parkConfig) && parkConfig.getIsNosenpayment() == 1 && PlatformPayType.NO_SEN_UNION_PAY.getCode().equals(parkConfig.getNoSenPayment()) && type == 1) {
            EnterNotifyRequest enterNotifyRequest = new EnterNotifyRequest();
            enterNotifyRequest.setParkCode(parkCode);
            enterNotifyRequest.setPlateNum(plateNum);
            enterNotifyRequest.setOrderNum(orderNum);
            enterNotifyRequest.setEnterTime(DateTools.secondTostring((int)Math.toIntExact(enterTime)));
            try {
                ObjectResponse response = this.payCenterService.autoPayEnterNotify(enterNotifyRequest);
                if (response.getCode().equals("200")) {
                    return SUCCESS;
                }
                log.info("[\u514d\u5bc6\u652f\u4ed8\u5165\u573a\u901a\u77e5]\u901a\u77e5\u5931\u8d25\uff0corderNum[{}]", (Object)orderNum);
            }
            catch (Exception e) {
                log.error("[\u514d\u5bc6\u652f\u4ed8\u5165\u573a\u901a\u77e5]\u901a\u77e5\u5931\u8d25: {}. orderNum[{}]", new Object[]{e.getMessage(), orderNum, e});
            }
        }
        return FAIL;
    }

    @Override
    public String exitNotify(OrderInfo orderInfo, String parkCode) {
        ParkConfig parkConfig = this.parkConfigDao.selectByParkId(orderInfo.getParkId().longValue());
        if (Objects.nonNull(parkConfig) && parkConfig.getIsNosenpayment() == 1 && PlatformPayType.NO_SEN_UNION_PAY.getCode().equals(parkConfig.getNoSenPayment()) && orderInfo.getType() == 1) {
            ExitNotifyRequest exitNotifyRequest = new ExitNotifyRequest();
            exitNotifyRequest.setParkCode(parkCode);
            exitNotifyRequest.setPlateNum(orderInfo.getPlateNum());
            exitNotifyRequest.setOrderNum(orderInfo.getOrderNum());
            exitNotifyRequest.setPaidPrice(MoneyTool.fromYuanToFen((String)orderInfo.getPaidPrice()));
            exitNotifyRequest.setExitTime(orderInfo.getExitTime() == null ? DateTools.getFormat((Date)new Date()) : DateTools.secondTostring((int)Math.toIntExact(orderInfo.getExitTime())));
            ObjectResponse response = this.payCenterService.autoPayExitNotify(exitNotifyRequest);
            if (response.getCode().equals("200")) {
                return SUCCESS;
            }
            log.info("[\u514d\u5bc6\u652f\u4ed8\u79bb\u573a\u901a\u77e5]\u901a\u77e5\u5931\u8d25\uff0c\u8ba2\u5355\u53c2\u6570\uff1a[{}]", (Object)orderInfo);
        }
        return FAIL;
    }
}

